/*
 Navicat Premium Data Transfer

 Source Server         : Localhost
 Source Server Type    : MySQL
 Source Server Version : 50736 (5.7.36)
 Source Host           : localhost:3306
 Source Schema         : viperpro

 Target Server Type    : MySQL
 Target Server Version : 50736 (5.7.36)
 File Encoding         : 65001

 Date: 12/04/2024 21:18:34
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for affiliate_histories
-- ----------------------------
DROP TABLE IF EXISTS `affiliate_histories`;
CREATE TABLE `affiliate_histories`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `inviter` int(10) UNSIGNED NOT NULL,
  `commission` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `commission_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `deposited` tinyint(4) NULL DEFAULT 0,
  `deposited_amount` decimal(10, 2) NULL DEFAULT 0.00,
  `losses` bigint(20) NULL DEFAULT 0,
  `losses_amount` decimal(10, 2) NULL DEFAULT 0.00,
  `commission_paid` decimal(10, 2) NULL DEFAULT 0.00,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `receita` decimal(10, 2) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `affiliate_histories_user_id_index`(`user_id`) USING BTREE,
  INDEX `affiliate_histories_inviter_index`(`inviter`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of affiliate_histories
-- ----------------------------

-- ----------------------------
-- Table structure for affiliate_withdraws
-- ----------------------------
DROP TABLE IF EXISTS `affiliate_withdraws`;
CREATE TABLE `affiliate_withdraws`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `pix_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pix_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bank_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `currency` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `symbol` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `affiliate_withdraws_user_id_foreign`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of affiliate_withdraws
-- ----------------------------

-- ----------------------------
-- Table structure for banners
-- ----------------------------
DROP TABLE IF EXISTS `banners`;
CREATE TABLE `banners`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'home',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 19 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of banners
-- ----------------------------
INSERT INTO `banners` VALUES (17, '#', '01HVAC8Q2DSYNS94BM9DFZP5A0.png', 'home', '...', '2024-04-07 13:29:27', '2024-04-12 21:03:42');
INSERT INTO `banners` VALUES (18, NULL, '01HVACB5SAJ2M89ZC6EGVBM581.png', 'home', '....', '2024-04-07 13:30:46', '2024-04-12 21:05:02');
INSERT INTO `banners` VALUES (15, '#', '01HVAC6ZF0341E0X75M3XN2P3H.png', 'carousel', '...', '2024-04-05 22:58:25', '2024-04-12 21:02:45');
INSERT INTO `banners` VALUES (8, '#', '01HVAC5Z2JX7ZJMJ6PBFEP9FS0.png', 'carousel', '...', '2024-01-13 15:41:09', '2024-04-12 21:02:12');
INSERT INTO `banners` VALUES (16, '#', '01HVAC79ENAGJG21MC3AXZR6QB.png', 'home', '...', '2024-04-05 23:03:23', '2024-04-12 21:02:55');

-- ----------------------------
-- Table structure for categories
-- ----------------------------
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `casino_categories_slug_unique`(`slug`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of categories
-- ----------------------------

-- ----------------------------
-- Table structure for category_game
-- ----------------------------
DROP TABLE IF EXISTS `category_game`;
CREATE TABLE `category_game`  (
  `category_id` bigint(20) UNSIGNED NOT NULL,
  `game_id` bigint(20) UNSIGNED NOT NULL,
  INDEX `category_games_category_id_foreign`(`category_id`) USING BTREE,
  INDEX `category_games_game_id_foreign`(`game_id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of category_game
-- ----------------------------
INSERT INTO `category_game` VALUES (1, 631);
INSERT INTO `category_game` VALUES (17, 631);
INSERT INTO `category_game` VALUES (1, 634);
INSERT INTO `category_game` VALUES (17, 632);
INSERT INTO `category_game` VALUES (1, 632);
INSERT INTO `category_game` VALUES (17, 633);
INSERT INTO `category_game` VALUES (17, 634);
INSERT INTO `category_game` VALUES (1, 633);
INSERT INTO `category_game` VALUES (17, 635);
INSERT INTO `category_game` VALUES (1, 635);
INSERT INTO `category_game` VALUES (17, 636);
INSERT INTO `category_game` VALUES (1, 636);
INSERT INTO `category_game` VALUES (17, 637);
INSERT INTO `category_game` VALUES (1, 637);
INSERT INTO `category_game` VALUES (17, 638);
INSERT INTO `category_game` VALUES (1, 638);
INSERT INTO `category_game` VALUES (17, 639);
INSERT INTO `category_game` VALUES (17, 640);
INSERT INTO `category_game` VALUES (1, 640);
INSERT INTO `category_game` VALUES (17, 641);
INSERT INTO `category_game` VALUES (1, 641);
INSERT INTO `category_game` VALUES (1, 639);
INSERT INTO `category_game` VALUES (17, 642);
INSERT INTO `category_game` VALUES (1, 642);
INSERT INTO `category_game` VALUES (19, 1520);
INSERT INTO `category_game` VALUES (19, 1457);
INSERT INTO `category_game` VALUES (19, 1444);
INSERT INTO `category_game` VALUES (19, 1449);
INSERT INTO `category_game` VALUES (19, 1514);
INSERT INTO `category_game` VALUES (17, 1380);
INSERT INTO `category_game` VALUES (20, 6709);
INSERT INTO `category_game` VALUES (1, 6709);
INSERT INTO `category_game` VALUES (19, 6925);
INSERT INTO `category_game` VALUES (19, 7300);
INSERT INTO `category_game` VALUES (17, 8680);
INSERT INTO `category_game` VALUES (17, 12035);
INSERT INTO `category_game` VALUES (17, 8728);
INSERT INTO `category_game` VALUES (17, 8738);
INSERT INTO `category_game` VALUES (19, 8931);
INSERT INTO `category_game` VALUES (17, 12043);
INSERT INTO `category_game` VALUES (17, 12042);
INSERT INTO `category_game` VALUES (17, 12040);
INSERT INTO `category_game` VALUES (19, 9173);
INSERT INTO `category_game` VALUES (19, 9172);
INSERT INTO `category_game` VALUES (19, 9161);
INSERT INTO `category_game` VALUES (17, 9169);
INSERT INTO `category_game` VALUES (19, 9159);

-- ----------------------------
-- Table structure for currencies
-- ----------------------------
DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 114 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of currencies
-- ----------------------------
INSERT INTO `currencies` VALUES (1, 'Leke', 'ALL', 'Lek', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (2, 'Dollars', 'USD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (3, 'Afghanis', 'AFN', '؋', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (4, 'Pesos', 'ARS', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (5, 'Guilders', 'AWG', 'ƒ', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (6, 'Dollars', 'AUD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (7, 'New Manats', 'AZN', 'ман', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (8, 'Dollars', 'BSD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (9, 'Dollars', 'BBD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (10, 'Rubles', 'BYR', 'p.', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (11, 'Euro', 'EUR', '€', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (12, 'Dollars', 'BZD', 'BZ$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (13, 'Dollars', 'BMD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (14, 'Bolivianos', 'BOB', '$b', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (15, 'Convertible Marka', 'BAM', 'KM', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (16, 'Pula', 'BWP', 'P', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (17, 'Leva', 'BGN', 'лв', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (18, 'Reais', 'BRL', 'R$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (19, 'Pounds', 'GBP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (20, 'Dollars', 'BND', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (21, 'Riels', 'KHR', '៛', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (22, 'Dollars', 'CAD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (23, 'Dollars', 'KYD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (24, 'Pesos', 'CLP', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (25, 'Yuan Renminbi', 'CNY', '¥', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (26, 'Pesos', 'COP', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (27, 'Colón', 'CRC', '₡', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (28, 'Kuna', 'HRK', 'kn', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (29, 'Pesos', 'CUP', '₱', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (30, 'Koruny', 'CZK', 'Kč', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (31, 'Kroner', 'DKK', 'kr', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (32, 'Pesos', 'DOP', 'RD$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (33, 'Dollars', 'XCD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (34, 'Pounds', 'EGP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (35, 'Colones', 'SVC', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (36, 'Pounds', 'FKP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (37, 'Dollars', 'FJD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (38, 'Cedis', 'GHC', '¢', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (39, 'Pounds', 'GIP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (40, 'Quetzales', 'GTQ', 'Q', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (41, 'Pounds', 'GGP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (42, 'Dollars', 'GYD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (43, 'Lempiras', 'HNL', 'L', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (44, 'Dollars', 'HKD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (45, 'Forint', 'HUF', 'Ft', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (46, 'Kronur', 'ISK', 'kr', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (47, 'Rupees', 'INR', 'Rp', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (48, 'Rupiahs', 'IDR', 'Rp', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (49, 'Rials', 'IRR', '﷼', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (50, 'Pounds', 'IMP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (51, 'New Shekels', 'ILS', '₪', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (52, 'Dollars', 'JMD', 'J$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (53, 'Yen', 'JPY', '¥', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (54, 'Pounds', 'JEP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (55, 'Tenge', 'KZT', 'лв', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (56, 'Won', 'KPW', '₩', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (57, 'Won', 'KRW', '₩', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (58, 'Soms', 'KGS', 'лв', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (59, 'Kips', 'LAK', '₭', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (60, 'Lati', 'LVL', 'Ls', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (61, 'Pounds', 'LBP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (62, 'Dollars', 'LRD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (63, 'Switzerland Francs', 'CHF', 'CHF', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (64, 'Litai', 'LTL', 'Lt', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (65, 'Denars', 'MKD', 'ден', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (66, 'Ringgits', 'MYR', 'RM', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (67, 'Rupees', 'MUR', '₨', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (68, 'Pesos', 'MXN', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (69, 'Tugriks', 'MNT', '₮', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (70, 'Meticais', 'MZN', 'MT', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (71, 'Dollars', 'NAD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (72, 'Rupees', 'NPR', '₨', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (73, 'Guilders', 'ANG', 'ƒ', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (74, 'Dollars', 'NZD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (75, 'Cordobas', 'NIO', 'C$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (76, 'Nairas', 'NGN', '₦', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (77, 'Krone', 'NOK', 'kr', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (78, 'Rials', 'OMR', '﷼', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (79, 'Rupees', 'PKR', '₨', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (80, 'Balboa', 'PAB', 'B/.', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (81, 'Guarani', 'PYG', 'Gs', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (82, 'Nuevos Soles', 'PEN', 'S/.', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (83, 'Pesos', 'PHP', 'Php', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (84, 'Zlotych', 'PLN', 'zł', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (85, 'Rials', 'QAR', '﷼', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (86, 'New Lei', 'RON', 'lei', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (87, 'Rubles', 'RUB', 'руб', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (88, 'Pounds', 'SHP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (89, 'Riyals', 'SAR', '﷼', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (90, 'Dinars', 'RSD', 'Дин.', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (91, 'Rupees', 'SCR', '₨', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (92, 'Dollars', 'SGD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (93, 'Dollars', 'SBD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (94, 'Shillings', 'SOS', 'S', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (95, 'Rand', 'ZAR', 'R', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (96, 'Rupees', 'LKR', '₨', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (97, 'Kronor', 'SEK', 'kr', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (98, 'Dollars', 'SRD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (99, 'Pounds', 'SYP', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (100, 'New Dollars', 'TWD', 'NT$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (101, 'Baht', 'THB', '฿', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (102, 'Dollars', 'TTD', 'TT$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (103, 'Lira', 'TRY', '₺', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (104, 'Liras', 'TRL', '£', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (105, 'Dollars', 'TVD', '$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (106, 'Hryvnia', 'UAH', '₴', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (107, 'Pesos', 'UYU', '$U', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (108, 'Sums', 'UZS', 'лв', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (109, 'Bolivares Fuertes', 'VEF', 'Bs', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (110, 'Dong', 'VND', '₫', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (111, 'Rials', 'YER', '﷼', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (112, 'Zimbabwe Dollars', 'ZWD', 'Z$', '2023-11-07 15:01:38', NULL);
INSERT INTO `currencies` VALUES (113, 'Rupees', 'INR', '₹', '2023-11-07 15:01:38', NULL);

-- ----------------------------
-- Table structure for currency_alloweds
-- ----------------------------
DROP TABLE IF EXISTS `currency_alloweds`;
CREATE TABLE `currency_alloweds`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `currency_id` bigint(20) UNSIGNED NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `currency_alloweds_currency_id_foreign`(`currency_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of currency_alloweds
-- ----------------------------

-- ----------------------------
-- Table structure for custom_layouts
-- ----------------------------
DROP TABLE IF EXISTS `custom_layouts`;
CREATE TABLE `custom_layouts`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `font_family_default` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `primary_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#0073D2',
  `primary_opacity_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `secundary_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#084375',
  `gray_dark_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#3b3b3b',
  `gray_light_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#c9c9c9',
  `gray_medium_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#676767',
  `gray_over_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#1A1C20',
  `title_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ffffff',
  `text_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#98A7B5',
  `sub_text_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#656E78',
  `placeholder_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#4D565E',
  `background_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#24262B',
  `background_base` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '#ECEFF1',
  `background_base_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '#24262B',
  `carousel_banners` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '#1E2024',
  `carousel_banners_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '#1E2024',
  `sidebar_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `sidebar_color_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `navtop_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `navtop_color_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `side_menu` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `side_menu_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `input_primary` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `input_primary_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `footer_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `footer_color_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `card_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `card_color_dark` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `border_radius` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.25rem',
  `custom_css` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `custom_js` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `custom_header` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `custom_body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `instagram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telegram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `whastapp` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `youtube` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of custom_layouts
-- ----------------------------
INSERT INTO `custom_layouts` VALUES (1, '\'Roboto Condensed\', sans-serif', '#1da639', '#03ad4022', '#0db849', '#3b3b3b', '#c9c9c9', '#676767', '#191A1E', '#ffffff', '#98A7B5', '#656E78', '#4D565E', '#24262B', '#e8e8e8', '#24262B', '#bdbdbd', '#1E2024', '#ffffff', '#191A1E', '#d8d8de', '#24262B', '#828282', '#24262B', '#dedede', '#1E2024', '#919191', '#1E2024', '#ababab', '#1E2024', '.25rem', NULL, NULL, NULL, NULL, '2024-01-01 11:36:03', '2024-03-30 19:29:45', NULL, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for debug
-- ----------------------------
DROP TABLE IF EXISTS `debug`;
CREATE TABLE `debug`  (
  `text` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of debug
-- ----------------------------
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806915\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806915\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806915\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806916\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806916\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806916\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806917\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806918\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806918\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806918\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806919\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806919\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806919\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806920\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806921\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806921\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 535367\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 154646\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806922\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806923\"');
INSERT INTO `debug` VALUES ('\"PlaceBet: 914806924\"');
INSERT INTO `debug` VALUES ('\"AwardWinnings: 914806924\"');

-- ----------------------------
-- Table structure for deposits
-- ----------------------------
DROP TABLE IF EXISTS `deposits`;
CREATE TABLE `deposits`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `currency` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `symbol` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `deposits_user_id_foreign`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of deposits
-- ----------------------------

-- ----------------------------
-- Table structure for digito_pay_payments
-- ----------------------------
DROP TABLE IF EXISTS `digito_pay_payments`;
CREATE TABLE `digito_pay_payments`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `withdrawal_id` int(10) UNSIGNED NOT NULL,
  `pix_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pix_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `observation` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `digito_pay_payments_user_id_index`(`user_id`) USING BTREE,
  INDEX `digito_pay_payments_withdrawal_id_index`(`withdrawal_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of digito_pay_payments
-- ----------------------------

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `failed_jobs_uuid_unique`(`uuid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of failed_jobs
-- ----------------------------

-- ----------------------------
-- Table structure for game_favorites
-- ----------------------------
DROP TABLE IF EXISTS `game_favorites`;
CREATE TABLE `game_favorites`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `game_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `game_favorites_user_id_game_id_unique`(`user_id`, `game_id`) USING BTREE,
  INDEX `game_favorites_game_id_foreign`(`game_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of game_favorites
-- ----------------------------

-- ----------------------------
-- Table structure for game_likes
-- ----------------------------
DROP TABLE IF EXISTS `game_likes`;
CREATE TABLE `game_likes`  (
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `game_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE INDEX `game_likes_user_id_game_id_unique`(`user_id`, `game_id`) USING BTREE,
  INDEX `game_likes_game_id_foreign`(`game_id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of game_likes
-- ----------------------------

-- ----------------------------
-- Table structure for game_reviews
-- ----------------------------
DROP TABLE IF EXISTS `game_reviews`;
CREATE TABLE `game_reviews`  (
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `game_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rating` int(11) NOT NULL DEFAULT 0,
  UNIQUE INDEX `game_reviews_user_id_game_id_unique`(`user_id`, `game_id`) USING BTREE,
  INDEX `game_reviews_game_id_foreign`(`game_id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of game_reviews
-- ----------------------------

-- ----------------------------
-- Table structure for games
-- ----------------------------
DROP TABLE IF EXISTS `games`;
CREATE TABLE `games`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `provider_id` int(10) UNSIGNED NOT NULL,
  `game_server_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `game_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `game_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `game_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `game_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cover` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `technology` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `has_lobby` tinyint(4) NOT NULL DEFAULT 0,
  `is_mobile` tinyint(4) NOT NULL DEFAULT 0,
  `has_freespins` tinyint(4) NOT NULL DEFAULT 0,
  `has_tables` tinyint(4) NOT NULL DEFAULT 0,
  `only_demo` tinyint(4) NULL DEFAULT 0,
  `rtp` bigint(20) NOT NULL COMMENT 'Controle de RTP em porcentagem',
  `distribution` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'O nome do provedor',
  `views` bigint(20) NOT NULL DEFAULT 0,
  `is_featured` tinyint(1) NULL DEFAULT 0,
  `show_home` tinyint(1) NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `games_provider_id_index`(`provider_id`) USING BTREE,
  INDEX `games_game_code_index`(`game_code`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2014 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of games
-- ----------------------------
INSERT INTO `games` VALUES (1, 9, NULL, 'bs-slot-goldenDragonInferno', 'Golden Dragon Inferno', 'bs-slot-goldenDragonInferno', NULL, NULL, 'fivers/bs-slot-goldenDragonInferno.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:24', '2024-04-12 13:50:24');
INSERT INTO `games` VALUES (2, 9, NULL, 'bs-tb-zoom-roulette', 'Zoom Roulette', 'bs-tb-zoom-roulette', NULL, NULL, 'fivers/bs-tb-zoom-roulette.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:25', '2024-04-12 13:50:25');
INSERT INTO `games` VALUES (3, 9, NULL, 'bs-slot-treasure-room', 'Treasure Room', 'bs-slot-treasure-room', NULL, NULL, 'fivers/bs-slot-treasure-room.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:26', '2024-04-12 13:50:26');
INSERT INTO `games` VALUES (4, 7, NULL, 'gaming7777-inst-zeus-quest', 'Zeus Quest', 'gaming7777-inst-zeus-quest', NULL, NULL, 'fivers/gaming7777-inst-zeus-quest.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:26', '2024-04-12 13:50:26');
INSERT INTO `games` VALUES (5, 7, NULL, 'gaming7777-slot-wizard-of-plenty', 'Wizard of Plenty', 'gaming7777-slot-wizard-of-plenty', NULL, NULL, 'fivers/gaming7777-slot-wizard-of-plenty.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:27', '2024-04-12 13:50:27');
INSERT INTO `games` VALUES (6, 7, NULL, 'gaming7777-tb-the-american-bingo', 'The American Bingo', 'gaming7777-tb-the-american-bingo', NULL, NULL, 'fivers/gaming7777-tb-the-american-bingo.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:27', '2024-04-12 13:50:27');
INSERT INTO `games` VALUES (7, 2, NULL, 'prag-tb-mega-baccarat', 'Mega Baccarat', 'prag-tb-mega-baccarat', NULL, NULL, 'fivers/prag-tb-mega-baccarat.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:28', '2024-04-12 13:50:28');
INSERT INTO `games` VALUES (8, 15, NULL, 'sms-tb-balloon', 'Balloon', 'sms-tb-balloon', NULL, NULL, 'fivers/sms-tb-balloon.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:29', '2024-04-12 13:50:29');
INSERT INTO `games` VALUES (9, 15, NULL, 'sms-tb-cappadocia', 'Cappadocia', 'sms-tb-cappadocia', NULL, NULL, 'fivers/sms-tb-cappadocia.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:30', '2024-04-12 13:50:30');
INSERT INTO `games` VALUES (10, 6, NULL, '3o-slot-dragonPearls', 'Dragon Pearls', '3o-slot-dragonPearls', NULL, NULL, 'fivers/3o-slot-dragonPearls.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:31', '2024-04-12 13:50:31');
INSERT INTO `games` VALUES (11, 10, NULL, 'boo-slot-buffaloHold', 'Buffalo Hold and Win', 'boo-slot-buffaloHold', NULL, NULL, 'fivers/boo-slot-buffaloHold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:31', '2024-04-12 13:50:31');
INSERT INTO `games` VALUES (12, 10, NULL, 'boo-slot-crazyBananas', 'Crazy Bananas', 'boo-slot-crazyBananas', NULL, NULL, 'fivers/boo-slot-crazyBananas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:32', '2024-04-12 13:50:32');
INSERT INTO `games` VALUES (13, 10, NULL, 'boo-slot-3x-boomingBananas', 'Booming Bananas', 'boo-slot-3x-boomingBananas', NULL, NULL, 'fivers/boo-slot-3x-boomingBananas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:33', '2024-04-12 13:50:33');
INSERT INTO `games` VALUES (14, 2, NULL, 'prag-tb-baccarat-401', 'Live Casino - Baccarat', 'prag-tb-baccarat-401', NULL, NULL, 'fivers/prag-tb-baccarat-401.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:33', '2024-04-12 13:50:33');
INSERT INTO `games` VALUES (15, 2, NULL, 'prag-tb-bj3', 'Blackjack 3 - Azure', 'prag-tb-bj3', NULL, NULL, 'fivers/prag-tb-bj3.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:34', '2024-04-12 13:50:34');
INSERT INTO `games` VALUES (16, 2, NULL, 'prag-tb-bj1', 'Blackjack 1 - Azure', 'prag-tb-bj1', NULL, NULL, 'fivers/prag-tb-bj1.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:35', '2024-04-12 13:50:35');
INSERT INTO `games` VALUES (17, 2, NULL, 'prag-tb-bj2', 'Blackjack 2 - Azure', 'prag-tb-bj2', NULL, NULL, 'fivers/prag-tb-bj2.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:36', '2024-04-12 13:50:36');
INSERT INTO `games` VALUES (18, 2, NULL, 'prag-tb-bj4', 'Blackjack 4 - Azure', 'prag-tb-bj4', NULL, NULL, 'fivers/prag-tb-bj4.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:37', '2024-04-12 13:50:37');
INSERT INTO `games` VALUES (19, 2, NULL, 'prag-tb-bj5', 'Blackjack 5 - Azure', 'prag-tb-bj5', NULL, NULL, 'fivers/prag-tb-bj5.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:38', '2024-04-12 13:50:38');
INSERT INTO `games` VALUES (20, 2, NULL, 'prag-tb-bj6', 'Blackjack 6 - Azure', 'prag-tb-bj6', NULL, NULL, 'fivers/prag-tb-bj6.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:38', '2024-04-12 13:50:38');
INSERT INTO `games` VALUES (21, 2, NULL, 'prag-tb-bj7', 'Blackjack 7 - Azure', 'prag-tb-bj7', NULL, NULL, 'fivers/prag-tb-bj7.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:39', '2024-04-12 13:50:39');
INSERT INTO `games` VALUES (22, 2, NULL, 'prag-tb-bj8', 'Blackjack 8 - Azure', 'prag-tb-bj8', NULL, NULL, 'fivers/prag-tb-bj8.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:40', '2024-04-12 13:50:40');
INSERT INTO `games` VALUES (23, 2, NULL, 'prag-tb-bj9', 'Blackjack 9 - Azure', 'prag-tb-bj9', NULL, NULL, 'fivers/prag-tb-bj9.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:41', '2024-04-12 13:50:41');
INSERT INTO `games` VALUES (24, 2, NULL, 'prag-tb-bj10', 'Blackjack 10 - Azure', 'prag-tb-bj10', NULL, NULL, 'fivers/prag-tb-bj10.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:42', '2024-04-12 13:50:42');
INSERT INTO `games` VALUES (25, 2, NULL, 'prag-tb-roulette1Azure', 'Roulette 1 Azure', 'prag-tb-roulette1Azure', NULL, NULL, 'fivers/prag-tb-roulette1Azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:43', '2024-04-12 13:50:43');
INSERT INTO `games` VALUES (26, 2, NULL, 'prag-tb-boomCity', 'Boom City', 'prag-tb-boomCity', NULL, NULL, 'fivers/prag-tb-boomCity.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:43', '2024-04-12 13:50:43');
INSERT INTO `games` VALUES (27, 2, NULL, 'prag-slot-roulette14-spanish', 'Roulette 14 - Spanish', 'prag-slot-roulette14-spanish', NULL, NULL, 'fivers/prag-slot-roulette14-spanish.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:44', '2024-04-12 13:50:44');
INSERT INTO `games` VALUES (28, 2, NULL, 'prag-tb-PowerUpRoulette', 'Power Up Roulette', 'prag-tb-PowerUpRoulette', NULL, NULL, 'fivers/prag-tb-PowerUpRoulette.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:45', '2024-04-12 13:50:45');
INSERT INTO `games` VALUES (29, 2, NULL, 'prag-tb-roulette205', 'Speed Roulette 2', 'prag-tb-roulette205', NULL, NULL, 'fivers/prag-tb-roulette205.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:46', '2024-04-12 13:50:46');
INSERT INTO `games` VALUES (30, 2, NULL, 'prag-tb-oneblack3', 'One Blackjack 3', 'prag-tb-oneblack3', NULL, NULL, 'fivers/prag-tb-oneblack3.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:47', '2024-04-12 13:50:47');
INSERT INTO `games` VALUES (31, 2, NULL, 'prag-tb-SnakesandLadders', 'Snakes and Ladders', 'prag-tb-SnakesandLadders', NULL, NULL, 'fivers/prag-tb-SnakesandLadders.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:48', '2024-04-12 13:50:48');
INSERT INTO `games` VALUES (32, 2, NULL, 'prag-tb-SpeedAutoRoulette', 'Speed Auto Roulette', 'prag-tb-SpeedAutoRoulette', NULL, NULL, 'fivers/prag-tb-SpeedAutoRoulette.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:48', '2024-04-12 13:50:48');
INSERT INTO `games` VALUES (33, 2, NULL, 'prag-tb-fortune-6-baccarat', 'Fortune 6 Baccarat', 'prag-tb-fortune-6-baccarat', NULL, NULL, 'fivers/prag-tb-fortune-6-baccarat.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:49', '2024-04-12 13:50:49');
INSERT INTO `games` VALUES (34, 2, NULL, 'prag-tb-baccarat-lobby', 'Baccarat Lobby', 'prag-tb-baccarat-lobby', NULL, NULL, 'fivers/prag-tb-baccarat-lobby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:50', '2024-04-12 13:50:50');
INSERT INTO `games` VALUES (35, 2, NULL, 'prag-tb-super-8-baccarat', 'Super 8 Baccarat', 'prag-tb-super-8-baccarat', NULL, NULL, 'fivers/prag-tb-super-8-baccarat.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:51', '2024-04-12 13:50:51');
INSERT INTO `games` VALUES (36, 2, NULL, 'prag-tb-blackjack-lobby', 'Blackjack Lobby', 'prag-tb-blackjack-lobby', NULL, NULL, 'fivers/prag-tb-blackjack-lobby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:52', '2024-04-12 13:50:52');
INSERT INTO `games` VALUES (37, 2, NULL, 'prag-tb-speed-blackjack-1-ruby', 'Speed Blackjack 1 - Ruby', 'prag-tb-speed-blackjack-1-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-1-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:53', '2024-04-12 13:50:53');
INSERT INTO `games` VALUES (38, 2, NULL, 'prag-tb-speed-blackjack-2-ruby', 'Speed Blackjack 2 - Ruby', 'prag-tb-speed-blackjack-2-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-2-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:54', '2024-04-12 13:50:54');
INSERT INTO `games` VALUES (39, 2, NULL, 'prag-tb-speed-blackjack-3-ruby', 'Speed Blackjack 3 - Ruby', 'prag-tb-speed-blackjack-3-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-3-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:54', '2024-04-12 13:50:54');
INSERT INTO `games` VALUES (40, 2, NULL, 'prag-tb-speed-blackjack-4-ruby', 'Speed Blackjack 4 - Ruby', 'prag-tb-speed-blackjack-4-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-4-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:55', '2024-04-12 13:50:55');
INSERT INTO `games` VALUES (41, 2, NULL, 'prag-tb-speed-blackjack-5-ruby', 'Speed Blackjack 5 - Ruby', 'prag-tb-speed-blackjack-5-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-5-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:56', '2024-04-12 13:50:56');
INSERT INTO `games` VALUES (42, 2, NULL, 'prag-tb-speed-blackjack-6-ruby', 'Speed Blackjack 6 - Ruby', 'prag-tb-speed-blackjack-6-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-6-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:57', '2024-04-12 13:50:57');
INSERT INTO `games` VALUES (43, 2, NULL, 'prag-tb-speed-blackjack-7-ruby', 'Speed Blackjack 7 - Ruby', 'prag-tb-speed-blackjack-7-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-7-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:58', '2024-04-12 13:50:58');
INSERT INTO `games` VALUES (44, 2, NULL, 'prag-tb-speed-blackjack-8-ruby', 'Speed Blackjack 8 - Ruby', 'prag-tb-speed-blackjack-8-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-8-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:50:59', '2024-04-12 13:50:59');
INSERT INTO `games` VALUES (45, 2, NULL, 'prag-tb-speed-blackjack-10-ruby', 'Speed Blackjack 10 - Ruby', 'prag-tb-speed-blackjack-10-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-10-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:00', '2024-04-12 13:51:00');
INSERT INTO `games` VALUES (46, 2, NULL, 'prag-tb-speed-blackjack-11-  azure', 'Speed Blackjack 11 - Azure', 'prag-tb-speed-blackjack-11-  azure', NULL, NULL, 'fivers/prag-tb-speed-blackjack-11-  azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:00', '2024-04-12 13:51:00');
INSERT INTO `games` VALUES (47, 2, NULL, 'prag-tb-speed-blackjack-12-  azure', 'Speed Blackjack 12 - Azure', 'prag-tb-speed-blackjack-12-  azure', NULL, NULL, 'fivers/prag-tb-speed-blackjack-12-  azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:01', '2024-04-12 13:51:01');
INSERT INTO `games` VALUES (48, 2, NULL, 'prag-tb-speed-blackjack-14-  azure', 'Speed Blackjack 14 - Azure', 'prag-tb-speed-blackjack-14-  azure', NULL, NULL, 'fivers/prag-tb-speed-blackjack-14-  azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:02', '2024-04-12 13:51:02');
INSERT INTO `games` VALUES (49, 2, NULL, 'prag-tb-speed-blackjack-15-ruby', 'Speed Blackjack - 15 Ruby', 'prag-tb-speed-blackjack-15-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-15-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:03', '2024-04-12 13:51:03');
INSERT INTO `games` VALUES (50, 2, NULL, 'prag-tb-speed-blackjack-16-ruby', 'Speed Blackjack - 16 Ruby', 'prag-tb-speed-blackjack-16-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-16-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:04', '2024-04-12 13:51:04');
INSERT INTO `games` VALUES (51, 2, NULL, 'prag-tb-speed-blackjack-17-ruby', 'Speed Blackjack - 17 Ruby', 'prag-tb-speed-blackjack-17-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-17-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:05', '2024-04-12 13:51:05');
INSERT INTO `games` VALUES (52, 2, NULL, 'prag-tb-speed-blackjack-18-ruby', 'Speed Blackjack - 18 Ruby', 'prag-tb-speed-blackjack-18-ruby', NULL, NULL, 'fivers/prag-tb-speed-blackjack-18-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:06', '2024-04-12 13:51:06');
INSERT INTO `games` VALUES (53, 2, NULL, 'prag-tb-vip-blackjack-1-ruby', 'VIP Blackjack 1 - Ruby', 'prag-tb-vip-blackjack-1-ruby', NULL, NULL, 'fivers/prag-tb-vip-blackjack-1-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:06', '2024-04-12 13:51:06');
INSERT INTO `games` VALUES (54, 2, NULL, 'prag-tb-vip-blackjack-2-ruby', 'VIP Blackjack 2 - Ruby', 'prag-tb-vip-blackjack-2-ruby', NULL, NULL, 'fivers/prag-tb-vip-blackjack-2-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:07', '2024-04-12 13:51:07');
INSERT INTO `games` VALUES (55, 2, NULL, 'prag-tb-vip-blackjack-3-ruby', 'VIP Blackjack 3 - Ruby', 'prag-tb-vip-blackjack-3-ruby', NULL, NULL, 'fivers/prag-tb-vip-blackjack-3-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:08', '2024-04-12 13:51:08');
INSERT INTO `games` VALUES (56, 2, NULL, 'prag-tb-vip-blackjack-4-ruby', 'VIP Blackjack 4 - Ruby', 'prag-tb-vip-blackjack-4-ruby', NULL, NULL, 'fivers/prag-tb-vip-blackjack-4-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:09', '2024-04-12 13:51:09');
INSERT INTO `games` VALUES (57, 2, NULL, 'prag-tb-vip-blackjack-5-ruby', 'VIP Blackjack 5 - Ruby', 'prag-tb-vip-blackjack-5-ruby', NULL, NULL, 'fivers/prag-tb-vip-blackjack-5-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:10', '2024-04-12 13:51:10');
INSERT INTO `games` VALUES (58, 2, NULL, 'prag-tb-one-blackjack-4-flemish', 'ONE Blackjack 4 - Flemish', 'prag-tb-one-blackjack-4-flemish', NULL, NULL, 'fivers/prag-tb-one-blackjack-4-flemish.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:11', '2024-04-12 13:51:11');
INSERT INTO `games` VALUES (59, 2, NULL, 'prag-tb-blackjack-50-ruby', 'Blackjack 50 - Ruby', 'prag-tb-blackjack-50-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-50-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:12', '2024-04-12 13:51:12');
INSERT INTO `games` VALUES (60, 2, NULL, 'prag-tb-blackjack-51-ruby', 'Blackjack 51 - Ruby', 'prag-tb-blackjack-51-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-51-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:12', '2024-04-12 13:51:12');
INSERT INTO `games` VALUES (61, 2, NULL, 'prag-tb-blackjack-52-ruby', 'Blackjack 52 - Ruby', 'prag-tb-blackjack-52-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-52-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:13', '2024-04-12 13:51:13');
INSERT INTO `games` VALUES (62, 2, NULL, 'prag-tb-blackjack-53-ruby', 'Blackjack 53 - Ruby', 'prag-tb-blackjack-53-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-53-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:14', '2024-04-12 13:51:14');
INSERT INTO `games` VALUES (63, 2, NULL, 'prag-tb-blackjack-54-ruby', 'Blackjack 54 - Ruby', 'prag-tb-blackjack-54-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-54-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:15', '2024-04-12 13:51:15');
INSERT INTO `games` VALUES (64, 2, NULL, 'prag-tb-blackjack-55-ruby', 'Blackjack 55 - Ruby', 'prag-tb-blackjack-55-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-55-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:16', '2024-04-12 13:51:16');
INSERT INTO `games` VALUES (65, 2, NULL, 'prag-tb-blackjack-57-azure', 'Blackjack 57 - Azure', 'prag-tb-blackjack-57-azure', NULL, NULL, 'fivers/prag-tb-blackjack-57-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:17', '2024-04-12 13:51:17');
INSERT INTO `games` VALUES (66, 2, NULL, 'prag-tb-blackjack-58-azure', 'Blackjack 58 - Azure', 'prag-tb-blackjack-58-azure', NULL, NULL, 'fivers/prag-tb-blackjack-58-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:18', '2024-04-12 13:51:18');
INSERT INTO `games` VALUES (67, 2, NULL, 'prag-tb-blackjack-59-azure', 'Blackjack 59 - Azure', 'prag-tb-blackjack-59-azure', NULL, NULL, 'fivers/prag-tb-blackjack-59-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:18', '2024-04-12 13:51:18');
INSERT INTO `games` VALUES (68, 2, NULL, 'prag-tb-blackjack-60-azure', 'Blackjack 60 - Azure', 'prag-tb-blackjack-60-azure', NULL, NULL, 'fivers/prag-tb-blackjack-60-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:19', '2024-04-12 13:51:19');
INSERT INTO `games` VALUES (69, 2, NULL, 'prag-tb-blackjack-61-azure', 'Blackjack 61 - Azure', 'prag-tb-blackjack-61-azure', NULL, NULL, 'fivers/prag-tb-blackjack-61-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:20', '2024-04-12 13:51:20');
INSERT INTO `games` VALUES (70, 2, NULL, 'prag-tb-blackjack-62-azure', 'Blackjack 62 - Azure', 'prag-tb-blackjack-62-azure', NULL, NULL, 'fivers/prag-tb-blackjack-62-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:21', '2024-04-12 13:51:21');
INSERT INTO `games` VALUES (71, 2, NULL, 'prag-tb-blackjack-63-azure', 'Blackjack 63 - Azure', 'prag-tb-blackjack-63-azure', NULL, NULL, 'fivers/prag-tb-blackjack-63-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:22', '2024-04-12 13:51:22');
INSERT INTO `games` VALUES (72, 2, NULL, 'prag-tb-blackjack-64-ruby', 'Blackjack 64 - Ruby', 'prag-tb-blackjack-64-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-64-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:23', '2024-04-12 13:51:23');
INSERT INTO `games` VALUES (73, 2, NULL, 'prag-tb-blackjack-65-ruby', 'Blackjack 65 - Ruby', 'prag-tb-blackjack-65-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-65-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:24', '2024-04-12 13:51:24');
INSERT INTO `games` VALUES (74, 2, NULL, 'prag-tb-blackjack-66-ruby', 'Blackjack 66 - Ruby', 'prag-tb-blackjack-66-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-66-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:25', '2024-04-12 13:51:25');
INSERT INTO `games` VALUES (75, 2, NULL, 'prag-tb-blackjack-67-ruby', 'Blackjack 67 - Ruby', 'prag-tb-blackjack-67-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-67-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:25', '2024-04-12 13:51:25');
INSERT INTO `games` VALUES (76, 2, NULL, 'prag-tb-blackjack-68-ruby', 'Blackjack 68 - Ruby', 'prag-tb-blackjack-68-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-68-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:26', '2024-04-12 13:51:26');
INSERT INTO `games` VALUES (77, 2, NULL, 'prag-tb-blackjack-69-ruby', 'Blackjack 69 - Ruby', 'prag-tb-blackjack-69-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-69-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:27', '2024-04-12 13:51:27');
INSERT INTO `games` VALUES (78, 2, NULL, 'prag-tb-blackjack-70-ruby', 'Blackjack 70 - Ruby', 'prag-tb-blackjack-70-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-70-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:28', '2024-04-12 13:51:28');
INSERT INTO `games` VALUES (79, 2, NULL, 'prag-tb-blackjack-71-ruby', 'Blackjack 71 - Ruby', 'prag-tb-blackjack-71-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-71-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:29', '2024-04-12 13:51:29');
INSERT INTO `games` VALUES (80, 2, NULL, 'prag-tb-blackjack-72-ruby', 'Blackjack 72 - Ruby', 'prag-tb-blackjack-72-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-72-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:30', '2024-04-12 13:51:30');
INSERT INTO `games` VALUES (81, 2, NULL, 'prag-tb-blackjack-73-ruby', 'Blackjack 73 - Ruby', 'prag-tb-blackjack-73-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-73-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:30', '2024-04-12 13:51:30');
INSERT INTO `games` VALUES (82, 2, NULL, 'prag-tb-blackjack-74-ruby', 'Blackjack 74 - Ruby', 'prag-tb-blackjack-74-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-74-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:31', '2024-04-12 13:51:31');
INSERT INTO `games` VALUES (83, 2, NULL, 'prag-tb-blackjack-49-ruby', 'Blackjack 49 - Ruby', 'prag-tb-blackjack-49-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-49-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:32', '2024-04-12 13:51:32');
INSERT INTO `games` VALUES (84, 2, NULL, 'prag-tb-blackjack-48-ruby', 'Blackjack 48 - Ruby', 'prag-tb-blackjack-48-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-48-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:33', '2024-04-12 13:51:33');
INSERT INTO `games` VALUES (85, 2, NULL, 'prag-tb-blackjack-47-ruby', 'Blackjack 47 - Ruby', 'prag-tb-blackjack-47-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-47-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:34', '2024-04-12 13:51:34');
INSERT INTO `games` VALUES (86, 2, NULL, 'prag-tb-blackjack-46-ruby', 'Blackjack 46 - Ruby', 'prag-tb-blackjack-46-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-46-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:35', '2024-04-12 13:51:35');
INSERT INTO `games` VALUES (87, 2, NULL, 'prag-tb-blackjack-45-ruby', 'Blackjack 45 - Ruby', 'prag-tb-blackjack-45-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-45-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:36', '2024-04-12 13:51:36');
INSERT INTO `games` VALUES (88, 2, NULL, 'prag-tb-blackjack-44-ruby', 'Blackjack 44 - Ruby', 'prag-tb-blackjack-44-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-44-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:37', '2024-04-12 13:51:37');
INSERT INTO `games` VALUES (89, 2, NULL, 'prag-tb-blackjack-43-ruby', 'Blackjack 43 - Ruby', 'prag-tb-blackjack-43-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-43-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:38', '2024-04-12 13:51:38');
INSERT INTO `games` VALUES (90, 2, NULL, 'prag-tb-blackjack-42-ruby', 'Blackjack 42 - Ruby', 'prag-tb-blackjack-42-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-42-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:39', '2024-04-12 13:51:39');
INSERT INTO `games` VALUES (91, 2, NULL, 'prag-tb-blackjack-41-ruby', 'Blackjack 41 - Ruby', 'prag-tb-blackjack-41-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-41-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:40', '2024-04-12 13:51:40');
INSERT INTO `games` VALUES (92, 2, NULL, 'prag-tb-blackjack-40-ruby', 'Blackjack 40 - Ruby', 'prag-tb-blackjack-40-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-40-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:41', '2024-04-12 13:51:41');
INSERT INTO `games` VALUES (93, 2, NULL, 'prag-tb-blackjack-39-ruby', 'Blackjack 39 - Ruby', 'prag-tb-blackjack-39-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-39-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:42', '2024-04-12 13:51:42');
INSERT INTO `games` VALUES (94, 2, NULL, 'prag-tb-blackjack-38-ruby', 'Blackjack 38 - Ruby', 'prag-tb-blackjack-38-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-38-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:43', '2024-04-12 13:51:43');
INSERT INTO `games` VALUES (95, 2, NULL, 'prag-tb-blackjack-37-ruby', 'Blackjack 37 - Ruby', 'prag-tb-blackjack-37-ruby', NULL, NULL, 'fivers/prag-tb-blackjack-37-ruby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:44', '2024-04-12 13:51:44');
INSERT INTO `games` VALUES (96, 2, NULL, 'prag-tb-blackjack-36-the-club', 'Blackjack 36 - The Club', 'prag-tb-blackjack-36-the-club', NULL, NULL, 'fivers/prag-tb-blackjack-36-the-club.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:45', '2024-04-12 13:51:45');
INSERT INTO `games` VALUES (97, 2, NULL, 'prag-tb-blackjack-35-the-club', 'Blackjack 35 - The Club', 'prag-tb-blackjack-35-the-club', NULL, NULL, 'fivers/prag-tb-blackjack-35-the-club.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:46', '2024-04-12 13:51:46');
INSERT INTO `games` VALUES (98, 2, NULL, 'prag-tb-blackjack-34-the-club', 'Blackjack 34 - The Club', 'prag-tb-blackjack-34-the-club', NULL, NULL, 'fivers/prag-tb-blackjack-34-the-club.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:47', '2024-04-12 13:51:47');
INSERT INTO `games` VALUES (99, 2, NULL, 'prag-tb-blackjack-33-the-club', 'Blackjack 33 - The Club', 'prag-tb-blackjack-33-the-club', NULL, NULL, 'fivers/prag-tb-blackjack-33-the-club.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:48', '2024-04-12 13:51:48');
INSERT INTO `games` VALUES (100, 2, NULL, 'prag-tb-blackjack-32-azure', 'Blackjack 32 - Azure (Azure Studio II)', 'prag-tb-blackjack-32-azure', NULL, NULL, 'fivers/prag-tb-blackjack-32-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:49', '2024-04-12 13:51:49');
INSERT INTO `games` VALUES (101, 2, NULL, 'prag-tb-blackjack-31-azure', 'Blackjack 31 - Azure (Azure Studio II)', 'prag-tb-blackjack-31-azure', NULL, NULL, 'fivers/prag-tb-blackjack-31-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:50', '2024-04-12 13:51:50');
INSERT INTO `games` VALUES (102, 2, NULL, 'prag-tb-blackjack-30-azure', 'Blackjack 30 - Azure (Azure Studio II)', 'prag-tb-blackjack-30-azure', NULL, NULL, 'fivers/prag-tb-blackjack-30-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:51', '2024-04-12 13:51:51');
INSERT INTO `games` VALUES (103, 2, NULL, 'prag-tb-blackjack-29-azure', 'Blackjack 29 - Azure (Azure Studio II)', 'prag-tb-blackjack-29-azure', NULL, NULL, 'fivers/prag-tb-blackjack-29-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:52', '2024-04-12 13:51:52');
INSERT INTO `games` VALUES (104, 2, NULL, 'prag-tb-blackjack-28-azure', 'Blackjack 28 - Azure (Azure Studio II)', 'prag-tb-blackjack-28-azure', NULL, NULL, 'fivers/prag-tb-blackjack-28-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:53', '2024-04-12 13:51:53');
INSERT INTO `games` VALUES (105, 2, NULL, 'prag-tb-blackjack-27-azure', 'Blackjack 27 - Azure (Azure Studio II)', 'prag-tb-blackjack-27-azure', NULL, NULL, 'fivers/prag-tb-blackjack-27-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:54', '2024-04-12 13:51:54');
INSERT INTO `games` VALUES (106, 2, NULL, 'prag-tb-blackjack-26-azure', 'Blackjack 26 - Azure (Azure Studio II)', 'prag-tb-blackjack-26-azure', NULL, NULL, 'fivers/prag-tb-blackjack-26-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:55', '2024-04-12 13:51:55');
INSERT INTO `games` VALUES (107, 2, NULL, 'prag-tb-blackjack-25-azure', 'Blackjack 25 - Azure (Azure Studio II)', 'prag-tb-blackjack-25-azure', NULL, NULL, 'fivers/prag-tb-blackjack-25-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:56', '2024-04-12 13:51:56');
INSERT INTO `games` VALUES (108, 2, NULL, 'prag-tb-blackjack-24-azure', 'Blackjack 24 - Azure (Azure Studio II)', 'prag-tb-blackjack-24-azure', NULL, NULL, 'fivers/prag-tb-blackjack-24-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:57', '2024-04-12 13:51:57');
INSERT INTO `games` VALUES (109, 2, NULL, 'prag-tb-blackjack-23-azure', 'Blackjack 23 - Azure (Azure Studio II)', 'prag-tb-blackjack-23-azure', NULL, NULL, 'fivers/prag-tb-blackjack-23-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:51:59', '2024-04-12 13:51:59');
INSERT INTO `games` VALUES (110, 2, NULL, 'prag-tb-blackjack-22-azure', 'Blackjack 22 - Azure (Azure Studio II)', 'prag-tb-blackjack-22-azure', NULL, NULL, 'fivers/prag-tb-blackjack-22-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:00', '2024-04-12 13:52:00');
INSERT INTO `games` VALUES (111, 2, NULL, 'prag-tb-blackjack-21-azure', 'Blackjack 21 - Azure (Azure Studio II)', 'prag-tb-blackjack-21-azure', NULL, NULL, 'fivers/prag-tb-blackjack-21-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:01', '2024-04-12 13:52:01');
INSERT INTO `games` VALUES (112, 2, NULL, 'prag-tb-blackjack-20-azure', 'Blackjack 20 - Azure (Azure Studio II)', 'prag-tb-blackjack-20-azure', NULL, NULL, 'fivers/prag-tb-blackjack-20-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:02', '2024-04-12 13:52:02');
INSERT INTO `games` VALUES (113, 2, NULL, 'prag-tb-blackjack-19-azure', 'Blackjack 19 - Azure (Azure Studio II)', 'prag-tb-blackjack-19-azure', NULL, NULL, 'fivers/prag-tb-blackjack-19-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:03', '2024-04-12 13:52:03');
INSERT INTO `games` VALUES (114, 2, NULL, 'prag-tb-blackjack-18-azure', 'Blackjack 18 - Azure (Azure Studio II)', 'prag-tb-blackjack-18-azure', NULL, NULL, 'fivers/prag-tb-blackjack-18-azure.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:04', '2024-04-12 13:52:04');
INSERT INTO `games` VALUES (115, 2, NULL, 'prag-tb-blackjack-11', 'Blackjack 11 (Green Studio)', 'prag-tb-blackjack-11', NULL, NULL, 'fivers/prag-tb-blackjack-11.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:05', '2024-04-12 13:52:05');
INSERT INTO `games` VALUES (116, 2, NULL, 'prag-tb-blackjack-15', 'Blackjack 15 (Green Studio)', 'prag-tb-blackjack-15', NULL, NULL, 'fivers/prag-tb-blackjack-15.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:06', '2024-04-12 13:52:06');
INSERT INTO `games` VALUES (117, 2, NULL, 'prag-tb-roulette-lobby', 'Roulette Lobby', 'prag-tb-roulette-lobby', NULL, NULL, 'fivers/prag-tb-roulette-lobby.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:07', '2024-04-12 13:52:07');
INSERT INTO `games` VALUES (118, 2, NULL, 'prag-tb-roulette-3-macao', 'Roulette 3 - Macao', 'prag-tb-roulette-3-macao', NULL, NULL, 'fivers/prag-tb-roulette-3-macao.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:08', '2024-04-12 13:52:08');
INSERT INTO `games` VALUES (119, 2, NULL, 'prag-tb-roulette-4-russian', 'Roulette 4 - Russian', 'prag-tb-roulette-4-russian', NULL, NULL, 'fivers/prag-tb-roulette-4-russian.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:09', '2024-04-12 13:52:09');
INSERT INTO `games` VALUES (120, 2, NULL, 'prag-tb-roulette-5-german', 'Roulette 5 - German', 'prag-tb-roulette-5-german', NULL, NULL, 'fivers/prag-tb-roulette-5-german.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:10', '2024-04-12 13:52:10');
INSERT INTO `games` VALUES (121, 2, NULL, 'prag-tb-roulette-7-italian', 'Roulette 7 - Italian', 'prag-tb-roulette-7-italian', NULL, NULL, 'fivers/prag-tb-roulette-7-italian.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:11', '2024-04-12 13:52:11');
INSERT INTO `games` VALUES (122, 2, NULL, 'prag-tb-roulette-6-turkish', 'Roulette 6 - Turkish', 'prag-tb-roulette-6-turkish', NULL, NULL, 'fivers/prag-tb-roulette-6-turkish.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:12', '2024-04-12 13:52:12');
INSERT INTO `games` VALUES (123, 2, NULL, 'prag-tb-roulette-11-dutch', 'Roulette 11 - Dutch', 'prag-tb-roulette-11-dutch', NULL, NULL, 'fivers/prag-tb-roulette-11-dutch.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:13', '2024-04-12 13:52:13');
INSERT INTO `games` VALUES (124, 2, NULL, 'prag-tb-roulette-12-romanian', 'Roulette 12 - Romanian', 'prag-tb-roulette-12-romanian', NULL, NULL, 'fivers/prag-tb-roulette-12-romanian.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:14', '2024-04-12 13:52:14');
INSERT INTO `games` VALUES (125, 2, NULL, 'prag-tb-roulette-15-flemish', 'Roulette 15 - Flemish', 'prag-tb-roulette-15-flemish', NULL, NULL, 'fivers/prag-tb-roulette-15-flemish.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:15', '2024-04-12 13:52:15');
INSERT INTO `games` VALUES (126, 2, NULL, 'prag-tb-roulette-16-swedish', 'Roulette 16 - Swedish', 'prag-tb-roulette-16-swedish', NULL, NULL, 'fivers/prag-tb-roulette-16-swedish.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:16', '2024-04-12 13:52:16');
INSERT INTO `games` VALUES (127, 2, NULL, 'prag-tb-baccarat-2', 'Baccarat-2', 'prag-tb-baccarat-2', NULL, NULL, 'fivers/prag-tb-baccarat-2.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:17', '2024-04-12 13:52:17');
INSERT INTO `games` VALUES (128, 2, NULL, 'prag-tb-baccarat-3', 'Baccarat-3', 'prag-tb-baccarat-3', NULL, NULL, 'fivers/prag-tb-baccarat-3.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:18', '2024-04-12 13:52:18');
INSERT INTO `games` VALUES (129, 2, NULL, 'prag-tb-baccarat-5', 'Baccarat-5', 'prag-tb-baccarat-5', NULL, NULL, 'fivers/prag-tb-baccarat-5.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:19', '2024-04-12 13:52:19');
INSERT INTO `games` VALUES (130, 2, NULL, 'prag-tb-baccarat-6', 'Baccarat-6', 'prag-tb-baccarat-6', NULL, NULL, 'fivers/prag-tb-baccarat-6.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:20', '2024-04-12 13:52:20');
INSERT INTO `games` VALUES (131, 2, NULL, 'prag-tb-baccarat-8', 'Baccarat-8', 'prag-tb-baccarat-8', NULL, NULL, 'fivers/prag-tb-baccarat-8.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:21', '2024-04-12 13:52:21');
INSERT INTO `games` VALUES (132, 2, NULL, 'prag-tb-speed-baccarat-2', 'Speed Baccarat 2', 'prag-tb-speed-baccarat-2', NULL, NULL, 'fivers/prag-tb-speed-baccarat-2.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:22', '2024-04-12 13:52:22');
INSERT INTO `games` VALUES (133, 2, NULL, 'prag-tb-no-comm-baccarat-1', 'No Comm Baccarat 1', 'prag-tb-no-comm-baccarat-1', NULL, NULL, 'fivers/prag-tb-no-comm-baccarat-1.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:23', '2024-04-12 13:52:23');
INSERT INTO `games` VALUES (134, 2, NULL, 'prag-tb-speed-baccarat-3', 'Speed Baccarat 3', 'prag-tb-speed-baccarat-3', NULL, NULL, 'fivers/prag-tb-speed-baccarat-3.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:24', '2024-04-12 13:52:24');
INSERT INTO `games` VALUES (135, 2, NULL, 'prag-tb-speed-baccarat-5', 'Speed Baccarat 5', 'prag-tb-speed-baccarat-5', NULL, NULL, 'fivers/prag-tb-speed-baccarat-5.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:25', '2024-04-12 13:52:25');
INSERT INTO `games` VALUES (136, 2, NULL, 'prag-tb-speed-baccarat-6', 'Speed Baccarat 6', 'prag-tb-speed-baccarat-6', NULL, NULL, 'fivers/prag-tb-speed-baccarat-6.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:26', '2024-04-12 13:52:26');
INSERT INTO `games` VALUES (137, 2, NULL, 'prag-tb-speed-baccarat-10', 'Speed Baccarat 10', 'prag-tb-speed-baccarat-10', NULL, NULL, 'fivers/prag-tb-speed-baccarat-10.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:27', '2024-04-12 13:52:27');
INSERT INTO `games` VALUES (138, 2, NULL, 'prag-tb-speed-baccarat-11', 'Speed Baccarat 11', 'prag-tb-speed-baccarat-11', NULL, NULL, 'fivers/prag-tb-speed-baccarat-11.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:28', '2024-04-12 13:52:28');
INSERT INTO `games` VALUES (139, 2, NULL, 'prag-tb-speed-baccarat-12', 'Speed Baccarat 12', 'prag-tb-speed-baccarat-12', NULL, NULL, 'fivers/prag-tb-speed-baccarat-12.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:29', '2024-04-12 13:52:29');
INSERT INTO `games` VALUES (140, 2, NULL, 'prag-tb-speed-baccarat-13', 'Speed Baccarat 13', 'prag-tb-speed-baccarat-13', NULL, NULL, 'fivers/prag-tb-speed-baccarat-13.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:30', '2024-04-12 13:52:30');
INSERT INTO `games` VALUES (141, 2, NULL, 'prag-tb-speed-baccarat-14', 'Speed Baccarat 14', 'prag-tb-speed-baccarat-14', NULL, NULL, 'fivers/prag-tb-speed-baccarat-14.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:31', '2024-04-12 13:52:31');
INSERT INTO `games` VALUES (142, 2, NULL, 'prag-tb-speed-baccarat-15', 'Speed Baccarat 15', 'prag-tb-speed-baccarat-15', NULL, NULL, 'fivers/prag-tb-speed-baccarat-15.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:32', '2024-04-12 13:52:32');
INSERT INTO `games` VALUES (143, 2, NULL, 'prag-tb-no-comm-speed-baccarat-1', 'No Comm Speed Baccarat 1', 'prag-tb-no-comm-speed-baccarat-1', NULL, NULL, 'fivers/prag-tb-no-comm-speed-baccarat-1.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:33', '2024-04-12 13:52:33');
INSERT INTO `games` VALUES (144, 2, NULL, 'prag-tb-no-comm-speed-baccarat-2', 'No Comm Speed Baccarat 2', 'prag-tb-no-comm-speed-baccarat-2', NULL, NULL, 'fivers/prag-tb-no-comm-speed-baccarat-2.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:34', '2024-04-12 13:52:34');
INSERT INTO `games` VALUES (145, 2, NULL, 'prag-tb-speed-baccarat-1-korean', 'Speed Baccarat 1 - Korean', 'prag-tb-speed-baccarat-1-korean', NULL, NULL, 'fivers/prag-tb-speed-baccarat-1-korean.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:35', '2024-04-12 13:52:35');
INSERT INTO `games` VALUES (146, 2, NULL, 'prag-tb-speed-baccarat-2-korean', 'Speed Baccarat 2 - Korean', 'prag-tb-speed-baccarat-2-korean', NULL, NULL, 'fivers/prag-tb-speed-baccarat-2-korean.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:36', '2024-04-12 13:52:36');
INSERT INTO `games` VALUES (147, 2, NULL, 'prag-tb-automegaroulette', 'Auto Mega Roulette', 'prag-tb-automegaroulette', NULL, NULL, 'fivers/prag-tb-automegaroulette.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:37', '2024-04-12 13:52:37');
INSERT INTO `games` VALUES (148, 2, NULL, 'prag-tb-vegasballbonanza', 'Vegas Ball Bonanza', 'prag-tb-vegasballbonanza', NULL, NULL, 'fivers/prag-tb-vegasballbonanza.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:38', '2024-04-12 13:52:38');
INSERT INTO `games` VALUES (149, 2, NULL, 'prag-tb-SpeedBJ30Emerald', 'Speed Blackjack 30 - Emerald', 'prag-tb-SpeedBJ30Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ30Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:39', '2024-04-12 13:52:39');
INSERT INTO `games` VALUES (150, 2, NULL, 'prag-tb-SpeedBJ29Emerald', 'Speed Blackjack 29 - Emerald', 'prag-tb-SpeedBJ29Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ29Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:40', '2024-04-12 13:52:40');
INSERT INTO `games` VALUES (151, 2, NULL, 'prag-tb-SpeedBJ28Emerald', 'Speed Blackjack 28 - Emerald', 'prag-tb-SpeedBJ28Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ28Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:41', '2024-04-12 13:52:41');
INSERT INTO `games` VALUES (152, 2, NULL, 'prag-tb-SpeedBJ27Emerald', 'Speed Blackjack 27 - Emerald', 'prag-tb-SpeedBJ27Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ27Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:42', '2024-04-12 13:52:42');
INSERT INTO `games` VALUES (153, 2, NULL, 'prag-tb-SpeedBJ26Emerald', 'Speed Blackjack 26 - Emerald', 'prag-tb-SpeedBJ26Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ26Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:43', '2024-04-12 13:52:43');
INSERT INTO `games` VALUES (154, 2, NULL, 'prag-tb-SpeedBJ25Emerald', 'Speed Blackjack 25 - Emerald', 'prag-tb-SpeedBJ25Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ25Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:44', '2024-04-12 13:52:44');
INSERT INTO `games` VALUES (155, 2, NULL, 'prag-tb-SpeedBJ24Emerald', 'Speed Blackjack 24 - Emerald', 'prag-tb-SpeedBJ24Emerald', NULL, NULL, 'fivers/prag-tb-SpeedBJ24Emerald.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:45', '2024-04-12 13:52:45');
INSERT INTO `games` VALUES (156, 2, NULL, 'prag-BrazilianRoulette', 'Brazilian Roulette', 'prag-BrazilianRoulette', NULL, NULL, 'fivers/prag-BrazilianRoulette.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:46', '2024-04-12 13:52:46');
INSERT INTO `games` VALUES (157, 19, NULL, 'prag-slot-jokersJewels', 'Jokers Jewels', 'prag-slot-jokersJewels', NULL, NULL, 'fivers/prag-slot-jokersJewels.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:46', '2024-04-12 13:52:46');
INSERT INTO `games` VALUES (158, 19, NULL, 'prag-slot-888Dragons', '888Dragons', 'prag-slot-888Dragons', NULL, NULL, 'fivers/prag-slot-888Dragons.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:47', '2024-04-12 13:52:47');
INSERT INTO `games` VALUES (159, 19, NULL, 'prag-slot-drago-JewelsofFortune', 'Drago Jewels of Fortune', 'prag-slot-drago-JewelsofFortune', NULL, NULL, 'fivers/prag-slot-drago-JewelsofFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:48', '2024-04-12 13:52:48');
INSERT INTO `games` VALUES (160, 19, NULL, 'prag-slot-hottoBurn', 'Hotto Burn', 'prag-slot-hottoBurn', NULL, NULL, 'fivers/prag-slot-hottoBurn.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:48', '2024-04-12 13:52:48');
INSERT INTO `games` VALUES (161, 19, NULL, 'prag-slot-caishensCash', 'Caishens Cash', 'prag-slot-caishensCash', NULL, NULL, 'fivers/prag-slot-caishensCash.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:49', '2024-04-12 13:52:49');
INSERT INTO `games` VALUES (162, 19, NULL, 'prag-slot-caishensGold', 'Caishens Gold', 'prag-slot-caishensGold', NULL, NULL, 'fivers/prag-slot-caishensGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:50', '2024-04-12 13:52:50');
INSERT INTO `games` VALUES (163, 19, NULL, 'prag-slot-pandasFortune', 'Pandas Fortune', 'prag-slot-pandasFortune', NULL, NULL, 'fivers/prag-slot-pandasFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:51', '2024-04-12 13:52:51');
INSERT INTO `games` VALUES (164, 19, NULL, 'prag-slot-masterChensFortune', 'Master Chens Fortune', 'prag-slot-masterChensFortune', NULL, NULL, 'fivers/prag-slot-masterChensFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:51', '2024-04-12 13:52:51');
INSERT INTO `games` VALUES (165, 19, NULL, 'prag-slot-irishCharms', 'Irish Charms', 'prag-slot-irishCharms', NULL, NULL, 'fivers/prag-slot-irishCharms.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:52', '2024-04-12 13:52:52');
INSERT INTO `games` VALUES (166, 19, NULL, 'prag-slot-bookOfKingdoms', 'Book Of Kingdoms', 'prag-slot-bookOfKingdoms', NULL, NULL, 'fivers/prag-slot-bookOfKingdoms.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:53', '2024-04-12 13:52:53');
INSERT INTO `games` VALUES (167, 19, NULL, 'prag-slot-diamondsareForever3Lines', 'Diamonds are Forever Lines', 'prag-slot-diamondsareForever3Lines', NULL, NULL, 'fivers/prag-slot-diamondsareForever3Lines.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:54', '2024-04-12 13:52:54');
INSERT INTO `games` VALUES (168, 19, NULL, 'prag-slot-aladdinsTreasure', 'Aladdins Treasure', 'prag-slot-aladdinsTreasure', NULL, NULL, 'fivers/prag-slot-aladdinsTreasure.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:54', '2024-04-12 13:52:54');
INSERT INTO `games` VALUES (169, 19, NULL, 'prag-slot-daVincisTreasure', 'Da Vincis Treasure', 'prag-slot-daVincisTreasure', NULL, NULL, 'fivers/prag-slot-daVincisTreasure.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:55', '2024-04-12 13:52:55');
INSERT INTO `games` VALUES (170, 19, NULL, 'prag-slot-ladyoftheMoon', 'Lady of the Moon', 'prag-slot-ladyoftheMoon', NULL, NULL, 'fivers/prag-slot-ladyoftheMoon.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:55', '2024-04-12 13:52:55');
INSERT INTO `games` VALUES (171, 19, NULL, 'prag-slot-gloriousRome', 'Glorious Rome', 'prag-slot-gloriousRome', NULL, NULL, 'fivers/prag-slot-gloriousRome.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:56', '2024-04-12 13:52:56');
INSERT INTO `games` VALUES (172, 19, NULL, 'prag-slot-aladdinandtheSorcerer', 'Aladdin and the Sorcerer', 'prag-slot-aladdinandtheSorcerer', NULL, NULL, 'fivers/prag-slot-aladdinandtheSorcerer.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:57', '2024-04-12 13:52:57');
INSERT INTO `games` VALUES (173, 19, NULL, 'prag-slot-dwarvenGold', 'Dwarven Gold', 'prag-slot-dwarvenGold', NULL, NULL, 'fivers/prag-slot-dwarvenGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:57', '2024-04-12 13:52:57');
INSERT INTO `games` VALUES (174, 19, NULL, 'prag-slot-talesofEgypt', 'Tales of Egypt', 'prag-slot-talesofEgypt', NULL, NULL, 'fivers/prag-slot-talesofEgypt.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:58', '2024-04-12 13:52:58');
INSERT INTO `games` VALUES (175, 19, NULL, 'prag-slot-hockeyLeague', 'Hockey League', 'prag-slot-hockeyLeague', NULL, NULL, 'fivers/prag-slot-hockeyLeague.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:59', '2024-04-12 13:52:59');
INSERT INTO `games` VALUES (176, 19, NULL, 'prag-slot-romeoandJuliet', 'Romeo and Juliet', 'prag-slot-romeoandJuliet', NULL, NULL, 'fivers/prag-slot-romeoandJuliet.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:52:59', '2024-04-12 13:52:59');
INSERT INTO `games` VALUES (177, 19, NULL, 'prag-slot-theCatfather', 'The Cat Father', 'prag-slot-theCatfather', NULL, NULL, 'fivers/prag-slot-theCatfather.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:00', '2024-04-12 13:53:00');
INSERT INTO `games` VALUES (178, 19, NULL, 'prag-slot-hockeyLeagueWildMatch P', 'Hockey League Wild Match', 'prag-slot-hockeyLeagueWildMatch P', NULL, NULL, 'fivers/prag-slot-hockeyLeagueWildMatch P.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:01', '2024-04-12 13:53:01');
INSERT INTO `games` VALUES (179, 19, NULL, 'prag-slot-johnandBookofTut', 'John and Book of Tut', 'prag-slot-johnandBookofTut', NULL, NULL, 'fivers/prag-slot-johnandBookofTut.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:01', '2024-04-12 13:53:01');
INSERT INTO `games` VALUES (180, 19, NULL, 'prag-slot-meraldKingRainbowRoad', 'Merald King Rainbow Road', 'prag-slot-meraldKingRainbowRoad', NULL, NULL, 'fivers/prag-slot-meraldKingRainbowRoad.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:02', '2024-04-12 13:53:02');
INSERT INTO `games` VALUES (181, 19, NULL, 'prag-slot-gatesOlympus', 'Gates Olympus', 'prag-slot-gatesOlympus', NULL, NULL, 'fivers/prag-slot-gatesOlympus.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:03', '2024-04-12 13:53:03');
INSERT INTO `games` VALUES (182, 19, NULL, 'prag-slot-handMidas', 'Hand Midas', 'prag-slot-handMidas', NULL, NULL, 'fivers/prag-slot-handMidas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:03', '2024-04-12 13:53:03');
INSERT INTO `games` VALUES (183, 19, NULL, 'prag-slot-eyeStorm', 'Eye Storm', 'prag-slot-eyeStorm', NULL, NULL, 'fivers/prag-slot-eyeStorm.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:04', '2024-04-12 13:53:04');
INSERT INTO `games` VALUES (184, 19, NULL, 'prag-slot-dragonKingdomEyesFire', 'Dragon Kingdom Eyes Fire', 'prag-slot-dragonKingdomEyesFire', NULL, NULL, 'fivers/prag-slot-dragonKingdomEyesFire.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:05', '2024-04-12 13:53:05');
INSERT INTO `games` VALUES (185, 19, NULL, 'prag-slot-mayanGods', 'Mayan Gods', 'prag-slot-mayanGods', NULL, NULL, 'fivers/prag-slot-mayanGods.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:05', '2024-04-12 13:53:05');
INSERT INTO `games` VALUES (186, 19, NULL, 'prag-slot-spartaKing', 'Sparta King', 'prag-slot-spartaKing', NULL, NULL, 'fivers/prag-slot-spartaKing.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:06', '2024-04-12 13:53:06');
INSERT INTO `games` VALUES (187, 19, NULL, 'prag-slot-bigBass', 'Big Bass', 'prag-slot-bigBass', NULL, NULL, 'fivers/prag-slot-bigBass.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:07', '2024-04-12 13:53:07');
INSERT INTO `games` VALUES (188, 19, NULL, 'prag-slot-carolMegaways', 'Carol Megaways', 'prag-slot-carolMegaways', NULL, NULL, 'fivers/prag-slot-carolMegaways.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:07', '2024-04-12 13:53:07');
INSERT INTO `games` VALUES (189, 19, NULL, 'prag-slot-burnHoldWin', 'Burn Hold Win', 'prag-slot-burnHoldWin', NULL, NULL, 'fivers/prag-slot-burnHoldWin.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:08', '2024-04-12 13:53:08');
INSERT INTO `games` VALUES (190, 19, NULL, 'prag-slot-powerThorMega', 'Power Thor Mega', 'prag-slot-powerThorMega', NULL, NULL, 'fivers/prag-slot-powerThorMega.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:09', '2024-04-12 13:53:09');
INSERT INTO `games` VALUES (191, 19, NULL, 'prag-slot-floatingDragonHS', 'Floating Dragon HS', 'prag-slot-floatingDragonHS', NULL, NULL, 'fivers/prag-slot-floatingDragonHS.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:09', '2024-04-12 13:53:09');
INSERT INTO `games` VALUES (192, 19, NULL, 'prag-slot-hotFiesta', 'Hot Fiesta', 'prag-slot-hotFiesta', NULL, NULL, 'fivers/prag-slot-hotFiesta.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:10', '2024-04-12 13:53:10');
INSERT INTO `games` VALUES (193, 19, NULL, 'prag-slot-buffaloMega', 'Buffalo Mega', 'prag-slot-buffaloMega', NULL, NULL, 'fivers/prag-slot-buffaloMega.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:11', '2024-04-12 13:53:11');
INSERT INTO `games` VALUES (194, 19, NULL, 'prag-slot-amazingMoney', 'Amazing Money', 'prag-slot-amazingMoney', NULL, NULL, 'fivers/prag-slot-amazingMoney.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:11', '2024-04-12 13:53:11');
INSERT INTO `games` VALUES (195, 19, NULL, 'prag-slot-magicCauldron', 'Magic Cauldron', 'prag-slot-magicCauldron', NULL, NULL, 'fivers/prag-slot-magicCauldron.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:12', '2024-04-12 13:53:12');
INSERT INTO `games` VALUES (196, 19, NULL, 'prag-slot-heartRio', 'Heart Rio', 'prag-slot-heartRio', NULL, NULL, 'fivers/prag-slot-heartRio.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:13', '2024-04-12 13:53:13');
INSERT INTO `games` VALUES (197, 19, NULL, 'prag-slot-dragonHotHS', 'Dragon Hot HS', 'prag-slot-dragonHotHS', NULL, NULL, 'fivers/prag-slot-dragonHotHS.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:13', '2024-04-12 13:53:13');
INSERT INTO `games` VALUES (198, 19, NULL, 'prag-slot-bookofVikings', 'Book of Vikings', 'prag-slot-bookofVikings', NULL, NULL, 'fivers/prag-slot-bookofVikings.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:14', '2024-04-12 13:53:14');
INSERT INTO `games` VALUES (199, 19, NULL, 'prag-slot-riseofGizaPowerNudge', 'Rise of Giza Power Nudge', 'prag-slot-riseofGizaPowerNudge', NULL, NULL, 'fivers/prag-slot-riseofGizaPowerNudge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:15', '2024-04-12 13:53:15');
INSERT INTO `games` VALUES (200, 19, NULL, 'prag-slot-bermuda', 'Bermuda', 'prag-slot-bermuda', NULL, NULL, 'fivers/prag-slot-bermuda.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:16', '2024-04-12 13:53:16');
INSERT INTO `games` VALUES (201, 19, NULL, 'prag-slot-bbbMegaways', 'BBB Megaways', 'prag-slot-bbbMegaways', NULL, NULL, 'fivers/prag-slot-bbbMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:16', '2024-04-12 13:53:16');
INSERT INTO `games` VALUES (202, 19, NULL, 'prag-slot-bookofFallen', 'Book of Fallen', 'prag-slot-bookofFallen', NULL, NULL, 'fivers/prag-slot-bookofFallen.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:17', '2024-04-12 13:53:17');
INSERT INTO `games` VALUES (203, 19, NULL, 'prag-slot-xmasbonanza', 'Xmas Bonanza', 'prag-slot-xmasbonanza', NULL, NULL, 'fivers/prag-slot-xmasbonanza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:18', '2024-04-12 13:53:18');
INSERT INTO `games` VALUES (204, 19, NULL, 'prag-slot-smugglersCove', 'Smugglers Cove', 'prag-slot-smugglersCove', NULL, NULL, 'fivers/prag-slot-smugglersCove.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:18', '2024-04-12 13:53:18');
INSERT INTO `games` VALUES (205, 19, NULL, 'prag-slot-crystalCavernsM', 'Crystal Caverns Megaways', 'prag-slot-crystalCavernsM', NULL, NULL, 'fivers/prag-slot-crystalCavernsM.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:19', '2024-04-12 13:53:19');
INSERT INTO `games` VALUES (206, 19, NULL, 'prag-slot-magiciansSecrets', 'Magicians Secrets', 'prag-slot-magiciansSecrets', NULL, NULL, 'fivers/prag-slot-magiciansSecrets.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:20', '2024-04-12 13:53:20');
INSERT INTO `games` VALUES (207, 19, NULL, 'prag-slot-wildDepths', 'Wild Depths', 'prag-slot-wildDepths', NULL, NULL, 'fivers/prag-slot-wildDepths.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:21', '2024-04-12 13:53:21');
INSERT INTO `games` VALUES (208, 19, NULL, 'prag-slot-goldparty', 'Gold Party', 'prag-slot-goldparty', NULL, NULL, 'fivers/prag-slot-goldparty.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:21', '2024-04-12 13:53:21');
INSERT INTO `games` VALUES (209, 19, NULL, 'prag-slot-rockVegas', 'Rock Vegas', 'prag-slot-rockVegas', NULL, NULL, 'fivers/prag-slot-rockVegas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:22', '2024-04-12 13:53:22');
INSERT INTO `games` VALUES (210, 19, NULL, 'prag-slot-gatesValhalla', 'Gates Valhalla', 'prag-slot-gatesValhalla', NULL, NULL, 'fivers/prag-slot-gatesValhalla.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:23', '2024-04-12 13:53:23');
INSERT INTO `games` VALUES (211, 19, NULL, 'prag-slot-colossalCashZ', 'Colossal Cash Z', 'prag-slot-colossalCashZ', NULL, NULL, 'fivers/prag-slot-colossalCashZ.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:23', '2024-04-12 13:53:23');
INSERT INTO `games` VALUES (212, 19, NULL, 'prag-slot-mightRa', 'Might Ra', 'prag-slot-mightRa', NULL, NULL, 'fivers/prag-slot-mightRa.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:24', '2024-04-12 13:53:24');
INSERT INTO `games` VALUES (213, 19, NULL, 'prag-slot-snakeladd', 'Snake and Ladders', 'prag-slot-snakeladd', NULL, NULL, 'fivers/prag-slot-snakeladd.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:24', '2024-04-12 13:53:24');
INSERT INTO `games` VALUES (214, 19, NULL, 'prag-slot-drillthatgold', 'Drill that Gold', 'prag-slot-drillthatgold', NULL, NULL, 'fivers/prag-slot-drillthatgold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:25', '2024-04-12 13:53:25');
INSERT INTO `games` VALUES (215, 19, NULL, 'prag-slot-littlegem', 'Little Gem', 'prag-slot-littlegem', NULL, NULL, 'fivers/prag-slot-littlegem.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:26', '2024-04-12 13:53:26');
INSERT INTO `games` VALUES (216, 19, NULL, 'prag-slot-stickysymbol', 'The Great Stick-Up', 'prag-slot-stickysymbol', NULL, NULL, 'fivers/prag-slot-stickysymbol.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:26', '2024-04-12 13:53:26');
INSERT INTO `games` VALUES (217, 19, NULL, 'prag-slot-asgardjp', 'Asgard Jackpot', 'prag-slot-asgardjp', NULL, NULL, 'fivers/prag-slot-asgardjp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:27', '2024-04-12 13:53:27');
INSERT INTO `games` VALUES (218, 19, NULL, 'prag-slot-madamejp', 'Madame Destiny Jackpot', 'prag-slot-madamejp', NULL, NULL, 'fivers/prag-slot-madamejp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:28', '2024-04-12 13:53:28');
INSERT INTO `games` VALUES (219, 19, NULL, 'prag-slot-doghousejp', 'The Dog House Jackpot', 'prag-slot-doghousejp', NULL, NULL, 'fivers/prag-slot-doghousejp.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:28', '2024-04-12 13:53:28');
INSERT INTO `games` VALUES (220, 19, NULL, 'prag-slot-7776secrets', 'John Hunter and the Aztec Treasure', 'prag-slot-7776secrets', NULL, NULL, 'fivers/prag-slot-7776secrets.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:29', '2024-04-12 13:53:29');
INSERT INTO `games` VALUES (221, 19, NULL, 'prag-slot-5hotburn', 'Hot to Burn', 'prag-slot-5hotburn', NULL, NULL, 'fivers/prag-slot-5hotburn.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:30', '2024-04-12 13:53:30');
INSERT INTO `games` VALUES (222, 19, NULL, 'prag-slot-waysxjuicy', 'Extra Juicy Megaways', 'prag-slot-waysxjuicy', NULL, NULL, 'fivers/prag-slot-waysxjuicy.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:30', '2024-04-12 13:53:30');
INSERT INTO `games` VALUES (223, 19, NULL, 'prag-slot-gobnudge', 'Goblin Heist', 'prag-slot-gobnudge', NULL, NULL, 'fivers/prag-slot-gobnudge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:31', '2024-04-12 13:53:31');
INSERT INTO `games` VALUES (224, 19, NULL, 'prag-slot-chkchase', 'Chicken Chase - Caccia alla Gallina', 'prag-slot-chkchase', NULL, NULL, 'fivers/prag-slot-chkchase.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:32', '2024-04-12 13:53:32');
INSERT INTO `games` VALUES (225, 19, NULL, 'prag-slot-tropicalTiki', 'Tropical TIKI', 'prag-slot-tropicalTiki', NULL, NULL, 'fivers/prag-slot-tropicalTiki.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:32', '2024-04-12 13:53:32');
INSERT INTO `games` VALUES (226, 19, NULL, 'prag-slot-MuertosMultiplier', 'Muertos Multiplier', 'prag-slot-MuertosMultiplier', NULL, NULL, 'fivers/prag-slot-MuertosMultiplier.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:33', '2024-04-12 13:53:33');
INSERT INTO `games` VALUES (227, 19, NULL, 'prag-slot-bigbassreel', 'Big Bass Keeping it Reel', 'prag-slot-bigbassreel', NULL, NULL, 'fivers/prag-slot-bigbassreel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:33', '2024-04-12 13:53:33');
INSERT INTO `games` VALUES (228, 19, NULL, 'prag-slot-spinescore', 'Spin e Score', 'prag-slot-spinescore', NULL, NULL, 'fivers/prag-slot-spinescore.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:34', '2024-04-12 13:53:34');
INSERT INTO `games` VALUES (229, 19, NULL, 'prag-slot-biggerbass', 'Bigger Bass Blizzard Christmas Catch', 'prag-slot-biggerbass', NULL, NULL, 'fivers/prag-slot-biggerbass.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:35', '2024-04-12 13:53:35');
INSERT INTO `games` VALUES (230, 19, NULL, 'prag-slot-furyodin', 'Fury of Odin Megaways', 'prag-slot-furyodin', NULL, NULL, 'fivers/prag-slot-furyodin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:38', '2024-04-12 13:53:38');
INSERT INTO `games` VALUES (231, 19, NULL, 'prag-slot-GatesofBetmotion', 'Gates of Betmotion', 'prag-slot-GatesofBetmotion', NULL, NULL, 'fivers/prag-slot-GatesofBetmotion.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:39', '2024-04-12 13:53:39');
INSERT INTO `games` VALUES (232, 19, NULL, 'prag-slot-HotPepper', 'Hot Pepper', 'prag-slot-HotPepper', NULL, NULL, 'fivers/prag-slot-HotPepper.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:39', '2024-04-12 13:53:39');
INSERT INTO `games` VALUES (233, 19, NULL, 'prag-slot-StarlightChristmas', 'Starlight Christmas', 'prag-slot-StarlightChristmas', NULL, NULL, 'fivers/prag-slot-StarlightChristmas.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:40', '2024-04-12 13:53:40');
INSERT INTO `games` VALUES (234, 19, NULL, 'prag-slot-Sweetpowernudge', 'Sweet powernudge', 'prag-slot-Sweetpowernudge', NULL, NULL, 'fivers/prag-slot-Sweetpowernudge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:40', '2024-04-12 13:53:40');
INSERT INTO `games` VALUES (235, 19, NULL, 'prag-slot-SantasGreatGift', 'Santas great gift', 'prag-slot-SantasGreatGift', NULL, NULL, 'fivers/prag-slot-SantasGreatGift.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:41', '2024-04-12 13:53:41');
INSERT INTO `games` VALUES (236, 19, NULL, 'prag-slot-WildHopDrop', 'Wild Hop & Drop', 'prag-slot-WildHopDrop', NULL, NULL, 'fivers/prag-slot-WildHopDrop.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:42', '2024-04-12 13:53:42');
INSERT INTO `games` VALUES (237, 19, NULL, 'prag-slot-TheRedQueen', 'The Red Queen', 'prag-slot-TheRedQueen', NULL, NULL, 'fivers/prag-slot-TheRedQueen.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:42', '2024-04-12 13:53:42');
INSERT INTO `games` VALUES (238, 19, NULL, 'prag-slot-WildCelebretyBusM', 'Wild Celebrety Bus Megaways', 'prag-slot-WildCelebretyBusM', NULL, NULL, 'fivers/prag-slot-WildCelebretyBusM.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:43', '2024-04-12 13:53:43');
INSERT INTO `games` VALUES (239, 19, NULL, 'prag-slot-fortune-of-giza', 'Fortune of Giza', 'prag-slot-fortune-of-giza', NULL, NULL, 'fivers/prag-slot-fortune-of-giza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:44', '2024-04-12 13:53:44');
INSERT INTO `games` VALUES (240, 19, NULL, 'prag-slot-hot-to-burn-extreme', 'Hot to Burn Extreme', 'prag-slot-hot-to-burn-extreme', NULL, NULL, 'fivers/prag-slot-hot-to-burn-extreme.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:45', '2024-04-12 13:53:45');
INSERT INTO `games` VALUES (241, 19, NULL, 'prag-slot-happy-hooves', 'Happy Hooves', 'prag-slot-happy-hooves', NULL, NULL, 'fivers/prag-slot-happy-hooves.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:45', '2024-04-12 13:53:45');
INSERT INTO `games` VALUES (242, 19, NULL, 'prag-slot-floating-dragon-megaways', 'Floating Dragon Megaways', 'prag-slot-floating-dragon-megaways', NULL, NULL, 'fivers/prag-slot-floating-dragon-megaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:46', '2024-04-12 13:53:46');
INSERT INTO `games` VALUES (243, 19, NULL, 'prag-slot-john-hunter-and-the-book-of-tut-respin', 'John Hunter and the Book of Tut Respin', 'prag-slot-john-hunter-and-the-book-of-tut-respin', NULL, NULL, 'fivers/prag-slot-john-hunter-and-the-book-of-tut-respin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:47', '2024-04-12 13:53:47');
INSERT INTO `games` VALUES (244, 19, NULL, 'prag-slot-pirate-golden-age', 'Pirate Golden Age', 'prag-slot-pirate-golden-age', NULL, NULL, 'fivers/prag-slot-pirate-golden-age.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:48', '2024-04-12 13:53:48');
INSERT INTO `games` VALUES (245, 19, NULL, 'prag-slot-firebird-spirit', 'Firebird Spirit', 'prag-slot-firebird-spirit', NULL, NULL, 'fivers/prag-slot-firebird-spirit.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:48', '2024-04-12 13:53:48');
INSERT INTO `games` VALUES (246, 19, NULL, 'prag-slot-release-the-kraken-2', 'Release the Kraken 2', 'prag-slot-release-the-kraken-2', NULL, NULL, 'fivers/prag-slot-release-the-kraken-2.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:49', '2024-04-12 13:53:49');
INSERT INTO `games` VALUES (247, 19, NULL, 'prag-slot-towering-fortunes', 'Towering Fortunes', 'prag-slot-towering-fortunes', NULL, NULL, 'fivers/prag-slot-towering-fortunes.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:50', '2024-04-12 13:53:50');
INSERT INTO `games` VALUES (248, 19, NULL, 'prag-slot-gems-of-serengeti', 'Gems of Serengeti', 'prag-slot-gems-of-serengeti', NULL, NULL, 'fivers/prag-slot-gems-of-serengeti.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:52', '2024-04-12 13:53:52');
INSERT INTO `games` VALUES (249, 19, NULL, 'prag-slot-snakes-ladders-2-snake-eyes', 'Snakes & Ladders 2 - Snake Eyes', 'prag-slot-snakes-ladders-2-snake-eyes', NULL, NULL, 'fivers/prag-slot-snakes-ladders-2-snake-eyes.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:53', '2024-04-12 13:53:53');
INSERT INTO `games` VALUES (250, 19, NULL, 'prag-slot-reel-banks', 'Reel Banks', 'prag-slot-reel-banks', NULL, NULL, 'fivers/prag-slot-reel-banks.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:53', '2024-04-12 13:53:53');
INSERT INTO `games` VALUES (251, 19, NULL, 'prag-slot-jokers-jewels-dice', 'Jokers Jewels Dice', 'prag-slot-jokers-jewels-dice', NULL, NULL, 'fivers/prag-slot-jokers-jewels-dice.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:54', '2024-04-12 13:53:54');
INSERT INTO `games` VALUES (252, 19, NULL, 'prag-slot-cowboy-coins', 'Cowboy Coins', 'prag-slot-cowboy-coins', NULL, NULL, 'fivers/prag-slot-cowboy-coins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:55', '2024-04-12 13:53:55');
INSERT INTO `games` VALUES (253, 19, NULL, 'prag-slot-the-knight-king', 'The Knight King', 'prag-slot-the-knight-king', NULL, NULL, 'fivers/prag-slot-the-knight-king.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:55', '2024-04-12 13:53:55');
INSERT INTO `games` VALUES (254, 19, NULL, 'prag-slot-big-bass-hold-spinner', 'Big Bass - Hold & Spinner', 'prag-slot-big-bass-hold-spinner', NULL, NULL, 'fivers/prag-slot-big-bass-hold-spinner.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:56', '2024-04-12 13:53:56');
INSERT INTO `games` VALUES (255, 19, NULL, 'prag-slot-kingdom-of-the-dead', 'Kingdom of The Dead', 'prag-slot-kingdom-of-the-dead', NULL, NULL, 'fivers/prag-slot-kingdom-of-the-dead.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:57', '2024-04-12 13:53:57');
INSERT INTO `games` VALUES (256, 19, NULL, 'prag-slot-country-farming', 'Country Farming', 'prag-slot-country-farming', NULL, NULL, 'fivers/prag-slot-country-farming.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:57', '2024-04-12 13:53:57');
INSERT INTO `games` VALUES (257, 19, NULL, 'prag-slot-big-bass-amazon-xtrem', 'Big Bass Amazon Xtrem', 'prag-slot-big-bass-amazon-xtrem', NULL, NULL, 'fivers/prag-slot-big-bass-amazon-xtrem.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:58', '2024-04-12 13:53:58');
INSERT INTO `games` VALUES (258, 5, NULL, 'bgtv-lg-wheel-of-fortune', 'Wheel Of Fortune', 'bgtv-lg-wheel-of-fortune', NULL, NULL, 'fivers/bgtv-lg-wheel-of-fortune.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:58', '2024-04-12 13:53:58');
INSERT INTO `games` VALUES (259, 5, NULL, 'bgtv-lg-classic-wheel', 'Classic Wheel', 'bgtv-lg-classic-wheel', NULL, NULL, 'fivers/bgtv-lg-classic-wheel.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:59', '2024-04-12 13:53:59');
INSERT INTO `games` VALUES (260, 5, NULL, 'bgtv-lg-lucky-7', 'Lucky 7', 'bgtv-lg-lucky-7', NULL, NULL, 'fivers/bgtv-lg-lucky-7.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:53:59', '2024-04-12 13:53:59');
INSERT INTO `games` VALUES (261, 19, NULL, 'prag-slot-BigBassKeepingitReel', 'Big Bass - Keeping it Reel', 'prag-slot-BigBassKeepingitReel', NULL, NULL, 'fivers/prag-slot-BigBassKeepingitReel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:00', '2024-04-12 13:54:00');
INSERT INTO `games` VALUES (262, 19, NULL, 'prag-slot-BigBassBonanzaMegaways', 'Big Bass Bonanza Megaways', 'prag-slot-BigBassBonanzaMegaways', NULL, NULL, 'fivers/prag-slot-BigBassBonanzaMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:01', '2024-04-12 13:54:01');
INSERT INTO `games` VALUES (263, 19, NULL, 'prag-slot-HeistfortheGoldenNugget', 'Heist for the Golden Nugget', 'prag-slot-HeistfortheGoldenNugget', NULL, NULL, 'fivers/prag-slot-HeistfortheGoldenNugget.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:01', '2024-04-12 13:54:01');
INSERT INTO `games` VALUES (264, 19, NULL, 'prag-slot-LobsterBobsCrazyCrabShack', 'Lobster Bob’s Crazy Crab Shack', 'prag-slot-LobsterBobsCrazyCrabShack', NULL, NULL, 'fivers/prag-slot-LobsterBobsCrazyCrabShack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:02', '2024-04-12 13:54:02');
INSERT INTO `games` VALUES (265, 19, NULL, 'prag-SkyBount', 'Sky Bount', 'prag-SkyBount', NULL, NULL, 'fivers/prag-SkyBount.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:03', '2024-04-12 13:54:03');
INSERT INTO `games` VALUES (266, 20, NULL, 'prag-Steeplechase', 'Steeplechase', 'prag-Steeplechase', NULL, NULL, 'fivers/prag-Steeplechase.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:04', '2024-04-12 13:54:04');
INSERT INTO `games` VALUES (267, 20, NULL, 'prag-Force1', 'Force 1', 'prag-Force1', NULL, NULL, 'fivers/prag-Force1.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:06', '2024-04-12 13:54:06');
INSERT INTO `games` VALUES (268, 20, NULL, 'prag-FantasticLeague', 'Fantastic League', 'prag-FantasticLeague', NULL, NULL, 'fivers/prag-FantasticLeague.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:08', '2024-04-12 13:54:08');
INSERT INTO `games` VALUES (269, 20, NULL, 'prag-GreyhoundRacing', 'Greyhound Racing', 'prag-GreyhoundRacing', NULL, NULL, 'fivers/prag-GreyhoundRacing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:09', '2024-04-12 13:54:09');
INSERT INTO `games` VALUES (270, 20, NULL, 'prag-HorseRacing', 'Horse Racing', 'prag-HorseRacing', NULL, NULL, 'fivers/prag-HorseRacing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:11', '2024-04-12 13:54:11');
INSERT INTO `games` VALUES (271, 20, NULL, 'prag-PenaltyShootout', 'Penalty Shootout', 'prag-PenaltyShootout', NULL, NULL, 'fivers/prag-PenaltyShootout.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:13', '2024-04-12 13:54:13');
INSERT INTO `games` VALUES (272, 19, NULL, 'prag-BigBassCrash', 'Big Bass Crash', 'prag-BigBassCrash', NULL, NULL, 'fivers/prag-BigBassCrash.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:13', '2024-04-12 13:54:13');
INSERT INTO `games` VALUES (273, 19, NULL, 'prag-slot-peakyBlinders', 'Peaky Blinders', 'prag-slot-peakyBlinders', NULL, NULL, 'fivers/prag-slot-peakyBlinders.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:14', '2024-04-12 13:54:14');
INSERT INTO `games` VALUES (274, 19, NULL, 'prag-tb-multihandBlackjack', 'Multihand Blackjack', 'prag-tb-multihandBlackjack', NULL, NULL, 'fivers/prag-tb-multihandBlackjack.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:15', '2024-04-12 13:54:15');
INSERT INTO `games` VALUES (275, 19, NULL, 'prag-tb-americanBlackjack', 'American Blackjack', 'prag-tb-americanBlackjack', NULL, NULL, 'fivers/prag-tb-americanBlackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:15', '2024-04-12 13:54:15');
INSERT INTO `games` VALUES (276, 2, NULL, 'prag-tb-dragonTiger', 'Dragon Tiger', 'prag-tb-dragonTiger', NULL, NULL, 'fivers/prag-tb-dragonTiger.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:16', '2024-04-12 13:54:16');
INSERT INTO `games` VALUES (277, 19, NULL, 'prag-sc-wolfGold1Million', 'Wolf Gold 1,000,000', 'prag-sc-wolfGold1Million', NULL, NULL, 'fivers/prag-sc-wolfGold1Million.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:17', '2024-04-12 13:54:17');
INSERT INTO `games` VALUES (278, 19, NULL, 'prag-sc-PandaGold', 'Panda Gold 10,000', 'prag-sc-PandaGold', NULL, NULL, 'fivers/prag-sc-PandaGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:17', '2024-04-12 13:54:17');
INSERT INTO `games` VALUES (279, 19, NULL, 'prag-sc-HotSafari', 'Hot Safari 50,000', 'prag-sc-HotSafari', NULL, NULL, 'fivers/prag-sc-HotSafari.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:18', '2024-04-12 13:54:18');
INSERT INTO `games` VALUES (280, 19, NULL, 'prag-sc-GoldRush', 'Gold Rush 250,000', 'prag-sc-GoldRush', NULL, NULL, 'fivers/prag-sc-GoldRush.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:19', '2024-04-12 13:54:19');
INSERT INTO `games` VALUES (281, 19, NULL, 'prag-sc-DiamondStrike', 'Diamond Strike 100,000', 'prag-sc-DiamondStrike', NULL, NULL, 'fivers/prag-sc-DiamondStrike.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:19', '2024-04-12 13:54:19');
INSERT INTO `games` VALUES (282, 19, NULL, 'prag-sc-7Piggies', '7 Piggies 5,000', 'prag-sc-7Piggies', NULL, NULL, 'fivers/prag-sc-7Piggies.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:20', '2024-04-12 13:54:20');
INSERT INTO `games` VALUES (283, 9, NULL, 'prag-tb-baccarat', 'Baccarat', 'prag-tb-baccarat', NULL, NULL, 'fivers/prag-tb-baccarat.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:21', '2024-04-12 13:54:21');
INSERT INTO `games` VALUES (284, 19, NULL, 'prag-tb-roulette', 'Roulette', 'prag-tb-roulette', NULL, NULL, 'fivers/prag-tb-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:21', '2024-04-12 13:54:21');
INSERT INTO `games` VALUES (285, 15, NULL, 'sms-tb-spinx', 'SpinX', 'sms-tb-spinx', NULL, NULL, 'fivers/sms-tb-spinx.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:23', '2024-04-12 13:54:23');
INSERT INTO `games` VALUES (286, 15, NULL, 'sms-tb-jetx3', 'JetX3', 'sms-tb-jetx3', NULL, NULL, 'fivers/sms-tb-jetx3.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:23', '2024-04-12 13:54:23');
INSERT INTO `games` VALUES (287, 15, NULL, 'sms-tb-cricketx', 'CricketX', 'sms-tb-cricketx', NULL, NULL, 'fivers/sms-tb-cricketx.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:24', '2024-04-12 13:54:24');
INSERT INTO `games` VALUES (288, 15, NULL, 'sms-slot-viking', 'Viking', 'sms-slot-viking', NULL, NULL, 'fivers/sms-slot-viking.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:25', '2024-04-12 13:54:25');
INSERT INTO `games` VALUES (289, 15, NULL, 'sms-slot-aztec', 'Aztec', 'sms-slot-aztec', NULL, NULL, 'fivers/sms-slot-aztec.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:26', '2024-04-12 13:54:26');
INSERT INTO `games` VALUES (290, 15, NULL, 'sms-slot-cityslot', 'City Slot', 'sms-slot-cityslot', NULL, NULL, 'fivers/sms-slot-cityslot.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:27', '2024-04-12 13:54:27');
INSERT INTO `games` VALUES (291, 15, NULL, 'sms-slot-cowboy', 'Cowboy', 'sms-slot-cowboy', NULL, NULL, 'fivers/sms-slot-cowboy.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:27', '2024-04-12 13:54:27');
INSERT INTO `games` VALUES (292, 15, NULL, 'sms-slot-christmas', 'Christmas Eve', 'sms-slot-christmas', NULL, NULL, 'fivers/sms-slot-christmas.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:28', '2024-04-12 13:54:28');
INSERT INTO `games` VALUES (293, 15, NULL, 'sms-slot-funfruit', 'Fun Fruit', 'sms-slot-funfruit', NULL, NULL, 'fivers/sms-slot-funfruit.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:29', '2024-04-12 13:54:29');
INSERT INTO `games` VALUES (294, 15, NULL, 'sms-slot-samurai', 'Samurai', 'sms-slot-samurai', NULL, NULL, 'fivers/sms-slot-samurai.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:30', '2024-04-12 13:54:30');
INSERT INTO `games` VALUES (295, 15, NULL, 'sms-slot-argo', 'Argo', 'sms-slot-argo', NULL, NULL, 'fivers/sms-slot-argo.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:31', '2024-04-12 13:54:31');
INSERT INTO `games` VALUES (296, 15, NULL, 'sms-slot-moonstone', 'MoonStone', 'sms-slot-moonstone', NULL, NULL, 'fivers/sms-slot-moonstone.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:32', '2024-04-12 13:54:32');
INSERT INTO `games` VALUES (297, 15, NULL, 'sms-slot-blazinghot', 'Burning Ice', 'sms-slot-blazinghot', NULL, NULL, 'fivers/sms-slot-blazinghot.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:32', '2024-04-12 13:54:32');
INSERT INTO `games` VALUES (298, 15, NULL, 'sms-slot-evolution', 'Evolution', 'sms-slot-evolution', NULL, NULL, 'fivers/sms-slot-evolution.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:33', '2024-04-12 13:54:33');
INSERT INTO `games` VALUES (299, 15, NULL, 'sms-slot-fruit5', 'Magic Garden', 'sms-slot-fruit5', NULL, NULL, 'fivers/sms-slot-fruit5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:34', '2024-04-12 13:54:34');
INSERT INTO `games` VALUES (300, 15, NULL, 'sms-slot-blazinghot10', 'Burning Ice 10', 'sms-slot-blazinghot10', NULL, NULL, 'fivers/sms-slot-blazinghot10.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:35', '2024-04-12 13:54:35');
INSERT INTO `games` VALUES (301, 15, NULL, 'sms-slot-fruit10', 'Magic Garden 10', 'sms-slot-fruit10', NULL, NULL, 'fivers/sms-slot-fruit10.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:36', '2024-04-12 13:54:36');
INSERT INTO `games` VALUES (302, 15, NULL, 'sms-slot-blazinghot40', 'Burning Ice 40', 'sms-slot-blazinghot40', NULL, NULL, 'fivers/sms-slot-blazinghot40.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:36', '2024-04-12 13:54:36');
INSERT INTO `games` VALUES (303, 15, NULL, 'sms-slot-fruit40', 'Magic Garden 40', 'sms-slot-fruit40', NULL, NULL, 'fivers/sms-slot-fruit40.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:37', '2024-04-12 13:54:37');
INSERT INTO `games` VALUES (304, 15, NULL, 'sms-slot-dark', 'Dark', 'sms-slot-dark', NULL, NULL, 'fivers/sms-slot-dark.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:38', '2024-04-12 13:54:38');
INSERT INTO `games` VALUES (305, 15, NULL, 'sms-slot-ww2', 'World War II', 'sms-slot-ww2', NULL, NULL, 'fivers/sms-slot-ww2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:39', '2024-04-12 13:54:39');
INSERT INTO `games` VALUES (306, 15, NULL, 'sms-slot-summercocktail', 'Summer Cocktail', 'sms-slot-summercocktail', NULL, NULL, 'fivers/sms-slot-summercocktail.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:40', '2024-04-12 13:54:40');
INSERT INTO `games` VALUES (307, 15, NULL, 'sms-slot-dark100', 'Dark 100', 'sms-slot-dark100', NULL, NULL, 'fivers/sms-slot-dark100.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:40', '2024-04-12 13:54:40');
INSERT INTO `games` VALUES (308, 15, NULL, 'sms-slot-vampires', 'Vampires', 'sms-slot-vampires', NULL, NULL, 'fivers/sms-slot-vampires.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:41', '2024-04-12 13:54:41');
INSERT INTO `games` VALUES (309, 15, NULL, 'sms-slot-multihot5', 'Multi Hot5', 'sms-slot-multihot5', NULL, NULL, 'fivers/sms-slot-multihot5.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:42', '2024-04-12 13:54:42');
INSERT INTO `games` VALUES (310, 15, NULL, 'sms-slot-elves', 'The Kingdom of the Elves', 'sms-slot-elves', NULL, NULL, 'fivers/sms-slot-elves.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:43', '2024-04-12 13:54:43');
INSERT INTO `games` VALUES (311, 15, NULL, 'sms-tb-virtualroulette', 'Virtual Roulette', 'sms-tb-virtualroulette', NULL, NULL, 'fivers/sms-tb-virtualroulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:43', '2024-04-12 13:54:43');
INSERT INTO `games` VALUES (312, 15, NULL, 'sms-tb-virtualburningroulette', 'Virtual Burning Roulette', 'sms-tb-virtualburningroulette', NULL, NULL, 'fivers/sms-tb-virtualburningroulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:44', '2024-04-12 13:54:44');
INSERT INTO `games` VALUES (313, 15, NULL, 'sms-tb-bonusroulette', 'Bonus Roulette', 'sms-tb-bonusroulette', NULL, NULL, 'fivers/sms-tb-bonusroulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:44', '2024-04-12 13:54:44');
INSERT INTO `games` VALUES (314, 15, NULL, 'sms-tb-animationroulette', 'Personal Roulette', 'sms-tb-animationroulette', NULL, NULL, 'fivers/sms-tb-animationroulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:45', '2024-04-12 13:54:45');
INSERT INTO `games` VALUES (315, 15, NULL, 'sms-tb-virtualclassicroulette', 'Virtual Classic Roulette', 'sms-tb-virtualclassicroulette', NULL, NULL, 'fivers/sms-tb-virtualclassicroulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:46', '2024-04-12 13:54:46');
INSERT INTO `games` VALUES (316, 15, NULL, 'sms-tb-classickeno', 'French Keno', 'sms-tb-classickeno', NULL, NULL, 'fivers/sms-tb-classickeno.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:46', '2024-04-12 13:54:46');
INSERT INTO `games` VALUES (317, 15, NULL, 'sms-tb-russiankeno', 'Russian Keno', 'sms-tb-russiankeno', NULL, NULL, 'fivers/sms-tb-russiankeno.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:47', '2024-04-12 13:54:47');
INSERT INTO `games` VALUES (318, 15, NULL, 'sms-tb-vipkeno', 'VIP Keno', 'sms-tb-vipkeno', NULL, NULL, 'fivers/sms-tb-vipkeno.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:47', '2024-04-12 13:54:47');
INSERT INTO `games` VALUES (319, 15, NULL, 'sms-tb-plinkox', 'PlinkoX', 'sms-tb-plinkox', NULL, NULL, 'fivers/sms-tb-plinkox.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:48', '2024-04-12 13:54:48');
INSERT INTO `games` VALUES (320, 15, NULL, 'sms-tb-footballx', 'FootballX', 'sms-tb-footballx', NULL, NULL, 'fivers/sms-tb-footballx.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:49', '2024-04-12 13:54:49');
INSERT INTO `games` VALUES (321, 15, NULL, 'sms-slot-paradice10', 'Para Dice 10', 'sms-slot-paradice10', NULL, NULL, 'fivers/sms-slot-paradice10.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:50', '2024-04-12 13:54:50');
INSERT INTO `games` VALUES (322, 15, NULL, 'sms-slot-zombies', 'Zombies', 'sms-slot-zombies', NULL, NULL, 'fivers/sms-slot-zombies.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:51', '2024-04-12 13:54:51');
INSERT INTO `games` VALUES (323, 15, NULL, 'sms-slot-babylon', 'Babylon', 'sms-slot-babylon', NULL, NULL, 'fivers/sms-slot-babylon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:51', '2024-04-12 13:54:51');
INSERT INTO `games` VALUES (324, 15, NULL, 'sms-crash-towerx', 'Tower X', 'sms-crash-towerx', NULL, NULL, 'fivers/sms-crash-towerx.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:52', '2024-04-12 13:54:52');
INSERT INTO `games` VALUES (325, 15, NULL, 'sms-crash-slicerx', 'Slicer X', 'sms-crash-slicerx', NULL, NULL, 'fivers/sms-crash-slicerx.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:53', '2024-04-12 13:54:53');
INSERT INTO `games` VALUES (326, 15, NULL, 'sms-crash-multihotways', 'Multi Hot Ways', 'sms-crash-multihotways', NULL, NULL, 'fivers/sms-crash-multihotways.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:54', '2024-04-12 13:54:54');
INSERT INTO `games` VALUES (327, 15, NULL, 'sms-crash-jokerbuybonus', 'Jokers 4 Bonuses', 'sms-crash-jokerbuybonus', NULL, NULL, 'fivers/sms-crash-jokerbuybonus.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:54', '2024-04-12 13:54:54');
INSERT INTO `games` VALUES (328, 9, NULL, 'bs-slot-lucky-seven', 'Lucky Seven', 'bs-slot-lucky-seven', NULL, NULL, 'fivers/bs-slot-lucky-seven.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:55', '2024-04-12 13:54:55');
INSERT INTO `games` VALUES (329, 9, NULL, 'bs-slot-glam-life', 'Glam Life', 'bs-slot-glam-life', NULL, NULL, 'fivers/bs-slot-glam-life.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:56', '2024-04-12 13:54:56');
INSERT INTO `games` VALUES (330, 9, NULL, 'bs-slot-genies-fortune', 'Genies Fortune', 'bs-slot-genies-fortune', NULL, NULL, 'fivers/bs-slot-genies-fortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:57', '2024-04-12 13:54:57');
INSERT INTO `games` VALUES (331, 9, NULL, 'bs-slot-gladiator', 'Gladiator', 'bs-slot-gladiator', NULL, NULL, 'fivers/bs-slot-gladiator.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:58', '2024-04-12 13:54:58');
INSERT INTO `games` VALUES (332, 9, NULL, 'bs-slot-heist', 'Heist', 'bs-slot-heist', NULL, NULL, 'fivers/bs-slot-heist.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:59', '2024-04-12 13:54:59');
INSERT INTO `games` VALUES (333, 9, NULL, 'bs-slot-once-upon-a-time', 'Once Upon A Time', 'bs-slot-once-upon-a-time', NULL, NULL, 'fivers/bs-slot-once-upon-a-time.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:54:59', '2024-04-12 13:54:59');
INSERT INTO `games` VALUES (334, 9, NULL, 'bs-slot-barbary-coast', 'Barbary Coast', 'bs-slot-barbary-coast', NULL, NULL, 'fivers/bs-slot-barbary-coast.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:00', '2024-04-12 13:55:00');
INSERT INTO `games` VALUES (335, 9, NULL, 'bs-slot-mr-vegas', 'Mr. Vegas', 'bs-slot-mr-vegas', NULL, NULL, 'fivers/bs-slot-mr-vegas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:01', '2024-04-12 13:55:01');
INSERT INTO `games` VALUES (336, 9, NULL, 'bs-slot-rockstar', 'RockStar', 'bs-slot-rockstar', NULL, NULL, 'fivers/bs-slot-rockstar.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:02', '2024-04-12 13:55:02');
INSERT INTO `games` VALUES (337, 9, NULL, 'bs-slot-house-of-fun', 'House of Fun', 'bs-slot-house-of-fun', NULL, NULL, 'fivers/bs-slot-house-of-fun.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:03', '2024-04-12 13:55:03');
INSERT INTO `games` VALUES (338, 9, NULL, 'bs-slot-gold-diggers', 'Gold Diggers', 'bs-slot-gold-diggers', NULL, NULL, 'fivers/bs-slot-gold-diggers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:04', '2024-04-12 13:55:04');
INSERT INTO `games` VALUES (339, 9, NULL, 'bs-slot-2-million-bc', '2 Million B.C.', 'bs-slot-2-million-bc', NULL, NULL, 'fivers/bs-slot-2-million-bc.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:04', '2024-04-12 13:55:04');
INSERT INTO `games` VALUES (340, 9, NULL, 'bs-slot-paco-and-the-popping-peppers', 'Paco and the Popping Peppers', 'bs-slot-paco-and-the-popping-peppers', NULL, NULL, 'fivers/bs-slot-paco-and-the-popping-peppers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:05', '2024-04-12 13:55:05');
INSERT INTO `games` VALUES (341, 9, NULL, 'bs-slot-arrival', 'Arrival', 'bs-slot-arrival', NULL, NULL, 'fivers/bs-slot-arrival.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:06', '2024-04-12 13:55:06');
INSERT INTO `games` VALUES (342, 9, NULL, 'bs-slot-viking-age', 'Viking Age', 'bs-slot-viking-age', NULL, NULL, 'fivers/bs-slot-viking-age.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:07', '2024-04-12 13:55:07');
INSERT INTO `games` VALUES (343, 9, NULL, 'bs-slot-7th-heaven', '7th Heaven', 'bs-slot-7th-heaven', NULL, NULL, 'fivers/bs-slot-7th-heaven.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:07', '2024-04-12 13:55:07');
INSERT INTO `games` VALUES (344, 9, NULL, 'bs-slot-true-illusions', 'True Illusions', 'bs-slot-true-illusions', NULL, NULL, 'fivers/bs-slot-true-illusions.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:08', '2024-04-12 13:55:08');
INSERT INTO `games` VALUES (345, 9, NULL, 'bs-slot-mamma-mia', 'Mamma Mia', 'bs-slot-mamma-mia', NULL, NULL, 'fivers/bs-slot-mamma-mia.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:09', '2024-04-12 13:55:09');
INSERT INTO `games` VALUES (346, 9, NULL, 'bs-slot-madder-scientist', 'Madder Scientist', 'bs-slot-madder-scientist', NULL, NULL, 'fivers/bs-slot-madder-scientist.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:09', '2024-04-12 13:55:09');
INSERT INTO `games` VALUES (347, 9, NULL, 'bs-slot-lost', 'Lost', 'bs-slot-lost', NULL, NULL, 'fivers/bs-slot-lost.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:10', '2024-04-12 13:55:10');
INSERT INTO `games` VALUES (348, 9, NULL, 'bs-slot-black-gold', 'Black Gold', 'bs-slot-black-gold', NULL, NULL, 'fivers/bs-slot-black-gold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:11', '2024-04-12 13:55:11');
INSERT INTO `games` VALUES (349, 9, NULL, 'bs-slot-slots-angels', 'Slots Angels', 'bs-slot-slots-angels', NULL, NULL, 'fivers/bs-slot-slots-angels.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:12', '2024-04-12 13:55:12');
INSERT INTO `games` VALUES (350, 9, NULL, 'bs-slot-under-the-sea', 'Under the Sea', 'bs-slot-under-the-sea', NULL, NULL, 'fivers/bs-slot-under-the-sea.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:13', '2024-04-12 13:55:13');
INSERT INTO `games` VALUES (351, 9, NULL, 'bs-slot-the-exterminator', 'The Exterminator', 'bs-slot-the-exterminator', NULL, NULL, 'fivers/bs-slot-the-exterminator.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:13', '2024-04-12 13:55:13');
INSERT INTO `games` VALUES (352, 9, NULL, 'bs-slot-at-the-movies', 'At the Movies', 'bs-slot-at-the-movies', NULL, NULL, 'fivers/bs-slot-at-the-movies.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:14', '2024-04-12 13:55:14');
INSERT INTO `games` VALUES (353, 9, NULL, 'bs-slot-safari-sam', 'Safari Sam', 'bs-slot-safari-sam', NULL, NULL, 'fivers/bs-slot-safari-sam.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:15', '2024-04-12 13:55:15');
INSERT INTO `games` VALUES (354, 9, NULL, 'bs-slot-sushi-bar', 'Sushi Bar', 'bs-slot-sushi-bar', NULL, NULL, 'fivers/bs-slot-sushi-bar.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:16', '2024-04-12 13:55:16');
INSERT INTO `games` VALUES (355, 9, NULL, 'bs-slot-after-night-falls', 'After Night Falls', 'bs-slot-after-night-falls', NULL, NULL, 'fivers/bs-slot-after-night-falls.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:17', '2024-04-12 13:55:17');
INSERT INTO `games` VALUES (356, 9, NULL, 'bs-slot-at-the-copa', 'At The Copa', 'bs-slot-at-the-copa', NULL, NULL, 'fivers/bs-slot-at-the-copa.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:17', '2024-04-12 13:55:17');
INSERT INTO `games` VALUES (357, 9, NULL, 'bs-slot-under-the-bed', 'Under the Bed', 'bs-slot-under-the-bed', NULL, NULL, 'fivers/bs-slot-under-the-bed.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:18', '2024-04-12 13:55:18');
INSERT INTO `games` VALUES (358, 9, NULL, 'bs-slot-boomanji', 'Boomanji', 'bs-slot-boomanji', NULL, NULL, 'fivers/bs-slot-boomanji.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:19', '2024-04-12 13:55:19');
INSERT INTO `games` VALUES (359, 9, NULL, 'bs-slot-greedy-goblins', 'Greedy Goblins', 'bs-slot-greedy-goblins', NULL, NULL, 'fivers/bs-slot-greedy-goblins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:20', '2024-04-12 13:55:20');
INSERT INTO `games` VALUES (360, 9, NULL, 'bs-slot-slotfather-jp', 'Slot Father jp', 'bs-slot-slotfather-jp', NULL, NULL, 'fivers/bs-slot-slotfather-jp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:21', '2024-04-12 13:55:21');
INSERT INTO `games` VALUES (361, 9, NULL, 'bs-slot-enchanted-jp', 'Enchanted JP', 'bs-slot-enchanted-jp', NULL, NULL, 'fivers/bs-slot-enchanted-jp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:22', '2024-04-12 13:55:22');
INSERT INTO `games` VALUES (362, 9, NULL, 'bs-slot-a-night-in-paris-jp', 'A Night in Paris jp', 'bs-slot-a-night-in-paris-jp', NULL, NULL, 'fivers/bs-slot-a-night-in-paris-jp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:22', '2024-04-12 13:55:22');
INSERT INTO `games` VALUES (363, 9, NULL, 'bs-slot-the-true-sheriff', 'The True Sheriff', 'bs-slot-the-true-sheriff', NULL, NULL, 'fivers/bs-slot-the-true-sheriff.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:23', '2024-04-12 13:55:23');
INSERT INTO `games` VALUES (364, 9, NULL, 'bs-slot-sugar-pop', 'Sugar Pop', 'bs-slot-sugar-pop', NULL, NULL, 'fivers/bs-slot-sugar-pop.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:24', '2024-04-12 13:55:24');
INSERT INTO `games` VALUES (365, 9, NULL, 'bs-slot-good-girl-bad-girl', 'Good Girl, Bad Girl', 'bs-slot-good-girl-bad-girl', NULL, NULL, 'fivers/bs-slot-good-girl-bad-girl.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:25', '2024-04-12 13:55:25');
INSERT INTO `games` VALUES (366, 9, NULL, 'bs-slot-the-curious-machine-plus', 'The Curious Machine Plus', 'bs-slot-the-curious-machine-plus', NULL, NULL, 'fivers/bs-slot-the-curious-machine-plus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:26', '2024-04-12 13:55:26');
INSERT INTO `games` VALUES (367, 9, NULL, 'bs-slot-tycoons-plus', 'Tycoons Plus', 'bs-slot-tycoons-plus', NULL, NULL, 'fivers/bs-slot-tycoons-plus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:26', '2024-04-12 13:55:26');
INSERT INTO `games` VALUES (368, 9, NULL, 'bs-slot-gypsy-rose', 'Gypsy Rose', 'bs-slot-gypsy-rose', NULL, NULL, 'fivers/bs-slot-gypsy-rose.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:27', '2024-04-12 13:55:27');
INSERT INTO `games` VALUES (369, 9, NULL, 'bs-slot-puppy-love-plus', 'Puppy Love Plus', 'bs-slot-puppy-love-plus', NULL, NULL, 'fivers/bs-slot-puppy-love-plus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:28', '2024-04-12 13:55:28');
INSERT INTO `games` VALUES (370, 9, NULL, 'bs-slot-dr-jekyll-and-mr-hyde', 'Dr Jekyll and Mr Hyde', 'bs-slot-dr-jekyll-and-mr-hyde', NULL, NULL, 'fivers/bs-slot-dr-jekyll-and-mr-hyde.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:29', '2024-04-12 13:55:29');
INSERT INTO `games` VALUES (371, 9, NULL, 'bs-slot-it-came-from-venus-jp-plus', 'It Came From Venus JP Plus', 'bs-slot-it-came-from-venus-jp-plus', NULL, NULL, 'fivers/bs-slot-it-came-from-venus-jp-plus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:30', '2024-04-12 13:55:30');
INSERT INTO `games` VALUES (372, 9, NULL, 'bs-slot-fruit-zen', 'Fruit Zen', 'bs-slot-fruit-zen', NULL, NULL, 'fivers/bs-slot-fruit-zen.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:30', '2024-04-12 13:55:30');
INSERT INTO `games` VALUES (373, 9, NULL, 'bs-slot-pinocchio', 'Pinocchio', 'bs-slot-pinocchio', NULL, NULL, 'fivers/bs-slot-pinocchio.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:31', '2024-04-12 13:55:31');
INSERT INTO `games` VALUES (374, 9, NULL, 'bs-slot-mega-gems', 'Mega Gems', 'bs-slot-mega-gems', NULL, NULL, 'fivers/bs-slot-mega-gems.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:32', '2024-04-12 13:55:32');
INSERT INTO `games` VALUES (375, 9, NULL, 'bs-slot-event-horizon', 'Event Horizon', 'bs-slot-event-horizon', NULL, NULL, 'fivers/bs-slot-event-horizon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:33', '2024-04-12 13:55:33');
INSERT INTO `games` VALUES (376, 9, NULL, 'bs-slot-alkemors-tower', 'Alkemors Tower', 'bs-slot-alkemors-tower', NULL, NULL, 'fivers/bs-slot-alkemors-tower.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:33', '2024-04-12 13:55:33');
INSERT INTO `games` VALUES (377, 9, NULL, 'bs-slot-mega-glam-life-jp', 'Mega Glam Life JP', 'bs-slot-mega-glam-life-jp', NULL, NULL, 'fivers/bs-slot-mega-glam-life-jp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:34', '2024-04-12 13:55:34');
INSERT INTO `games` VALUES (378, 9, NULL, 'bs-slot-weekend-in-vegas', 'Weekend In Vegas', 'bs-slot-weekend-in-vegas', NULL, NULL, 'fivers/bs-slot-weekend-in-vegas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:35', '2024-04-12 13:55:35');
INSERT INTO `games` VALUES (379, 9, NULL, 'bs-slot-the-tipsy-tourist', 'The Tipsy Tourist', 'bs-slot-the-tipsy-tourist', NULL, NULL, 'fivers/bs-slot-the-tipsy-tourist.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:36', '2024-04-12 13:55:36');
INSERT INTO `games` VALUES (380, 9, NULL, 'bs-slot-a-christmas-carol', 'A Christmas Carol', 'bs-slot-a-christmas-carol', NULL, NULL, 'fivers/bs-slot-a-christmas-carol.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:37', '2024-04-12 13:55:37');
INSERT INTO `games` VALUES (381, 9, NULL, 'bs-slot-4-seasons', '4 Seasons', 'bs-slot-4-seasons', NULL, NULL, 'fivers/bs-slot-4-seasons.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:38', '2024-04-12 13:55:38');
INSERT INTO `games` VALUES (382, 9, NULL, 'bs-slot-frankenslots-monster', 'Frankenslots Monster', 'bs-slot-frankenslots-monster', NULL, NULL, 'fivers/bs-slot-frankenslots-monster.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:39', '2024-04-12 13:55:39');
INSERT INTO `games` VALUES (383, 9, NULL, 'bs-slot-birds', 'Birds', 'bs-slot-birds', NULL, NULL, 'fivers/bs-slot-birds.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:39', '2024-04-12 13:55:39');
INSERT INTO `games` VALUES (384, 9, NULL, 'bs-slot-charms-and-clovers', 'Charms And Clovers', 'bs-slot-charms-and-clovers', NULL, NULL, 'fivers/bs-slot-charms-and-clovers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:40', '2024-04-12 13:55:40');
INSERT INTO `games` VALUES (385, 9, NULL, 'bs-slot-fa-fa-twins', 'Fa-Fa Twins', 'bs-slot-fa-fa-twins', NULL, NULL, 'fivers/bs-slot-fa-fa-twins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:41', '2024-04-12 13:55:41');
INSERT INTO `games` VALUES (386, 9, NULL, 'bs-slot-great-88', 'Great 88', 'bs-slot-great-88', NULL, NULL, 'fivers/bs-slot-great-88.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:42', '2024-04-12 13:55:42');
INSERT INTO `games` VALUES (387, 9, NULL, 'bs-slot-slotfather-2', 'Slotfather 2', 'bs-slot-slotfather-2', NULL, NULL, 'fivers/bs-slot-slotfather-2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:43', '2024-04-12 13:55:43');
INSERT INTO `games` VALUES (388, 9, NULL, 'bs-slot-sin-city-nights', 'Sin City Nights', 'bs-slot-sin-city-nights', NULL, NULL, 'fivers/bs-slot-sin-city-nights.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:44', '2024-04-12 13:55:44');
INSERT INTO `games` VALUES (389, 9, NULL, 'bs-slot-kawaii-kitty', 'Kawaii Kitty', 'bs-slot-kawaii-kitty', NULL, NULL, 'fivers/bs-slot-kawaii-kitty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:44', '2024-04-12 13:55:44');
INSERT INTO `games` VALUES (390, 9, NULL, 'bs-slot-the-angler', 'The Angler', 'bs-slot-the-angler', NULL, NULL, 'fivers/bs-slot-the-angler.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:45', '2024-04-12 13:55:45');
INSERT INTO `games` VALUES (391, 9, NULL, 'bs-slot-magic-shoppe', 'Magic Shoppe', 'bs-slot-magic-shoppe', NULL, NULL, 'fivers/bs-slot-magic-shoppe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:46', '2024-04-12 13:55:46');
INSERT INTO `games` VALUES (392, 9, NULL, 'bs-slot-fire-and-steel', 'Fire & Steel', 'bs-slot-fire-and-steel', NULL, NULL, 'fivers/bs-slot-fire-and-steel.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:47', '2024-04-12 13:55:47');
INSERT INTO `games` VALUES (393, 9, NULL, 'bs-slot-blood-eternal', 'Blood Eternal', 'bs-slot-blood-eternal', NULL, NULL, 'fivers/bs-slot-blood-eternal.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:47', '2024-04-12 13:55:47');
INSERT INTO `games` VALUES (394, 9, NULL, 'bs-slot-jumbo-joker', 'Jumbo Joker', 'bs-slot-jumbo-joker', NULL, NULL, 'fivers/bs-slot-jumbo-joker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:48', '2024-04-12 13:55:48');
INSERT INTO `games` VALUES (395, 9, NULL, 'bs-slot-stampede', 'Stampede', 'bs-slot-stampede', NULL, NULL, 'fivers/bs-slot-stampede.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:49', '2024-04-12 13:55:49');
INSERT INTO `games` VALUES (396, 9, NULL, 'bs-slot-legend-of-the-nile', 'Legend Of The Nile', 'bs-slot-legend-of-the-nile', NULL, NULL, 'fivers/bs-slot-legend-of-the-nile.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:50', '2024-04-12 13:55:50');
INSERT INTO `games` VALUES (397, 9, NULL, 'bs-slot-sugar-pop-2', 'Sugar Pop 2', 'bs-slot-sugar-pop-2', NULL, NULL, 'fivers/bs-slot-sugar-pop-2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:51', '2024-04-12 13:55:51');
INSERT INTO `games` VALUES (398, 9, NULL, 'bs-slot-giovannis-gems', 'Giovannis Gems', 'bs-slot-giovannis-gems', NULL, NULL, 'fivers/bs-slot-giovannis-gems.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:52', '2024-04-12 13:55:52');
INSERT INTO `games` VALUES (399, 9, NULL, 'bs-slot-reels-of-wealth', 'Reels Of Wealth', 'bs-slot-reels-of-wealth', NULL, NULL, 'fivers/bs-slot-reels-of-wealth.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:53', '2024-04-12 13:55:53');
INSERT INTO `games` VALUES (400, 9, NULL, 'bs-slot-ogre-empire', 'Ogre Empire', 'bs-slot-ogre-empire', NULL, NULL, 'fivers/bs-slot-ogre-empire.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:54', '2024-04-12 13:55:54');
INSERT INTO `games` VALUES (401, 9, NULL, 'bs-slot-the-golden-owl-of-athena', 'The Golden Owl of Athena', 'bs-slot-the-golden-owl-of-athena', NULL, NULL, 'fivers/bs-slot-the-golden-owl-of-athena.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:54', '2024-04-12 13:55:54');
INSERT INTO `games` VALUES (402, 9, NULL, 'bs-slot-dragon-kings', 'Dragon Kings', 'bs-slot-dragon-kings', NULL, NULL, 'fivers/bs-slot-dragon-kings.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:55', '2024-04-12 13:55:55');
INSERT INTO `games` VALUES (403, 9, NULL, 'bs-slot-faerie-spells', 'Faerie Spells', 'bs-slot-faerie-spells', NULL, NULL, 'fivers/bs-slot-faerie-spells.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:56', '2024-04-12 13:55:56');
INSERT INTO `games` VALUES (404, 9, NULL, 'bs-slot-chilli-pop', 'Chilli Pop', 'bs-slot-chilli-pop', NULL, NULL, 'fivers/bs-slot-chilli-pop.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:56', '2024-04-12 13:55:56');
INSERT INTO `games` VALUES (405, 9, NULL, 'bs-slot-yak-yeti-and-roll', 'Yak, Yeti & Roll', 'bs-slot-yak-yeti-and-roll', NULL, NULL, 'fivers/bs-slot-yak-yeti-and-roll.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:57', '2024-04-12 13:55:57');
INSERT INTO `games` VALUES (406, 9, NULL, 'bs-slot-carnaval-forever', 'Carnaval Forever', 'bs-slot-carnaval-forever', NULL, NULL, 'fivers/bs-slot-carnaval-forever.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:58', '2024-04-12 13:55:58');
INSERT INTO `games` VALUES (407, 9, NULL, 'bs-slot-fruitbat-crazy', 'Fruit bat Crazy', 'bs-slot-fruitbat-crazy', NULL, NULL, 'fivers/bs-slot-fruitbat-crazy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:59', '2024-04-12 13:55:59');
INSERT INTO `games` VALUES (408, 9, NULL, 'bs-slot-viking-voyage', 'Viking Voyage', 'bs-slot-viking-voyage', NULL, NULL, 'fivers/bs-slot-viking-voyage.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:55:59', '2024-04-12 13:55:59');
INSERT INTO `games` VALUES (409, 9, NULL, 'bs-slot-bamboo-rush', 'Bamboo Rush', 'bs-slot-bamboo-rush', NULL, NULL, 'fivers/bs-slot-bamboo-rush.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:00', '2024-04-12 13:56:00');
INSERT INTO `games` VALUES (410, 9, NULL, 'bs-slot-spinfinity-man', 'Spinfinity Man', 'bs-slot-spinfinity-man', NULL, NULL, 'fivers/bs-slot-spinfinity-man.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:01', '2024-04-12 13:56:01');
INSERT INTO `games` VALUES (411, 9, NULL, 'bs-slot-gold-canyon', 'Gold Canyon', 'bs-slot-gold-canyon', NULL, NULL, 'fivers/bs-slot-gold-canyon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:02', '2024-04-12 13:56:02');
INSERT INTO `games` VALUES (412, 9, NULL, 'bs-slot-wolf-moon-rising', 'Wolf Moon Rising', 'bs-slot-wolf-moon-rising', NULL, NULL, 'fivers/bs-slot-wolf-moon-rising.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:03', '2024-04-12 13:56:03');
INSERT INTO `games` VALUES (413, 9, NULL, 'bs-slot-gemmed', 'Gemmed', 'bs-slot-gemmed', NULL, NULL, 'fivers/bs-slot-gemmed.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:04', '2024-04-12 13:56:04');
INSERT INTO `games` VALUES (414, 9, NULL, 'bs-slot-caishens-arrival', 'Caishens Arrival', 'bs-slot-caishens-arrival', NULL, NULL, 'fivers/bs-slot-caishens-arrival.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:04', '2024-04-12 13:56:04');
INSERT INTO `games` VALUES (415, 9, NULL, 'bs-slot-take-the-bank', 'Take The Bank', 'bs-slot-take-the-bank', NULL, NULL, 'fivers/bs-slot-take-the-bank.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:05', '2024-04-12 13:56:05');
INSERT INTO `games` VALUES (416, 9, NULL, 'bs-slot-dragon-and-phoenix', 'Dragon & Phoenix', 'bs-slot-dragon-and-phoenix', NULL, NULL, 'fivers/bs-slot-dragon-and-phoenix.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:06', '2024-04-12 13:56:06');
INSERT INTO `games` VALUES (417, 9, NULL, 'bs-slot-super-sweets', 'Super Sweets', 'bs-slot-super-sweets', NULL, NULL, 'fivers/bs-slot-super-sweets.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:07', '2024-04-12 13:56:07');
INSERT INTO `games` VALUES (418, 9, NULL, 'bs-slot-spring-tails', 'Spring Tails', 'bs-slot-spring-tails', NULL, NULL, 'fivers/bs-slot-spring-tails.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:08', '2024-04-12 13:56:08');
INSERT INTO `games` VALUES (419, 9, NULL, 'bs-slot-back-to-venus', 'Back To Venus', 'bs-slot-back-to-venus', NULL, NULL, 'fivers/bs-slot-back-to-venus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:08', '2024-04-12 13:56:08');
INSERT INTO `games` VALUES (420, 9, NULL, 'bs-slot-total-overdrive', 'Total Overdrive', 'bs-slot-total-overdrive', NULL, NULL, 'fivers/bs-slot-total-overdrive.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:09', '2024-04-12 13:56:09');
INSERT INTO `games` VALUES (421, 9, NULL, 'bs-slot-quest-to-the-west', 'Quest To The West', 'bs-slot-quest-to-the-west', NULL, NULL, 'fivers/bs-slot-quest-to-the-west.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:10', '2024-04-12 13:56:10');
INSERT INTO `games` VALUES (422, 9, NULL, 'bs-slot-book-of-shadows', 'Book of Darkness', 'bs-slot-book-of-shadows', NULL, NULL, 'fivers/bs-slot-book-of-shadows.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:11', '2024-04-12 13:56:11');
INSERT INTO `games` VALUES (423, 9, NULL, 'bs-slot-the-hive', 'The Hive', 'bs-slot-the-hive', NULL, NULL, 'fivers/bs-slot-the-hive.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:12', '2024-04-12 13:56:12');
INSERT INTO `games` VALUES (424, 9, NULL, 'bs-slot-mystic-hive', 'Mystic Hive', 'bs-slot-mystic-hive', NULL, NULL, 'fivers/bs-slot-mystic-hive.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:13', '2024-04-12 13:56:13');
INSERT INTO `games` VALUES (425, 9, NULL, 'bs-tb-american-roulette', 'American Roulette', 'bs-tb-american-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:13', '2024-04-12 13:56:13');
INSERT INTO `games` VALUES (426, 9, NULL, 'bs-tb-pai-gow', 'Pai Gow', 'bs-tb-pai-gow', NULL, NULL, 'fivers/bs-tb-pai-gow.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:14', '2024-04-12 13:56:14');
INSERT INTO `games` VALUES (427, 9, NULL, 'bs-tb-caribbean-poker', 'Caribbean Poker', 'bs-tb-caribbean-poker', NULL, NULL, 'fivers/bs-tb-caribbean-poker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:14', '2024-04-12 13:56:14');
INSERT INTO `games` VALUES (428, 9, NULL, 'bs-tb-super-7-blackjack', 'Super 7 Blackjack', 'bs-tb-super-7-blackjack', NULL, NULL, 'fivers/bs-tb-super-7-blackjack.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:15', '2024-04-12 13:56:15');
INSERT INTO `games` VALUES (429, 9, NULL, 'bs-tb-top-card-trumps', 'Top Card Trumps', 'bs-tb-top-card-trumps', NULL, NULL, 'fivers/bs-tb-top-card-trumps.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:16', '2024-04-12 13:56:16');
INSERT INTO `games` VALUES (430, 9, NULL, 'bs-tb-single-deck-blackjack', 'Single Deck Blackjack', 'bs-tb-single-deck-blackjack', NULL, NULL, 'fivers/bs-tb-single-deck-blackjack.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:18', '2024-04-12 13:56:18');
INSERT INTO `games` VALUES (431, 9, NULL, 'bs-tb-21-burn-blackjack', '21 Burn Blackjack', 'bs-tb-21-burn-blackjack', NULL, NULL, 'fivers/bs-tb-21-burn-blackjack.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:18', '2024-04-12 13:56:18');
INSERT INTO `games` VALUES (432, 9, NULL, 'bs-tb-draw-hi-lo', 'Draw Hi-Lo', 'bs-tb-draw-hi-lo', NULL, NULL, 'fivers/bs-tb-draw-hi-lo.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:19', '2024-04-12 13:56:19');
INSERT INTO `games` VALUES (433, 9, NULL, 'bs-tb-european-roulette', 'European Roulette', 'bs-tb-european-roulette', NULL, NULL, 'fivers/bs-tb-european-roulette.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:20', '2024-04-12 13:56:20');
INSERT INTO `games` VALUES (434, 9, NULL, 'bs-tb-pontoon', 'Pontoon', 'bs-tb-pontoon', NULL, NULL, 'fivers/bs-tb-pontoon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:20', '2024-04-12 13:56:20');
INSERT INTO `games` VALUES (435, 9, NULL, 'bs-tb-pirate-21', 'Pirate 21', 'bs-tb-pirate-21', NULL, NULL, 'fivers/bs-tb-pirate-21.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:21', '2024-04-12 13:56:21');
INSERT INTO `games` VALUES (436, 9, NULL, 'bs-tb-red-dog', 'Red Dog', 'bs-tb-red-dog', NULL, NULL, 'fivers/bs-tb-red-dog.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:22', '2024-04-12 13:56:22');
INSERT INTO `games` VALUES (437, 9, NULL, 'bs-tb-triple-edge-poker', 'Triple Edge Poker', 'bs-tb-triple-edge-poker', NULL, NULL, 'fivers/bs-tb-triple-edge-poker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:23', '2024-04-12 13:56:23');
INSERT INTO `games` VALUES (438, 9, NULL, 'bs-tb-european-blackjack', 'European Blackjack', 'bs-tb-european-blackjack', NULL, NULL, 'fivers/bs-tb-european-blackjack.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:23', '2024-04-12 13:56:23');
INSERT INTO `games` VALUES (439, 9, NULL, 'bs-tb-vip-european-roulette', 'Vip European Roulette', 'bs-tb-vip-european-roulette', NULL, NULL, 'fivers/bs-tb-vip-european-roulette.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:24', '2024-04-12 13:56:24');
INSERT INTO `games` VALUES (440, 9, NULL, 'bs-tb-vip-american-roulette', 'Vip American Roulette', 'bs-tb-vip-american-roulette', NULL, NULL, 'fivers/bs-tb-vip-american-roulette.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:25', '2024-04-12 13:56:25');
INSERT INTO `games` VALUES (441, 9, NULL, 'bs-tb-oasis-poker', 'Oasis Poker', 'bs-tb-oasis-poker', NULL, NULL, 'fivers/bs-tb-oasis-poker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:26', '2024-04-12 13:56:26');
INSERT INTO `games` VALUES (442, 9, NULL, 'bs-tb-three-card-rummy', 'Three Card Rummy', 'bs-tb-three-card-rummy', NULL, NULL, 'fivers/bs-tb-three-card-rummy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:27', '2024-04-12 13:56:27');
INSERT INTO `games` VALUES (443, 9, NULL, 'bs-tb-deuces-wild', 'Deuces Wild', 'bs-tb-deuces-wild', NULL, NULL, 'fivers/bs-tb-deuces-wild.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:27', '2024-04-12 13:56:27');
INSERT INTO `games` VALUES (444, 9, NULL, 'bs-slot-milesBellhouseandGears', 'Miles Bellhouse and the Gears of Time', 'bs-slot-milesBellhouseandGears', NULL, NULL, 'fivers/bs-slot-milesBellhouseandGears.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:28', '2024-04-12 13:56:28');
INSERT INTO `games` VALUES (445, 9, NULL, 'bs-slot-takeSantasShop', 'Take Santas Shop', 'bs-slot-takeSantasShop', NULL, NULL, 'fivers/bs-slot-takeSantasShop.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:29', '2024-04-12 13:56:29');
INSERT INTO `games` VALUES (446, 9, NULL, 'bs-slot-dimSumPrize', 'Dim Sum Prize', 'bs-slot-dimSumPrize', NULL, NULL, 'fivers/bs-slot-dimSumPrize.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:30', '2024-04-12 13:56:30');
INSERT INTO `games` VALUES (447, 9, NULL, 'bs-slot-goldenHorns', 'Golden Horns', 'bs-slot-goldenHorns', NULL, NULL, 'fivers/bs-slot-goldenHorns.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:31', '2024-04-12 13:56:31');
INSERT INTO `games` VALUES (448, 9, NULL, 'bs-slot-primalHunt', 'Primal Hunt', 'bs-slot-primalHunt', NULL, NULL, 'fivers/bs-slot-primalHunt.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:31', '2024-04-12 13:56:31');
INSERT INTO `games` VALUES (449, 9, NULL, 'bs-slot-stacked', 'Stacked', 'bs-slot-stacked', NULL, NULL, 'fivers/bs-slot-stacked.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:32', '2024-04-12 13:56:32');
INSERT INTO `games` VALUES (450, 9, NULL, 'bs-slot-takeOlympus', 'Take Olympus', 'bs-slot-takeOlympus', NULL, NULL, 'fivers/bs-slot-takeOlympus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:33', '2024-04-12 13:56:33');
INSERT INTO `games` VALUES (451, 9, NULL, 'bs-slot-safariSam2', 'Safari Sam 2', 'bs-slot-safariSam2', NULL, NULL, 'fivers/bs-slot-safariSam2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:34', '2024-04-12 13:56:34');
INSERT INTO `games` VALUES (452, 9, NULL, 'bs-slot-lavaGold', 'Lava Gold', 'bs-slot-lavaGold', NULL, NULL, 'fivers/bs-slot-lavaGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:35', '2024-04-12 13:56:35');
INSERT INTO `games` VALUES (453, 9, NULL, 'bs-slot-hatTrickHero', 'Hat Trick Hero', 'bs-slot-hatTrickHero', NULL, NULL, 'fivers/bs-slot-hatTrickHero.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:35', '2024-04-12 13:56:35');
INSERT INTO `games` VALUES (454, 9, NULL, 'bs-slot-mrMacau', 'Mr. Macau', 'bs-slot-mrMacau', NULL, NULL, 'fivers/bs-slot-mrMacau.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:36', '2024-04-12 13:56:36');
INSERT INTO `games` VALUES (455, 9, NULL, 'bs-slot-jungleStripes', 'Jungle Stripes', 'bs-slot-jungleStripes', NULL, NULL, 'fivers/bs-slot-jungleStripes.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:37', '2024-04-12 13:56:37');
INSERT INTO `games` VALUES (456, 9, NULL, 'bs-slot-wildDrops', 'Wild Drops', 'bs-slot-wildDrops', NULL, NULL, 'fivers/bs-slot-wildDrops.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:38', '2024-04-12 13:56:38');
INSERT INTO `games` VALUES (457, 9, NULL, 'bs-slot-88fortune', '88 Frenzy Fortune', 'bs-slot-88fortune', NULL, NULL, 'fivers/bs-slot-88fortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:39', '2024-04-12 13:56:39');
INSERT INTO `games` VALUES (458, 9, NULL, 'bs-slot-7fortuneFrenzy', '7 Fortune Frenzy', 'bs-slot-7fortuneFrenzy', NULL, NULL, 'fivers/bs-slot-7fortuneFrenzy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:40', '2024-04-12 13:56:40');
INSERT INTO `games` VALUES (459, 9, NULL, 'bs-slot-towerofFortuna', 'Tower of Fortuna', 'bs-slot-towerofFortuna', NULL, NULL, 'fivers/bs-slot-towerofFortuna.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:40', '2024-04-12 13:56:40');
INSERT INTO `games` VALUES (460, 9, NULL, 'bs-slot-returntoParis', 'Return to Paris', 'bs-slot-returntoParis', NULL, NULL, 'fivers/bs-slot-returntoParis.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:41', '2024-04-12 13:56:41');
INSERT INTO `games` VALUES (461, 9, NULL, 'bs-slot-thaiBlossoms', 'Thai Blossoms', 'bs-slot-thaiBlossoms', NULL, NULL, 'fivers/bs-slot-thaiBlossoms.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:42', '2024-04-12 13:56:42');
INSERT INTO `games` VALUES (462, 9, NULL, 'bs-slot-stayFrosty', 'Stay Frosty', 'bs-slot-stayFrosty', NULL, NULL, 'fivers/bs-slot-stayFrosty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:43', '2024-04-12 13:56:43');
INSERT INTO `games` VALUES (463, 9, NULL, 'bs-slot-taketheKingdom', 'Take the Kingdom', 'bs-slot-taketheKingdom', NULL, NULL, 'fivers/bs-slot-taketheKingdom.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:43', '2024-04-12 13:56:43');
INSERT INTO `games` VALUES (464, 9, NULL, 'bs-slot-goldTigerAscent', 'Gold Tiger Ascent', 'bs-slot-goldTigerAscent', NULL, NULL, 'fivers/bs-slot-goldTigerAscent.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:44', '2024-04-12 13:56:44');
INSERT INTO `games` VALUES (465, 9, NULL, 'bs-slot-tripleJuicyDrops', 'Triple Juicy Drops', 'bs-slot-tripleJuicyDrops', NULL, NULL, 'fivers/bs-slot-tripleJuicyDrops.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:45', '2024-04-12 13:56:45');
INSERT INTO `games` VALUES (466, 9, NULL, 'bs-slot-lostMysteryChests', 'Lost Mystery Chests', 'bs-slot-lostMysteryChests', NULL, NULL, 'fivers/bs-slot-lostMysteryChests.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:46', '2024-04-12 13:56:46');
INSERT INTO `games` VALUES (467, 9, NULL, 'bs-slot-primalWilderness', 'Primal Wilderness', 'bs-slot-primalWilderness', NULL, NULL, 'fivers/bs-slot-primalWilderness.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:47', '2024-04-12 13:56:47');
INSERT INTO `games` VALUES (468, 9, NULL, 'bs-slot-kenseiBlades', 'Kensei Blades', 'bs-slot-kenseiBlades', NULL, NULL, 'fivers/bs-slot-kenseiBlades.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:47', '2024-04-12 13:56:47');
INSERT INTO `games` VALUES (469, 9, NULL, 'bs-slot-geminiJoker', 'Gemini Joker', 'bs-slot-geminiJoker', NULL, NULL, 'fivers/bs-slot-geminiJoker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:48', '2024-04-12 13:56:48');
INSERT INTO `games` VALUES (470, 9, NULL, 'bs-slot-bookofHelios', 'Book of Helios', 'bs-slot-bookofHelios', NULL, NULL, 'fivers/bs-slot-bookofHelios.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:49', '2024-04-12 13:56:49');
INSERT INTO `games` VALUES (471, 9, NULL, 'bs-slot-wildsofFortune', 'Wilds of Fortune', 'bs-slot-wildsofFortune', NULL, NULL, 'fivers/bs-slot-wildsofFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:50', '2024-04-12 13:56:50');
INSERT INTO `games` VALUES (472, 9, NULL, 'bs-slot-windsofWealth', 'Winds of Wealth', 'bs-slot-windsofWealth', NULL, NULL, 'fivers/bs-slot-windsofWealth.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:51', '2024-04-12 13:56:51');
INSERT INTO `games` VALUES (473, 9, NULL, 'bs-slot-trinintyReels', 'Trininty Reels', 'bs-slot-trinintyReels', NULL, NULL, 'fivers/bs-slot-trinintyReels.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:51', '2024-04-12 13:56:51');
INSERT INTO `games` VALUES (474, 9, NULL, 'bs-slot-woodlanders', 'Woodlanders', 'bs-slot-woodlanders', NULL, NULL, 'fivers/bs-slot-woodlanders.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:52', '2024-04-12 13:56:52');
INSERT INTO `games` VALUES (475, 9, NULL, 'bs-slot-Sleighin', 'Sleighin It', 'bs-slot-Sleighin', NULL, NULL, 'fivers/bs-slot-Sleighin.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:53', '2024-04-12 13:56:53');
INSERT INTO `games` VALUES (476, 9, NULL, 'bs-slot-RagstoWitchesNJP', 'Rags to Witches NJP', 'bs-slot-RagstoWitchesNJP', NULL, NULL, 'fivers/bs-slot-RagstoWitchesNJP.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:53', '2024-04-12 13:56:53');
INSERT INTO `games` VALUES (477, 9, NULL, 'bs-slot-BOUNDINGLUCK', 'BOUNDING LUCK', 'bs-slot-BOUNDINGLUCK', NULL, NULL, 'fivers/bs-slot-BOUNDINGLUCK.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:54', '2024-04-12 13:56:54');
INSERT INTO `games` VALUES (478, 9, NULL, 'bs-slot-HEARTSDESIRE', 'HEARTS DESIRE', 'bs-slot-HEARTSDESIRE', NULL, NULL, 'fivers/bs-slot-HEARTSDESIRE.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:55', '2024-04-12 13:56:55');
INSERT INTO `games` VALUES (479, 9, NULL, 'bs-slot-Expansion', 'Expansion', 'bs-slot-Expansion', NULL, NULL, 'fivers/bs-slot-Expansion.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:56', '2024-04-12 13:56:56');
INSERT INTO `games` VALUES (480, 9, NULL, 'bs-crash-TripleCrash', 'Triple Cash or Crash', 'bs-crash-TripleCrash', NULL, NULL, 'fivers/bs-crash-TripleCrash.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:56', '2024-04-12 13:56:56');
INSERT INTO `games` VALUES (481, 9, NULL, 'bs-slot-CharmsandTreasures', 'Charms and Treasures', 'bs-slot-CharmsandTreasures', NULL, NULL, 'fivers/bs-slot-CharmsandTreasures.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:57', '2024-04-12 13:56:57');
INSERT INTO `games` VALUES (482, 9, NULL, 'bs-tb-SUPREME777JACKPOTS', 'SUPREME 777 JACKPOTS', 'bs-tb-SUPREME777JACKPOTS', NULL, NULL, 'fivers/bs-tb-SUPREME777JACKPOTS.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:58', '2024-04-12 13:56:58');
INSERT INTO `games` VALUES (483, 9, NULL, 'bs-slot-PhoSho', 'Pho Sho', 'bs-slot-PhoSho', NULL, NULL, 'fivers/bs-slot-PhoSho.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:59', '2024-04-12 13:56:59');
INSERT INTO `games` VALUES (484, 9, NULL, 'bs-slot-WishGranted', 'Wish Granted', 'bs-slot-WishGranted', NULL, NULL, 'fivers/bs-slot-WishGranted.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:56:59', '2024-04-12 13:56:59');
INSERT INTO `games` VALUES (485, 9, NULL, 'bs-slot-AprilFuryAndTheChamberOfScarabs', 'April Fury And The Chamber Of Scarabs', 'bs-slot-AprilFuryAndTheChamberOfScarabs', NULL, NULL, 'fivers/bs-slot-AprilFuryAndTheChamberOfScarabs.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:00', '2024-04-12 13:57:00');
INSERT INTO `games` VALUES (486, 9, NULL, 'bs-slot-72Fortunes', '72 Fortunes', 'bs-slot-72Fortunes', NULL, NULL, 'fivers/bs-slot-72Fortunes.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:01', '2024-04-12 13:57:01');
INSERT INTO `games` VALUES (487, 9, NULL, 'bs-slot-FruitMojo', 'Fruit Mojo', 'bs-slot-FruitMojo', NULL, NULL, 'fivers/bs-slot-FruitMojo.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:02', '2024-04-12 13:57:02');
INSERT INTO `games` VALUES (488, 9, NULL, 'bs-SuperGoldenDragonInferno', 'Super Golden Dragon InfernoTM', 'bs-SuperGoldenDragonInferno', NULL, NULL, 'fivers/bs-SuperGoldenDragonInferno.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:03', '2024-04-12 13:57:03');
INSERT INTO `games` VALUES (489, 6, NULL, '3o-slot-aztecFire2', 'Aztec Fire 2', '3o-slot-aztecFire2', NULL, NULL, 'fivers/3o-slot-aztecFire2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:04', '2024-04-12 13:57:04');
INSERT INTO `games` VALUES (490, 6, NULL, '3o-slot-moreMagicApple', 'More Magic Apple', '3o-slot-moreMagicApple', NULL, NULL, 'fivers/3o-slot-moreMagicApple.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:05', '2024-04-12 13:57:05');
INSERT INTO `games` VALUES (491, 6, NULL, '3o-slot-fishReef', 'Fish Reef', '3o-slot-fishReef', NULL, NULL, 'fivers/3o-slot-fishReef.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:06', '2024-04-12 13:57:06');
INSERT INTO `games` VALUES (492, 6, NULL, '3o-slot-queenOfTheSun', 'Queen of the Sun', '3o-slot-queenOfTheSun', NULL, NULL, 'fivers/3o-slot-queenOfTheSun.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:06', '2024-04-12 13:57:06');
INSERT INTO `games` VALUES (493, 6, NULL, '3o-slot-buddhaMegaways', 'Buddha Megaways', '3o-slot-buddhaMegaways', NULL, NULL, 'fivers/3o-slot-buddhaMegaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:07', '2024-04-12 13:57:07');
INSERT INTO `games` VALUES (494, 6, NULL, '3o-slot-aztecPyramid', 'Aztec Pyramid', '3o-slot-aztecPyramid', NULL, NULL, 'fivers/3o-slot-aztecPyramid.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:08', '2024-04-12 13:57:08');
INSERT INTO `games` VALUES (495, 6, NULL, '3o-slot-superRichGod', 'Super Rich GOD', '3o-slot-superRichGod', NULL, NULL, 'fivers/3o-slot-superRichGod.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:09', '2024-04-12 13:57:09');
INSERT INTO `games` VALUES (496, 6, NULL, '3o-slot-greatPanda', 'Great Panda', '3o-slot-greatPanda', NULL, NULL, 'fivers/3o-slot-greatPanda.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:09', '2024-04-12 13:57:09');
INSERT INTO `games` VALUES (497, 6, NULL, '3o-slot-tigersGold', 'Tigers Gold', '3o-slot-tigersGold', NULL, NULL, 'fivers/3o-slot-tigersGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:10', '2024-04-12 13:57:10');
INSERT INTO `games` VALUES (498, 6, NULL, '3o-slot-777gemsRespin', '777 Gems Respin', '3o-slot-777gemsRespin', NULL, NULL, 'fivers/3o-slot-777gemsRespin.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:11', '2024-04-12 13:57:11');
INSERT INTO `games` VALUES (499, 6, NULL, '3o-slot-sunOfEgypt', 'Sun of Egypt', '3o-slot-sunOfEgypt', NULL, NULL, 'fivers/3o-slot-sunOfEgypt.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:11', '2024-04-12 13:57:11');
INSERT INTO `games` VALUES (500, 7, NULL, 'gaming7777-inst-agent-7', 'Agent 7', 'gaming7777-inst-agent-7', NULL, NULL, 'fivers/gaming7777-inst-agent-7.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:12', '2024-04-12 13:57:12');
INSERT INTO `games` VALUES (501, 7, NULL, 'gaming7777-slot-beach-hunt', 'Beach Hunt', 'gaming7777-slot-beach-hunt', NULL, NULL, 'fivers/gaming7777-slot-beach-hunt.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:12', '2024-04-12 13:57:12');
INSERT INTO `games` VALUES (502, 7, NULL, 'gaming7777-tb-blackjack', 'Blackjack', 'gaming7777-tb-blackjack', NULL, NULL, 'fivers/gaming7777-tb-blackjack.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:13', '2024-04-12 13:57:13');
INSERT INTO `games` VALUES (503, 7, NULL, 'gaming7777-tb-booster-roulette', 'Booster Roulette', 'gaming7777-tb-booster-roulette', NULL, NULL, 'fivers/gaming7777-tb-booster-roulette.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:14', '2024-04-12 13:57:14');
INSERT INTO `games` VALUES (504, 7, NULL, 'gaming7777-inst-break-the-vault-now', 'Break The Vault Now', 'gaming7777-inst-break-the-vault-now', NULL, NULL, 'fivers/gaming7777-inst-break-the-vault-now.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:14', '2024-04-12 13:57:14');
INSERT INTO `games` VALUES (505, 7, NULL, 'gaming7777-inst-bucks-detective', 'Bucks Detective', 'gaming7777-inst-bucks-detective', NULL, NULL, 'fivers/gaming7777-inst-bucks-detective.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:15', '2024-04-12 13:57:15');
INSERT INTO `games` VALUES (506, 7, NULL, 'gaming7777-tb-caribbean-stud-poker', 'Caribbean Stud Poker', 'gaming7777-tb-caribbean-stud-poker', NULL, NULL, 'fivers/gaming7777-tb-caribbean-stud-poker.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:15', '2024-04-12 13:57:15');
INSERT INTO `games` VALUES (507, 7, NULL, 'gaming7777-tb-caribbean-stud-poker-jackpot', 'Caribbean Stud Poker - Jackpot', 'gaming7777-tb-caribbean-stud-poker-jackpot', NULL, NULL, 'fivers/gaming7777-tb-caribbean-stud-poker-jackpot.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:16', '2024-04-12 13:57:16');
INSERT INTO `games` VALUES (508, 7, NULL, 'gaming7777-slot-cash-100', 'Cash 100', 'gaming7777-slot-cash-100', NULL, NULL, 'fivers/gaming7777-slot-cash-100.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:17', '2024-04-12 13:57:17');
INSERT INTO `games` VALUES (509, 7, NULL, 'gaming7777-slot-cash-100-easter', 'Cash 100 Easter', 'gaming7777-slot-cash-100-easter', NULL, NULL, 'fivers/gaming7777-slot-cash-100-easter.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:17', '2024-04-12 13:57:17');
INSERT INTO `games` VALUES (510, 7, NULL, 'gaming7777-slot-cash-20', 'Cash 20', 'gaming7777-slot-cash-20', NULL, NULL, 'fivers/gaming7777-slot-cash-20.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:18', '2024-04-12 13:57:18');
INSERT INTO `games` VALUES (511, 7, NULL, 'gaming7777-slot-cash-20-christmas', 'Cash 20 Christmas', 'gaming7777-slot-cash-20-christmas', NULL, NULL, 'fivers/gaming7777-slot-cash-20-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:18', '2024-04-12 13:57:18');
INSERT INTO `games` VALUES (512, 7, NULL, 'gaming7777-inst-cash-20x', 'Cash 20x', 'gaming7777-inst-cash-20x', NULL, NULL, 'fivers/gaming7777-inst-cash-20x.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:19', '2024-04-12 13:57:19');
INSERT INTO `games` VALUES (513, 7, NULL, 'gaming7777-inst-cash-20x-chistmas', 'Cash 20x Christmas', 'gaming7777-inst-cash-20x-chistmas', NULL, NULL, 'fivers/gaming7777-inst-cash-20x-chistmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:20', '2024-04-12 13:57:20');
INSERT INTO `games` VALUES (514, 7, NULL, 'gaming7777-slot-cash-40', 'Cash 40', 'gaming7777-slot-cash-40', NULL, NULL, 'fivers/gaming7777-slot-cash-40.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:20', '2024-04-12 13:57:20');
INSERT INTO `games` VALUES (515, 7, NULL, 'gaming7777-slot-cash-40-christmas', 'Cash 40 Christmas', 'gaming7777-slot-cash-40-christmas', NULL, NULL, 'fivers/gaming7777-slot-cash-40-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:21', '2024-04-12 13:57:21');
INSERT INTO `games` VALUES (516, 7, NULL, 'gaming7777-slot-cash-5', 'Cash 5', 'gaming7777-slot-cash-5', NULL, NULL, 'fivers/gaming7777-slot-cash-5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:21', '2024-04-12 13:57:21');
INSERT INTO `games` VALUES (517, 7, NULL, 'gaming7777-slot-cash-5-christmas', 'Cash 5 Christmas', 'gaming7777-slot-cash-5-christmas', NULL, NULL, 'fivers/gaming7777-slot-cash-5-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:22', '2024-04-12 13:57:22');
INSERT INTO `games` VALUES (518, 7, NULL, 'gaming7777-inst-cash-puzzle', 'Cash Puzzle', 'gaming7777-inst-cash-puzzle', NULL, NULL, 'fivers/gaming7777-inst-cash-puzzle.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:23', '2024-04-12 13:57:23');
INSERT INTO `games` VALUES (519, 7, NULL, 'gaming7777-inst-chocolate', 'Chocolate', 'gaming7777-inst-chocolate', NULL, NULL, 'fivers/gaming7777-inst-chocolate.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:23', '2024-04-12 13:57:23');
INSERT INTO `games` VALUES (520, 7, NULL, 'gaming7777-slot-club-mr-luck', 'Club Mr. Luck', 'gaming7777-slot-club-mr-luck', NULL, NULL, 'fivers/gaming7777-slot-club-mr-luck.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:24', '2024-04-12 13:57:24');
INSERT INTO `games` VALUES (521, 7, NULL, 'gaming7777-slot-crystal-palace-joker', 'Crystal Palace Joker', 'gaming7777-slot-crystal-palace-joker', NULL, NULL, 'fivers/gaming7777-slot-crystal-palace-joker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:25', '2024-04-12 13:57:25');
INSERT INTO `games` VALUES (522, 7, NULL, 'gaming7777-inst-diamonds-of-majesty', 'Diamonds of Majesty', 'gaming7777-inst-diamonds-of-majesty', NULL, NULL, 'fivers/gaming7777-inst-diamonds-of-majesty.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:25', '2024-04-12 13:57:25');
INSERT INTO `games` VALUES (523, 7, NULL, 'gaming7777-inst-diamonds-of-majesty-valentine', 'Diamonds of Majesty Valentine', 'gaming7777-inst-diamonds-of-majesty-valentine', NULL, NULL, 'fivers/gaming7777-inst-diamonds-of-majesty-valentine.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:26', '2024-04-12 13:57:26');
INSERT INTO `games` VALUES (524, 7, NULL, 'gaming7777-tb-dice-2', 'Dice 2', 'gaming7777-tb-dice-2', NULL, NULL, 'fivers/gaming7777-tb-dice-2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:27', '2024-04-12 13:57:27');
INSERT INTO `games` VALUES (525, 7, NULL, 'gaming7777-tb-dice-5', 'Dice 5', 'gaming7777-tb-dice-5', NULL, NULL, 'fivers/gaming7777-tb-dice-5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:27', '2024-04-12 13:57:27');
INSERT INTO `games` VALUES (526, 7, NULL, 'gaming7777-inst-double-coffee', 'Double Coffee', 'gaming7777-inst-double-coffee', NULL, NULL, 'fivers/gaming7777-inst-double-coffee.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:28', '2024-04-12 13:57:28');
INSERT INTO `games` VALUES (527, 7, NULL, 'gaming7777-inst-dream-ride', 'Dream Ride', 'gaming7777-inst-dream-ride', NULL, NULL, 'fivers/gaming7777-inst-dream-ride.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:29', '2024-04-12 13:57:29');
INSERT INTO `games` VALUES (528, 7, NULL, 'gaming7777-inst-easter-cash', 'Easter Cash', 'gaming7777-inst-easter-cash', NULL, NULL, 'fivers/gaming7777-inst-easter-cash.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:29', '2024-04-12 13:57:29');
INSERT INTO `games` VALUES (529, 7, NULL, 'gaming7777-inst-egyptian-treasure', 'Egyptian Treasure', 'gaming7777-inst-egyptian-treasure', NULL, NULL, 'fivers/gaming7777-inst-egyptian-treasure.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:30', '2024-04-12 13:57:30');
INSERT INTO `games` VALUES (530, 7, NULL, 'gaming7777-inst-egyptian-treasure-2', 'Egyptian Treasure II', 'gaming7777-inst-egyptian-treasure-2', NULL, NULL, 'fivers/gaming7777-inst-egyptian-treasure-2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:31', '2024-04-12 13:57:31');
INSERT INTO `games` VALUES (531, 7, NULL, 'gaming7777-inst-fast-50-100-1000', 'Fast 50 100 1000', 'gaming7777-inst-fast-50-100-1000', NULL, NULL, 'fivers/gaming7777-inst-fast-50-100-1000.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:31', '2024-04-12 13:57:31');
INSERT INTO `games` VALUES (532, 7, NULL, 'gaming7777-inst-fast-lap', 'Fast Lap', 'gaming7777-inst-fast-lap', NULL, NULL, 'fivers/gaming7777-inst-fast-lap.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:32', '2024-04-12 13:57:32');
INSERT INTO `games` VALUES (533, 7, NULL, 'gaming7777-inst-football-stars', 'Football Stars', 'gaming7777-inst-football-stars', NULL, NULL, 'fivers/gaming7777-inst-football-stars.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:33', '2024-04-12 13:57:33');
INSERT INTO `games` VALUES (534, 7, NULL, 'gaming7777-slot-fortunes-of- rome', 'Fortunes of Rome', 'gaming7777-slot-fortunes-of- rome', NULL, NULL, 'fivers/gaming7777-slot-fortunes-of- rome.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:33', '2024-04-12 13:57:33');
INSERT INTO `games` VALUES (535, 7, NULL, 'gaming7777-inst-fruit-cash', 'Fruit Cash', 'gaming7777-inst-fruit-cash', NULL, NULL, 'fivers/gaming7777-inst-fruit-cash.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:34', '2024-04-12 13:57:34');
INSERT INTO `games` VALUES (536, 7, NULL, 'gaming7777-slot-fruits', 'Fruits', 'gaming7777-slot-fruits', NULL, NULL, 'fivers/gaming7777-slot-fruits.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:34', '2024-04-12 13:57:34');
INSERT INTO `games` VALUES (537, 7, NULL, 'gaming7777-inst-funfair-2x', 'FunFair 2x', 'gaming7777-inst-funfair-2x', NULL, NULL, 'fivers/gaming7777-inst-funfair-2x.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:35', '2024-04-12 13:57:35');
INSERT INTO `games` VALUES (538, 7, NULL, 'gaming7777-inst-funfair-2x-christmas', 'FunFair 2x Christmas', 'gaming7777-inst-funfair-2x-christmas', NULL, NULL, 'fivers/gaming7777-inst-funfair-2x-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:36', '2024-04-12 13:57:36');
INSERT INTO `games` VALUES (539, 7, NULL, 'gaming7777-slot-galaxy-fortune', 'Galaxy Fortune', 'gaming7777-slot-galaxy-fortune', NULL, NULL, 'fivers/gaming7777-slot-galaxy-fortune.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:36', '2024-04-12 13:57:36');
INSERT INTO `games` VALUES (540, 7, NULL, 'gaming7777-inst-geisha', 'Geisha', 'gaming7777-inst-geisha', NULL, NULL, 'fivers/gaming7777-inst-geisha.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:37', '2024-04-12 13:57:37');
INSERT INTO `games` VALUES (541, 7, NULL, 'gaming7777-slot-gingers-and-gems', 'Gingers and Gems', 'gaming7777-slot-gingers-and-gems', NULL, NULL, 'fivers/gaming7777-slot-gingers-and-gems.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:38', '2024-04-12 13:57:38');
INSERT INTO `games` VALUES (542, 7, NULL, 'gaming7777-inst-golden-7', 'Golden 7', 'gaming7777-inst-golden-7', NULL, NULL, 'fivers/gaming7777-inst-golden-7.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:38', '2024-04-12 13:57:38');
INSERT INTO `games` VALUES (543, 7, NULL, 'gaming7777-inst-golden-7-christmas', 'Golden 7 Christmas', 'gaming7777-inst-golden-7-christmas', NULL, NULL, 'fivers/gaming7777-inst-golden-7-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:39', '2024-04-12 13:57:39');
INSERT INTO `games` VALUES (544, 7, NULL, 'gaming7777-inst-golden-7-spring', 'Golden 7 Spring', 'gaming7777-inst-golden-7-spring', NULL, NULL, 'fivers/gaming7777-inst-golden-7-spring.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:40', '2024-04-12 13:57:40');
INSERT INTO `games` VALUES (545, 7, NULL, 'gaming7777-inst-golden-pyramids', 'Golden Pyramids', 'gaming7777-inst-golden-pyramids', NULL, NULL, 'fivers/gaming7777-inst-golden-pyramids.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:40', '2024-04-12 13:57:40');
INSERT INTO `games` VALUES (546, 7, NULL, 'gaming7777-slot-golden-scarab', 'Golden Scarab', 'gaming7777-slot-golden-scarab', NULL, NULL, 'fivers/gaming7777-slot-golden-scarab.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:41', '2024-04-12 13:57:41');
INSERT INTO `games` VALUES (547, 8, NULL, 'gaming7777-inst-greenhats-jackpot', 'Greenhats Jackpot', 'gaming7777-inst-greenhats-jackpot', NULL, NULL, 'fivers/gaming7777-inst-greenhats-jackpot.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:42', '2024-04-12 13:57:42');
INSERT INTO `games` VALUES (548, 8, NULL, 'gaming7777-slot-greenhats-megawins', 'Greenhats Megawins', 'gaming7777-slot-greenhats-megawins', NULL, NULL, 'fivers/gaming7777-slot-greenhats-megawins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:42', '2024-04-12 13:57:42');
INSERT INTO `games` VALUES (549, 7, NULL, 'gaming7777-inst-halloween', 'Halloween', 'gaming7777-inst-halloween', NULL, NULL, 'fivers/gaming7777-inst-halloween.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:43', '2024-04-12 13:57:43');
INSERT INTO `games` VALUES (550, 7, NULL, 'gaming7777-inst-hawaii', 'Hawaii', 'gaming7777-inst-hawaii', NULL, NULL, 'fivers/gaming7777-inst-hawaii.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:44', '2024-04-12 13:57:44');
INSERT INTO `games` VALUES (551, 7, NULL, 'gaming7777-inst-hit-the-pinata', 'Hit the Pinata', 'gaming7777-inst-hit-the-pinata', NULL, NULL, 'fivers/gaming7777-inst-hit-the-pinata.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:44', '2024-04-12 13:57:44');
INSERT INTO `games` VALUES (552, 7, NULL, 'gaming7777-inst-honey-of-gold', 'Honey of Gold', 'gaming7777-inst-honey-of-gold', NULL, NULL, 'fivers/gaming7777-inst-honey-of-gold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:45', '2024-04-12 13:57:45');
INSERT INTO `games` VALUES (553, 7, NULL, 'gaming7777-slot-hot-ball', 'Hot Ball', 'gaming7777-slot-hot-ball', NULL, NULL, 'fivers/gaming7777-slot-hot-ball.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:45', '2024-04-12 13:57:45');
INSERT INTO `games` VALUES (554, 7, NULL, 'gaming7777-inst-i-love-cash', 'I Love Cash', 'gaming7777-inst-i-love-cash', NULL, NULL, 'fivers/gaming7777-inst-i-love-cash.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:46', '2024-04-12 13:57:46');
INSERT INTO `games` VALUES (555, 7, NULL, 'gaming7777-inst-i-love-cash-christmas', 'I Love Cash Christmas', 'gaming7777-inst-i-love-cash-christmas', NULL, NULL, 'fivers/gaming7777-inst-i-love-cash-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:47', '2024-04-12 13:57:47');
INSERT INTO `games` VALUES (556, 7, NULL, 'gaming7777-inst-i-love-cash-valentine', 'I Love Cash Valentine', 'gaming7777-inst-i-love-cash-valentine', NULL, NULL, 'fivers/gaming7777-inst-i-love-cash-valentine.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:47', '2024-04-12 13:57:47');
INSERT INTO `games` VALUES (557, 7, NULL, 'gaming7777-slot-jack-and-the-beans', 'Jack and the Beans', 'gaming7777-slot-jack-and-the-beans', NULL, NULL, 'fivers/gaming7777-slot-jack-and-the-beans.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:48', '2024-04-12 13:57:48');
INSERT INTO `games` VALUES (558, 7, NULL, 'gaming7777-tb-jelly-kenooo', 'Jelly Kenooo', 'gaming7777-tb-jelly-kenooo', NULL, NULL, 'fivers/gaming7777-tb-jelly-kenooo.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:49', '2024-04-12 13:57:49');
INSERT INTO `games` VALUES (559, 7, NULL, 'gaming7777-slot-jinn', 'Jinn', 'gaming7777-slot-jinn', NULL, NULL, 'fivers/gaming7777-slot-jinn.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:49', '2024-04-12 13:57:49');
INSERT INTO `games` VALUES (560, 7, NULL, 'gaming7777-slot-jinn-spring-oasis', 'Jinn Spring Oasis', 'gaming7777-slot-jinn-spring-oasis', NULL, NULL, 'fivers/gaming7777-slot-jinn-spring-oasis.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:50', '2024-04-12 13:57:50');
INSERT INTO `games` VALUES (561, 7, NULL, 'gaming7777-inst-jungle-conquest', 'Jungle Conquest', 'gaming7777-inst-jungle-conquest', NULL, NULL, 'fivers/gaming7777-inst-jungle-conquest.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:51', '2024-04-12 13:57:51');
INSERT INTO `games` VALUES (562, 7, NULL, 'gaming7777-tb-kenooo-jackpots', 'Kenooo Jackpots', 'gaming7777-tb-kenooo-jackpots', NULL, NULL, 'fivers/gaming7777-tb-kenooo-jackpots.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:51', '2024-04-12 13:57:51');
INSERT INTO `games` VALUES (563, 7, NULL, 'gaming7777-slot-knights-and-magic', 'Knights and Magic', 'gaming7777-slot-knights-and-magic', NULL, NULL, 'fivers/gaming7777-slot-knights-and-magic.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:52', '2024-04-12 13:57:52');
INSERT INTO `games` VALUES (564, 7, NULL, 'gaming7777-inst-lucky-7777', 'Lucky 7777', 'gaming7777-inst-lucky-7777', NULL, NULL, 'fivers/gaming7777-inst-lucky-7777.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:53', '2024-04-12 13:57:53');
INSERT INTO `games` VALUES (565, 7, NULL, 'gaming7777-inst-lucky-7777-christmas', 'Lucky 7777 Christmas', 'gaming7777-inst-lucky-7777-christmas', NULL, NULL, 'fivers/gaming7777-inst-lucky-7777-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:53', '2024-04-12 13:57:53');
INSERT INTO `games` VALUES (566, 7, NULL, 'gaming7777-inst-lucky-clovers', 'Lucky Clovers', 'gaming7777-inst-lucky-clovers', NULL, NULL, 'fivers/gaming7777-inst-lucky-clovers.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:54', '2024-04-12 13:57:54');
INSERT INTO `games` VALUES (567, 7, NULL, 'gaming7777-inst-lucky-clovers-christmas', 'Lucky Clovers Christmas', 'gaming7777-inst-lucky-clovers-christmas', NULL, NULL, 'fivers/gaming7777-inst-lucky-clovers-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:55', '2024-04-12 13:57:55');
INSERT INTO `games` VALUES (568, 7, NULL, 'gaming7777-slot-lucky-submarine', 'Lucky Submarine', 'gaming7777-slot-lucky-submarine', NULL, NULL, 'fivers/gaming7777-slot-lucky-submarine.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:55', '2024-04-12 13:57:55');
INSERT INTO `games` VALUES (569, 7, NULL, 'gaming7777-inst-mayan-gold', 'Mayan Gold', 'gaming7777-inst-mayan-gold', NULL, NULL, 'fivers/gaming7777-inst-mayan-gold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:56', '2024-04-12 13:57:56');
INSERT INTO `games` VALUES (570, 7, NULL, 'gaming7777-slot-mega-jackpots-disco', 'Mega Jackpots Disco', 'gaming7777-slot-mega-jackpots-disco', NULL, NULL, 'fivers/gaming7777-slot-mega-jackpots-disco.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:57', '2024-04-12 13:57:57');
INSERT INTO `games` VALUES (571, 7, NULL, 'gaming7777-slot-most-wanted', 'Most Wanted', 'gaming7777-slot-most-wanted', NULL, NULL, 'fivers/gaming7777-slot-most-wanted.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:57', '2024-04-12 13:57:57');
INSERT INTO `games` VALUES (572, 7, NULL, 'gaming7777-inst-multi-wins', 'Multi Wins', 'gaming7777-inst-multi-wins', NULL, NULL, 'fivers/gaming7777-inst-multi-wins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:58', '2024-04-12 13:57:58');
INSERT INTO `games` VALUES (573, 7, NULL, 'gaming7777-tb-mystery-of-ra-kenooo', 'Mystery of Ra Kenooo', 'gaming7777-tb-mystery-of-ra-kenooo', NULL, NULL, 'fivers/gaming7777-tb-mystery-of-ra-kenooo.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:59', '2024-04-12 13:57:59');
INSERT INTO `games` VALUES (574, 7, NULL, 'gaming7777-slot-pearl-of-egypt-kingdom', 'Pearl of Egypt Kingdom', 'gaming7777-slot-pearl-of-egypt-kingdom', NULL, NULL, 'fivers/gaming7777-slot-pearl-of-egypt-kingdom.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:57:59', '2024-04-12 13:57:59');
INSERT INTO `games` VALUES (575, 7, NULL, 'gaming7777-tb-roulette-7', 'Roulette 7', 'gaming7777-tb-roulette-7', NULL, NULL, 'fivers/gaming7777-tb-roulette-7.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:00', '2024-04-12 13:58:00');
INSERT INTO `games` VALUES (576, 7, NULL, 'gaming7777-slot-samurai-fortunes', 'Samurai Fortunes', 'gaming7777-slot-samurai-fortunes', NULL, NULL, 'fivers/gaming7777-slot-samurai-fortunes.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:00', '2024-04-12 13:58:00');
INSERT INTO `games` VALUES (577, 7, NULL, 'gaming7777-slot-samurai-fortunes-2', 'Samurai Fortunes II', 'gaming7777-slot-samurai-fortunes-2', NULL, NULL, 'fivers/gaming7777-slot-samurai-fortunes-2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:01', '2024-04-12 13:58:01');
INSERT INTO `games` VALUES (578, 7, NULL, 'gaming7777-inst-sea-of-treasures', 'Sea of Treasures', 'gaming7777-inst-sea-of-treasures', NULL, NULL, 'fivers/gaming7777-inst-sea-of-treasures.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:02', '2024-04-12 13:58:02');
INSERT INTO `games` VALUES (579, 7, NULL, 'gaming7777-inst-sea-of-treasures-8-march', 'Sea of Treasures 8 March', 'gaming7777-inst-sea-of-treasures-8-march', NULL, NULL, 'fivers/gaming7777-inst-sea-of-treasures-8-march.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:02', '2024-04-12 13:58:02');
INSERT INTO `games` VALUES (580, 7, NULL, 'gaming7777-inst-sea-of-treasures-christmas', 'Sea of Treasures Christmas', 'gaming7777-inst-sea-of-treasures-christmas', NULL, NULL, 'fivers/gaming7777-inst-sea-of-treasures-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:03', '2024-04-12 13:58:03');
INSERT INTO `games` VALUES (581, 7, NULL, 'gaming7777-inst-silver-and-gold', 'Silver & Gold', 'gaming7777-inst-silver-and-gold', NULL, NULL, 'fivers/gaming7777-inst-silver-and-gold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:04', '2024-04-12 13:58:04');
INSERT INTO `games` VALUES (582, 7, NULL, 'gaming7777-slot-silver-and-gold-slot', 'Silver & Gold Slot', 'gaming7777-slot-silver-and-gold-slot', NULL, NULL, 'fivers/gaming7777-slot-silver-and-gold-slot.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:04', '2024-04-12 13:58:04');
INSERT INTO `games` VALUES (583, 7, NULL, 'gaming7777-slot-speed-race', 'Speed Race', 'gaming7777-slot-speed-race', NULL, NULL, 'fivers/gaming7777-slot-speed-race.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:05', '2024-04-12 13:58:05');
INSERT INTO `games` VALUES (584, 7, NULL, 'gaming7777-slot-star-signs', 'Star Signs', 'gaming7777-slot-star-signs', NULL, NULL, 'fivers/gaming7777-slot-star-signs.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:05', '2024-04-12 13:58:05');
INSERT INTO `games` VALUES (585, 7, NULL, 'gaming7777-slot-super-7777', 'Super 7777', 'gaming7777-slot-super-7777', NULL, NULL, 'fivers/gaming7777-slot-super-7777.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:06', '2024-04-12 13:58:06');
INSERT INTO `games` VALUES (586, 7, NULL, 'gaming7777-slot-super-7777-christmas', 'Super 7777 Christmas', 'gaming7777-slot-super-7777-christmas', NULL, NULL, 'fivers/gaming7777-slot-super-7777-christmas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:07', '2024-04-12 13:58:07');
INSERT INTO `games` VALUES (587, 10, NULL, 'boo-slot-barnyardTwister', 'Barnyard Twister', 'boo-slot-barnyardTwister', NULL, NULL, 'fivers/boo-slot-barnyardTwister.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:07', '2024-04-12 13:58:07');
INSERT INTO `games` VALUES (588, 10, NULL, 'boo-slot-vipFilthyRiches', 'VIP Filthy Riches', 'boo-slot-vipFilthyRiches', NULL, NULL, 'fivers/boo-slot-vipFilthyRiches.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:08', '2024-04-12 13:58:08');
INSERT INTO `games` VALUES (589, 10, NULL, 'boo-slot-sugarSkulls', 'Sugar Skulls', 'boo-slot-sugarSkulls', NULL, NULL, 'fivers/boo-slot-sugarSkulls.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:09', '2024-04-12 13:58:09');
INSERT INTO `games` VALUES (590, 10, NULL, 'boo-slot-fengShuiKitties', 'Feng Shui Kitties', 'boo-slot-fengShuiKitties', NULL, NULL, 'fivers/boo-slot-fengShuiKitties.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:10', '2024-04-12 13:58:10');
INSERT INTO `games` VALUES (591, 10, NULL, 'boo-slot-wunderfestDeluxe', 'Wunderfest Deluxe', 'boo-slot-wunderfestDeluxe', NULL, NULL, 'fivers/boo-slot-wunderfestDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:10', '2024-04-12 13:58:10');
INSERT INTO `games` VALUES (592, 10, NULL, 'boo-slot-bigAppleWins', 'Big Apple Wins', 'boo-slot-bigAppleWins', NULL, NULL, 'fivers/boo-slot-bigAppleWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:11', '2024-04-12 13:58:11');
INSERT INTO `games` VALUES (593, 10, NULL, 'boo-slot-wildDiamond7x', 'Wild Diamond x7', 'boo-slot-wildDiamond7x', NULL, NULL, 'fivers/boo-slot-wildDiamond7x.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:12', '2024-04-12 13:58:12');
INSERT INTO `games` VALUES (594, 10, NULL, 'boo-slot-lavaLoca', 'Lava Loca', 'boo-slot-lavaLoca', NULL, NULL, 'fivers/boo-slot-lavaLoca.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:12', '2024-04-12 13:58:12');
INSERT INTO `games` VALUES (595, 10, NULL, 'boo-slot-boomingSevenDeluxe', 'Booming Seven Deluxe', 'boo-slot-boomingSevenDeluxe', NULL, NULL, 'fivers/boo-slot-boomingSevenDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:13', '2024-04-12 13:58:13');
INSERT INTO `games` VALUES (596, 10, NULL, 'boo-slot-cubaCaliente', 'Cuba Caliente', 'boo-slot-cubaCaliente', NULL, NULL, 'fivers/boo-slot-cubaCaliente.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:14', '2024-04-12 13:58:14');
INSERT INTO `games` VALUES (597, 10, NULL, 'boo-slot-vegasVIPGold', 'Vegas VIP Gold', 'boo-slot-vegasVIPGold', NULL, NULL, 'fivers/boo-slot-vegasVIPGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:14', '2024-04-12 13:58:14');
INSERT INTO `games` VALUES (598, 10, NULL, 'boo-slot-parisNights', 'Paris Nights', 'boo-slot-parisNights', NULL, NULL, 'fivers/boo-slot-parisNights.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:15', '2024-04-12 13:58:15');
INSERT INTO `games` VALUES (599, 10, NULL, 'boo-slot-discoBar7s', 'Disco Bar 7s', 'boo-slot-discoBar7s', NULL, NULL, 'fivers/boo-slot-discoBar7s.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:16', '2024-04-12 13:58:16');
INSERT INTO `games` VALUES (600, 10, NULL, 'boo-slot-wildPride', 'Wild Pride', 'boo-slot-wildPride', NULL, NULL, 'fivers/boo-slot-wildPride.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:16', '2024-04-12 13:58:16');
INSERT INTO `games` VALUES (601, 10, NULL, 'boo-slot-mexicoWins', 'Mexico Wins', 'boo-slot-mexicoWins', NULL, NULL, 'fivers/boo-slot-mexicoWins.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:17', '2024-04-12 13:58:17');
INSERT INTO `games` VALUES (602, 10, NULL, 'boo-slot-vegasWins', 'Vegas Wins', 'boo-slot-vegasWins', NULL, NULL, 'fivers/boo-slot-vegasWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:17', '2024-04-12 13:58:17');
INSERT INTO `games` VALUES (603, 10, NULL, 'boo-slot-valleyOfPharaohs', 'Valley of Pharaohs', 'boo-slot-valleyOfPharaohs', NULL, NULL, 'fivers/boo-slot-valleyOfPharaohs.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:18', '2024-04-12 13:58:18');
INSERT INTO `games` VALUES (604, 10, NULL, 'boo-slot-royalWins', 'Royal Wins', 'boo-slot-royalWins', NULL, NULL, 'fivers/boo-slot-royalWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:19', '2024-04-12 13:58:19');
INSERT INTO `games` VALUES (605, 10, NULL, 'boo-slot-bacheloretteParty', 'Bachelorette Party', 'boo-slot-bacheloretteParty', NULL, NULL, 'fivers/boo-slot-bacheloretteParty.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:19', '2024-04-12 13:58:19');
INSERT INTO `games` VALUES (606, 10, NULL, 'boo-slot-goldenProfits', 'Golden Profits', 'boo-slot-goldenProfits', NULL, NULL, 'fivers/boo-slot-goldenProfits.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:20', '2024-04-12 13:58:20');
INSERT INTO `games` VALUES (607, 10, NULL, 'boo-slot-goldenGirls', 'Golden Girls', 'boo-slot-goldenGirls', NULL, NULL, 'fivers/boo-slot-goldenGirls.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:21', '2024-04-12 13:58:21');
INSERT INTO `games` VALUES (608, 10, NULL, 'boo-slot-asiaWins', 'Asia Wins', 'boo-slot-asiaWins', NULL, NULL, 'fivers/boo-slot-asiaWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:21', '2024-04-12 13:58:21');
INSERT INTO `games` VALUES (609, 10, NULL, 'boo-slot-classico', 'Classico', 'boo-slot-classico', NULL, NULL, 'fivers/boo-slot-classico.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:22', '2024-04-12 13:58:22');
INSERT INTO `games` VALUES (610, 10, NULL, 'boo-slot-exoticFruit', 'Exotic Fruit', 'boo-slot-exoticFruit', NULL, NULL, 'fivers/boo-slot-exoticFruit.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:23', '2024-04-12 13:58:23');
INSERT INTO `games` VALUES (611, 10, NULL, 'boo-slot-babyBloomers', 'Baby Bloomers', 'boo-slot-babyBloomers', NULL, NULL, 'fivers/boo-slot-babyBloomers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:23', '2024-04-12 13:58:23');
INSERT INTO `games` VALUES (612, 10, NULL, 'boo-slot-lotusLove', 'Lotus Love', 'boo-slot-lotusLove', NULL, NULL, 'fivers/boo-slot-lotusLove.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:24', '2024-04-12 13:58:24');
INSERT INTO `games` VALUES (613, 10, NULL, 'boo-slot-harvestFest', 'Harvest Fest', 'boo-slot-harvestFest', NULL, NULL, 'fivers/boo-slot-harvestFest.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:25', '2024-04-12 13:58:25');
INSERT INTO `games` VALUES (614, 10, NULL, 'boo-slot-santasKiss', 'Santa ́s Kiss', 'boo-slot-santasKiss', NULL, NULL, 'fivers/boo-slot-santasKiss.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:25', '2024-04-12 13:58:25');
INSERT INTO `games` VALUES (615, 10, NULL, 'boo-slot-wunderfest', 'Wunderfest', 'boo-slot-wunderfest', NULL, NULL, 'fivers/boo-slot-wunderfest.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:26', '2024-04-12 13:58:26');
INSERT INTO `games` VALUES (616, 10, NULL, 'boo-slot-boomerangBonanza', 'Boomerang Bonanza', 'boo-slot-boomerangBonanza', NULL, NULL, 'fivers/boo-slot-boomerangBonanza.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:27', '2024-04-12 13:58:27');
INSERT INTO `games` VALUES (617, 10, NULL, 'boo-slot-DevilsHeat', 'Devil ́s Heart', 'boo-slot-DevilsHeat', NULL, NULL, 'fivers/boo-slot-DevilsHeat.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:28', '2024-04-12 13:58:28');
INSERT INTO `games` VALUES (618, 10, NULL, 'boo-slot-doublinGold', 'Dublin Gold', 'boo-slot-doublinGold', NULL, NULL, 'fivers/boo-slot-doublinGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:28', '2024-04-12 13:58:28');
INSERT INTO `games` VALUES (619, 10, NULL, 'boo-slot-wildJester', 'Wild Jester', 'boo-slot-wildJester', NULL, NULL, 'fivers/boo-slot-wildJester.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:29', '2024-04-12 13:58:29');
INSERT INTO `games` VALUES (620, 10, NULL, 'boo-slot-romeo', 'Romeo', 'boo-slot-romeo', NULL, NULL, 'fivers/boo-slot-romeo.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:30', '2024-04-12 13:58:30');
INSERT INTO `games` VALUES (621, 10, NULL, 'boo-slot-boomingSeven', 'Booming Seven', 'boo-slot-boomingSeven', NULL, NULL, 'fivers/boo-slot-boomingSeven.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:30', '2024-04-12 13:58:30');
INSERT INTO `games` VALUES (622, 10, NULL, 'boo-slot-dolphinsLuck2', 'Dolphin ́s Luck 2', 'boo-slot-dolphinsLuck2', NULL, NULL, 'fivers/boo-slot-dolphinsLuck2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:31', '2024-04-12 13:58:31');
INSERT INTO `games` VALUES (623, 10, NULL, 'boo-slot-boomingBars', 'Booming Bars', 'boo-slot-boomingBars', NULL, NULL, 'fivers/boo-slot-boomingBars.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:32', '2024-04-12 13:58:32');
INSERT INTO `games` VALUES (624, 10, NULL, 'boo-slot-cherryBombDeluxe', 'Cherry Bomb Deluxe', 'boo-slot-cherryBombDeluxe', NULL, NULL, 'fivers/boo-slot-cherryBombDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:32', '2024-04-12 13:58:32');
INSERT INTO `games` VALUES (625, 10, NULL, 'boo-slot-theKingPanda', 'The King Panda', 'boo-slot-theKingPanda', NULL, NULL, 'fivers/boo-slot-theKingPanda.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:33', '2024-04-12 13:58:33');
INSERT INTO `games` VALUES (626, 10, NULL, 'boo-slot-freemasonsFortune', 'Freemasons Fortune', 'boo-slot-freemasonsFortune', NULL, NULL, 'fivers/boo-slot-freemasonsFortune.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:34', '2024-04-12 13:58:34');
INSERT INTO `games` VALUES (627, 10, NULL, 'boo-slot-exoticFruitDeluxe', 'Exotic Fruit Deluxe', 'boo-slot-exoticFruitDeluxe', NULL, NULL, 'fivers/boo-slot-exoticFruitDeluxe.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:35', '2024-04-12 13:58:35');
INSERT INTO `games` VALUES (628, 10, NULL, 'boo-slot-goal', 'Goal!!!', 'boo-slot-goal', NULL, NULL, 'fivers/boo-slot-goal.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:36', '2024-04-12 13:58:36');
INSERT INTO `games` VALUES (629, 10, NULL, 'boo-slot-sharkMeet', 'Shark Meet', 'boo-slot-sharkMeet', NULL, NULL, 'fivers/boo-slot-sharkMeet.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:37', '2024-04-12 13:58:37');
INSERT INTO `games` VALUES (630, 10, NULL, 'boo-slot-wildCherries', 'Wild Cherries', 'boo-slot-wildCherries', NULL, NULL, 'fivers/boo-slot-wildCherries.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:38', '2024-04-12 13:58:38');
INSERT INTO `games` VALUES (631, 10, NULL, 'boo-slot-genieWishes', 'Genie Wishes', 'boo-slot-genieWishes', NULL, NULL, 'fivers/boo-slot-genieWishes.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:39', '2024-04-12 13:58:39');
INSERT INTO `games` VALUES (632, 10, NULL, 'boo-slot-desertDrag', 'Desert Drag', 'boo-slot-desertDrag', NULL, NULL, 'fivers/boo-slot-desertDrag.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:40', '2024-04-12 13:58:40');
INSERT INTO `games` VALUES (633, 10, NULL, 'boo-slot-coldCash', 'Cold Cash', 'boo-slot-coldCash', NULL, NULL, 'fivers/boo-slot-coldCash.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:41', '2024-04-12 13:58:41');
INSERT INTO `games` VALUES (634, 10, NULL, 'boo-slot-jingleJingle', 'Jingle Jingle', 'boo-slot-jingleJingle', NULL, NULL, 'fivers/boo-slot-jingleJingle.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:42', '2024-04-12 13:58:42');
INSERT INTO `games` VALUES (635, 10, NULL, 'boo-slot-octoberfest', 'Octoberfest', 'boo-slot-octoberfest', NULL, NULL, 'fivers/boo-slot-octoberfest.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:43', '2024-04-12 13:58:43');
INSERT INTO `games` VALUES (636, 10, NULL, 'boo-slot-gangsterGamblers', 'Gangster Gamblers', 'boo-slot-gangsterGamblers', NULL, NULL, 'fivers/boo-slot-gangsterGamblers.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:44', '2024-04-12 13:58:44');
INSERT INTO `games` VALUES (637, 10, NULL, 'boo-slot-revolution', 'Revolution', 'boo-slot-revolution', NULL, NULL, 'fivers/boo-slot-revolution.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:45', '2024-04-12 13:58:45');
INSERT INTO `games` VALUES (638, 10, NULL, 'boo-slot-chicagoNights', 'Chicago Nights', 'boo-slot-chicagoNights', NULL, NULL, 'fivers/boo-slot-chicagoNights.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:46', '2024-04-12 13:58:46');
INSERT INTO `games` VALUES (639, 10, NULL, 'boo-slot-laRomantica', 'La romantica', 'boo-slot-laRomantica', NULL, NULL, 'fivers/boo-slot-laRomantica.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:47', '2024-04-12 13:58:47');
INSERT INTO `games` VALUES (640, 10, NULL, 'boo-slot-legendofQuYuan', 'Legend of Qu Yuan', 'boo-slot-legendofQuYuan', NULL, NULL, 'fivers/boo-slot-legendofQuYuan.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:48', '2024-04-12 13:58:48');
INSERT INTO `games` VALUES (641, 10, NULL, 'boo-slot-monsterMunchies', 'Monster Munchies', 'boo-slot-monsterMunchies', NULL, NULL, 'fivers/boo-slot-monsterMunchies.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:49', '2024-04-12 13:58:49');
INSERT INTO `games` VALUES (642, 10, NULL, 'boo-slot-ohCatrina', 'Oh Catrina!', 'boo-slot-ohCatrina', NULL, NULL, 'fivers/boo-slot-ohCatrina.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:50', '2024-04-12 13:58:50');
INSERT INTO `games` VALUES (643, 10, NULL, 'boo-slot-tailgating', 'Tailgating', 'boo-slot-tailgating', NULL, NULL, 'fivers/boo-slot-tailgating.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:51', '2024-04-12 13:58:51');
INSERT INTO `games` VALUES (644, 10, NULL, 'boo-slot-miamiNights', 'Miami Nights', 'boo-slot-miamiNights', NULL, NULL, 'fivers/boo-slot-miamiNights.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:51', '2024-04-12 13:58:51');
INSERT INTO `games` VALUES (645, 10, NULL, 'boo-slot-boomingGold', 'Booming Gold', 'boo-slot-boomingGold', NULL, NULL, 'fivers/boo-slot-boomingGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:52', '2024-04-12 13:58:52');
INSERT INTO `games` VALUES (646, 10, NULL, 'boo-slot-5x-astroPandas', 'Astro Pandas', 'boo-slot-5x-astroPandas', NULL, NULL, 'fivers/boo-slot-5x-astroPandas.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:52', '2024-04-12 13:58:52');
INSERT INTO `games` VALUES (647, 10, NULL, 'boo-slot-boomshakalaka', 'Boomshakalaka', 'boo-slot-boomshakalaka', NULL, NULL, 'fivers/boo-slot-boomshakalaka.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:53', '2024-04-12 13:58:53');
INSERT INTO `games` VALUES (648, 10, NULL, 'boo-slot-showMeTheMummy', 'Show me the Mummy', 'boo-slot-showMeTheMummy', NULL, NULL, 'fivers/boo-slot-showMeTheMummy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:54', '2024-04-12 13:58:54');
INSERT INTO `games` VALUES (649, 10, NULL, 'boo-slot-cheekyMonkeys', 'Cheeky Monkeys', 'boo-slot-cheekyMonkeys', NULL, NULL, 'fivers/boo-slot-cheekyMonkeys.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:54', '2024-04-12 13:58:54');
INSERT INTO `games` VALUES (650, 10, NULL, 'boo-slot-stellarSpins', 'Stellar Spins', 'boo-slot-stellarSpins', NULL, NULL, 'fivers/boo-slot-stellarSpins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:55', '2024-04-12 13:58:55');
INSERT INTO `games` VALUES (651, 10, NULL, 'boo-slot-goldenLuckyPigs', 'Golden Lucky Pigs', 'boo-slot-goldenLuckyPigs', NULL, NULL, 'fivers/boo-slot-goldenLuckyPigs.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:56', '2024-04-12 13:58:56');
INSERT INTO `games` VALUES (652, 10, NULL, 'boo-slot-superBoom', 'Super Boom', 'boo-slot-superBoom', NULL, NULL, 'fivers/boo-slot-superBoom.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:57', '2024-04-12 13:58:57');
INSERT INTO `games` VALUES (653, 10, NULL, 'boo-slot-wildOcean', 'Wild Ocean', 'boo-slot-wildOcean', NULL, NULL, 'fivers/boo-slot-wildOcean.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:58', '2024-04-12 13:58:58');
INSERT INTO `games` VALUES (654, 10, NULL, 'boo-slot-goldVein', 'Gold Vein', 'boo-slot-goldVein', NULL, NULL, 'fivers/boo-slot-goldVein.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:59', '2024-04-12 13:58:59');
INSERT INTO `games` VALUES (655, 10, NULL, 'boo-slot-pirateBooty', 'Pirate Booty', 'boo-slot-pirateBooty', NULL, NULL, 'fivers/boo-slot-pirateBooty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:58:59', '2024-04-12 13:58:59');
INSERT INTO `games` VALUES (656, 10, NULL, 'boo-slot-boomingCircus', 'Booming Circus', 'boo-slot-boomingCircus', NULL, NULL, 'fivers/boo-slot-boomingCircus.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:00', '2024-04-12 13:59:00');
INSERT INTO `games` VALUES (657, 10, NULL, 'boo-slot-leprechaunsLuckyBarrel', 'Leprechauns Lucky Barrel', 'boo-slot-leprechaunsLuckyBarrel', NULL, NULL, 'fivers/boo-slot-leprechaunsLuckyBarrel.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:01', '2024-04-12 13:59:01');
INSERT INTO `games` VALUES (658, 10, NULL, 'boo-slot-surfinReels', 'Surfin Reels', 'boo-slot-surfinReels', NULL, NULL, 'fivers/boo-slot-surfinReels.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:02', '2024-04-12 13:59:02');
INSERT INTO `games` VALUES (659, 10, NULL, 'boo-slot-colossalVikings', 'Colossal Vikings', 'boo-slot-colossalVikings', NULL, NULL, 'fivers/boo-slot-colossalVikings.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:03', '2024-04-12 13:59:03');
INSERT INTO `games` VALUES (660, 10, NULL, 'boo-slot-aztecPalace', 'Aztec Palace', 'boo-slot-aztecPalace', NULL, NULL, 'fivers/boo-slot-aztecPalace.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:03', '2024-04-12 13:59:03');
INSERT INTO `games` VALUES (661, 10, NULL, 'boo-slot-colossalFruitSmash', 'Colossal Fruit Smash', 'boo-slot-colossalFruitSmash', NULL, NULL, 'fivers/boo-slot-colossalFruitSmash.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:04', '2024-04-12 13:59:04');
INSERT INTO `games` VALUES (662, 10, NULL, 'boo-slot-witchesWildBrew', 'Witches Wild Brew', 'boo-slot-witchesWildBrew', NULL, NULL, 'fivers/boo-slot-witchesWildBrew.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:05', '2024-04-12 13:59:05');
INSERT INTO `games` VALUES (663, 10, NULL, 'boo-slot-snailRace', 'Snail Race', 'boo-slot-snailRace', NULL, NULL, 'fivers/boo-slot-snailRace.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:06', '2024-04-12 13:59:06');
INSERT INTO `games` VALUES (664, 10, NULL, 'boo-slot-dragonsChest', 'Dragons Chest', 'boo-slot-dragonsChest', NULL, NULL, 'fivers/boo-slot-dragonsChest.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:07', '2024-04-12 13:59:07');
INSERT INTO `games` VALUES (665, 10, NULL, 'boo-slot-chickenParty', 'Chicken Party', 'boo-slot-chickenParty', NULL, NULL, 'fivers/boo-slot-chickenParty.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:08', '2024-04-12 13:59:08');
INSERT INTO `games` VALUES (666, 10, NULL, 'boo-slot-hooked', 'Hooked', 'boo-slot-hooked', NULL, NULL, 'fivers/boo-slot-hooked.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:08', '2024-04-12 13:59:08');
INSERT INTO `games` VALUES (667, 10, NULL, 'boo-slot-wildEnergy', 'Wild Energy', 'boo-slot-wildEnergy', NULL, NULL, 'fivers/boo-slot-wildEnergy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:09', '2024-04-12 13:59:09');
INSERT INTO `games` VALUES (668, 10, NULL, 'boo-slot-gladiatorArena', 'Gladiator Arena', 'boo-slot-gladiatorArena', NULL, NULL, 'fivers/boo-slot-gladiatorArena.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:10', '2024-04-12 13:59:10');
INSERT INTO `games` VALUES (669, 10, NULL, 'boo-slot-arabianSpins', 'Arabian Spins', 'boo-slot-arabianSpins', NULL, NULL, 'fivers/boo-slot-arabianSpins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:10', '2024-04-12 13:59:10');
INSERT INTO `games` VALUES (670, 10, NULL, 'boo-slot-spinosaurus', 'Spinosaurus', 'boo-slot-spinosaurus', NULL, NULL, 'fivers/boo-slot-spinosaurus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:11', '2024-04-12 13:59:11');
INSERT INTO `games` VALUES (671, 10, NULL, 'boo-slot-gunspinner', 'Gunspinner', 'boo-slot-gunspinner', NULL, NULL, 'fivers/boo-slot-gunspinner.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:12', '2024-04-12 13:59:12');
INSERT INTO `games` VALUES (672, 10, NULL, 'boo-slot-dangerZone', 'Danger Zone', 'boo-slot-dangerZone', NULL, NULL, 'fivers/boo-slot-dangerZone.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:12', '2024-04-12 13:59:12');
INSERT INTO `games` VALUES (673, 10, NULL, 'boo-slot-showMaster', 'Show Master', 'boo-slot-showMaster', NULL, NULL, 'fivers/boo-slot-showMaster.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:13', '2024-04-12 13:59:13');
INSERT INTO `games` VALUES (674, 10, NULL, 'boo-slot-burningClassics', 'Burning Classics', 'boo-slot-burningClassics', NULL, NULL, 'fivers/boo-slot-burningClassics.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:13', '2024-04-12 13:59:13');
INSERT INTO `games` VALUES (675, 10, NULL, 'boo-slot-howlingWolves', 'Howling Wolves', 'boo-slot-howlingWolves', NULL, NULL, 'fivers/boo-slot-howlingWolves.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:14', '2024-04-12 13:59:14');
INSERT INTO `games` VALUES (676, 10, NULL, 'boo-slot-tikiWins', 'Tiki Wins', 'boo-slot-tikiWins', NULL, NULL, 'fivers/boo-slot-tikiWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:15', '2024-04-12 13:59:15');
INSERT INTO `games` VALUES (677, 10, NULL, 'boo-slot-luckyScarabs', 'Lucky Scarabs', 'boo-slot-luckyScarabs', NULL, NULL, 'fivers/boo-slot-luckyScarabs.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:16', '2024-04-12 13:59:16');
INSERT INTO `games` VALUES (678, 10, NULL, 'boo-slot-horrorHouse', 'Horror House', 'boo-slot-horrorHouse', NULL, NULL, 'fivers/boo-slot-horrorHouse.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:16', '2024-04-12 13:59:16');
INSERT INTO `games` VALUES (679, 10, NULL, 'boo-slot-wombaroo', 'Wombaroo', 'boo-slot-wombaroo', NULL, NULL, 'fivers/boo-slot-wombaroo.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:17', '2024-04-12 13:59:17');
INSERT INTO `games` VALUES (680, 10, NULL, 'boo-slot-jestersJoy', 'Jesters Joy', 'boo-slot-jestersJoy', NULL, NULL, 'fivers/boo-slot-jestersJoy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:17', '2024-04-12 13:59:17');
INSERT INTO `games` VALUES (681, 10, NULL, 'boo-slot-freezingClassics', 'Freezing Classics', 'boo-slot-freezingClassics', NULL, NULL, 'fivers/boo-slot-freezingClassics.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:18', '2024-04-12 13:59:18');
INSERT INTO `games` VALUES (682, 10, NULL, 'boo-slot-bookofTombs', 'Book of Tombs', 'boo-slot-bookofTombs', NULL, NULL, 'fivers/boo-slot-bookofTombs.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:19', '2024-04-12 13:59:19');
INSERT INTO `games` VALUES (683, 10, NULL, 'boo-slot-cashPig', 'Cash Pig', 'boo-slot-cashPig', NULL, NULL, 'fivers/boo-slot-cashPig.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:20', '2024-04-12 13:59:20');
INSERT INTO `games` VALUES (684, 10, NULL, 'boo-slot-sphinxFortune', 'Sphinx Fortune', 'boo-slot-sphinxFortune', NULL, NULL, 'fivers/boo-slot-sphinxFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:20', '2024-04-12 13:59:20');
INSERT INTO `games` VALUES (685, 10, NULL, 'boo-slot-wizardingWins', 'Wizarding Wins', 'boo-slot-wizardingWins', NULL, NULL, 'fivers/boo-slot-wizardingWins.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:21', '2024-04-12 13:59:21');
INSERT INTO `games` VALUES (686, 10, NULL, 'boo-slot-diamondRiches', 'Diamond Riches', 'boo-slot-diamondRiches', NULL, NULL, 'fivers/boo-slot-diamondRiches.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:22', '2024-04-12 13:59:22');
INSERT INTO `games` VALUES (687, 10, NULL, 'boo-slot-majesticSafari', 'Majestic Safari', 'boo-slot-majesticSafari', NULL, NULL, 'fivers/boo-slot-majesticSafari.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:23', '2024-04-12 13:59:23');
INSERT INTO `games` VALUES (688, 10, NULL, 'boo-slot-goldHunter', 'Gold Hunter', 'boo-slot-goldHunter', NULL, NULL, 'fivers/boo-slot-goldHunter.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:23', '2024-04-12 13:59:23');
INSERT INTO `games` VALUES (689, 10, NULL, 'boo-slot-bangBang', 'Bang Bang', 'boo-slot-bangBang', NULL, NULL, 'fivers/boo-slot-bangBang.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:24', '2024-04-12 13:59:24');
INSERT INTO `games` VALUES (690, 10, NULL, 'boo-slot-wildVegas', 'Wild Wild Vegas', 'boo-slot-wildVegas', NULL, NULL, 'fivers/boo-slot-wildVegas.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:25', '2024-04-12 13:59:25');
INSERT INTO `games` VALUES (691, 10, NULL, 'boo-slot-greekLegends', 'Greek Legends', 'boo-slot-greekLegends', NULL, NULL, 'fivers/boo-slot-greekLegends.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:26', '2024-04-12 13:59:26');
INSERT INTO `games` VALUES (692, 10, NULL, 'boo-slot-crystal', 'Crystal Classics', 'boo-slot-crystal', NULL, NULL, 'fivers/boo-slot-crystal.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:26', '2024-04-12 13:59:26');
INSERT INTO `games` VALUES (693, 10, NULL, 'boo-slot-redHotVolcano', 'Red Hot Volcano', 'boo-slot-redHotVolcano', NULL, NULL, 'fivers/boo-slot-redHotVolcano.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:27', '2024-04-12 13:59:27');
INSERT INTO `games` VALUES (694, 10, NULL, 'boo-slot-rhinoHoldWin', 'Rhino Hold and Win', 'boo-slot-rhinoHoldWin', NULL, NULL, 'fivers/boo-slot-rhinoHoldWin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:28', '2024-04-12 13:59:28');
INSERT INTO `games` VALUES (695, 10, NULL, 'boo-slot-wildBonusReSpins', 'Wild Bonus Re-Spins', 'boo-slot-wildBonusReSpins', NULL, NULL, 'fivers/boo-slot-wildBonusReSpins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:28', '2024-04-12 13:59:28');
INSERT INTO `games` VALUES (696, 10, NULL, 'boo-slot-mightyGorilla', 'Mighty Gorilla', 'boo-slot-mightyGorilla', NULL, NULL, 'fivers/boo-slot-mightyGorilla.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:29', '2024-04-12 13:59:29');
INSERT INTO `games` VALUES (697, 10, NULL, 'boo-slot-moneyMoose', 'Money Moose', 'boo-slot-moneyMoose', NULL, NULL, 'fivers/boo-slot-moneyMoose.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:30', '2024-04-12 13:59:30');
INSERT INTO `games` VALUES (698, 10, NULL, 'boo-slot-oceanDrive', 'Ocean Drive', 'boo-slot-oceanDrive', NULL, NULL, 'fivers/boo-slot-oceanDrive.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:31', '2024-04-12 13:59:31');
INSERT INTO `games` VALUES (699, 10, NULL, 'boo-slot-HowlingWolvesMega', 'Howling Wolves Megaways', 'boo-slot-HowlingWolvesMega', NULL, NULL, 'fivers/boo-slot-HowlingWolvesMega.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:32', '2024-04-12 13:59:32');
INSERT INTO `games` VALUES (700, 10, NULL, 'boo-slot-flamingChilies', 'Flaming Chilies', 'boo-slot-flamingChilies', NULL, NULL, 'fivers/boo-slot-flamingChilies.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:32', '2024-04-12 13:59:32');
INSERT INTO `games` VALUES (701, 10, NULL, 'boo-slot-GambleliciousHW', 'Gamblelicious Hold and Win', 'boo-slot-GambleliciousHW', NULL, NULL, 'fivers/boo-slot-GambleliciousHW.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:33', '2024-04-12 13:59:33');
INSERT INTO `games` VALUES (702, 10, NULL, 'boo-slot-BlockchainM', 'Blockchain Megaways', 'boo-slot-BlockchainM', NULL, NULL, 'fivers/boo-slot-BlockchainM.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:34', '2024-04-12 13:59:34');
INSERT INTO `games` VALUES (703, 10, NULL, 'boo-slot-monsterTMadness', 'Monster Truck Madness', 'boo-slot-monsterTMadness', NULL, NULL, 'fivers/boo-slot-monsterTMadness.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:35', '2024-04-12 13:59:35');
INSERT INTO `games` VALUES (704, 10, NULL, 'boo-slot-legDiamonds', 'Legendary Diamonds', 'boo-slot-legDiamonds', NULL, NULL, 'fivers/boo-slot-legDiamonds.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:35', '2024-04-12 13:59:35');
INSERT INTO `games` VALUES (705, 10, NULL, 'boo-slot-burningClassicsGW', 'Burning Classics Go Wild', 'boo-slot-burningClassicsGW', NULL, NULL, 'fivers/boo-slot-burningClassicsGW.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:36', '2024-04-12 13:59:36');
INSERT INTO `games` VALUES (706, 10, NULL, 'boo-slot-StarlightRiches', 'Starlight Riches', 'boo-slot-StarlightRiches', NULL, NULL, 'fivers/boo-slot-StarlightRiches.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:37', '2024-04-12 13:59:37');
INSERT INTO `games` VALUES (707, 10, NULL, 'boo-slot-letitspin', 'Let it Spin', 'boo-slot-letitspin', NULL, NULL, 'fivers/boo-slot-letitspin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:38', '2024-04-12 13:59:38');
INSERT INTO `games` VALUES (708, 10, NULL, 'boo-slot-TheJungleEmpire', 'The Jungle Empire', 'boo-slot-TheJungleEmpire', NULL, NULL, 'fivers/boo-slot-TheJungleEmpire.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:39', '2024-04-12 13:59:39');
INSERT INTO `games` VALUES (709, 10, NULL, 'boo-slot-RollTheDice', 'Roll the Dice', 'boo-slot-RollTheDice', NULL, NULL, 'fivers/boo-slot-RollTheDice.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:39', '2024-04-12 13:59:39');
INSERT INTO `games` VALUES (710, 10, NULL, 'boo-slot-TreasureVault', 'Treasure Vault', 'boo-slot-TreasureVault', NULL, NULL, 'fivers/boo-slot-TreasureVault.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:40', '2024-04-12 13:59:40');
INSERT INTO `games` VALUES (711, 10, NULL, 'boo-slot-GoldenStrawberries', 'Golden Strawberries', 'boo-slot-GoldenStrawberries', NULL, NULL, 'fivers/boo-slot-GoldenStrawberries.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:41', '2024-04-12 13:59:41');
INSERT INTO `games` VALUES (712, 10, NULL, 'boo-slot-TNTBonanza', 'TNT Bonanza', 'boo-slot-TNTBonanza', NULL, NULL, 'fivers/boo-slot-TNTBonanza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:42', '2024-04-12 13:59:42');
INSERT INTO `games` VALUES (713, 10, NULL, 'boo-slot-TheRodfatherMys', 'The Rodfather Megaways', 'boo-slot-TheRodfatherMys', NULL, NULL, 'fivers/boo-slot-TheRodfatherMys.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:42', '2024-04-12 13:59:42');
INSERT INTO `games` VALUES (714, 10, NULL, 'boo-slot-DiceDiceBaby', 'Dice Dice Baby', 'boo-slot-DiceDiceBaby', NULL, NULL, 'fivers/boo-slot-DiceDiceBaby.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:43', '2024-04-12 13:59:43');
INSERT INTO `games` VALUES (715, 10, NULL, 'boo-slot-GoBananza', 'Go Bananza', 'boo-slot-GoBananza', NULL, NULL, 'fivers/boo-slot-GoBananza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:44', '2024-04-12 13:59:44');
INSERT INTO `games` VALUES (716, 10, NULL, 'boo-slot-DogSquad', 'Dog Squad', 'boo-slot-DogSquad', NULL, NULL, 'fivers/boo-slot-DogSquad.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:45', '2024-04-12 13:59:45');
INSERT INTO `games` VALUES (717, 10, NULL, 'boo-TheMightyToro', 'The Mighty Toro', 'boo-TheMightyToro', NULL, NULL, 'fivers/boo-TheMightyToro.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:46', '2024-04-12 13:59:46');
INSERT INTO `games` VALUES (718, 10, NULL, 'boo-PowerofOlympus', 'Power of Olympus', 'boo-PowerofOlympus', NULL, NULL, 'fivers/boo-PowerofOlympus.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:46', '2024-04-12 13:59:46');
INSERT INTO `games` VALUES (719, 10, NULL, 'boo-PiñataWildz', 'Piñata Wildz', 'boo-PiñataWildz', NULL, NULL, 'fivers/boo-PiñataWildz.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:47', '2024-04-12 13:59:47');
INSERT INTO `games` VALUES (720, 10, NULL, 'boo-GoldGoldGold', 'Gold Gold Gold', 'boo-GoldGoldGold', NULL, NULL, 'fivers/boo-GoldGoldGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:48', '2024-04-12 13:59:48');
INSERT INTO `games` VALUES (721, 10, NULL, 'boo-KingCobra', 'King Cobra', 'boo-KingCobra', NULL, NULL, 'fivers/boo-KingCobra.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:49', '2024-04-12 13:59:49');
INSERT INTO `games` VALUES (722, 10, NULL, 'boo-BambooWilds', 'Bamboo Wilds', 'boo-BambooWilds', NULL, NULL, 'fivers/boo-BambooWilds.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:50', '2024-04-12 13:59:50');
INSERT INTO `games` VALUES (723, 10, NULL, 'boo-CracktheBankHoldandWin', 'Crack the Bank Hold and Win', 'boo-CracktheBankHoldandWin', NULL, NULL, 'fivers/boo-CracktheBankHoldandWin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:51', '2024-04-12 13:59:51');
INSERT INTO `games` VALUES (724, 10, NULL, 'boo-TheWildWingsofPhoenix', 'The Wild Wings of Phoenix', 'boo-TheWildWingsofPhoenix', NULL, NULL, 'fivers/boo-TheWildWingsofPhoenix.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:51', '2024-04-12 13:59:51');
INSERT INTO `games` VALUES (725, 10, NULL, 'boo-StickyBombs', 'Sticky Bombs', 'boo-StickyBombs', NULL, NULL, 'fivers/boo-StickyBombs.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:52', '2024-04-12 13:59:52');
INSERT INTO `games` VALUES (726, 10, NULL, 'boo-MammothTundra', 'Mammoth Tundra', 'boo-MammothTundra', NULL, NULL, 'fivers/boo-MammothTundra.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:53', '2024-04-12 13:59:53');
INSERT INTO `games` VALUES (727, 10, NULL, 'boo-MoneyInc', 'Money Inc', 'boo-MoneyInc', NULL, NULL, 'fivers/boo-MoneyInc.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:54', '2024-04-12 13:59:54');
INSERT INTO `games` VALUES (728, 13, NULL, 'pgs-slot-TreeOfFortune', 'Tree Of Fortune', 'pgs-slot-TreeOfFortune', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:54', '2024-04-12 13:59:54');
INSERT INTO `games` VALUES (729, 19, NULL, 'pgs-tb-JokerWild', 'Joker Wild', 'pgs-tb-JokerWild', NULL, NULL, 'fivers/pgs-tb-JokerWild.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:56', '2024-04-12 13:59:56');
INSERT INTO `games` VALUES (730, 19, NULL, 'pgs-slot-SummonConquer', 'Summon Conquer', 'pgs-slot-SummonConquer', NULL, NULL, 'fivers/pgs-slot-SummonConquer.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:58', '2024-04-12 13:59:58');
INSERT INTO `games` VALUES (731, 13, NULL, 'pgs-slot-Hotpot', 'Hot Pot', 'pgs-slot-Hotpot', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:58', '2024-04-12 13:59:58');
INSERT INTO `games` VALUES (732, 13, NULL, 'pgs-slot-MrHallowWin', 'Mr Hallow Win', 'pgs-slot-MrHallowWin', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:59', '2024-04-12 13:59:59');
INSERT INTO `games` VALUES (733, 19, NULL, 'pgs-slot-LegendOfHouYi', 'Legend Of Hou Yi', 'pgs-slot-LegendOfHouYi', NULL, NULL, 'fivers/pgs-slot-LegendOfHouYi.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 13:59:59', '2024-04-12 13:59:59');
INSERT INTO `games` VALUES (734, 13, NULL, 'pgs-slot-SantasGiftRush', 'Santas Gift Rush', 'pgs-slot-SantasGiftRush', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:00', '2024-04-12 14:00:00');
INSERT INTO `games` VALUES (735, 19, NULL, 'pgs-tb-BaccaratDeluxe', 'Baccarat Deluxe', 'pgs-tb-BaccaratDeluxe', NULL, NULL, 'fivers/pgs-tb-BaccaratDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:00', '2024-04-12 14:00:00');
INSERT INTO `games` VALUES (736, 13, NULL, 'pgs-slot-SymbolsOfEgypt', 'Symbols Of Egypt', 'pgs-slot-SymbolsOfEgypt', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:01', '2024-04-12 14:00:01');
INSERT INTO `games` VALUES (737, 13, NULL, 'pgs-slot-EmperorsFavour', 'Emperors Favour', 'pgs-slot-EmperorsFavour', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:02', '2024-04-12 14:00:02');
INSERT INTO `games` VALUES (738, 13, NULL, 'pgs-slot-TheGreatIcescape', 'The Great Ice Scape', 'pgs-slot-TheGreatIcescape', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:02', '2024-04-12 14:00:02');
INSERT INTO `games` VALUES (739, 13, NULL, 'pgs-slot-JourneyToTheWealth', 'Journey To The Wealth', 'pgs-slot-JourneyToTheWealth', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:03', '2024-04-12 14:00:03');
INSERT INTO `games` VALUES (740, 13, NULL, 'pgs-slot-captainsBounty', 'Captains Bounty', 'pgs-slot-captainsBounty', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:04', '2024-04-12 14:00:04');
INSERT INTO `games` VALUES (741, 13, NULL, 'pgs-slot-ninjaVsSamurai', 'Ninja Vs Samurai', 'pgs-slot-ninjaVsSamurai', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:04', '2024-04-12 14:00:04');
INSERT INTO `games` VALUES (742, 13, NULL, 'pgs-slot-caishenwins', 'Cai Shen Wins', 'pgs-slot-caishenwins', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:05', '2024-04-12 14:00:05');
INSERT INTO `games` VALUES (743, 13, NULL, 'pgs-slot-egyptsbookmystery', 'Egypts Book Mystery', 'pgs-slot-egyptsbookmystery', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:05', '2024-04-12 14:00:05');
INSERT INTO `games` VALUES (744, 13, NULL, 'pgs-slot-genies3Wishes', 'Genies 3 Wishes', 'pgs-slot-genies3Wishes', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:06', '2024-04-12 14:00:06');
INSERT INTO `games` VALUES (745, 13, NULL, 'pgs-slot-treasuresAztec', 'Treasures Aztec', 'pgs-slot-treasuresAztec', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:07', '2024-04-12 14:00:07');
INSERT INTO `games` VALUES (746, 13, NULL, 'pgs-slot-vampiresCharm', 'Vampires Charm', 'pgs-slot-vampiresCharm', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:07', '2024-04-12 14:00:07');
INSERT INTO `games` VALUES (747, 13, NULL, 'pgs-slot-secretsOfCleopatra', 'Secrets Of Cleopatra', 'pgs-slot-secretsOfCleopatra', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:08', '2024-04-12 14:00:08');
INSERT INTO `games` VALUES (748, 13, NULL, 'pgs-slot-queenBounty', 'Queen Bounty', 'pgs-slot-queenBounty', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:08', '2024-04-12 14:00:08');
INSERT INTO `games` VALUES (749, 19, NULL, 'pgs-slot-jewelsProsper', 'Jewels Prosper', 'pgs-slot-jewelsProsper', NULL, NULL, 'fivers/pgs-slot-jewelsProsper.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:09', '2024-04-12 14:00:09');
INSERT INTO `games` VALUES (750, 13, NULL, 'pgs-slot-jackFrosts', 'Jack Frosts', 'pgs-slot-jackFrosts', 'slots', NULL, '01HVAD0SA8AVVVKKQDFP7ET5PT.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:00:09', '2024-04-12 21:16:51');
INSERT INTO `games` VALUES (751, 13, NULL, 'pgs-slot-gdnIceFire', 'Guardian of Ice and Fire', 'pgs-slot-gdnIceFire', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:10', '2024-04-12 14:00:10');
INSERT INTO `games` VALUES (752, 13, NULL, 'pgs-slot-heistStakes', 'Heist Stakes', 'pgs-slot-heistStakes', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:10', '2024-04-12 14:00:10');
INSERT INTO `games` VALUES (753, 13, NULL, 'pgs-slot-waysQilin', 'Ways Of Qilin', 'pgs-slot-waysQilin', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:11', '2024-04-12 14:00:11');
INSERT INTO `games` VALUES (754, 13, NULL, 'pgs-slot-riseofApollo', 'Rise Of Apollo', 'pgs-slot-riseofApollo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:11', '2024-04-12 14:00:11');
INSERT INTO `games` VALUES (755, 19, NULL, 'pgs-slot-sushiOishi', 'Sushi Oishi', 'pgs-slot-sushiOishi', NULL, NULL, 'fivers/pgs-slot-sushiOishi.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:12', '2024-04-12 14:00:12');
INSERT INTO `games` VALUES (756, 19, NULL, 'pgs-slot-cryptFortune', 'Raider Janes Crypt of Fortune', 'pgs-slot-cryptFortune', NULL, NULL, 'fivers/pgs-slot-cryptFortune.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:13', '2024-04-12 14:00:13');
INSERT INTO `games` VALUES (757, 13, NULL, 'pgs-slot-destinySunMoon', 'Destiny of Sun and Moon', 'pgs-slot-destinySunMoon', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:13', '2024-04-12 14:00:13');
INSERT INTO `games` VALUES (758, 13, NULL, 'pgs-slot-queensBanquet', 'The Queens Banquet', 'pgs-slot-queensBanquet', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:14', '2024-04-12 14:00:14');
INSERT INTO `games` VALUES (759, 19, NULL, 'pgs-ninjaraccoonfrenzy', 'Ninja Raccoon Frenzy', 'pgs-ninjaraccoonfrenzy', NULL, NULL, 'fivers/pgs-ninjaraccoonfrenzy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:16', '2024-04-12 14:00:16');
INSERT INTO `games` VALUES (760, 5, NULL, 'bgtv-lg-lucky-5', 'Lucky 5', 'bgtv-lg-lucky-5', NULL, NULL, 'fivers/bgtv-lg-lucky-5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:16', '2024-04-12 14:00:16');
INSERT INTO `games` VALUES (761, 5, NULL, 'bgtv-lg-bet-on-poker', 'Bet On Poker', 'bgtv-lg-bet-on-poker', NULL, NULL, 'fivers/bgtv-lg-bet-on-poker.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:17', '2024-04-12 14:00:17');
INSERT INTO `games` VALUES (762, 5, NULL, 'bgtv-lg-war-of-bets', 'War Of Bets', 'bgtv-lg-war-of-bets', NULL, NULL, 'fivers/bgtv-lg-war-of-bets.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:17', '2024-04-12 14:00:17');
INSERT INTO `games` VALUES (763, 5, NULL, 'bgtv-lg-lucky-6', 'Lucky 6', 'bgtv-lg-lucky-6', NULL, NULL, 'fivers/bgtv-lg-lucky-6.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:18', '2024-04-12 14:00:18');
INSERT INTO `games` VALUES (764, 5, NULL, 'bgtv-lg-dice-duel', 'Dice Duel', 'bgtv-lg-dice-duel', NULL, NULL, 'fivers/bgtv-lg-dice-duel.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:18', '2024-04-12 14:00:18');
INSERT INTO `games` VALUES (765, 5, NULL, 'bgtv-lg-speedy-7', 'Speedy 7', 'bgtv-lg-speedy-7', NULL, NULL, 'fivers/bgtv-lg-speedy-7.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:19', '2024-04-12 14:00:19');
INSERT INTO `games` VALUES (766, 5, NULL, 'bgtv-lg-6-poker', '6+ Poker', 'bgtv-lg-6-poker', NULL, NULL, 'fivers/bgtv-lg-6-poker.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:19', '2024-04-12 14:00:19');
INSERT INTO `games` VALUES (767, 18, NULL, 'superHotBingo', 'Super Hot Bingo', 'superHotBingo', NULL, NULL, 'fivers/superHotBingo.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:20', '2024-04-12 14:00:20');
INSERT INTO `games` VALUES (768, 18, NULL, 'superPachinko', 'Super Pachinko', 'superPachinko', NULL, NULL, 'fivers/superPachinko.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:20', '2024-04-12 14:00:20');
INSERT INTO `games` VALUES (769, 18, NULL, 'zodiac', 'Zodiac', 'zodiac', NULL, NULL, 'fivers/zodiac.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:21', '2024-04-12 14:00:21');
INSERT INTO `games` VALUES (770, 18, NULL, 'flex', 'Flex', 'flex', NULL, NULL, 'fivers/flex.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:21', '2024-04-12 14:00:21');
INSERT INTO `games` VALUES (771, 18, NULL, 'candy', 'Candy', 'candy', NULL, NULL, 'fivers/candy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:22', '2024-04-12 14:00:22');
INSERT INTO `games` VALUES (772, 18, NULL, 'goal', 'Goal', 'goal', NULL, NULL, 'fivers/goal.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:22', '2024-04-12 14:00:22');
INSERT INTO `games` VALUES (773, 18, NULL, 'pirate', 'Pirate', 'pirate', NULL, NULL, 'fivers/pirate.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:23', '2024-04-12 14:00:23');
INSERT INTO `games` VALUES (774, 18, NULL, 'farm', 'Farm', 'farm', NULL, NULL, 'fivers/farm.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:23', '2024-04-12 14:00:23');
INSERT INTO `games` VALUES (775, 18, NULL, 'pachinko3', 'Pachinko 3', 'pachinko3', NULL, NULL, 'fivers/pachinko3.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:24', '2024-04-12 14:00:24');
INSERT INTO `games` VALUES (776, 18, NULL, 'candy3d', 'Candy  3D', 'candy3d', NULL, NULL, 'fivers/candy3d.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:24', '2024-04-12 14:00:24');
INSERT INTO `games` VALUES (777, 18, NULL, 'superPachinkoPlus', 'Super Pachinko Plus', 'superPachinkoPlus', NULL, NULL, 'fivers/superPachinkoPlus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:25', '2024-04-12 14:00:25');
INSERT INTO `games` VALUES (778, 18, NULL, 'jogoDosBichosPraia', 'Jogo dos Bichos Praia', 'jogoDosBichosPraia', NULL, NULL, 'fivers/jogoDosBichosPraia.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:25', '2024-04-12 14:00:25');
INSERT INTO `games` VALUES (779, 18, NULL, 'halloweenGrooveBingo', 'Halloween Groove Bingo', 'halloweenGrooveBingo', NULL, NULL, 'fivers/halloweenGrooveBingo.gif', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:26', '2024-04-12 14:00:26');
INSERT INTO `games` VALUES (780, 18, NULL, 'crystalMonster', 'Crystal Monster', 'crystalMonster', NULL, NULL, 'fivers/crystalMonster.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:27', '2024-04-12 14:00:27');
INSERT INTO `games` VALUES (781, 18, NULL, 'cucasSwamp', 'Cucas Swamp', 'cucasSwamp', NULL, NULL, 'fivers/cucasSwamp.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:27', '2024-04-12 14:00:27');
INSERT INTO `games` VALUES (782, 18, NULL, 'melcochita', 'Melcochita', 'melcochita', NULL, NULL, 'fivers/melcochita.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:28', '2024-04-12 14:00:28');
INSERT INTO `games` VALUES (783, 17, NULL, 'prag-slot-spaceman', 'Spaceman', 'prag-slot-spaceman', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:28', '2024-04-12 14:00:28');
INSERT INTO `games` VALUES (784, 19, NULL, 'prag-slot-fruitParty', 'Fruit Party', 'prag-slot-fruitParty', NULL, NULL, 'fivers/prag-slot-fruitParty.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:29', '2024-04-12 14:00:29');
INSERT INTO `games` VALUES (785, 15, NULL, 'sms-tb-jetx', 'jetX', 'sms-tb-jetx', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:30', '2024-04-12 14:00:30');
INSERT INTO `games` VALUES (786, 19, NULL, '3o-slot-olympianGods', 'Olympian Gods', '3o-slot-olympianGods', NULL, NULL, 'fivers/3o-slot-olympianGods.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:30', '2024-04-12 14:00:30');
INSERT INTO `games` VALUES (787, 19, NULL, '3o-slot-bookOfSun', 'Book of Sun', '3o-slot-bookOfSun', NULL, NULL, 'fivers/3o-slot-bookOfSun.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:31', '2024-04-12 14:00:31');
INSERT INTO `games` VALUES (788, 17, NULL, 'prag-tb-baccarat-402', 'Live Cassino - Speed Baccarat', 'prag-tb-baccarat-402', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:31', '2024-04-12 14:00:31');
INSERT INTO `games` VALUES (789, 17, NULL, 'prag-tb-roulette201', 'Live Casino - Roulette', 'prag-tb-roulette201', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:32', '2024-04-12 14:00:32');
INSERT INTO `games` VALUES (790, 17, NULL, 'prag-tb-roulette203', 'Live Casino - Speed Roulette', 'prag-tb-roulette203', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:32', '2024-04-12 14:00:32');
INSERT INTO `games` VALUES (791, 17, NULL, 'prag-tb-roulette225', 'Live Casino - Auto Roulette', 'prag-tb-roulette225', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:33', '2024-04-12 14:00:33');
INSERT INTO `games` VALUES (792, 17, NULL, 'prag-tb-sicbo', 'Live Casino - Mega Sic Bo', 'prag-tb-sicbo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:33', '2024-04-12 14:00:33');
INSERT INTO `games` VALUES (793, 17, NULL, 'prag-tb-mw', 'Live Casino - Mega Wheel', 'prag-tb-mw', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:34', '2024-04-12 14:00:34');
INSERT INTO `games` VALUES (794, 17, NULL, 'prag-tb-mr', 'Live Casino - Mega Roulette', 'prag-tb-mr', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:34', '2024-04-12 14:00:34');
INSERT INTO `games` VALUES (795, 17, NULL, 'prag-tb-onebj', 'Live Casino - One Blackjack', 'prag-tb-onebj', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:35', '2024-04-12 14:00:35');
INSERT INTO `games` VALUES (796, 17, NULL, 'prag-tb-dt', 'Live Casino - Dragon Tiger', 'prag-tb-dt', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:35', '2024-04-12 14:00:35');
INSERT INTO `games` VALUES (797, 17, NULL, 'prag-tb-abh161', 'Live Casino - Andar Bahar', 'prag-tb-abh161', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:36', '2024-04-12 14:00:36');
INSERT INTO `games` VALUES (798, 17, NULL, 'prag-tb-bj', 'Live Casino - BlackJack', 'prag-tb-bj', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:36', '2024-04-12 14:00:36');
INSERT INTO `games` VALUES (799, 17, NULL, 'prag-tb-r161', 'Live Casino - Indian Roulette', 'prag-tb-r161', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:37', '2024-04-12 14:00:37');
INSERT INTO `games` VALUES (800, 17, NULL, 'prag-tb-r141', 'Live Casino - The Club Roulette', 'prag-tb-r141', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:37', '2024-04-12 14:00:37');
INSERT INTO `games` VALUES (801, 17, NULL, 'prag-tb-bj105', 'Live Casino - Ruby One Blackjack', 'prag-tb-bj105', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:38', '2024-04-12 14:00:38');
INSERT INTO `games` VALUES (802, 17, NULL, 'prag-tb-swb', 'Live Casino - Sweet Bonanza', 'prag-tb-swb', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:38', '2024-04-12 14:00:38');
INSERT INTO `games` VALUES (803, 17, NULL, 'prag-tb-r221', 'Live Casino - Ruby Roulette', 'prag-tb-r221', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:39', '2024-04-12 14:00:39');
INSERT INTO `games` VALUES (804, 17, NULL, 'prag-tb-one-blackjack-5-flemish', 'ONE Blackjack 5 - Flemish', 'prag-tb-one-blackjack-5-flemish', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:39', '2024-04-12 14:00:39');
INSERT INTO `games` VALUES (805, 17, NULL, 'prag-tb-blackjack-56-azure', 'Blackjack 56 - Azure', 'prag-tb-blackjack-56-azure', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:40', '2024-04-12 14:00:40');
INSERT INTO `games` VALUES (806, 17, NULL, 'prag-tb-LobbyTopGames', 'Lobby Top Games', 'prag-tb-LobbyTopGames', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:40', '2024-04-12 14:00:40');
INSERT INTO `games` VALUES (807, 19, NULL, 'prag-slot-pyramidKing', 'Pyramid King', 'prag-slot-pyramidKing', NULL, NULL, 'fivers/prag-slot-pyramidKing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:41', '2024-04-12 14:00:41');
INSERT INTO `games` VALUES (808, 19, NULL, 'prag-slot-aztecGems', 'Aztec Gems', 'prag-slot-aztecGems', NULL, NULL, 'fivers/prag-slot-aztecGems.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:42', '2024-04-12 14:00:42');
INSERT INTO `games` VALUES (809, 19, NULL, 'prag-slot-sweetBonanza', 'Sweet Bonanza', 'prag-slot-sweetBonanza', NULL, NULL, 'fivers/prag-slot-sweetBonanza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:42', '2024-04-12 14:00:42');
INSERT INTO `games` VALUES (810, 19, NULL, 'prag-slot-greatRhinoMegaways', 'Great Rhino Megaways', 'prag-slot-greatRhinoMegaways', NULL, NULL, 'fivers/prag-slot-greatRhinoMegaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:43', '2024-04-12 14:00:43');
INSERT INTO `games` VALUES (811, 19, NULL, 'prag-slot-broncoSpirit', 'Bronco Spirit', 'prag-slot-broncoSpirit', NULL, NULL, 'fivers/prag-slot-broncoSpirit.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:44', '2024-04-12 14:00:44');
INSERT INTO `games` VALUES (812, 19, NULL, 'prag-slot-greatRhino', 'Great Rhino', 'prag-slot-greatRhino', NULL, NULL, 'fivers/prag-slot-greatRhino.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:44', '2024-04-12 14:00:44');
INSERT INTO `games` VALUES (813, 19, NULL, 'prag-slot-threeStarFortune', 'Three Star Fortune', 'prag-slot-threeStarFortune', NULL, NULL, 'fivers/prag-slot-threeStarFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:45', '2024-04-12 14:00:45');
INSERT INTO `games` VALUES (814, 19, NULL, 'prag-slot-fire88', 'Fire 88', 'prag-slot-fire88', NULL, NULL, 'fivers/prag-slot-fire88.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:46', '2024-04-12 14:00:46');
INSERT INTO `games` VALUES (815, 19, NULL, 'prag-slot-fireStrike', 'Fire Strike', 'prag-slot-fireStrike', NULL, NULL, 'fivers/prag-slot-fireStrike.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:46', '2024-04-12 14:00:46');
INSERT INTO `games` VALUES (816, 19, NULL, 'prag-slot-wildWestGold', 'Wild West Gold', 'prag-slot-wildWestGold', NULL, NULL, 'fivers/prag-slot-wildWestGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:47', '2024-04-12 14:00:47');
INSERT INTO `games` VALUES (817, 19, NULL, 'prag-slot-ultraBurn', 'Ultra Burn', 'prag-slot-ultraBurn', NULL, NULL, 'fivers/prag-slot-ultraBurn.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:48', '2024-04-12 14:00:48');
INSERT INTO `games` VALUES (818, 19, NULL, 'prag-slot-diamondStrike', 'Diamond Strike', 'prag-slot-diamondStrike', NULL, NULL, 'fivers/prag-slot-diamondStrike.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:48', '2024-04-12 14:00:48');
INSERT INTO `games` VALUES (819, 19, NULL, 'prag-slot-treeofRiches', 'Tree of Riches', 'prag-slot-treeofRiches', NULL, NULL, 'fivers/prag-slot-treeofRiches.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:49', '2024-04-12 14:00:49');
INSERT INTO `games` VALUES (820, 19, NULL, 'prag-slot-danceParty', 'Dance Party', 'prag-slot-danceParty', NULL, NULL, 'fivers/prag-slot-danceParty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:50', '2024-04-12 14:00:50');
INSERT INTO `games` VALUES (821, 19, NULL, 'prag-slot-theDogHouse', 'The Dog House', 'prag-slot-theDogHouse', NULL, NULL, 'fivers/prag-slot-theDogHouse.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:50', '2024-04-12 14:00:50');
INSERT INTO `games` VALUES (822, 19, NULL, 'prag-slot-masterJoker', 'Master Joker', 'prag-slot-masterJoker', NULL, NULL, 'fivers/prag-slot-masterJoker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:51', '2024-04-12 14:00:51');
INSERT INTO `games` VALUES (823, 19, NULL, 'prag-slot-5LionsGold', '5 Lions Gold', 'prag-slot-5LionsGold', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:52', '2024-04-12 14:00:52');
INSERT INTO `games` VALUES (824, 19, NULL, 'prag-slot-wolfGold', 'Wolf Gold', 'prag-slot-wolfGold', NULL, NULL, 'fivers/prag-slot-wolfGold.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:52', '2024-04-12 14:00:52');
INSERT INTO `games` VALUES (825, 19, NULL, 'prag-slot-8Dragons', '8Dragons', 'prag-slot-8Dragons', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:53', '2024-04-12 14:00:53');
INSERT INTO `games` VALUES (826, 19, NULL, 'prag-slot-sweetBonanzaXmas', 'Sweet Bonanza Xmas', 'prag-slot-sweetBonanzaXmas', NULL, NULL, 'fivers/prag-slot-sweetBonanzaXmas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:53', '2024-04-12 14:00:53');
INSERT INTO `games` VALUES (827, 19, NULL, 'prag-slot-monkeyMadness', 'Monkey Madness', 'prag-slot-monkeyMadness', NULL, NULL, 'fivers/prag-slot-monkeyMadness.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:54', '2024-04-12 14:00:54');
INSERT INTO `games` VALUES (828, 19, NULL, 'prag-slot-888Gold', '888Gold', 'prag-slot-888Gold', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:55', '2024-04-12 14:00:55');
INSERT INTO `games` VALUES (829, 19, NULL, 'prag-slot-moneyMouse', 'Money Mouse', 'prag-slot-moneyMouse', NULL, NULL, 'fivers/prag-slot-moneyMouse.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:55', '2024-04-12 14:00:55');
INSERT INTO `games` VALUES (830, 19, NULL, 'prag-slot-johnHunterandtheTomboftheScarabQueen', 'John Hunter and the Tomb of the Scarab Queen', 'prag-slot-johnHunterandtheTomboftheScarabQueen', NULL, NULL, 'fivers/prag-slot-johnHunterandtheTomboftheScarabQueen.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:56', '2024-04-12 14:00:56');
INSERT INTO `games` VALUES (831, 19, NULL, 'prag-slot-mustangGold', 'Mustang Gold', 'prag-slot-mustangGold', NULL, NULL, 'fivers/prag-slot-mustangGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:57', '2024-04-12 14:00:57');
INSERT INTO `games` VALUES (832, 19, NULL, 'prag-slot-releasetheKraken', 'Release the Kraken', 'prag-slot-releasetheKraken', NULL, NULL, 'fivers/prag-slot-releasetheKraken.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:58', '2024-04-12 14:00:58');
INSERT INTO `games` VALUES (833, 19, NULL, 'prag-slot-5Lions', '5Lions', 'prag-slot-5Lions', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:58', '2024-04-12 14:00:58');
INSERT INTO `games` VALUES (834, 19, NULL, 'prag-slot-tripleTigers', 'Triple Tigers', 'prag-slot-tripleTigers', NULL, NULL, 'fivers/prag-slot-tripleTigers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:00:59', '2024-04-12 14:00:59');
INSERT INTO `games` VALUES (835, 19, NULL, 'prag-slot-super7s', 'Super 7s', 'prag-slot-super7s', NULL, NULL, 'fivers/prag-slot-super7s.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:00', '2024-04-12 14:01:00');
INSERT INTO `games` VALUES (836, 19, NULL, 'prag-slot-ancientEgyptClassic', 'Ancient Egypt Classic', 'prag-slot-ancientEgyptClassic', NULL, NULL, 'fivers/prag-slot-ancientEgyptClassic.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:00', '2024-04-12 14:01:00');
INSERT INTO `games` VALUES (837, 19, NULL, 'prag-slot-aztecBonanza', 'Aztec Bonanza', 'prag-slot-aztecBonanza', NULL, NULL, 'fivers/prag-slot-aztecBonanza.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:01', '2024-04-12 14:01:01');
INSERT INTO `games` VALUES (838, 19, NULL, 'prag-slot-goldenBeauty', 'Golden Beauty', 'prag-slot-goldenBeauty', NULL, NULL, 'fivers/prag-slot-goldenBeauty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:02', '2024-04-12 14:01:02');
INSERT INTO `games` VALUES (839, 19, NULL, 'prag-slot-luckyNewYear', 'Lucky New Year', 'prag-slot-luckyNewYear', NULL, NULL, 'fivers/prag-slot-luckyNewYear.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:02', '2024-04-12 14:01:02');
INSERT INTO `games` VALUES (840, 19, NULL, 'prag-slot-superJoker', 'Super Joker', 'prag-slot-superJoker', NULL, NULL, 'fivers/prag-slot-superJoker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:03', '2024-04-12 14:01:03');
INSERT INTO `games` VALUES (841, 19, NULL, 'prag-slot-monkeyWarrior', 'Monkey Warrior', 'prag-slot-monkeyWarrior', NULL, NULL, 'fivers/prag-slot-monkeyWarrior.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:04', '2024-04-12 14:01:04');
INSERT INTO `games` VALUES (842, 19, NULL, 'prag-slot-buffaloKing', 'Buffalo King', 'prag-slot-buffaloKing', NULL, NULL, 'fivers/prag-slot-buffaloKing.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:04', '2024-04-12 14:01:04');
INSERT INTO `games` VALUES (843, 19, NULL, 'prag-slot-pirateGold', 'Pirate Gold', 'prag-slot-pirateGold', NULL, NULL, 'fivers/prag-slot-pirateGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:05', '2024-04-12 14:01:05');
INSERT INTO `games` VALUES (844, 19, NULL, 'prag-slot-vegasMagic', 'Vegas Magic', 'prag-slot-vegasMagic', NULL, NULL, 'fivers/prag-slot-vegasMagic.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:06', '2024-04-12 14:01:06');
INSERT INTO `games` VALUES (845, 19, NULL, 'prag-slot-journeytotheWest', 'Journey to the West', 'prag-slot-journeytotheWest', NULL, NULL, 'fivers/prag-slot-journeytotheWest.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:07', '2024-04-12 14:01:07');
INSERT INTO `games` VALUES (846, 19, NULL, 'prag-slot-chilliHeat', 'Chilli Heat', 'prag-slot-chilliHeat', NULL, NULL, 'fivers/prag-slot-chilliHeat.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:07', '2024-04-12 14:01:07');
INSERT INTO `games` VALUES (847, 19, NULL, 'prag-slot-ladyGodiva', 'Lady Godiva', 'prag-slot-ladyGodiva', NULL, NULL, 'fivers/prag-slot-ladyGodiva.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:08', '2024-04-12 14:01:08');
INSERT INTO `games` VALUES (848, 19, NULL, 'prag-slot-treasureHorse', 'Treasure Horse', 'prag-slot-treasureHorse', NULL, NULL, 'fivers/prag-slot-treasureHorse.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:09', '2024-04-12 14:01:09');
INSERT INTO `games` VALUES (849, 19, NULL, 'prag-slot-mysterious', 'Mysterious', 'prag-slot-mysterious', NULL, NULL, 'fivers/prag-slot-mysterious.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:09', '2024-04-12 14:01:09');
INSERT INTO `games` VALUES (850, 19, NULL, 'prag-slot-wildSpells', 'Wild Spells', 'prag-slot-wildSpells', NULL, NULL, 'fivers/prag-slot-wildSpells.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:10', '2024-04-12 14:01:10');
INSERT INTO `games` VALUES (851, 19, NULL, 'prag-slot-goldRush', 'Gold Rush', 'prag-slot-goldRush', NULL, NULL, 'fivers/prag-slot-goldRush.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:11', '2024-04-12 14:01:11');
INSERT INTO `games` VALUES (852, 19, NULL, 'prag-slot-egyptianFortunes', 'Egyptian Fortunes', 'prag-slot-egyptianFortunes', NULL, NULL, 'fivers/prag-slot-egyptianFortunes.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:11', '2024-04-12 14:01:11');
INSERT INTO `games` VALUES (853, 19, NULL, 'prag-slot-goldTrain', 'Gold Train', 'prag-slot-goldTrain', NULL, NULL, 'fivers/prag-slot-goldTrain.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:12', '2024-04-12 14:01:12');
INSERT INTO `games` VALUES (854, 19, NULL, 'prag-slot-dragonKingdom', 'Dragon Kingdom', 'prag-slot-dragonKingdom', NULL, NULL, 'fivers/prag-slot-dragonKingdom.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:13', '2024-04-12 14:01:13');
INSERT INTO `games` VALUES (855, 19, NULL, 'prag-slot-tripleDragons', 'Triple Dragons', 'prag-slot-tripleDragons', NULL, NULL, 'fivers/prag-slot-tripleDragons.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:13', '2024-04-12 14:01:13');
INSERT INTO `games` VALUES (856, 19, NULL, 'prag-slot-mightyKong', 'Mighty Kong', 'prag-slot-mightyKong', NULL, NULL, 'fivers/prag-slot-mightyKong.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:14', '2024-04-12 14:01:14');
INSERT INTO `games` VALUES (857, 19, NULL, 'prag-slot-hotChilli', 'Hot Chilli', 'prag-slot-hotChilli', NULL, NULL, 'fivers/prag-slot-hotChilli.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:15', '2024-04-12 14:01:15');
INSERT INTO `games` VALUES (858, 19, NULL, 'prag-slot-asgard', 'Asgard', 'prag-slot-asgard', NULL, NULL, 'fivers/prag-slot-asgard.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:15', '2024-04-12 14:01:15');
INSERT INTO `games` VALUES (859, 19, NULL, 'prag-slot-theGreatChickenEscape', 'The Great Chicken Escape', 'prag-slot-theGreatChickenEscape', NULL, NULL, 'fivers/prag-slot-theGreatChickenEscape.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:16', '2024-04-12 14:01:16');
INSERT INTO `games` VALUES (860, 19, NULL, 'prag-slot-hotSafari', 'Hot Safari', 'prag-slot-hotSafari', NULL, NULL, 'fivers/prag-slot-hotSafari.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:17', '2024-04-12 14:01:17');
INSERT INTO `games` VALUES (861, 19, NULL, 'prag-slot-5LionsDance', '5Lions Dance', 'prag-slot-5LionsDance', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:17', '2024-04-12 14:01:17');
INSERT INTO `games` VALUES (862, 19, NULL, 'prag-slot-aztecGemsDeluxe', 'Aztec Gems Deluxe', 'prag-slot-aztecGemsDeluxe', NULL, NULL, 'fivers/prag-slot-aztecGemsDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:18', '2024-04-12 14:01:18');
INSERT INTO `games` VALUES (863, 19, NULL, 'prag-slot-curseoftheWerewolfMegaways', 'Curse of the Werewolf Megaways', 'prag-slot-curseoftheWerewolfMegaways', NULL, NULL, 'fivers/prag-slot-curseoftheWerewolfMegaways.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:19', '2024-04-12 14:01:19');
INSERT INTO `games` VALUES (864, 19, NULL, 'prag-slot-emeraldKing', 'Emerald King', 'prag-slot-emeraldKing', NULL, NULL, 'fivers/prag-slot-emeraldKing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:19', '2024-04-12 14:01:19');
INSERT INTO `games` VALUES (865, 19, NULL, 'prag-slot-gemsBonanza', 'Gems Bonanza', 'prag-slot-gemsBonanza', NULL, NULL, 'fivers/prag-slot-gemsBonanza.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:20', '2024-04-12 14:01:20');
INSERT INTO `games` VALUES (866, 19, NULL, 'prag-slot-greatRhinoDeluxe', 'Great Rhino Deluxe', 'prag-slot-greatRhinoDeluxe', NULL, NULL, 'fivers/prag-slot-greatRhinoDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:21', '2024-04-12 14:01:21');
INSERT INTO `games` VALUES (867, 19, NULL, 'prag-slot-jungleGorilla', 'Jungle Gorilla', 'prag-slot-jungleGorilla', NULL, NULL, 'fivers/prag-slot-jungleGorilla.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:21', '2024-04-12 14:01:21');
INSERT INTO `games` VALUES (868, 19, NULL, 'prag-slot-returnoftheDead', 'Return of the Dead', 'prag-slot-returnoftheDead', NULL, NULL, 'fivers/prag-slot-returnoftheDead.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:22', '2024-04-12 14:01:22');
INSERT INTO `games` VALUES (869, 19, NULL, 'prag-slot-starBounty', 'Star Bounty', 'prag-slot-starBounty', NULL, NULL, 'fivers/prag-slot-starBounty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:23', '2024-04-12 14:01:23');
INSERT INTO `games` VALUES (870, 19, NULL, 'prag-slot-theDogHouseMegaways', 'The Dog House Megaways', 'prag-slot-theDogHouseMegaways', NULL, NULL, 'fivers/prag-slot-theDogHouseMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:23', '2024-04-12 14:01:23');
INSERT INTO `games` VALUES (871, 19, NULL, 'prag-slot-theDragonTiger', 'The Dragon Tiger', 'prag-slot-theDragonTiger', NULL, NULL, 'fivers/prag-slot-theDragonTiger.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:24', '2024-04-12 14:01:24');
INSERT INTO `games` VALUES (872, 19, NULL, 'prag-slot-theWildMachine', 'The Wild Machine', 'prag-slot-theWildMachine', NULL, NULL, 'fivers/prag-slot-theWildMachine.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:25', '2024-04-12 14:01:25');
INSERT INTO `games` VALUES (873, 19, NULL, 'prag-slot-ultraHoldandSpin', 'Ultra Hold and Spin', 'prag-slot-ultraHoldandSpin', NULL, NULL, 'fivers/prag-slot-ultraHoldandSpin.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:26', '2024-04-12 14:01:26');
INSERT INTO `games` VALUES (874, 19, NULL, 'prag-slot-wildWalker', 'Wild Walker', 'prag-slot-wildWalker', NULL, NULL, 'fivers/prag-slot-wildWalker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:26', '2024-04-12 14:01:26');
INSERT INTO `games` VALUES (875, 19, NULL, 'prag-slot-wildWildRiches', 'Wild Wild Riches', 'prag-slot-wildWildRiches', NULL, NULL, 'fivers/prag-slot-wildWildRiches.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:27', '2024-04-12 14:01:27');
INSERT INTO `games` VALUES (876, 19, NULL, 'prag-slot-greekGods', 'Greek Gods', 'prag-slot-greekGods', NULL, NULL, 'fivers/prag-slot-greekGods.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:27', '2024-04-12 14:01:27');
INSERT INTO `games` VALUES (877, 19, NULL, 'prag-slot-honeyHoneyHoney', 'Honey Honey Honey', 'prag-slot-honeyHoneyHoney', NULL, NULL, 'fivers/prag-slot-honeyHoneyHoney.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:28', '2024-04-12 14:01:28');
INSERT INTO `games` VALUES (878, 19, NULL, 'prag-slot-starzMegaways', 'Starz Megaways', 'prag-slot-starzMegaways', NULL, NULL, 'fivers/prag-slot-starzMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:29', '2024-04-12 14:01:29');
INSERT INTO `games` VALUES (879, 19, NULL, 'prag-slot-streetRacer', 'Street Racer', 'prag-slot-streetRacer', NULL, NULL, 'fivers/prag-slot-streetRacer.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:29', '2024-04-12 14:01:29');
INSERT INTO `games` VALUES (880, 19, NULL, 'prag-slot-magicJourney', 'Magic Journey', 'prag-slot-magicJourney', NULL, NULL, 'fivers/prag-slot-magicJourney.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:30', '2024-04-12 14:01:30');
INSERT INTO `games` VALUES (881, 19, NULL, 'prag-slot-herculesandPegasus', 'Hercules and Pegasus', 'prag-slot-herculesandPegasus', NULL, NULL, 'fivers/prag-slot-herculesandPegasus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:31', '2024-04-12 14:01:31');
INSERT INTO `games` VALUES (882, 19, NULL, 'prag-slot-pekingLuck', 'Peking Luck', 'prag-slot-pekingLuck', NULL, NULL, 'fivers/prag-slot-pekingLuck.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:32', '2024-04-12 14:01:32');
INSERT INTO `games` VALUES (883, 19, NULL, 'prag-slot-fruitRainbow', 'Fruit Rainbow', 'prag-slot-fruitRainbow', NULL, NULL, 'fivers/prag-slot-fruitRainbow.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:32', '2024-04-12 14:01:32');
INSERT INTO `games` VALUES (884, 19, NULL, 'prag-slot-luckyDragons', 'Lucky Dragons', 'prag-slot-luckyDragons', NULL, NULL, 'fivers/prag-slot-luckyDragons.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:33', '2024-04-12 14:01:33');
INSERT INTO `games` VALUES (885, 19, NULL, 'prag-slot-pixieWings', 'Pixie Wings', 'prag-slot-pixieWings', NULL, NULL, 'fivers/prag-slot-pixieWings.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:33', '2024-04-12 14:01:33');
INSERT INTO `games` VALUES (886, 19, NULL, 'prag-slot-7Monkeys', '7Monkeys', 'prag-slot-7Monkeys', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:34', '2024-04-12 14:01:34');
INSERT INTO `games` VALUES (887, 19, NULL, 'prag-slot-sugarRush', 'Sugar Rush', 'prag-slot-sugarRush', NULL, NULL, 'fivers/prag-slot-sugarRush.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:34', '2024-04-12 14:01:34');
INSERT INTO `games` VALUES (888, 19, NULL, 'prag-slot-madameDestiny', 'Madame Destiny', 'prag-slot-madameDestiny', NULL, NULL, 'fivers/prag-slot-madameDestiny.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:35', '2024-04-12 14:01:35');
INSERT INTO `games` VALUES (889, 19, NULL, 'prag-slot-tripleJokers', 'Triple Jokers', 'prag-slot-tripleJokers', NULL, NULL, 'fivers/prag-slot-tripleJokers.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:36', '2024-04-12 14:01:36');
INSERT INTO `games` VALUES (890, 19, NULL, 'prag-slot-7Piggies', '7Piggies', 'prag-slot-7Piggies', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:37', '2024-04-12 14:01:37');
INSERT INTO `games` VALUES (891, 19, NULL, 'prag-slot-fairytaleFortune', 'Fairytale Fortune', 'prag-slot-fairytaleFortune', NULL, NULL, 'fivers/prag-slot-fairytaleFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:37', '2024-04-12 14:01:37');
INSERT INTO `games` VALUES (892, 19, NULL, 'prag-slot-dwarvenGoldDeluxe', 'Dwarven Gold Deluxe', 'prag-slot-dwarvenGoldDeluxe', NULL, NULL, 'fivers/prag-slot-dwarvenGoldDeluxe.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:38', '2024-04-12 14:01:38');
INSERT INTO `games` VALUES (893, 19, NULL, 'prag-slot-greatReef', 'Great Reef', 'prag-slot-greatReef', NULL, NULL, 'fivers/prag-slot-greatReef.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:39', '2024-04-12 14:01:39');
INSERT INTO `games` VALUES (894, 19, NULL, 'prag-slot-beowulf', 'Beowulf', 'prag-slot-beowulf', NULL, NULL, 'fivers/prag-slot-beowulf.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:39', '2024-04-12 14:01:39');
INSERT INTO `games` VALUES (895, 19, NULL, 'prag-slot-ancientEgypt', 'Ancient Egypt', 'prag-slot-ancientEgypt', NULL, NULL, 'fivers/prag-slot-ancientEgypt.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:40', '2024-04-12 14:01:40');
INSERT INTO `games` VALUES (896, 19, NULL, 'prag-slot-leprechaunCarol', 'Leprechaun Carol', 'prag-slot-leprechaunCarol', NULL, NULL, 'fivers/prag-slot-leprechaunCarol.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:41', '2024-04-12 14:01:41');
INSERT INTO `games` VALUES (897, 19, NULL, 'prag-slot-wildPixies', 'Wild Pixies', 'prag-slot-wildPixies', NULL, NULL, 'fivers/prag-slot-wildPixies.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:42', '2024-04-12 14:01:42');
INSERT INTO `games` VALUES (898, 19, NULL, 'prag-slot-queenofGold', 'Queen of Gold', 'prag-slot-queenofGold', NULL, NULL, 'fivers/prag-slot-queenofGold.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:42', '2024-04-12 14:01:42');
INSERT INTO `games` VALUES (899, 19, NULL, 'prag-slot-3GenieWishes', '3Genie Wishes', 'prag-slot-3GenieWishes', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:43', '2024-04-12 14:01:43');
INSERT INTO `games` VALUES (900, 19, NULL, 'prag-slot-vegasNights', 'Vegas Nights', 'prag-slot-vegasNights', NULL, NULL, 'fivers/prag-slot-vegasNights.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:43', '2024-04-12 14:01:43');
INSERT INTO `games` VALUES (901, 19, NULL, 'prag-slot-jadeButterfly', 'Jade Butterfly', 'prag-slot-jadeButterfly', NULL, NULL, 'fivers/prag-slot-jadeButterfly.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:44', '2024-04-12 14:01:44');
INSERT INTO `games` VALUES (902, 19, NULL, 'prag-slot-santa', 'Santa', 'prag-slot-santa', NULL, NULL, 'fivers/prag-slot-santa.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:45', '2024-04-12 14:01:45');
INSERT INTO `games` VALUES (903, 19, NULL, 'prag-slot-wildGladiator', 'Wild Gladiator', 'prag-slot-wildGladiator', NULL, NULL, 'fivers/prag-slot-wildGladiator.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:46', '2024-04-12 14:01:46');
INSERT INTO `games` VALUES (904, 19, NULL, 'prag-slot-leprechaunSong', 'Leprechaun Song', 'prag-slot-leprechaunSong', NULL, NULL, 'fivers/prag-slot-leprechaunSong.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:46', '2024-04-12 14:01:46');
INSERT INTO `games` VALUES (905, 19, NULL, 'prag-slot-jurassicGiants', 'Jurassic Giants', 'prag-slot-jurassicGiants', NULL, NULL, 'fivers/prag-slot-jurassicGiants.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:47', '2024-04-12 14:01:47');
INSERT INTO `games` VALUES (906, 19, NULL, 'prag-slot-magicCrystals', 'Magic Crystals', 'prag-slot-magicCrystals', NULL, NULL, 'fivers/prag-slot-magicCrystals.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:48', '2024-04-12 14:01:48');
INSERT INTO `games` VALUES (907, 19, NULL, 'prag-slot-safariKing', 'Safari King', 'prag-slot-safariKing', NULL, NULL, 'fivers/prag-slot-safariKing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:48', '2024-04-12 14:01:48');
INSERT INTO `games` VALUES (908, 19, NULL, 'prag-slot-pantherQueen', 'Panther Queen', 'prag-slot-pantherQueen', NULL, NULL, 'fivers/prag-slot-pantherQueen.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:49', '2024-04-12 14:01:49');
INSERT INTO `games` VALUES (909, 19, NULL, 'prag-slot-herculesSonofZeus', 'Hercules Son of Zeus', 'prag-slot-herculesSonofZeus', NULL, NULL, 'fivers/prag-slot-herculesSonofZeus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:50', '2024-04-12 14:01:50');
INSERT INTO `games` VALUES (910, 19, NULL, 'prag-slot-queenofAtlantis', 'Queen of Atlantis', 'prag-slot-queenofAtlantis', NULL, NULL, 'fivers/prag-slot-queenofAtlantis.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:50', '2024-04-12 14:01:50');
INSERT INTO `games` VALUES (911, 19, NULL, 'prag-slot-theChampions', 'The Champions', 'prag-slot-theChampions', NULL, NULL, 'fivers/prag-slot-theChampions.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:51', '2024-04-12 14:01:51');
INSERT INTO `games` VALUES (912, 19, NULL, 'prag-slot-theCatfatherPartII', 'The Cat father Part II', 'prag-slot-theCatfatherPartII', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:51', '2024-04-12 14:01:51');
INSERT INTO `games` VALUES (913, 19, NULL, 'prag-slot-voodooMagic', 'Voodoo Magic', 'prag-slot-voodooMagic', NULL, NULL, 'fivers/prag-slot-voodooMagic.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:52', '2024-04-12 14:01:52');
INSERT INTO `games` VALUES (914, 19, NULL, 'prag-slot-mysteriousEgypt', 'Mysterious Egypt', 'prag-slot-mysteriousEgypt', NULL, NULL, 'fivers/prag-slot-mysteriousEgypt.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:53', '2024-04-12 14:01:53');
INSERT INTO `games` VALUES (915, 19, NULL, 'prag-slot-congoCash', 'Congo Cash', 'prag-slot-congoCash', NULL, NULL, 'fivers/prag-slot-congoCash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:53', '2024-04-12 14:01:53');
INSERT INTO `games` VALUES (916, 19, NULL, 'prag-slot-madameDestinyMegaways', 'Madame Destiny Megaways', 'prag-slot-madameDestinyMegaways', NULL, NULL, 'fivers/prag-slot-madameDestinyMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:54', '2024-04-12 14:01:54');
INSERT INTO `games` VALUES (917, 19, NULL, 'prag-slot-jokerKing', 'Joker King', 'prag-slot-jokerKing', NULL, NULL, 'fivers/prag-slot-jokerKing.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:55', '2024-04-12 14:01:55');
INSERT INTO `games` VALUES (918, 19, NULL, 'prag-slot-cowboysGold', 'Cowboys Gold', 'prag-slot-cowboysGold', NULL, NULL, 'fivers/prag-slot-cowboysGold.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:55', '2024-04-12 14:01:55');
INSERT INTO `games` VALUES (919, 19, NULL, 'prag-slot-fishinReels', 'Fishin Reels', 'prag-slot-fishinReels', NULL, NULL, 'fivers/prag-slot-fishinReels.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:56', '2024-04-12 14:01:56');
INSERT INTO `games` VALUES (920, 19, NULL, 'prag-slot-juicyFruits', 'Juicy Fruits', 'prag-slot-juicyFruits', NULL, NULL, 'fivers/prag-slot-juicyFruits.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:56', '2024-04-12 14:01:56');
INSERT INTO `games` VALUES (921, 19, NULL, 'prag-slot-temujinTreasures', 'Temujin Treasures', 'prag-slot-temujinTreasures', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:57', '2024-04-12 14:01:57');
INSERT INTO `games` VALUES (922, 19, NULL, 'prag-slot-wildBooster', 'Wild Booster', 'prag-slot-wildBooster', NULL, NULL, 'fivers/prag-slot-wildBooster.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:58', '2024-04-12 14:01:58');
INSERT INTO `games` VALUES (923, 19, NULL, 'prag-slot-phoenixForge', 'Phoenix Forge', 'prag-slot-phoenixForge', NULL, NULL, 'fivers/prag-slot-phoenixForge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:58', '2024-04-12 14:01:58');
INSERT INTO `games` VALUES (924, 19, NULL, 'prag-slot-pandasFortune2', 'Pandas Fortune2', 'prag-slot-pandasFortune2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:59', '2024-04-12 14:01:59');
INSERT INTO `games` VALUES (925, 19, NULL, 'prag-slot-luckyLightning', 'Lucky Lightning', 'prag-slot-luckyLightning', NULL, NULL, 'fivers/prag-slot-luckyLightning.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:01:59', '2024-04-12 14:01:59');
INSERT INTO `games` VALUES (926, 19, NULL, 'prag-slot-5LionsMega', '5 Lions Mega', 'prag-slot-5LionsMega', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:00', '2024-04-12 14:02:00');
INSERT INTO `games` VALUES (927, 19, NULL, 'prag-slot-chickenDrop', 'Chicken Drop', 'prag-slot-chickenDrop', NULL, NULL, 'fivers/prag-slot-chickenDrop.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:01', '2024-04-12 14:02:01');
INSERT INTO `games` VALUES (928, 19, NULL, 'prag-slot-fruitParty2', 'Fruit Party2', 'prag-slot-fruitParty2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:01', '2024-04-12 14:02:01');
INSERT INTO `games` VALUES (929, 19, NULL, 'prag-slot-chilliHeatMegaways', 'Chilli Heat Megaways', 'prag-slot-chilliHeatMegaways', NULL, NULL, 'fivers/prag-slot-chilliHeatMegaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:02', '2024-04-12 14:02:02');
INSERT INTO `games` VALUES (930, 19, NULL, 'prag-slot-yumYumPowerways', 'Yum Yum Powerways', 'prag-slot-yumYumPowerways', NULL, NULL, 'fivers/prag-slot-yumYumPowerways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:03', '2024-04-12 14:02:03');
INSERT INTO `games` VALUES (931, 19, NULL, 'prag-slot-treasureWild', 'Treasure Wild', 'prag-slot-treasureWild', NULL, NULL, 'fivers/prag-slot-treasureWild.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:04', '2024-04-12 14:02:04');
INSERT INTO `games` VALUES (932, 19, NULL, 'prag-slot-starlightPrincess', 'Starlight Princess', 'prag-slot-starlightPrincess', NULL, NULL, 'fivers/prag-slot-starlightPrincess.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:04', '2024-04-12 14:02:04');
INSERT INTO `games` VALUES (933, 19, NULL, 'prag-slot-mysticChief', 'Mystic Chief', 'prag-slot-mysticChief', NULL, NULL, 'fivers/prag-slot-mysticChief.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:05', '2024-04-12 14:02:05');
INSERT INTO `games` VALUES (934, 19, NULL, 'prag-slot-piggyBankBills', 'Piggy Bank Bills', 'prag-slot-piggyBankBills', NULL, NULL, 'fivers/prag-slot-piggyBankBills.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:06', '2024-04-12 14:02:06');
INSERT INTO `games` VALUES (935, 19, NULL, 'prag-slot-cashBonanza', 'Cash Bonanza', 'prag-slot-cashBonanza', NULL, NULL, 'fivers/prag-slot-cashBonanza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:06', '2024-04-12 14:02:06');
INSERT INTO `games` VALUES (936, 19, NULL, 'prag-slot-dayofDead', 'Day of Dead', 'prag-slot-dayofDead', NULL, NULL, 'fivers/prag-slot-dayofDead.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:07', '2024-04-12 14:02:07');
INSERT INTO `games` VALUES (937, 19, NULL, 'prag-slot-starPiratesCode', 'Star Pirates Code', 'prag-slot-starPiratesCode', NULL, NULL, 'fivers/prag-slot-starPiratesCode.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:08', '2024-04-12 14:02:08');
INSERT INTO `games` VALUES (938, 19, NULL, 'prag-slot-bigJuan', 'Big Juan', 'prag-slot-bigJuan', NULL, NULL, 'fivers/prag-slot-bigJuan.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:08', '2024-04-12 14:02:08');
INSERT INTO `games` VALUES (939, 19, NULL, 'prag-slot-bountyGold', 'Bounty Gold', 'prag-slot-bountyGold', NULL, NULL, 'fivers/prag-slot-bountyGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:09', '2024-04-12 14:02:09');
INSERT INTO `games` VALUES (940, 18, NULL, 'prag-slot-superX', 'SuperX', 'prag-slot-superX', NULL, NULL, 'fivers/prag-slot-superX.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:10', '2024-04-12 14:02:10');
INSERT INTO `games` VALUES (941, 19, NULL, 'prag-slot-elementalGemsM', 'Elemental Gems Megaways', 'prag-slot-elementalGemsM', NULL, NULL, 'fivers/prag-slot-elementalGemsM.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:10', '2024-04-12 14:02:10');
INSERT INTO `games` VALUES (942, 19, NULL, 'prag-slot-barn-festival', 'Barn Festival', 'prag-slot-barn-festival', NULL, NULL, 'fivers/prag-slot-barn-festival.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:11', '2024-04-12 14:02:11');
INSERT INTO `games` VALUES (943, 19, NULL, 'prag-slot-wayswildwest', 'Wild West Gold Megaways', 'prag-slot-wayswildwest', NULL, NULL, 'fivers/prag-slot-wayswildwest.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:12', '2024-04-12 14:02:12');
INSERT INTO `games` VALUES (944, 19, NULL, 'prag-slot-cleocatra', 'Cleocatra', 'prag-slot-cleocatra', NULL, NULL, 'fivers/prag-slot-cleocatra.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:12', '2024-04-12 14:02:12');
INSERT INTO `games` VALUES (945, 19, NULL, 'prag-slot-25pyramid', 'Pyramid King', 'prag-slot-25pyramid', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:13', '2024-04-12 14:02:13');
INSERT INTO `games` VALUES (946, 19, NULL, 'prag-slot-20terrorv', 'Cash Elevator', 'prag-slot-20terrorv', NULL, NULL, 'fivers/prag-slot-20terrorv.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:14', '2024-04-12 14:02:14');
INSERT INTO `games` VALUES (947, 19, NULL, 'prag-slot-40pirgold', 'Pirate Gold Deluxe', 'prag-slot-40pirgold', NULL, NULL, 'fivers/prag-slot-40pirgold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:14', '2024-04-12 14:02:14');
INSERT INTO `games` VALUES (948, 19, NULL, 'prag-slot-20emptybank', 'Empty the Bank', 'prag-slot-20emptybank', NULL, NULL, 'fivers/prag-slot-20emptybank.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:15', '2024-04-12 14:02:15');
INSERT INTO `games` VALUES (949, 19, NULL, 'prag-slot-luckcharm', 'Lucky Grace And Charm', 'prag-slot-luckcharm', NULL, NULL, 'fivers/prag-slot-luckcharm.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:16', '2024-04-12 14:02:16');
INSERT INTO `games` VALUES (950, 19, NULL, 'prag-slot-12bbb', 'Bigger Bass Bonanza', 'prag-slot-12bbb', NULL, NULL, 'fivers/prag-slot-12bbb.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:16', '2024-04-12 14:02:16');
INSERT INTO `games` VALUES (951, 19, NULL, 'prag-slot-20santawonder', 'Santa\'s Wonderland', 'prag-slot-20santawonder', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:17', '2024-04-12 14:02:17');
INSERT INTO `games` VALUES (952, 19, NULL, 'prag-slot-ultim5', 'The Ultimate 5', 'prag-slot-ultim5', NULL, NULL, 'fivers/prag-slot-ultim5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:17', '2024-04-12 14:02:17');
INSERT INTO `games` VALUES (953, 19, NULL, 'prag-slot-tictac', 'Tic Tac Take', 'prag-slot-tictac', NULL, NULL, 'fivers/prag-slot-tictac.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:18', '2024-04-12 14:02:18');
INSERT INTO `games` VALUES (954, 19, NULL, 'prag-slot-rainbowg', 'Rainbow Gold', 'prag-slot-rainbowg', NULL, NULL, 'fivers/prag-slot-rainbowg.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:19', '2024-04-12 14:02:19');
INSERT INTO `games` VALUES (955, 19, NULL, 'prag-slot-bchprty', 'Wild Beach Party', 'prag-slot-bchprty', NULL, NULL, 'fivers/prag-slot-bchprty.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:19', '2024-04-12 14:02:19');
INSERT INTO `games` VALUES (956, 19, NULL, 'prag-slot-queenie', 'Queenie', 'prag-slot-queenie', NULL, NULL, 'fivers/prag-slot-queenie.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:20', '2024-04-12 14:02:20');
INSERT INTO `games` VALUES (957, 19, NULL, 'prag-slot-firestrike2', 'Fire Strike 2', 'prag-slot-firestrike2', NULL, NULL, 'fivers/prag-slot-firestrike2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:21', '2024-04-12 14:02:21');
INSERT INTO `games` VALUES (958, 19, NULL, 'prag-slot-northgard', 'North Guardians', 'prag-slot-northgard', NULL, NULL, 'fivers/prag-slot-northgard.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:21', '2024-04-12 14:02:21');
INSERT INTO `games` VALUES (959, 19, NULL, 'prag-slot-spiritadv', 'Spirit of Adventure', 'prag-slot-spiritadv', NULL, NULL, 'fivers/prag-slot-spiritadv.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:22', '2024-04-12 14:02:22');
INSERT INTO `games` VALUES (960, 19, NULL, 'prag-slot-mustanggld2', 'Clover Gold', 'prag-slot-mustanggld2', NULL, NULL, 'fivers/prag-slot-mustanggld2.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:22', '2024-04-12 14:02:22');
INSERT INTO `games` VALUES (961, 19, NULL, 'prag-slot-cleoeye', 'Eye of Cleopatra', 'prag-slot-cleoeye', NULL, NULL, 'fivers/prag-slot-cleoeye.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:23', '2024-04-12 14:02:23');
INSERT INTO `games` VALUES (962, 19, NULL, 'prag-slot-queenGods', 'Queen of Gods', 'prag-slot-queenGods', NULL, NULL, 'fivers/prag-slot-queenGods.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:24', '2024-04-12 14:02:24');
INSERT INTO `games` VALUES (963, 19, NULL, 'prag-slot-GreedyWolf', 'Greedy Wolf', 'prag-slot-GreedyWolf', NULL, NULL, 'fivers/prag-slot-GreedyWolf.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:25', '2024-04-12 14:02:25');
INSERT INTO `games` VALUES (964, 19, NULL, 'prag-slot-shieldofsparta', 'Shield of Sparta', 'prag-slot-shieldofsparta', NULL, NULL, 'fivers/prag-slot-shieldofsparta.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:25', '2024-04-12 14:02:25');
INSERT INTO `games` VALUES (965, 19, NULL, 'prag-slot-PinupGirls', 'Pinup Girls', 'prag-slot-PinupGirls', NULL, NULL, 'fivers/prag-slot-PinupGirls.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:26', '2024-04-12 14:02:26');
INSERT INTO `games` VALUES (966, 19, NULL, 'prag-slot-WildWBananas', 'Wild Wild Bananas', 'prag-slot-WildWBananas', NULL, NULL, 'fivers/prag-slot-WildWBananas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:27', '2024-04-12 14:02:27');
INSERT INTO `games` VALUES (967, 19, NULL, 'prag-slot-SwordofAres', 'Sword of Ares', 'prag-slot-SwordofAres', NULL, NULL, 'fivers/prag-slot-SwordofAres.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:27', '2024-04-12 14:02:27');
INSERT INTO `games` VALUES (968, 19, NULL, 'prag-slot-RabbitGarden', 'Rabbit Garden', 'prag-slot-RabbitGarden', NULL, NULL, 'fivers/prag-slot-RabbitGarden.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:28', '2024-04-12 14:02:28');
INSERT INTO `games` VALUES (969, 19, NULL, 'prag-slot-DiamondsofEgypt', 'Diamonds of Egypt', 'prag-slot-DiamondsofEgypt', NULL, NULL, 'fivers/prag-slot-DiamondsofEgypt.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:28', '2024-04-12 14:02:28');
INSERT INTO `games` VALUES (970, 19, NULL, 'prag-slot-LampOfInfinity', 'Lamp Of Infinity', 'prag-slot-LampOfInfinity', NULL, NULL, 'fivers/prag-slot-LampOfInfinity.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:29', '2024-04-12 14:02:29');
INSERT INTO `games` VALUES (971, 19, NULL, 'prag-slot-zombie-carnival', 'Zombie Carnival', 'prag-slot-zombie-carnival', NULL, NULL, 'fivers/prag-slot-zombie-carnival.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:30', '2024-04-12 14:02:30');
INSERT INTO `games` VALUES (972, 19, NULL, 'prag-slot-cash-patrol', 'Cash Patrol', 'prag-slot-cash-patrol', NULL, NULL, 'fivers/prag-slot-cash-patrol.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:30', '2024-04-12 14:02:30');
INSERT INTO `games` VALUES (973, 19, NULL, 'prag-slot-big-bass-splash', 'Big Bass Splash', 'prag-slot-big-bass-splash', NULL, NULL, 'fivers/prag-slot-big-bass-splash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:31', '2024-04-12 14:02:31');
INSERT INTO `games` VALUES (974, 19, NULL, 'prag-slot-bomb-bonanza', 'Bomb Bonanza', 'prag-slot-bomb-bonanza', NULL, NULL, 'fivers/prag-slot-bomb-bonanza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:32', '2024-04-12 14:02:32');
INSERT INTO `games` VALUES (975, 19, NULL, 'prag-slot-shining-hot-5', 'Shining Hot 5', 'prag-slot-shining-hot-5', NULL, NULL, 'fivers/prag-slot-shining-hot-5.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:32', '2024-04-12 14:02:32');
INSERT INTO `games` VALUES (976, 19, NULL, 'prag-slot-shining-hot-20', 'Shining Hot 20', 'prag-slot-shining-hot-20', NULL, NULL, 'fivers/prag-slot-shining-hot-20.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:33', '2024-04-12 14:02:33');
INSERT INTO `games` VALUES (977, 19, NULL, 'prag-slot-shining-hot-40', 'Shining Hot 40', 'prag-slot-shining-hot-40', NULL, NULL, 'fivers/prag-slot-shining-hot-40.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:34', '2024-04-12 14:02:34');
INSERT INTO `games` VALUES (978, 19, NULL, 'prag-slot-shining-hot-100', 'Shining Hot 100', 'prag-slot-shining-hot-100', NULL, NULL, 'fivers/prag-slot-shining-hot-100.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:34', '2024-04-12 14:02:34');
INSERT INTO `games` VALUES (979, 19, NULL, 'prag-slot-magic-money-maze', 'Magic Money Maze', 'prag-slot-magic-money-maze', NULL, NULL, 'fivers/prag-slot-magic-money-maze.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:35', '2024-04-12 14:02:35');
INSERT INTO `games` VALUES (980, 19, NULL, 'prag-slot-gorilla-mayhem', 'Gorilla Mayhem', 'prag-slot-gorilla-mayhem', NULL, NULL, 'fivers/prag-slot-gorilla-mayhem.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:36', '2024-04-12 14:02:36');
INSERT INTO `games` VALUES (981, 19, NULL, 'prag-slot-black-bull', 'Black Bull', 'prag-slot-black-bull', NULL, NULL, 'fivers/prag-slot-black-bull.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:36', '2024-04-12 14:02:36');
INSERT INTO `games` VALUES (982, 19, NULL, 'prag-slot-down-the-rails', 'Down the Rails', 'prag-slot-down-the-rails', NULL, NULL, 'fivers/prag-slot-down-the-rails.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:37', '2024-04-12 14:02:37');
INSERT INTO `games` VALUES (983, 19, NULL, 'prag-slot-fire-hot-5', 'Fire Hot 5', 'prag-slot-fire-hot-5', NULL, NULL, 'fivers/prag-slot-fire-hot-5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:38', '2024-04-12 14:02:38');
INSERT INTO `games` VALUES (984, 19, NULL, 'prag-slot-fire-hot-20', 'Fire Hot 20', 'prag-slot-fire-hot-20', NULL, NULL, 'fivers/prag-slot-fire-hot-20.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:38', '2024-04-12 14:02:38');
INSERT INTO `games` VALUES (985, 19, NULL, 'prag-slot-fire-hot-40', 'Fire Hot 40', 'prag-slot-fire-hot-40', NULL, NULL, 'fivers/prag-slot-fire-hot-40.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:39', '2024-04-12 14:02:39');
INSERT INTO `games` VALUES (986, 19, NULL, 'prag-slot-fire-hot-100', 'Fire Hot 100', 'prag-slot-fire-hot-100', NULL, NULL, 'fivers/prag-slot-fire-hot-100.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:40', '2024-04-12 14:02:40');
INSERT INTO `games` VALUES (987, 19, NULL, 'prag-slot-octobeer-fortunes', 'Octobeer Fortunes', 'prag-slot-octobeer-fortunes', NULL, NULL, 'fivers/prag-slot-octobeer-fortunes.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:40', '2024-04-12 14:02:40');
INSERT INTO `games` VALUES (988, 19, NULL, 'prag-slot-striking-hot-5', 'Striking Hot 5', 'prag-slot-striking-hot-5', NULL, NULL, 'fivers/prag-slot-striking-hot-5.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:41', '2024-04-12 14:02:41');
INSERT INTO `games` VALUES (989, 19, NULL, 'prag-slot-book-of-golden-sands', 'Book of Golden Sands', 'prag-slot-book-of-golden-sands', NULL, NULL, 'fivers/prag-slot-book-of-golden-sands.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:42', '2024-04-12 14:02:42');
INSERT INTO `games` VALUES (990, 19, NULL, 'prag-slot-crown-of-fire', 'Crown of Fire', 'prag-slot-crown-of-fire', NULL, NULL, 'fivers/prag-slot-crown-of-fire.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:42', '2024-04-12 14:02:42');
INSERT INTO `games` VALUES (991, 19, NULL, 'prag-slot-aztec-blaze', 'Aztec Blaze', 'prag-slot-aztec-blaze', NULL, NULL, 'fivers/prag-slot-aztec-blaze.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:43', '2024-04-12 14:02:43');
INSERT INTO `games` VALUES (992, 19, NULL, 'prag-slot-candy-stars', 'Candy Stars', 'prag-slot-candy-stars', NULL, NULL, 'fivers/prag-slot-candy-stars.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:44', '2024-04-12 14:02:44');
INSERT INTO `games` VALUES (993, 2, NULL, 'prag-slot-pizza', 'PIZZA! PIZZA? PIZZA!', 'prag-slot-pizza', NULL, NULL, 'fivers/prag-slot-pizza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:45', '2024-04-12 14:02:45');
INSERT INTO `games` VALUES (994, 19, NULL, 'prag-slot-dragon-hero', 'Dragon Hero', 'prag-slot-dragon-hero', NULL, NULL, 'fivers/prag-slot-dragon-hero.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:45', '2024-04-12 14:02:45');
INSERT INTO `games` VALUES (995, 19, NULL, 'prag-slot-Sweet-bonanza-dice', 'Sweet Bonanza Dice', 'prag-slot-Sweet-bonanza-dice', NULL, NULL, 'fivers/prag-slot-Sweet-bonanza-dice.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:46', '2024-04-12 14:02:46');
INSERT INTO `games` VALUES (996, 19, NULL, 'prag-slot-the-dog-house-diceshow', 'The Dog House Dice Show', 'prag-slot-the-dog-house-diceshow', NULL, NULL, 'fivers/prag-slot-the-dog-house-diceshow.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:47', '2024-04-12 14:02:47');
INSERT INTO `games` VALUES (997, 19, NULL, 'prag-slot-secret-city-gold', 'Secret City Gold', 'prag-slot-secret-city-gold', NULL, NULL, 'fivers/prag-slot-secret-city-gold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:47', '2024-04-12 14:02:47');
INSERT INTO `games` VALUES (998, 19, NULL, 'prag-slot-mammoth-gold-megaways', 'Mammoth Gold Megaways', 'prag-slot-mammoth-gold-megaways', NULL, NULL, 'fivers/prag-slot-mammoth-gold-megaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:48', '2024-04-12 14:02:48');
INSERT INTO `games` VALUES (999, 19, NULL, 'prag-slot-fish-eye', 'Fish Eye', 'prag-slot-fish-eye', NULL, NULL, 'fivers/prag-slot-fish-eye.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:49', '2024-04-12 14:02:49');
INSERT INTO `games` VALUES (1000, 19, NULL, 'prag-slot-monster-superlanche', 'Monster Superlanche', 'prag-slot-monster-superlanche', NULL, NULL, 'fivers/prag-slot-monster-superlanche.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:49', '2024-04-12 14:02:49');
INSERT INTO `games` VALUES (1001, 19, NULL, 'prag-slot-fire-archer', 'Fire Arche', 'prag-slot-fire-archer', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:50', '2024-04-12 14:02:50');
INSERT INTO `games` VALUES (1002, 19, NULL, 'prag-slot-club-tropicana', 'Club Tropicana', 'prag-slot-club-tropicana', NULL, NULL, 'fivers/prag-slot-club-tropicana.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:51', '2024-04-12 14:02:51');
INSERT INTO `games` VALUES (1003, 19, NULL, 'prag-slot-peak-power', 'Peak Power', 'prag-slot-peak-power', NULL, NULL, 'fivers/prag-slot-peak-power.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:51', '2024-04-12 14:02:51');
INSERT INTO `games` VALUES (1004, 19, NULL, 'prag-slot-wild-wild-riches-megaways', 'Wild Wild Riches Megaways', 'prag-slot-wild-wild-riches-megaways', NULL, NULL, 'fivers/prag-slot-wild-wild-riches-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:52', '2024-04-12 14:02:52');
INSERT INTO `games` VALUES (1005, 19, NULL, 'prag-slot-mystery-of-the-orient', 'Mystery of the Orient', 'prag-slot-mystery-of-the-orient', NULL, NULL, 'fivers/prag-slot-mystery-of-the-orient.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:53', '2024-04-12 14:02:53');
INSERT INTO `games` VALUES (1006, 19, NULL, 'prag-slot-wild-west-duels', 'Wild West Duels', 'prag-slot-wild-west-duels', NULL, NULL, 'fivers/prag-slot-wild-west-duels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:53', '2024-04-12 14:02:53');
INSERT INTO `games` VALUES (1007, 19, NULL, 'prag-slot-the-dog-house-multihold', 'The Dog House Multihold', 'prag-slot-the-dog-house-multihold', NULL, NULL, 'fivers/prag-slot-the-dog-house-multihold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:54', '2024-04-12 14:02:54');
INSERT INTO `games` VALUES (1008, 19, NULL, 'prag-slot-mochimon', 'Mochimon', 'prag-slot-mochimon', NULL, NULL, 'fivers/prag-slot-mochimon.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:55', '2024-04-12 14:02:55');
INSERT INTO `games` VALUES (1009, 19, NULL, 'prag-slot-jasmine-dreams', 'Jasmine Dreams', 'prag-slot-jasmine-dreams', NULL, NULL, 'fivers/prag-slot-jasmine-dreams.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:55', '2024-04-12 14:02:55');
INSERT INTO `games` VALUES (1010, 19, NULL, 'prag-slot-gods-of-giza', 'Gods of Giza', 'prag-slot-gods-of-giza', NULL, NULL, 'fivers/prag-slot-gods-of-giza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:56', '2024-04-12 14:02:56');
INSERT INTO `games` VALUES (1011, 19, NULL, 'prag-slot-african-elephant', 'African Elephant', 'prag-slot-african-elephant', NULL, NULL, 'fivers/prag-slot-african-elephant.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:57', '2024-04-12 14:02:57');
INSERT INTO `games` VALUES (1012, 19, NULL, 'prag-slot-3-dancing-monkeys', '3 Dancing Monkeys', 'prag-slot-3-dancing-monkeys', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:57', '2024-04-12 14:02:57');
INSERT INTO `games` VALUES (1013, 19, NULL, 'prag-slot-jane-hunter-and-the-mask-of-montezuma', 'Jane Hunter and the Mask of Montezuma', 'prag-slot-jane-hunter-and-the-mask-of-montezuma', NULL, NULL, 'fivers/prag-slot-jane-hunter-and-the-mask-of-montezuma.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:58', '2024-04-12 14:02:58');
INSERT INTO `games` VALUES (1014, 19, NULL, 'prag-slot-Excalibur-unleashed', 'Excalibur Unleashed', 'prag-slot-Excalibur-unleashed', NULL, NULL, 'fivers/prag-slot-Excalibur-unleashed.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:59', '2024-04-12 14:02:59');
INSERT INTO `games` VALUES (1015, 19, NULL, 'prag-slot-wild-bison-charge', 'Wild Bison Charge', 'prag-slot-wild-bison-charge', NULL, NULL, 'fivers/prag-slot-wild-bison-charge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:02:59', '2024-04-12 14:02:59');
INSERT INTO `games` VALUES (1016, 19, NULL, 'prag-slot-knight-hot-spotz', 'Knight Hot Spotz', 'prag-slot-knight-hot-spotz', NULL, NULL, 'fivers/prag-slot-knight-hot-spotz.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:00', '2024-04-12 14:03:00');
INSERT INTO `games` VALUES (1017, 19, NULL, 'prag-slot-jewel-rush', 'Jewel Rush', 'prag-slot-jewel-rush', NULL, NULL, 'fivers/prag-slot-jewel-rush.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:01', '2024-04-12 14:03:01');
INSERT INTO `games` VALUES (1018, 19, NULL, 'prag-slot-zeus-vs-hades-gods-of-war', 'Zeus vs Hades - Gods of War', 'prag-slot-zeus-vs-hades-gods-of-war', NULL, NULL, 'fivers/prag-slot-zeus-vs-hades-gods-of-war.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:02', '2024-04-12 14:03:02');
INSERT INTO `games` VALUES (1019, 19, NULL, 'prag-slot-sticky-bees', 'Sticky Bees', 'prag-slot-sticky-bees', NULL, NULL, 'fivers/prag-slot-sticky-bees.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:02', '2024-04-12 14:03:02');
INSERT INTO `games` VALUES (1020, 19, NULL, 'prag-slot-pirates-pub', 'Pirates Pub', 'prag-slot-pirates-pub', NULL, NULL, 'fivers/prag-slot-pirates-pub.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:03', '2024-04-12 14:03:03');
INSERT INTO `games` VALUES (1021, 19, NULL, 'prag-slot-floating-dragon-dragon-boat-festival', 'Floating Dragon - Dragon Boat Festival', 'prag-slot-floating-dragon-dragon-boat-festival', NULL, NULL, 'fivers/prag-slot-floating-dragon-dragon-boat-festival.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:04', '2024-04-12 14:03:04');
INSERT INTO `games` VALUES (1022, 19, NULL, 'prag-slot-fat-panda', 'Fat Panda', 'prag-slot-fat-panda', NULL, NULL, 'fivers/prag-slot-fat-panda.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:05', '2024-04-12 14:03:05');
INSERT INTO `games` VALUES (1023, 19, NULL, 'prag-slot-Hellvis-Wild', 'Hellvis Wild', 'prag-slot-Hellvis-Wild', NULL, NULL, 'fivers/prag-slot-Hellvis-Wild.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:05', '2024-04-12 14:03:05');
INSERT INTO `games` VALUES (1024, 19, NULL, 'prag-slot-Power-of-Merlin-Megaways', 'Power of Merlin Megaways', 'prag-slot-Power-of-Merlin-Megaways', NULL, NULL, 'fivers/prag-slot-Power-of-Merlin-Megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:06', '2024-04-12 14:03:06');
INSERT INTO `games` VALUES (1025, 19, NULL, 'prag-slot-cashbox', 'Cash Box', 'prag-slot-cashbox', NULL, NULL, 'fivers/prag-slot-cashbox.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:07', '2024-04-12 14:03:07');
INSERT INTO `games` VALUES (1026, 19, NULL, 'prag-slot-Spellbinding-Mystery', 'Spellbinding Mystery', 'prag-slot-Spellbinding-Mystery', NULL, NULL, 'fivers/prag-slot-Spellbinding-Mystery.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:07', '2024-04-12 14:03:07');
INSERT INTO `games` VALUES (1027, 19, NULL, 'prag-slot-JohnHunterandtheBookofTut', 'John Hunter and the Book of Tut', 'prag-slot-JohnHunterandtheBookofTut', NULL, NULL, 'fivers/prag-slot-JohnHunterandtheBookofTut.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:08', '2024-04-12 14:03:08');
INSERT INTO `games` VALUES (1028, 19, NULL, 'prag-slot-BigBassBonanza', 'Big Bass Bonanza', 'prag-slot-BigBassBonanza', NULL, NULL, 'fivers/prag-slot-BigBassBonanza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:09', '2024-04-12 14:03:09');
INSERT INTO `games` VALUES (1029, 19, NULL, 'prag-slot-BookoftheFallen', 'Book of the Fallen', 'prag-slot-BookoftheFallen', NULL, NULL, 'fivers/prag-slot-BookoftheFallen.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:10', '2024-04-12 14:03:10');
INSERT INTO `games` VALUES (1030, 19, NULL, 'prag-slot-FloatingDragonDragonBoatFesti va', 'Floating Dragon - Dragon Boat Festival', 'prag-slot-FloatingDragonDragonBoatFesti va', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:10', '2024-04-12 14:03:10');
INSERT INTO `games` VALUES (1031, 19, NULL, 'prag-slot-BigBassAmazonXtreme', 'Big Bass Amazon Xtreme', 'prag-slot-BigBassAmazonXtreme', NULL, NULL, 'fivers/prag-slot-BigBassAmazonXtreme.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:11', '2024-04-12 14:03:11');
INSERT INTO `games` VALUES (1032, 19, NULL, 'prag-slot-3BuzzingWilds', '3 Buzzing Wilds', 'prag-slot-3BuzzingWilds', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:11', '2024-04-12 14:03:11');
INSERT INTO `games` VALUES (1033, 19, NULL, 'prag-slot-GatesofOlympus', 'Gates of Olympus', 'prag-slot-GatesofOlympus', NULL, NULL, 'fivers/prag-slot-GatesofOlympus.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:12', '2024-04-12 14:03:12');
INSERT INTO `games` VALUES (1034, 19, NULL, 'prag-slot-PowerofThorMegaways', 'Power of Thor Megaways', 'prag-slot-PowerofThorMegaways', NULL, NULL, 'fivers/prag-slot-PowerofThorMegaways.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:12', '2024-04-12 14:03:12');
INSERT INTO `games` VALUES (1035, 19, NULL, 'prag-slot-BuffaloKingMegaways', 'Buffalo King Megaways', 'prag-slot-BuffaloKingMegaways', NULL, NULL, 'fivers/prag-slot-BuffaloKingMegaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:13', '2024-04-12 14:03:13');
INSERT INTO `games` VALUES (1036, 19, NULL, 'prag-slot-TheHandofMidas', 'The Hand of Midas', 'prag-slot-TheHandofMidas', NULL, NULL, 'fivers/prag-slot-TheHandofMidas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:14', '2024-04-12 14:03:14');
INSERT INTO `games` VALUES (1037, 19, NULL, 'prag-slot-PiggyBankers', 'Piggy Bankers', 'prag-slot-PiggyBankers', NULL, NULL, 'fivers/prag-slot-PiggyBankers.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:15', '2024-04-12 14:03:15');
INSERT INTO `games` VALUES (1038, 19, NULL, 'prag-slot-RocketBlastMegaways', 'Rocket Blast Megaways', 'prag-slot-RocketBlastMegaways', NULL, NULL, 'fivers/prag-slot-RocketBlastMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:15', '2024-04-12 14:03:15');
INSERT INTO `games` VALUES (1039, 19, NULL, 'prag-slot-DiamondCascade', 'Diamond Cascade', 'prag-slot-DiamondCascade', NULL, NULL, 'fivers/prag-slot-DiamondCascade.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:16', '2024-04-12 14:03:16');
INSERT INTO `games` VALUES (1040, 19, NULL, 'prag-slot-WisdomofAthena', 'Wisdom of Athena', 'prag-slot-WisdomofAthena', NULL, NULL, 'fivers/prag-slot-WisdomofAthena.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:17', '2024-04-12 14:03:17');
INSERT INTO `games` VALUES (1041, 19, NULL, 'prag-slot-PubKings', 'Pub Kings', 'prag-slot-PubKings', NULL, NULL, 'fivers/prag-slot-PubKings.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:17', '2024-04-12 14:03:17');
INSERT INTO `games` VALUES (1042, 19, NULL, 'prag-slot-MustangTrail', 'Mustang Trail', 'prag-slot-MustangTrail', NULL, NULL, 'fivers/prag-slot-MustangTrail.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:18', '2024-04-12 14:03:18');
INSERT INTO `games` VALUES (1043, 19, NULL, 'prag-slot-ForgeofOlympus', 'Forge of Olympus', 'prag-slot-ForgeofOlympus', NULL, NULL, 'fivers/prag-slot-ForgeofOlympus.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:19', '2024-04-12 14:03:19');
INSERT INTO `games` VALUES (1044, 19, NULL, 'prag-CandyBlitz', 'Candy Blitz', 'prag-CandyBlitz', NULL, NULL, 'fivers/prag-CandyBlitz.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:19', '2024-04-12 14:03:19');
INSERT INTO `games` VALUES (1045, 19, NULL, 'prag-BigBassHoldSpinnerMegaways', 'Big Bass Hold & Spinner Megaways', 'prag-BigBassHoldSpinnerMegaways', NULL, NULL, 'fivers/prag-BigBassHoldSpinnerMegaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:20', '2024-04-12 14:03:20');
INSERT INTO `games` VALUES (1046, 19, NULL, 'prag-BookTutMegaways', 'Book of Tut Megaways', 'prag-BookTutMegaways', NULL, NULL, 'fivers/prag-BookTutMegaways.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:21', '2024-04-12 14:03:21');
INSERT INTO `games` VALUES (1047, 19, NULL, 'prag-FrozenTropics', 'Frozen Tropics', 'prag-FrozenTropics', NULL, NULL, 'fivers/prag-FrozenTropics.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:21', '2024-04-12 14:03:21');
INSERT INTO `games` VALUES (1048, 19, NULL, 'prag-CyclopsSmash', 'Cyclops Smash', 'prag-CyclopsSmash', NULL, NULL, 'fivers/prag-CyclopsSmash.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:22', '2024-04-12 14:03:22');
INSERT INTO `games` VALUES (1049, 19, NULL, 'prag-8GoldenDragonChallenge', '8 Golden Dragon Challenge', 'prag-8GoldenDragonChallenge', NULL, NULL, 'fivers/prag-8GoldenDragonChallenge.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:23', '2024-04-12 14:03:23');
INSERT INTO `games` VALUES (1050, 19, NULL, 'prag-FortunesofAztec', 'Fortunes of Aztec', 'prag-FortunesofAztec', NULL, NULL, 'fivers/prag-FortunesofAztec.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:23', '2024-04-12 14:03:23');
INSERT INTO `games` VALUES (1051, 19, NULL, 'prag-GoldOasis', 'Gold Oasis', 'prag-GoldOasis', NULL, NULL, 'fivers/prag-GoldOasis.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:24', '2024-04-12 14:03:24');
INSERT INTO `games` VALUES (1052, 19, NULL, 'prag-RainbowReels', 'Rainbow Reels', 'prag-RainbowReels', NULL, NULL, 'fivers/prag-RainbowReels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:25', '2024-04-12 14:03:25');
INSERT INTO `games` VALUES (1053, 19, NULL, 'prag-GravityBonanza', 'Gravity Bonanza', 'prag-GravityBonanza', NULL, NULL, 'fivers/prag-GravityBonanza.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:25', '2024-04-12 14:03:25');
INSERT INTO `games` VALUES (1054, 19, NULL, 'prag-DemonPots', 'Demon Pots', 'prag-DemonPots', NULL, NULL, 'fivers/prag-DemonPots.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:26', '2024-04-12 14:03:26');
INSERT INTO `games` VALUES (1055, 19, NULL, 'prag-TwilightPrincess', 'Twilight Princess', 'prag-TwilightPrincess', NULL, NULL, 'fivers/prag-TwilightPrincess.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:26', '2024-04-12 14:03:26');
INSERT INTO `games` VALUES (1056, 19, NULL, 'prag-BigBassHalloween', 'Big Bass Halloween', 'prag-BigBassHalloween', NULL, NULL, 'fivers/prag-BigBassHalloween.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:27', '2024-04-12 14:03:27');
INSERT INTO `games` VALUES (1057, 15, NULL, 'sms-slot-bookofwin', 'BookOfWin', 'sms-slot-bookofwin', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:27', '2024-04-12 14:03:27');
INSERT INTO `games` VALUES (1058, 19, NULL, 'sms-slot-apollo', 'Apollo', 'sms-slot-apollo', NULL, NULL, 'fivers/sms-slot-apollo.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:28', '2024-04-12 14:03:28');
INSERT INTO `games` VALUES (1059, 9, NULL, 'bs-slot-rooks-revenge', 'Rook', 'bs-slot-rooks-revenge', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:29', '2024-04-12 14:03:29');
INSERT INTO `games` VALUES (1060, 9, NULL, 'bs-slot-more-gold-diggin', 'More Gold Digginl', 'bs-slot-more-gold-diggin', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:29', '2024-04-12 14:03:29');
INSERT INTO `games` VALUES (1061, 9, NULL, 'bs-slot-tigers-claw', 'Tigers Claw', 'bs-slot-tigers-claw', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:30', '2024-04-12 14:03:30');
INSERT INTO `games` VALUES (1062, 19, NULL, 'bs-slot-monster-pop', 'Monster Pop', 'bs-slot-monster-pop', NULL, NULL, 'fivers/bs-slot-monster-pop.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:31', '2024-04-12 14:03:31');
INSERT INTO `games` VALUES (1063, 19, NULL, 'bs-tb-baccarat', 'Baccarat', 'bs-tb-baccarat', NULL, NULL, 'fivers/bs-tb-baccarat.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:31', '2024-04-12 14:03:31');
INSERT INTO `games` VALUES (1064, 19, NULL, 'bs-tb-american-blackjack', 'American Blackjack', 'bs-tb-american-blackjack', NULL, NULL, 'fivers/bs-tb-american-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:32', '2024-04-12 14:03:32');
INSERT INTO `games` VALUES (1065, 19, NULL, 'bs-slot-faerieSpells', 'Faerie Spells', 'bs-slot-faerieSpells', NULL, NULL, 'fivers/bs-slot-faerieSpells.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:33', '2024-04-12 14:03:33');
INSERT INTO `games` VALUES (1066, 19, NULL, 'bs-slot-alkemors', 'Alkemors Elementrs', 'bs-slot-alkemors', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:33', '2024-04-12 14:03:33');
INSERT INTO `games` VALUES (1067, 9, NULL, 'bs-slot-captainsQuest-TIsland', 'Captains Quest: Treasure Island', 'bs-slot-captainsQuest-TIsland', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:34', '2024-04-12 14:03:34');
INSERT INTO `games` VALUES (1068, 9, NULL, 'bs-slot-MrVegas2BigMoneyTower', 'Mr. Vegas 2: Big Money Tower', 'bs-slot-MrVegas2BigMoneyTower', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:34', '2024-04-12 14:03:34');
INSERT INTO `games` VALUES (1069, 19, NULL, 'bs-slot-HotLucky7s', 'Hot Lucky 7', 'bs-slot-HotLucky7s', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:35', '2024-04-12 14:03:35');
INSERT INTO `games` VALUES (1070, 19, NULL, '3o-slot-coinVolcano', 'Coin Volcano', '3o-slot-coinVolcano', NULL, NULL, 'fivers/3o-slot-coinVolcano.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:35', '2024-04-12 14:03:35');
INSERT INTO `games` VALUES (1071, 19, NULL, '3o-slot-grabMoreGold', 'Grab more Gold!', '3o-slot-grabMoreGold', NULL, NULL, 'fivers/3o-slot-grabMoreGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:36', '2024-04-12 14:03:36');
INSERT INTO `games` VALUES (1072, 19, NULL, '3o-slot-3hotChillies', '3 Hot Chillies', '3o-slot-3hotChillies', NULL, NULL, 'fivers/3o-slot-3hotChillies.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:37', '2024-04-12 14:03:37');
INSERT INTO `games` VALUES (1073, 19, NULL, '3o-slot-777coins', '777 Coins', '3o-slot-777coins', NULL, NULL, 'fivers/3o-slot-777coins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:38', '2024-04-12 14:03:38');
INSERT INTO `games` VALUES (1074, 19, NULL, '3o-slot-blackWolf2', 'Black Wolf 2', '3o-slot-blackWolf2', NULL, NULL, 'fivers/3o-slot-blackWolf2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:39', '2024-04-12 14:03:39');
INSERT INTO `games` VALUES (1075, 19, NULL, '3o-slot-littleFarm', 'Little Farm', '3o-slot-littleFarm', NULL, NULL, 'fivers/3o-slot-littleFarm.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:39', '2024-04-12 14:03:39');
INSERT INTO `games` VALUES (1076, 19, NULL, '3o-slot-greenChilli2', 'Green Chilli 2', '3o-slot-greenChilli2', NULL, NULL, 'fivers/3o-slot-greenChilli2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:40', '2024-04-12 14:03:40');
INSERT INTO `games` VALUES (1077, 19, NULL, '3o-slot-forestSpirit', 'Forest Spirit', '3o-slot-forestSpirit', NULL, NULL, 'fivers/3o-slot-forestSpirit.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:41', '2024-04-12 14:03:41');
INSERT INTO `games` VALUES (1078, 19, NULL, '3o-slot-ladyFortune', 'Lady Fortune', '3o-slot-ladyFortune', NULL, NULL, 'fivers/3o-slot-ladyFortune.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:42', '2024-04-12 14:03:42');
INSERT INTO `games` VALUES (1079, 19, NULL, '3o-slot-mummyPower', 'Mummy Power', '3o-slot-mummyPower', NULL, NULL, 'fivers/3o-slot-mummyPower.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:42', '2024-04-12 14:03:42');
INSERT INTO `games` VALUES (1080, 19, NULL, '3o-slot-tigerGems', 'Tiger Gems', '3o-slot-tigerGems', NULL, NULL, 'fivers/3o-slot-tigerGems.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:43', '2024-04-12 14:03:43');
INSERT INTO `games` VALUES (1081, 19, NULL, '3o-slot-grabTheGold', 'Grab the Gold!', '3o-slot-grabTheGold', NULL, NULL, 'fivers/3o-slot-grabTheGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:44', '2024-04-12 14:03:44');
INSERT INTO `games` VALUES (1082, 19, NULL, '3o-slot-egyptFire', 'Egypt Fire', '3o-slot-egyptFire', NULL, NULL, 'fivers/3o-slot-egyptFire.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:45', '2024-04-12 14:03:45');
INSERT INTO `games` VALUES (1083, 19, NULL, '3o-slot-yoHoGold', 'Yo-Ho Gold!', '3o-slot-yoHoGold', NULL, NULL, 'fivers/3o-slot-yoHoGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:46', '2024-04-12 14:03:46');
INSERT INTO `games` VALUES (1084, 19, NULL, '3o-slot-mayaSun', 'Maya Sun', '3o-slot-mayaSun', NULL, NULL, 'fivers/3o-slot-mayaSun.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:47', '2024-04-12 14:03:47');
INSERT INTO `games` VALUES (1085, 19, NULL, '3o-slot-boomBoomGold', 'Boom! Boom! Gold!', '3o-slot-boomBoomGold', NULL, NULL, 'fivers/3o-slot-boomBoomGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:47', '2024-04-12 14:03:47');
INSERT INTO `games` VALUES (1086, 19, NULL, '3o-slot-dragonWealth', 'Dragon Wealth', '3o-slot-dragonWealth', NULL, NULL, 'fivers/3o-slot-dragonWealth.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:48', '2024-04-12 14:03:48');
INSERT INTO `games` VALUES (1087, 19, NULL, '3o-slot-sunlightPrincess', 'Sunlight Princess', '3o-slot-sunlightPrincess', NULL, NULL, 'fivers/3o-slot-sunlightPrincess.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:49', '2024-04-12 14:03:49');
INSERT INTO `games` VALUES (1088, 19, NULL, '3o-slot-goddessOfEgypt', 'Goddess of Egypt', '3o-slot-goddessOfEgypt', NULL, NULL, 'fivers/3o-slot-goddessOfEgypt.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:50', '2024-04-12 14:03:50');
INSERT INTO `games` VALUES (1089, 19, NULL, '3o-slot-rioGems', 'Rio Gems', '3o-slot-rioGems', NULL, NULL, 'fivers/3o-slot-rioGems.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:52', '2024-04-12 14:03:52');
INSERT INTO `games` VALUES (1090, 19, NULL, '3o-slot-hitMoreGold', 'Hit more Gold!', '3o-slot-hitMoreGold', NULL, NULL, 'fivers/3o-slot-hitMoreGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:52', '2024-04-12 14:03:52');
INSERT INTO `games` VALUES (1091, 19, NULL, '3o-slot-stickyPiggy', 'Sticky Piggy', '3o-slot-stickyPiggy', NULL, NULL, 'fivers/3o-slot-stickyPiggy.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:53', '2024-04-12 14:03:53');
INSERT INTO `games` VALUES (1092, 19, NULL, '3o-slot-greenChilli', 'Green Chilli', '3o-slot-greenChilli', NULL, NULL, 'fivers/3o-slot-greenChilli.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:54', '2024-04-12 14:03:54');
INSERT INTO `games` VALUES (1093, 19, NULL, '3o-slot-bigHeist', 'Big Heist', '3o-slot-bigHeist', NULL, NULL, 'fivers/3o-slot-bigHeist.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:55', '2024-04-12 14:03:55');
INSERT INTO `games` VALUES (1094, 19, NULL, '3o-slot-aztecFire', 'Aztec Fire', '3o-slot-aztecFire', NULL, NULL, 'fivers/3o-slot-aztecFire.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:56', '2024-04-12 14:03:56');
INSERT INTO `games` VALUES (1095, 19, NULL, '3o-slot-lotusCharm', 'Lotus Charm', '3o-slot-lotusCharm', NULL, NULL, 'fivers/3o-slot-lotusCharm.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:57', '2024-04-12 14:03:57');
INSERT INTO `games` VALUES (1096, 19, NULL, '3o-slot-eggsOfGold', 'Eggs of Gold', '3o-slot-eggsOfGold', NULL, NULL, 'fivers/3o-slot-eggsOfGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:57', '2024-04-12 14:03:57');
INSERT INTO `games` VALUES (1097, 19, NULL, '3o-slot-magicApple2', 'Magic Apple 2', '3o-slot-magicApple2', NULL, NULL, 'fivers/3o-slot-magicApple2.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:03:59', '2024-04-12 14:03:59');
INSERT INTO `games` VALUES (1098, 19, NULL, '3o-slot-caishenWealth', 'Caishen Wealth', '3o-slot-caishenWealth', NULL, NULL, 'fivers/3o-slot-caishenWealth.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:00', '2024-04-12 14:04:00');
INSERT INTO `games` VALUES (1099, 19, NULL, '3o-slot-sunOfEgypt3', 'Sun of Egypt 3', '3o-slot-sunOfEgypt3', NULL, NULL, 'fivers/3o-slot-sunOfEgypt3.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:00', '2024-04-12 14:04:00');
INSERT INTO `games` VALUES (1100, 19, NULL, '3o-slot-bookOfWizardCrystalChance', 'Book of Wizard: Crystal Chance', '3o-slot-bookOfWizardCrystalChance', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:01', '2024-04-12 14:04:01');
INSERT INTO `games` VALUES (1101, 19, NULL, '3o-slot-blackWolf', 'Black Wolf', '3o-slot-blackWolf', NULL, NULL, 'fivers/3o-slot-blackWolf.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:02', '2024-04-12 14:04:02');
INSERT INTO `games` VALUES (1102, 19, NULL, '3o-slot-candyBoom', 'Candy Boom', '3o-slot-candyBoom', NULL, NULL, 'fivers/3o-slot-candyBoom.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:02', '2024-04-12 14:04:02');
INSERT INTO `games` VALUES (1103, 19, NULL, '3o-slot-goldExpress', 'Gold Express', '3o-slot-goldExpress', NULL, NULL, 'fivers/3o-slot-goldExpress.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:03', '2024-04-12 14:04:03');
INSERT INTO `games` VALUES (1104, 19, NULL, '3o-slot-lordFortune2', 'Lord Fortune 2', '3o-slot-lordFortune2', NULL, NULL, 'fivers/3o-slot-lordFortune2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:04', '2024-04-12 14:04:04');
INSERT INTO `games` VALUES (1105, 19, NULL, '3o-slot-bookOfWizard', 'Book of Wizard', '3o-slot-bookOfWizard', NULL, NULL, 'fivers/3o-slot-bookOfWizard.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:04', '2024-04-12 14:04:04');
INSERT INTO `games` VALUES (1106, 19, NULL, '3o-slot-tigerJungle', 'Tiger Jungle', '3o-slot-tigerJungle', NULL, NULL, 'fivers/3o-slot-tigerJungle.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:05', '2024-04-12 14:04:05');
INSERT INTO `games` VALUES (1107, 19, NULL, '3o-slot-wolfNight', 'Wolf Night', '3o-slot-wolfNight', NULL, NULL, 'fivers/3o-slot-wolfNight.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:06', '2024-04-12 14:04:06');
INSERT INTO `games` VALUES (1108, 19, NULL, '3o-slot-3coinsEgypt', '3 Coins: Egypt', '3o-slot-3coinsEgypt', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:06', '2024-04-12 14:04:06');
INSERT INTO `games` VALUES (1109, 19, NULL, '3o-slot-pearlDiver', 'Pearl Diver', '3o-slot-pearlDiver', NULL, NULL, 'fivers/3o-slot-pearlDiver.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:07', '2024-04-12 14:04:07');
INSERT INTO `games` VALUES (1110, 19, NULL, '3o-slot-wukong', 'Wukong', '3o-slot-wukong', NULL, NULL, 'fivers/3o-slot-wukong.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:08', '2024-04-12 14:04:08');
INSERT INTO `games` VALUES (1111, 19, NULL, '3o-slot-scarabBoost', 'Scarab Boost', '3o-slot-scarabBoost', NULL, NULL, 'fivers/3o-slot-scarabBoost.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:09', '2024-04-12 14:04:09');
INSERT INTO `games` VALUES (1112, 19, NULL, '3o-slot-hitTheGold', 'Hit the Gold!', '3o-slot-hitTheGold', NULL, NULL, 'fivers/3o-slot-hitTheGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:09', '2024-04-12 14:04:09');
INSERT INTO `games` VALUES (1113, 6, NULL, '3o-slot-magicBallMultichance', 'Magic Ball: Multichance', '3o-slot-magicBallMultichance', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:10', '2024-04-12 14:04:10');
INSERT INTO `games` VALUES (1114, 19, NULL, '3o-slot-magicApple', 'Magic Apple', '3o-slot-magicApple', NULL, NULL, 'fivers/3o-slot-magicApple.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:11', '2024-04-12 14:04:11');
INSERT INTO `games` VALUES (1115, 19, NULL, '3o-slot-wolfSaga', 'Wolf Saga', '3o-slot-wolfSaga', NULL, NULL, 'fivers/3o-slot-wolfSaga.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:11', '2024-04-12 14:04:11');
INSERT INTO `games` VALUES (1116, 19, NULL, '3o-slot-3coins', '3 Coins', '3o-slot-3coins', NULL, NULL, 'fivers/3o-slot-3coins.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:12', '2024-04-12 14:04:12');
INSERT INTO `games` VALUES (1117, 19, NULL, '3o-slot-tigerStone', 'Eye of Gold', '3o-slot-tigerStone', NULL, NULL, 'fivers/3o-slot-tigerStone.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:13', '2024-04-12 14:04:13');
INSERT INTO `games` VALUES (1118, 19, NULL, '3o-slot-sunOfEgypt2', 'Sun of Egypt 2', '3o-slot-sunOfEgypt2', NULL, NULL, 'fivers/3o-slot-sunOfEgypt2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:14', '2024-04-12 14:04:14');
INSERT INTO `games` VALUES (1119, 6, NULL, '3o-slot-scarabTemple', 'Scarab Temple', '3o-slot-scarabTemple', NULL, NULL, 'fivers/3o-slot-scarabTemple.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:15', '2024-04-12 14:04:15');
INSERT INTO `games` VALUES (1120, 19, NULL, '3o-slot-thunderOfOlympus', 'Thunder of Olympus', '3o-slot-thunderOfOlympus', NULL, NULL, 'fivers/3o-slot-thunderOfOlympus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:15', '2024-04-12 14:04:15');
INSERT INTO `games` VALUES (1121, 19, NULL, '3o-slot-15dragonPearls', '15 Dragon Pearls', '3o-slot-15dragonPearls', NULL, NULL, 'fivers/3o-slot-15dragonPearls.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:16', '2024-04-12 14:04:16');
INSERT INTO `games` VALUES (1122, 19, NULL, '3o-slot-buddhaFortune', 'Buddha Fortune', '3o-slot-buddhaFortune', NULL, NULL, 'fivers/3o-slot-buddhaFortune.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:17', '2024-04-12 14:04:17');
INSERT INTO `games` VALUES (1123, 19, NULL, '3o-slot-superMarble', 'Super Marble', '3o-slot-superMarble', NULL, NULL, 'fivers/3o-slot-superMarble.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:17', '2024-04-12 14:04:17');
INSERT INTO `games` VALUES (1124, 19, NULL, '3o-slot-aztecSun', 'Aztec Sun', '3o-slot-aztecSun', NULL, NULL, 'fivers/3o-slot-aztecSun.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:18', '2024-04-12 14:04:18');
INSERT INTO `games` VALUES (1125, 19, NULL, '3o-slot-moonSisters', 'Moon Sisters', '3o-slot-moonSisters', NULL, NULL, 'fivers/3o-slot-moonSisters.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:19', '2024-04-12 14:04:19');
INSERT INTO `games` VALUES (1126, 19, NULL, '3o-slot-bookOfSunChoice', 'Book of Sun: Choice', '3o-slot-bookOfSunChoice', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:19', '2024-04-12 14:04:19');
INSERT INTO `games` VALUES (1127, 19, NULL, '3o-slot-scarabRiches', 'Scarab Riches', '3o-slot-scarabRiches', NULL, NULL, 'fivers/3o-slot-scarabRiches.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:20', '2024-04-12 14:04:20');
INSERT INTO `games` VALUES (1128, 19, NULL, '3o-slot-bookOfSunMultichance', 'Book of Sun: Multichance', '3o-slot-bookOfSunMultichance', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:20', '2024-04-12 14:04:20');
INSERT INTO `games` VALUES (1129, 19, NULL, 'gaming7777-tb-european-roulette', 'European Roulette', 'gaming7777-tb-european-roulette', NULL, NULL, 'fivers/gaming7777-tb-european-roulette.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:21', '2024-04-12 14:04:21');
INSERT INTO `games` VALUES (1130, 19, NULL, 'gaming7777-tb-money-tree', 'Money Tree', 'gaming7777-tb-money-tree', NULL, NULL, 'fivers/gaming7777-tb-money-tree.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:22', '2024-04-12 14:04:22');
INSERT INTO `games` VALUES (1131, 10, NULL, 'boo-slot-rudolphsRide', 'Rudophs Ride', 'boo-slot-rudolphsRide', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:22', '2024-04-12 14:04:22');
INSERT INTO `games` VALUES (1132, 19, NULL, 'boo-slot-winnersCup', 'Winners Cup', 'boo-slot-winnersCup', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:23', '2024-04-12 14:04:23');
INSERT INTO `games` VALUES (1133, 13, NULL, 'pgs-slot-FortuneTiger', 'Fortune Tiger', 'pgs-slot-FortuneTiger', 'slots', NULL, '01HVACM26Y4BQD2FEP1D6VWSZD.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:04:23', '2024-04-12 21:09:54');
INSERT INTO `games` VALUES (1134, 19, NULL, 'pgs-slot-leprechaunRiches', 'Leprechaun Riches', 'pgs-slot-leprechaunRiches', NULL, NULL, 'fivers/pgs-slot-leprechaunRiches.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:24', '2024-04-12 14:04:24');
INSERT INTO `games` VALUES (1135, 19, NULL, 'pgs-slot-candyburst', 'Candy Burst', 'pgs-slot-candyburst', NULL, NULL, 'fivers/pgs-slot-candyburst.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:25', '2024-04-12 14:04:25');
INSERT INTO `games` VALUES (1136, 19, NULL, 'pgs-slot-honeyTrapOfDiaoChan', 'Honey Trap of Diao Chan', 'pgs-slot-honeyTrapOfDiaoChan', NULL, NULL, 'fivers/pgs-slot-honeyTrapOfDiaoChan.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:25', '2024-04-12 14:04:25');
INSERT INTO `games` VALUES (1137, 19, NULL, 'pgs-slot-FortuneGods', 'Fortune Gods', 'pgs-slot-FortuneGods', NULL, NULL, 'fivers/pgs-slot-FortuneGods.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:26', '2024-04-12 14:04:26');
INSERT INTO `games` VALUES (1138, 19, NULL, 'pgs-slot-WinWinWon', 'Win Win Won', 'pgs-slot-WinWinWon', NULL, NULL, 'fivers/pgs-slot-WinWinWon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:27', '2024-04-12 14:04:27');
INSERT INTO `games` VALUES (1139, 19, NULL, 'pgs-slot-MedusaII', 'Medusa II', 'pgs-slot-MedusaII', NULL, NULL, 'fivers/pgs-slot-MedusaII.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:27', '2024-04-12 14:04:27');
INSERT INTO `games` VALUES (1140, 19, NULL, 'pgs-slot-Medusa', 'Medusa', 'pgs-slot-Medusa', NULL, NULL, 'fivers/pgs-slot-Medusa.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:28', '2024-04-12 14:04:28');
INSERT INTO `games` VALUES (1141, 19, NULL, 'pgs-slot-PlushieFrenzy', 'Plushie Frenzy', 'pgs-slot-PlushieFrenzy', NULL, NULL, 'fivers/pgs-slot-PlushieFrenzy.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:28', '2024-04-12 14:04:28');
INSERT INTO `games` VALUES (1142, 13, NULL, 'pgs-slot-GemSaviour', 'Gem Saviour', 'pgs-slot-GemSaviour', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:29', '2024-04-12 14:04:29');
INSERT INTO `games` VALUES (1143, 19, NULL, 'pgs-slot-HoodvsWolf', 'Hood vs Wolf', 'pgs-slot-HoodvsWolf', NULL, NULL, 'fivers/pgs-slot-HoodvsWolf.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:30', '2024-04-12 14:04:30');
INSERT INTO `games` VALUES (1144, 19, NULL, 'pgs-slot-DragonLegend', 'Dragon Legend', 'pgs-slot-DragonLegend', NULL, NULL, 'fivers/pgs-slot-DragonLegend.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:30', '2024-04-12 14:04:30');
INSERT INTO `games` VALUES (1145, 19, NULL, 'pgs-slot-ProsperityLion', 'Prosperity Lion', 'pgs-slot-ProsperityLion', NULL, NULL, 'fivers/pgs-slot-ProsperityLion.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:31', '2024-04-12 14:04:31');
INSERT INTO `games` VALUES (1146, 19, NULL, 'pgs-slot-HipHopPanda', 'Hip Hop Panda', 'pgs-slot-HipHopPanda', NULL, NULL, 'fivers/pgs-slot-HipHopPanda.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:32', '2024-04-12 14:04:32');
INSERT INTO `games` VALUES (1147, 19, NULL, 'pgs-slot-GemSaviourSword', 'Gem Saviour Sword', 'pgs-slot-GemSaviourSword', NULL, NULL, 'fivers/pgs-slot-GemSaviourSword.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:32', '2024-04-12 14:04:32');
INSERT INTO `games` VALUES (1148, 13, NULL, 'pgs-slot-PiggyGold', 'Piggy Gold', 'pgs-slot-PiggyGold', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:33', '2024-04-12 14:04:33');
INSERT INTO `games` VALUES (1149, 19, NULL, 'pgs-slot-JungleDelight', 'Jungle Delight', 'pgs-slot-JungleDelight', NULL, NULL, 'fivers/pgs-slot-JungleDelight.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:33', '2024-04-12 14:04:33');
INSERT INTO `games` VALUES (1150, 13, NULL, 'pgs-slot-DoubleFortune', 'Double Fortune', 'pgs-slot-DoubleFortune', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:34', '2024-04-12 14:04:34');
INSERT INTO `games` VALUES (1151, 13, NULL, 'pgs-slot-ganeshaGold', 'Ganesha Gold', 'pgs-slot-ganeshaGold', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:34', '2024-04-12 14:04:34');
INSERT INTO `games` VALUES (1152, 13, NULL, 'pgs-slot-flirtingScholar', 'Flirting Scholar', 'pgs-slot-flirtingScholar', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:35', '2024-04-12 14:04:35');
INSERT INTO `games` VALUES (1153, 19, NULL, 'pgs-slot-dragonTigerLuck', 'Dragon Tiger Luck', 'pgs-slot-dragonTigerLuck', NULL, NULL, 'fivers/pgs-slot-dragonTigerLuck.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:36', '2024-04-12 14:04:36');
INSERT INTO `games` VALUES (1154, 19, NULL, 'pgs-slot-mahjongWays', 'Mahjong Ways', 'pgs-slot-mahjongWays', NULL, NULL, 'fivers/pgs-slot-mahjongWays.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:36', '2024-04-12 14:04:36');
INSERT INTO `games` VALUES (1155, 19, NULL, 'pgs-slot-dragonHatch', 'Dragon Hatch', 'pgs-slot-dragonHatch', NULL, NULL, 'fivers/pgs-slot-dragonHatch.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:37', '2024-04-12 14:04:37');
INSERT INTO `games` VALUES (1156, 13, NULL, 'pgs-slot-fortuneMouse', 'Fortune Mouse', 'pgs-slot-fortuneMouse', 'slots', NULL, '01HVACVAZKXH00FT3HGT4HP36C.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:04:37', '2024-04-12 21:13:52');
INSERT INTO `games` VALUES (1157, 19, NULL, 'pgs-slot-reelLove', 'Reel Love', 'pgs-slot-reelLove', NULL, NULL, 'fivers/pgs-slot-reelLove.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:38', '2024-04-12 14:04:38');
INSERT INTO `games` VALUES (1158, 19, NULL, 'pgs-slot-gemsaviourconquest', 'Gem Saviour Conquest', 'pgs-slot-gemsaviourconquest', NULL, NULL, 'fivers/pgs-slot-gemsaviourconquest.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:39', '2024-04-12 14:04:39');
INSERT INTO `games` VALUES (1159, 19, NULL, 'pgs-slot-shaolinsoccer', 'Shaolin Soccer', 'pgs-slot-shaolinsoccer', NULL, NULL, 'fivers/pgs-slot-shaolinsoccer.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:39', '2024-04-12 14:04:39');
INSERT INTO `games` VALUES (1160, 19, NULL, 'pgs-slot-bikiniparadise', 'Bikini Paradise', 'pgs-slot-bikiniparadise', NULL, NULL, 'fivers/pgs-slot-bikiniparadise.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:40', '2024-04-12 14:04:40');
INSERT INTO `games` VALUES (1161, 19, NULL, 'pgs-slot-ganeshafortune', 'Ganesha Fortune', 'pgs-slot-ganeshafortune', NULL, NULL, 'fivers/pgs-slot-ganeshafortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:41', '2024-04-12 14:04:41');
INSERT INTO `games` VALUES (1162, 19, NULL, 'pgs-slot-mahjongways2', 'Mahjong Ways 2', 'pgs-slot-mahjongways2', NULL, NULL, 'fivers/pgs-slot-mahjongways2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:41', '2024-04-12 14:04:41');
INSERT INTO `games` VALUES (1163, 19, NULL, 'pgs-slot-phoenixrises', 'Phoenix Rises', 'pgs-slot-phoenixrises', NULL, NULL, 'fivers/pgs-slot-phoenixrises.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:42', '2024-04-12 14:04:42');
INSERT INTO `games` VALUES (1164, 19, NULL, 'pgs-slot-dreamsmacau', 'Dreams of Macau', 'pgs-slot-dreamsmacau', NULL, NULL, 'fivers/pgs-slot-dreamsmacau.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:43', '2024-04-12 14:04:43');
INSERT INTO `games` VALUES (1165, 19, NULL, 'pgs-slot-wildfFireworks', 'Wild Fireworks', 'pgs-slot-wildfFireworks', NULL, NULL, 'fivers/pgs-slot-wildfFireworks.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:44', '2024-04-12 14:04:44');
INSERT INTO `games` VALUES (1166, 19, NULL, 'pgs-slot-circusDelight', 'Circus Delight', 'pgs-slot-circusDelight', NULL, NULL, 'fivers/pgs-slot-circusDelight.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:44', '2024-04-12 14:04:44');
INSERT INTO `games` VALUES (1167, 19, NULL, 'pgs-slot-thaiRiverWonders', 'Thai River Wonders', 'pgs-slot-thaiRiverWonders', NULL, NULL, 'fivers/pgs-slot-thaiRiverWonders.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:45', '2024-04-12 14:04:45');
INSERT INTO `games` VALUES (1168, 19, NULL, 'pgs-slot-muayThaiChampion', 'Muay Thai Champion', 'pgs-slot-muayThaiChampion', NULL, NULL, 'fivers/pgs-slot-muayThaiChampion.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:46', '2024-04-12 14:04:46');
INSERT INTO `games` VALUES (1169, 19, NULL, 'pgs-slot-luckyNeko', 'Lucky Neko', 'pgs-slot-luckyNeko', NULL, NULL, 'fivers/pgs-slot-luckyNeko.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:46', '2024-04-12 14:04:46');
INSERT INTO `games` VALUES (1170, 19, NULL, 'pgs-slot-operaDynasty', 'Opera Dynasty', 'pgs-slot-operaDynasty', NULL, NULL, 'fivers/pgs-slot-operaDynasty.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:47', '2024-04-12 14:04:47');
INSERT INTO `games` VALUES (1171, 13, NULL, 'pgs-slot-fortuneOx', 'Fortune Ox', 'pgs-slot-fortuneOx', 'slots', NULL, '01HVACNSYV83DDVZGB2SCMJP54.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:04:47', '2024-04-12 21:10:51');
INSERT INTO `games` VALUES (1172, 19, NULL, 'pgs-slot-baliVacation', 'Bali Vacation', 'pgs-slot-baliVacation', NULL, NULL, 'fivers/pgs-slot-baliVacation.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:49', '2024-04-12 14:04:49');
INSERT INTO `games` VALUES (1173, 19, NULL, 'pgs-slot-candyBonanza', 'Candy Bonanza', 'pgs-slot-candyBonanza', NULL, NULL, 'fivers/pgs-slot-candyBonanza.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:50', '2024-04-12 14:04:50');
INSERT INTO `games` VALUES (1174, 19, NULL, 'pgs-slot-majesticTreasures', 'Majestic Treasures', 'pgs-slot-majesticTreasures', NULL, NULL, 'fivers/pgs-slot-majesticTreasures.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:51', '2024-04-12 14:04:51');
INSERT INTO `games` VALUES (1175, 19, NULL, 'pgs-slot-wildBandito', 'Wild Bandito', 'pgs-slot-wildBandito', NULL, NULL, 'fivers/pgs-slot-wildBandito.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:51', '2024-04-12 14:04:51');
INSERT INTO `games` VALUES (1176, 19, NULL, 'pgs-slot-cryptoGold', 'Crypto Gold', 'pgs-slot-cryptoGold', NULL, NULL, 'fivers/pgs-slot-cryptoGold.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:52', '2024-04-12 14:04:52');
INSERT INTO `games` VALUES (1177, 19, NULL, 'pgs-slot-jurassicKingdom', 'Jurassic Kingdom', 'pgs-slot-jurassicKingdom', NULL, NULL, 'fivers/pgs-slot-jurassicKingdom.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:53', '2024-04-12 14:04:53');
INSERT INTO `games` VALUES (1178, 19, NULL, 'pgs-slot-mermaidRiches', 'Mermaid Riches', 'pgs-slot-mermaidRiches', NULL, NULL, 'fivers/pgs-slot-mermaidRiches.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:54', '2024-04-12 14:04:54');
INSERT INTO `games` VALUES (1179, 19, NULL, 'pgs-slot-supermarketSpree', 'Supermarket Spree', 'pgs-slot-supermarketSpree', NULL, NULL, 'fivers/pgs-slot-supermarketSpree.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:54', '2024-04-12 14:04:54');
INSERT INTO `games` VALUES (1180, 19, NULL, 'pgs-slot-buffaloWin', 'Buffalo Win', 'pgs-slot-buffaloWin', NULL, NULL, 'fivers/pgs-slot-buffaloWin.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:55', '2024-04-12 14:04:55');
INSERT INTO `games` VALUES (1181, 19, NULL, 'pgs-slot-lMonkeyKing', 'Legendary Monkey King', 'pgs-slot-lMonkeyKing', NULL, NULL, 'fivers/pgs-slot-lMonkeyKing.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:56', '2024-04-12 14:04:56');
INSERT INTO `games` VALUES (1182, 19, NULL, 'pgs-slot-spiritedWonders', 'Spirited Wonders', 'pgs-slot-spiritedWonders', NULL, NULL, 'fivers/pgs-slot-spiritedWonders.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:57', '2024-04-12 14:04:57');
INSERT INTO `games` VALUES (1183, 19, NULL, 'pgs-slot-emojiriches', 'Emoji Riches', 'pgs-slot-emojiriches', NULL, NULL, 'fivers/pgs-slot-emojiriches.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:57', '2024-04-12 14:04:57');
INSERT INTO `games` VALUES (1184, 19, NULL, 'pgs-slot-cocktailnite', 'Cocktail Nights', 'pgs-slot-cocktailnite', NULL, NULL, 'fivers/pgs-slot-cocktailnite.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:58', '2024-04-12 14:04:58');
INSERT INTO `games` VALUES (1185, 19, NULL, 'pgs-slot-maskCarnival', 'Mask Carnival', 'pgs-slot-maskCarnival', NULL, NULL, 'fivers/pgs-slot-maskCarnival.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:59', '2024-04-12 14:04:59');
INSERT INTO `games` VALUES (1186, 19, NULL, 'pgs-slot-orientalprosperity', 'Oriental Prosperity', 'pgs-slot-orientalprosperity', NULL, NULL, 'fivers/pgs-slot-orientalprosperity.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:04:59', '2024-04-12 14:04:59');
INSERT INTO `games` VALUES (1187, 19, NULL, 'pgs-slot-garudaGems', 'Garuda Gems', 'pgs-slot-garudaGems', NULL, NULL, 'fivers/pgs-slot-garudaGems.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:00', '2024-04-12 14:05:00');
INSERT INTO `games` VALUES (1188, 19, NULL, 'pgs-slot-butterflyBlossom', 'Butterfly Blossom', 'pgs-slot-butterflyBlossom', NULL, NULL, 'fivers/pgs-slot-butterflyBlossom.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:01', '2024-04-12 14:05:01');
INSERT INTO `games` VALUES (1189, 19, NULL, 'pgs-slot-roosterRumble', 'Rooster Rumble', 'pgs-slot-roosterRumble', NULL, NULL, 'fivers/pgs-slot-roosterRumble.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:02', '2024-04-12 14:05:02');
INSERT INTO `games` VALUES (1190, 19, NULL, 'pgs-slot-battlegroundRoyale', 'Battleground Royale', 'pgs-slot-battlegroundRoyale', NULL, NULL, 'fivers/pgs-slot-battlegroundRoyale.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:03', '2024-04-12 14:05:03');
INSERT INTO `games` VALUES (1191, 19, NULL, 'pgs-slot-winwinFishPC', 'Win Win Fish Prawn Crab', 'pgs-slot-winwinFishPC', NULL, NULL, 'fivers/pgs-slot-winwinFishPC.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:04', '2024-04-12 14:05:04');
INSERT INTO `games` VALUES (1192, 19, NULL, 'pgs-slot-prosperityfortuneT', 'Prosperity Fortune Tree', 'pgs-slot-prosperityfortuneT', NULL, NULL, 'fivers/pgs-slot-prosperityfortuneT.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:05', '2024-04-12 14:05:05');
INSERT INTO `games` VALUES (1193, 19, NULL, 'pgs-slot-wildbountyS', 'Wild Bounty Showdown', 'pgs-slot-wildbountyS', NULL, NULL, 'fivers/pgs-slot-wildbountyS.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:07', '2024-04-12 14:05:07');
INSERT INTO `games` VALUES (1194, 19, NULL, 'pgs-slot-TotemWonders', 'Totem Wonders', 'pgs-slot-TotemWonders', NULL, NULL, 'fivers/pgs-slot-TotemWonders.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:09', '2024-04-12 14:05:09');
INSERT INTO `games` VALUES (1195, 19, NULL, 'pgs-slot-AlchemyGold', 'Alchemy Gold', 'pgs-slot-AlchemyGold', NULL, NULL, 'fivers/pgs-slot-AlchemyGold.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:10', '2024-04-12 14:05:10');
INSERT INTO `games` VALUES (1196, 19, NULL, 'pgs-slot-LegendOfPerseus', 'Legend of Perseus', 'pgs-slot-LegendOfPerseus', NULL, NULL, 'fivers/pgs-slot-LegendOfPerseus.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:12', '2024-04-12 14:05:12');
INSERT INTO `games` VALUES (1197, 19, NULL, 'pgs-slot-WildCoaster', 'Wild Coaster', 'pgs-slot-WildCoaster', NULL, NULL, 'fivers/pgs-slot-WildCoaster.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:14', '2024-04-12 14:05:14');
INSERT INTO `games` VALUES (1198, 19, NULL, 'pgs-slot-DinerDelights', 'Diner Delights', 'pgs-slot-DinerDelights', NULL, NULL, 'fivers/pgs-slot-DinerDelights.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:15', '2024-04-12 14:05:15');
INSERT INTO `games` VALUES (1199, 19, NULL, 'pgs-slot-AsgardianRising', 'Asgardian Rising', 'pgs-slot-AsgardianRising', NULL, NULL, 'fivers/pgs-slot-AsgardianRising.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:17', '2024-04-12 14:05:17');
INSERT INTO `games` VALUES (1200, 19, NULL, 'pgs-slot-MidasFortune', 'Midas Fortune', 'pgs-slot-MidasFortune', NULL, NULL, 'fivers/pgs-slot-MidasFortune.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:19', '2024-04-12 14:05:19');
INSERT INTO `games` VALUES (1201, 13, NULL, 'pgs-slot-FortuneRabbit', 'Fortune Rabbit', 'pgs-slot-FortuneRabbit', 'slots', NULL, '01HVACR5DNRPM0GFCVSB9KV83N.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:05:19', '2024-04-12 21:12:50');
INSERT INTO `games` VALUES (1202, 19, NULL, 'pgs-slot-RavePartyFever', 'Rave Party Fever', 'pgs-slot-RavePartyFever', NULL, NULL, 'fivers/pgs-slot-RavePartyFever.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:21', '2024-04-12 14:05:21');
INSERT INTO `games` VALUES (1203, 19, NULL, 'pgs-slot-HawaiianTiki', 'Hawaiian Tiki', 'pgs-slot-HawaiianTiki', NULL, NULL, 'fivers/pgs-slot-HawaiianTiki.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:23', '2024-04-12 14:05:23');
INSERT INTO `games` VALUES (1204, 19, NULL, 'pgs-slot-BakeryBonanza', 'Bakery Bonanza', 'pgs-slot-BakeryBonanza', NULL, NULL, 'fivers/pgs-slot-BakeryBonanza.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:24', '2024-04-12 14:05:24');
INSERT INTO `games` VALUES (1205, 19, NULL, 'pgs-slot-SongkranSplash', 'Songkran Splash', 'pgs-slot-SongkranSplash', NULL, NULL, 'fivers/pgs-slot-SongkranSplash.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:26', '2024-04-12 14:05:26');
INSERT INTO `games` VALUES (1206, 19, NULL, 'pgs-slot-luckypiggyv2', 'Lucky Piggy', 'pgs-slot-luckypiggyv2', NULL, NULL, 'fivers/pgs-slot-luckypiggyv2.jpeg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:27', '2024-04-12 14:05:27');
INSERT INTO `games` VALUES (1207, 19, NULL, 'pgs-slot-mysticalspirits', 'Mystical Spirits', 'pgs-slot-mysticalspirits', NULL, NULL, 'fivers/pgs-slot-mysticalspirits.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:28', '2024-04-12 14:05:28');
INSERT INTO `games` VALUES (1208, 19, NULL, 'pgs-slot-supergolfdrive', 'Super Golf Drive', 'pgs-slot-supergolfdrive', NULL, NULL, 'fivers/pgs-slot-supergolfdrive.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:30', '2024-04-12 14:05:30');
INSERT INTO `games` VALUES (1209, 19, NULL, 'pgs-slot-luckycloverlady', 'Lucky Clover Lady', 'pgs-slot-luckycloverlady', NULL, NULL, 'fivers/pgs-slot-luckycloverlady.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:32', '2024-04-12 14:05:32');
INSERT INTO `games` VALUES (1210, 18, NULL, 'pgs-slot-fruitycandy', 'Fruity Candy', 'pgs-slot-fruitycandy', NULL, NULL, 'fivers/pgs-slot-fruitycandy.png', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:32', '2024-04-12 14:05:32');
INSERT INTO `games` VALUES (1211, 19, NULL, 'pgs-cruiseroyale', 'Cruise Royale', 'pgs-cruiseroyale', NULL, NULL, 'fivers/pgs-cruiseroyale.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:33', '2024-04-12 14:05:33');
INSERT INTO `games` VALUES (1212, 19, NULL, 'pgs-ultimatestriker', 'Ultimate Striker', 'pgs-ultimatestriker', NULL, NULL, 'fivers/pgs-ultimatestriker.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:35', '2024-04-12 14:05:35');
INSERT INTO `games` VALUES (1213, 5, NULL, 'bgtv-lg-baccarat', 'Baccarat', 'bgtv-lg-baccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:35', '2024-04-12 14:05:35');
INSERT INTO `games` VALUES (1214, 13, NULL, 'pgs-FortuneDragon', 'Fortune Dragon', 'pgs-FortuneDragon', NULL, NULL, 'fivers/pgs-FortuneDragon.jpg', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 1, 0, '2024-04-12 14:05:36', '2024-04-12 21:15:03');
INSERT INTO `games` VALUES (1215, 21, NULL, 'vswayslions', '5 Lions Megaways', 'pragmaticplay-5-lions-megaways', NULL, NULL, 'fivers/pragmaticplay-5-lions-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:36', '2024-04-12 14:05:36');
INSERT INTO `games` VALUES (1216, 21, NULL, 'cs3w', 'Diamonds are Forever 3 Lines', 'pragmaticplay-diamonds-are-forever-3-lines', NULL, NULL, 'fivers/pragmaticplay-diamonds-are-forever-3-lines.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:37', '2024-04-12 14:05:37');
INSERT INTO `games` VALUES (1217, 21, NULL, 'vs20hburnhs', 'Hot to Burn Hold and Spin', 'pragmaticplay-hot-to-burn-hold-and-spin', NULL, NULL, 'fivers/pragmaticplay-hot-to-burn-hold-and-spin.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:37', '2024-04-12 14:05:37');
INSERT INTO `games` VALUES (1218, 21, NULL, 'vs10amm', 'Amazing Money Machine', 'pragmaticplay-amazing-money-machine', NULL, NULL, 'fivers/pragmaticplay-amazing-money-machine.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:38', '2024-04-12 14:05:38');
INSERT INTO `games` VALUES (1219, 21, NULL, 'prag-slot-extra-juicy', 'Extra Juicy', 'pragmaticplay-extra-juicy', NULL, NULL, 'fivers/pragmaticplay-extra-juicy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:39', '2024-04-12 14:05:39');
INSERT INTO `games` VALUES (1220, 21, NULL, 'vs25rio', 'Heart of Rio', 'pragmaticplay-heart-of-rio', NULL, NULL, 'fivers/pragmaticplay-heart-of-rio.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:39', '2024-04-12 14:05:39');
INSERT INTO `games` VALUES (1221, 21, NULL, 'vs10bxmasbnza', 'Christmas Big Bass Bonanza', 'pragmaticplay-christmas-big-bass-bonanza', NULL, NULL, 'fivers/pragmaticplay-christmas-big-bass-bonanza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:40', '2024-04-12 14:05:40');
INSERT INTO `games` VALUES (1222, 21, NULL, 'vs20colcashzone', 'Colossal Cash Zone', 'pragmaticplay-colossal-cash-zone', NULL, NULL, 'fivers/pragmaticplay-colossal-cash-zone.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:40', '2024-04-12 14:05:40');
INSERT INTO `games` VALUES (1223, 21, NULL, 'vs10floatdrg', 'Floating Dragon', 'pragmaticplay-floating-dragon', NULL, NULL, 'fivers/pragmaticplay-floating-dragon.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:41', '2024-04-12 14:05:41');
INSERT INTO `games` VALUES (1224, 21, NULL, 'vs40cosmiccash', 'Cosmic Cash', 'pragmaticplay-cosmic-cash', NULL, NULL, 'fivers/pragmaticplay-cosmic-cash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:42', '2024-04-12 14:05:42');
INSERT INTO `games` VALUES (1225, 21, NULL, 'vs10bbkir', 'Big Bass Bonanza - Keeping it Reel', 'pragmaticplay-big-bass-bonanza-keeping-it-reel', NULL, NULL, 'fivers/pragmaticplay-big-bass-bonanza-keeping-it-reel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:42', '2024-04-12 14:05:42');
INSERT INTO `games` VALUES (1226, 22, NULL, 'mj-slot-hot-fortune-wheel-80', 'Hot Fortune Wheel 80', '7-mojos-slots-hot-fortune-wheel-80', NULL, NULL, 'fivers/7-mojos-slots-hot-fortune-wheel-80.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:43', '2024-04-12 14:05:43');
INSERT INTO `games` VALUES (1227, 21, NULL, 'vs20muertos', 'Muertos Multiplier Megaways', 'pragmaticplay-muertos-multiplier-megaways', NULL, NULL, 'fivers/pragmaticplay-muertos-multiplier-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:43', '2024-04-12 14:05:43');
INSERT INTO `games` VALUES (1228, 21, NULL, 'vs25pandatemple', 'Panda Fortune 2', 'pragmaticplay-panda-fortune-2', NULL, NULL, 'fivers/pragmaticplay-panda-fortune-2.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:44', '2024-04-12 14:05:44');
INSERT INTO `games` VALUES (1229, 21, NULL, 'vs20xmascarol', 'Christmas Carol Megaways', 'pragmaticplay-christmas-carol-megaways', NULL, NULL, 'fivers/pragmaticplay-christmas-carol-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:44', '2024-04-12 14:05:44');
INSERT INTO `games` VALUES (1230, 21, NULL, 'vs20porbs', 'Santa\'s Great Gifts', 'pragmaticplay-santas-great-gifts', NULL, NULL, 'fivers/pragmaticplay-santas-great-gifts.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:45', '2024-04-12 14:05:45');
INSERT INTO `games` VALUES (1231, 22, NULL, 'mj-slot-fortune-genie', 'Fortune Genie', '7-mojos-slots-fortune-genie', NULL, NULL, 'fivers/7-mojos-slots-fortune-genie.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:46', '2024-04-12 14:05:46');
INSERT INTO `games` VALUES (1232, 21, NULL, 'vs20bermuda', 'Bermuda Riches', 'pragmaticplay-bermuda-riches', NULL, NULL, 'fivers/pragmaticplay-bermuda-riches.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:46', '2024-04-12 14:05:46');
INSERT INTO `games` VALUES (1233, 22, NULL, 'mj-slot-hot-fortune-wheel', 'Hot Fortune Wheel', '7-mojos-slots-hot-fortune-wheel', NULL, NULL, 'fivers/7-mojos-slots-hot-fortune-wheel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:47', '2024-04-12 14:05:47');
INSERT INTO `games` VALUES (1234, 21, NULL, 'vswayspizza', 'PIZZA PIZZA PIZZA', 'pragmaticplay-pizza-pizza-pizza', NULL, NULL, 'fivers/pragmaticplay-pizza-pizza-pizza.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:47', '2024-04-12 14:05:47');
INSERT INTO `games` VALUES (1235, 21, NULL, 'vs20gobnudge', 'Goblin Heist Powernudge', 'pragmaticplay-goblin-heist-powernudge', NULL, NULL, 'fivers/pragmaticplay-goblin-heist-powernudge.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:48', '2024-04-12 14:05:48');
INSERT INTO `games` VALUES (1236, 21, NULL, 'vs10runes', 'Gates of Valhalla', 'pragmaticplay-gates-of-valhalla', NULL, NULL, 'fivers/pragmaticplay-gates-of-valhalla.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:49', '2024-04-12 14:05:49');
INSERT INTO `games` VALUES (1237, 21, NULL, 'prag-slot-emerald-king-rainbow-road', 'Emerald King Rainbow Road', 'pragmaticplay-emerald-king-rainbow-road', NULL, NULL, 'fivers/pragmaticplay-emerald-king-rainbow-road.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:49', '2024-04-12 14:05:49');
INSERT INTO `games` VALUES (1238, 21, NULL, 'vs20magicpot', 'The Magic Cauldron', 'pragmaticplay-the-magic-cauldron', NULL, NULL, 'fivers/pragmaticplay-the-magic-cauldron.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:50', '2024-04-12 14:05:50');
INSERT INTO `games` VALUES (1239, 23, NULL, 'evoplay_5935', 'Rueda De Chile Bonus Buy', 'evoplay-rueda-de-chile-bonus-buy', NULL, NULL, 'fivers/evoplay-rueda-de-chile-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:50', '2024-04-12 14:05:50');
INSERT INTO `games` VALUES (1240, 23, NULL, 'evoplay_5855', 'Budai Reels Bonus Buy', 'evoplay-budai-reels-bonus-buy', NULL, NULL, 'fivers/evoplay-budai-reels-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:51', '2024-04-12 14:05:51');
INSERT INTO `games` VALUES (1241, 21, NULL, 'vs10bookoftut', 'Book of Tut', 'pragmaticplay-book-of-tut', NULL, NULL, 'fivers/pragmaticplay-book-of-tut.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:51', '2024-04-12 14:05:51');
INSERT INTO `games` VALUES (1242, 21, NULL, 'vs5drhs', 'Dragon Hot Hold & Spin', 'pragmaticplay-dragon-hot-hold-spin', NULL, NULL, 'fivers/pragmaticplay-dragon-hot-hold-spin.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:52', '2024-04-12 14:05:52');
INSERT INTO `games` VALUES (1243, 21, NULL, 'vs5littlegem', 'Little Gem Hold and Spin', 'pragmaticplay-little-gem-hold-and-spin', NULL, NULL, 'fivers/pragmaticplay-little-gem-hold-and-spin.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:53', '2024-04-12 14:05:53');
INSERT INTO `games` VALUES (1244, 21, NULL, 'prag-slot-might-of-ra', 'Might of Ra', 'pragmaticplay-might-of-ra', NULL, NULL, 'fivers/pragmaticplay-might-of-ra.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:53', '2024-04-12 14:05:53');
INSERT INTO `games` VALUES (1245, 21, NULL, 'vswaysconcoll', 'Firebird Spirit - Connect & Collect', 'pragmaticplay-firebird-spirit-connect-collect', NULL, NULL, 'fivers/pragmaticplay-firebird-spirit-connect-collect.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:54', '2024-04-12 14:05:54');
INSERT INTO `games` VALUES (1246, 22, NULL, 'mj-slot-80-fruit-dash', '80 Fruit Dash', '7-mojos-slots-80-fruit-dash', NULL, NULL, 'fivers/7-mojos-slots-80-fruit-dash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:54', '2024-04-12 14:05:54');
INSERT INTO `games` VALUES (1247, 21, NULL, 'vswaysfltdrg', 'Floating Dragon Hold & Spin Megaways', 'pragmaticplay-floating-dragon-hold-spin-megaways', NULL, NULL, 'fivers/pragmaticplay-floating-dragon-hold-spin-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:55', '2024-04-12 14:05:55');
INSERT INTO `games` VALUES (1248, 21, NULL, 'vswaysfrywld', 'Spin & Score Megaways', 'pragmaticplay-spin-score-megaways', NULL, NULL, 'fivers/pragmaticplay-spin-score-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:56', '2024-04-12 14:05:56');
INSERT INTO `games` VALUES (1249, 23, NULL, 'evoplay_229', 'Mega Greatest Catch', 'evoplay-mega-greatest-catch', NULL, NULL, 'fivers/evoplay-mega-greatest-catch.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:56', '2024-04-12 14:05:56');
INSERT INTO `games` VALUES (1250, 23, NULL, 'evoplay_5889', 'Money Minter', 'evoplay-money-minter', NULL, NULL, 'fivers/evoplay-money-minter.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:57', '2024-04-12 14:05:57');
INSERT INTO `games` VALUES (1251, 23, NULL, 'evoplay_586', 'Talismans of Fortune', 'evoplay-talismans-of-fortune', NULL, NULL, 'fivers/evoplay-talismans-of-fortune.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:57', '2024-04-12 14:05:57');
INSERT INTO `games` VALUES (1252, 22, NULL, 'mj-slot-big-5-africa', 'Big 5 Africa', '7-mojos-slots-big-5-africa', NULL, NULL, 'fivers/7-mojos-slots-big-5-africa.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:58', '2024-04-12 14:05:58');
INSERT INTO `games` VALUES (1253, 22, NULL, 'mj-slot-lucky-fruit-lines', 'Lucky Fruit Lines', '7-mojos-slots-lucky-fruit-lines', NULL, NULL, 'fivers/7-mojos-slots-lucky-fruit-lines.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:58', '2024-04-12 14:05:58');
INSERT INTO `games` VALUES (1254, 23, NULL, 'evoplay_5868', 'Temple of Thunder', 'evoplay-temple-of-thunder', NULL, NULL, 'fivers/evoplay-temple-of-thunder.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:05:59', '2024-04-12 14:05:59');
INSERT INTO `games` VALUES (1255, 21, NULL, 'vs10tut', 'Book Of Tut Respin', 'pragmaticplay-book-of-tut-respin', NULL, NULL, 'fivers/pragmaticplay-book-of-tut-respin.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:00', '2024-04-12 14:06:00');
INSERT INTO `games` VALUES (1256, 21, NULL, 'vs40spartaking', 'Spartan King', 'pragmaticplay-spartan-king', NULL, NULL, 'fivers/pragmaticplay-spartan-king.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:00', '2024-04-12 14:06:00');
INSERT INTO `games` VALUES (1257, 22, NULL, 'mj-slot-golden-vegas', 'Golden Vegas', '7-mojos-slots-golden-vegas', NULL, NULL, 'fivers/7-mojos-slots-golden-vegas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:01', '2024-04-12 14:06:01');
INSERT INTO `games` VALUES (1258, 23, NULL, 'evoplay_5823', 'Fruit Super Nova 80', 'evoplay-fruit-super-nova-80', NULL, NULL, 'fivers/evoplay-fruit-super-nova-80.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:01', '2024-04-12 14:06:01');
INSERT INTO `games` VALUES (1259, 23, NULL, 'evoplay_595', 'Chinese New Year', 'evoplay-chinese-new-year', NULL, NULL, 'fivers/evoplay-chinese-new-year.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:02', '2024-04-12 14:06:02');
INSERT INTO `games` VALUES (1260, 21, NULL, 'vs10eyestorm', 'Eye of the Storm', 'pragmaticplay-eye-of-the-storm', NULL, NULL, 'fivers/pragmaticplay-eye-of-the-storm.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:03', '2024-04-12 14:06:03');
INSERT INTO `games` VALUES (1261, 21, NULL, 'vs10mayangods', 'John Hunter And The Mayan Gods', 'pragmaticplay-john-hunter-and-the-mayan-gods', NULL, NULL, 'fivers/pragmaticplay-john-hunter-and-the-mayan-gods.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:03', '2024-04-12 14:06:03');
INSERT INTO `games` VALUES (1262, 21, NULL, 'vs10vampwolf', 'Vampires vs Wolves', 'pragmaticplay-vampires-vs-wolves', NULL, NULL, 'fivers/pragmaticplay-vampires-vs-wolves.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:04', '2024-04-12 14:06:04');
INSERT INTO `games` VALUES (1263, 22, NULL, 'mj-slot-wild-bandidos', 'Wild Bandidos', '7-mojos-slots-wild-bandidos', NULL, NULL, 'fivers/7-mojos-slots-wild-bandidos.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:04', '2024-04-12 14:06:04');
INSERT INTO `games` VALUES (1264, 23, NULL, 'evoplay_5742', 'Tree Of Light', 'evoplay-tree-of-light', NULL, NULL, 'fivers/evoplay-tree-of-light.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:05', '2024-04-12 14:06:05');
INSERT INTO `games` VALUES (1265, 21, NULL, 'vs10chkchase', 'Chicken Chase', 'pragmaticplay-chicken-chase', NULL, NULL, 'fivers/pragmaticplay-chicken-chase.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:06', '2024-04-12 14:06:06');
INSERT INTO `games` VALUES (1266, 21, NULL, 'vs10luckcharm', 'Lucky, Grace & Charm', 'pragmaticplay-lucky-grace-charm', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:06', '2024-04-12 14:06:06');
INSERT INTO `games` VALUES (1267, 22, NULL, 'mj-slot-60-ultra-classic-hot', '60 Ultra Classic Hot', '7-mojos-slots-60-ultra-classic-hot', NULL, NULL, 'fivers/7-mojos-slots-60-ultra-classic-hot.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:07', '2024-04-12 14:06:07');
INSERT INTO `games` VALUES (1268, 23, NULL, 'evoplay_5847', 'Budai Reels', 'evoplay-budai-reels', NULL, NULL, 'fivers/evoplay-budai-reels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:07', '2024-04-12 14:06:07');
INSERT INTO `games` VALUES (1269, 23, NULL, 'evoplay_5911', 'Money Minter Bonus Buy', 'evoplay-money-minter-bonus-buy', NULL, NULL, 'fivers/evoplay-money-minter-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:08', '2024-04-12 14:06:08');
INSERT INTO `games` VALUES (1270, 22, NULL, 'mj-slot-age-of-cleopatra', 'Age of Cleopatra', '7-mojos-slots-age-of-cleopatra', NULL, NULL, 'fivers/7-mojos-slots-age-of-cleopatra.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:08', '2024-04-12 14:06:08');
INSERT INTO `games` VALUES (1271, 23, NULL, 'evoplay_5763', 'Sweet Sugar', 'evoplay-sweet-sugar', NULL, NULL, 'fivers/evoplay-sweet-sugar.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:09', '2024-04-12 14:06:09');
INSERT INTO `games` VALUES (1272, 23, NULL, 'evoplay_5741', 'Fruit Nova', 'evoplay-fruit-nova', NULL, NULL, 'fivers/evoplay-fruit-nova.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:09', '2024-04-12 14:06:09');
INSERT INTO `games` VALUES (1273, 22, NULL, 'mj-slot-bandidos-showdown', 'Bandidos Showdown', '7-mojos-slots-bandidos-showdown', NULL, NULL, 'fivers/7-mojos-slots-bandidos-showdown.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:10', '2024-04-12 14:06:10');
INSERT INTO `games` VALUES (1274, 23, NULL, 'evoplay_5517', 'Hot Triple Sevens', 'evoplay-hot-triple-sevens', NULL, NULL, 'fivers/evoplay-hot-triple-sevens.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:11', '2024-04-12 14:06:11');
INSERT INTO `games` VALUES (1275, 21, NULL, 'vs7776secrets', 'Aztec Treasure', 'pragmaticplay-aztec-treasure', NULL, NULL, 'fivers/pragmaticplay-aztec-treasure.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:11', '2024-04-12 14:06:11');
INSERT INTO `games` VALUES (1276, 23, NULL, 'evoplay_5797', 'Fruit Super Nova 100', 'evoplay-fruit-super-nova-100', NULL, NULL, 'fivers/evoplay-fruit-super-nova-100.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:12', '2024-04-12 14:06:12');
INSERT INTO `games` VALUES (1277, 22, NULL, 'mj-slot-fruit-dash', 'Fruit Dash', '7-mojos-slots-fruit-dash', NULL, NULL, 'fivers/7-mojos-slots-fruit-dash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:12', '2024-04-12 14:06:12');
INSERT INTO `games` VALUES (1278, 23, NULL, 'evoplay_5873', 'The Greatest Catch Bonus Buy', 'evoplay-the-greatest-catch-bonus-buy', NULL, NULL, 'fivers/evoplay-the-greatest-catch-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:13', '2024-04-12 14:06:13');
INSERT INTO `games` VALUES (1279, 24, NULL, 'eg-tb-jokerpoker_1', 'Joker Poker', 'genii-joker-poker', NULL, NULL, 'fivers/genii-joker-poker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:14', '2024-04-12 14:06:14');
INSERT INTO `games` VALUES (1280, 23, NULL, 'evoplay_5841', 'Wild Overlords', 'evoplay-wild-overlords', NULL, NULL, 'fivers/evoplay-wild-overlords.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:14', '2024-04-12 14:06:14');
INSERT INTO `games` VALUES (1281, 23, NULL, 'evoplay_5909', 'Hot Volcano Bonus Buy', 'evoplay-hot-volcano-bonus-buy', NULL, NULL, 'fivers/evoplay-hot-volcano-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:15', '2024-04-12 14:06:15');
INSERT INTO `games` VALUES (1282, 22, NULL, 'mj-slot-adventure-saga', 'Adventure Saga', '7-mojos-slots-adventure-saga', NULL, NULL, 'fivers/7-mojos-slots-adventure-saga.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:15', '2024-04-12 14:06:15');
INSERT INTO `games` VALUES (1283, 22, NULL, 'mj-slot-40-hot-twist', '40 Hot Twist', '7-mojos-slots-40-hot-twist', NULL, NULL, 'fivers/7-mojos-slots-40-hot-twist.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:16', '2024-04-12 14:06:16');
INSERT INTO `games` VALUES (1284, 22, NULL, 'mj-slot-ultra-classic-hot', 'Ultra Classic Hot', '7-mojos-slots-ultra-classic-hot', NULL, NULL, 'fivers/7-mojos-slots-ultra-classic-hot.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:16', '2024-04-12 14:06:16');
INSERT INTO `games` VALUES (1285, 22, NULL, 'mj-slot-underwater-adventure', 'Underwater Adventure', '7-mojos-slots-underwater-adventure', NULL, NULL, 'fivers/7-mojos-slots-underwater-adventure.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:17', '2024-04-12 14:06:17');
INSERT INTO `games` VALUES (1286, 23, NULL, 'evoplay_5879', 'Juicy Gems Bonus Buy', 'evoplay-juicy-gems-bonus-buy', NULL, NULL, 'fivers/evoplay-juicy-gems-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:18', '2024-04-12 14:06:18');
INSERT INTO `games` VALUES (1287, 21, NULL, 'vs20olympx', 'Gates of Olympus 1000', 'pragmaticplay-gates-of-olympus-1000', NULL, NULL, 'fivers/pragmaticplay-gates-of-olympus-1000.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:18', '2024-04-12 14:06:18');
INSERT INTO `games` VALUES (1288, 23, NULL, 'evoplay_5740', 'Ice Mania', 'evoplay-ice-mania', NULL, NULL, 'fivers/evoplay-ice-mania.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:19', '2024-04-12 14:06:19');
INSERT INTO `games` VALUES (1289, 23, NULL, 'evoplay_5999', 'X-Demon Bonus Buy', 'evoplay-x-demon-bonus-buy', NULL, NULL, 'fivers/evoplay-x-demon-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:19', '2024-04-12 14:06:19');
INSERT INTO `games` VALUES (1290, 22, NULL, 'mj-slot-rune-wars', 'Rune Wars', '7-mojos-slots-rune-wars', NULL, NULL, 'fivers/7-mojos-slots-rune-wars.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:20', '2024-04-12 14:06:20');
INSERT INTO `games` VALUES (1291, 23, NULL, 'evoplay_592', 'Robin Hood', 'evoplay-robin-hood', NULL, NULL, 'fivers/evoplay-robin-hood.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:21', '2024-04-12 14:06:21');
INSERT INTO `games` VALUES (1292, 23, NULL, 'evoplay_5923', 'Inner Fire Bonus Buy', 'evoplay-inner-fire-bonus-buy', NULL, NULL, 'fivers/evoplay-inner-fire-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:21', '2024-04-12 14:06:21');
INSERT INTO `games` VALUES (1293, 23, NULL, 'evoplay_5787', 'Gold of Sirens Bonus Buy', 'evoplay-gold-of-sirens-bonus-buy', NULL, NULL, 'fivers/evoplay-gold-of-sirens-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:22', '2024-04-12 14:06:22');
INSERT INTO `games` VALUES (1294, 23, NULL, 'evoplay_5922', 'Mega Greatest Catch Bonus Buy', 'evoplay-mega-greatest-catch-bonus-buy', NULL, NULL, 'fivers/evoplay-mega-greatest-catch-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:22', '2024-04-12 14:06:22');
INSERT INTO `games` VALUES (1295, 23, NULL, 'evoplay_5930', 'Wolf Hiding Bonus Buy', 'evoplay-wolf-hiding-bonus-buy', NULL, NULL, 'fivers/evoplay-wolf-hiding-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:23', '2024-04-12 14:06:23');
INSERT INTO `games` VALUES (1296, 23, NULL, 'evoplay_5969', 'Treasure-snipes', 'evoplay-treasure-snipes', NULL, NULL, 'fivers/evoplay-treasure-snipes.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:24', '2024-04-12 14:06:24');
INSERT INTO `games` VALUES (1297, 23, NULL, 'evoplay_1635', 'Football', 'evoplay-football', NULL, NULL, 'fivers/evoplay-football.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:24', '2024-04-12 14:06:24');
INSERT INTO `games` VALUES (1298, 23, NULL, 'evoplay_4408', 'Trip to the Future', 'evoplay-trip-to-the-future', NULL, NULL, 'fivers/evoplay-trip-to-the-future.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:25', '2024-04-12 14:06:25');
INSERT INTO `games` VALUES (1299, 23, NULL, 'evoplay_220', 'Camino de Chili Bonus Buy', 'evoplay-camino-de-chili-bonus-buy', NULL, NULL, 'fivers/evoplay-camino-de-chili-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:25', '2024-04-12 14:06:25');
INSERT INTO `games` VALUES (1300, 23, NULL, 'evoplay_5947', 'Expanding Master', 'evoplay-expanding-master', NULL, NULL, 'fivers/evoplay-expanding-master.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:26', '2024-04-12 14:06:26');
INSERT INTO `games` VALUES (1301, 23, NULL, 'evoplay_5758', 'Ellen\'s Fortune', 'evoplay-ellens-fortune', NULL, NULL, 'fivers/evoplay-ellens-fortune.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:26', '2024-04-12 14:06:26');
INSERT INTO `games` VALUES (1302, 23, NULL, 'evoplay_556', 'Egypt Gods', 'evoplay-egypt-gods', NULL, NULL, 'fivers/evoplay-egypt-gods.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:27', '2024-04-12 14:06:27');
INSERT INTO `games` VALUES (1303, 23, NULL, 'evoplay_5813', 'Hot Triple Sevens Special', 'evoplay-hot-triple-sevens-special', NULL, NULL, 'fivers/evoplay-hot-triple-sevens-special.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:28', '2024-04-12 14:06:28');
INSERT INTO `games` VALUES (1304, 23, NULL, 'evoplay_2295', 'Candy Dreams', 'evoplay-candy-dreams', NULL, NULL, 'fivers/evoplay-candy-dreams.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:28', '2024-04-12 14:06:28');
INSERT INTO `games` VALUES (1305, 23, NULL, 'evoplay_5778', 'Shadow Of Luxor', 'evoplay-shadow-of-luxor', NULL, NULL, 'fivers/evoplay-shadow-of-luxor.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:29', '2024-04-12 14:06:29');
INSERT INTO `games` VALUES (1306, 23, NULL, 'evoplay_5857', 'Wild Overlords Bonus Buy', 'evoplay-wild-overlords-bonus-buy', NULL, NULL, 'fivers/evoplay-wild-overlords-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:29', '2024-04-12 14:06:29');
INSERT INTO `games` VALUES (1307, 23, NULL, 'evoplay_5789', 'Anubis Moon', 'evoplay-anubis-moon', NULL, NULL, 'fivers/evoplay-anubis-moon.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:30', '2024-04-12 14:06:30');
INSERT INTO `games` VALUES (1308, 23, NULL, 'evoplay_1290', 'Elven Princesses', 'evoplay-elven-princesses', NULL, NULL, 'fivers/evoplay-elven-princesses.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:31', '2024-04-12 14:06:31');
INSERT INTO `games` VALUES (1309, 23, NULL, 'evoplay_1707', 'The Emperor\'s Tomb', 'evoplay-the-emperors-tomb', NULL, NULL, 'fivers/evoplay-the-emperors-tomb.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:31', '2024-04-12 14:06:31');
INSERT INTO `games` VALUES (1310, 23, NULL, 'evoplay_5401', 'Reign of Dragons', 'evoplay-reign-of-dragons', NULL, NULL, 'fivers/evoplay-reign-of-dragons.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:32', '2024-04-12 14:06:32');
INSERT INTO `games` VALUES (1311, 23, NULL, 'evoplay_5795', 'Fruit Super Nova 60', 'evoplay-fruit-super-nova-60', NULL, NULL, 'fivers/evoplay-fruit-super-nova-60.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:32', '2024-04-12 14:06:32');
INSERT INTO `games` VALUES (1312, 23, NULL, 'evoplay_5893', 'Candy Dreams: Sweet Planet', 'evoplay-candy-dreams-sweet-planet', NULL, NULL, 'fivers/evoplay-candy-dreams-sweet-planet.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:33', '2024-04-12 14:06:33');
INSERT INTO `games` VALUES (1313, 23, NULL, 'evoplay_5793', 'Fruit Super Nova 30', 'evoplay-fruit-super-nova-30', NULL, NULL, 'fivers/evoplay-fruit-super-nova-30.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:33', '2024-04-12 14:06:33');
INSERT INTO `games` VALUES (1314, 23, NULL, 'evoplay_2922', 'Fruits Land', 'evoplay-fruits-land', NULL, NULL, 'fivers/evoplay-fruits-land.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:34', '2024-04-12 14:06:34');
INSERT INTO `games` VALUES (1315, 23, NULL, 'evoplay_5659', 'Exploding Fruits', 'evoplay-exploding-fruits', NULL, NULL, 'fivers/evoplay-exploding-fruits.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:35', '2024-04-12 14:06:35');
INSERT INTO `games` VALUES (1316, 23, NULL, 'evoplay_4384', 'Lucky Girls', 'evoplay-lucky-girls', NULL, NULL, 'fivers/evoplay-lucky-girls.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:35', '2024-04-12 14:06:35');
INSERT INTO `games` VALUES (1317, 21, NULL, 'vs20starlightx', 'Starlight Princess 1000', 'pragmaticplay-starlight-princess-1000', NULL, NULL, 'fivers/pragmaticplay-starlight-princess-1000.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:36', '2024-04-12 14:06:36');
INSERT INTO `games` VALUES (1318, 23, NULL, 'evoplay_5963', 'Hot Rio Nights Bonus Buy', 'evoplay-hot-rio-nights-bonus-buy', NULL, NULL, 'fivers/evoplay-hot-rio-nights-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:36', '2024-04-12 14:06:36');
INSERT INTO `games` VALUES (1319, 23, NULL, 'evoplay_5887', 'Tree Of Light Bonus Buy', 'evoplay-tree-of-light-bonus-buy', NULL, NULL, 'fivers/evoplay-tree-of-light-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:37', '2024-04-12 14:06:37');
INSERT INTO `games` VALUES (1320, 23, NULL, 'evoplay_5783', 'Cycle of Luck Bonus Buy', 'evoplay-cycle-of-luck-bonus-buy', NULL, NULL, 'fivers/evoplay-cycle-of-luck-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:38', '2024-04-12 14:06:38');
INSERT INTO `games` VALUES (1321, 23, NULL, 'evoplay_5752', 'Fruit Super Nova', 'evoplay-fruit-super-nova', NULL, NULL, 'fivers/evoplay-fruit-super-nova.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:38', '2024-04-12 14:06:38');
INSERT INTO `games` VALUES (1322, 23, NULL, 'evoplay_5877', 'Juicy Gems', 'evoplay-juicy-gems', NULL, NULL, 'fivers/evoplay-juicy-gems.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:39', '2024-04-12 14:06:39');
INSERT INTO `games` VALUES (1323, 23, NULL, 'evoplay_5897', 'Camino de Chili', 'evoplay-camino-de-chili', NULL, NULL, 'fivers/evoplay-camino-de-chili.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:39', '2024-04-12 14:06:39');
INSERT INTO `games` VALUES (1324, 23, NULL, 'evoplay_2931', 'Charming Queens', 'evoplay-charming-queens', NULL, NULL, 'fivers/evoplay-charming-queens.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:40', '2024-04-12 14:06:40');
INSERT INTO `games` VALUES (1325, 23, NULL, 'evoplay_583', 'Basketball', 'evoplay-basketball', NULL, NULL, 'fivers/evoplay-basketball.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:40', '2024-04-12 14:06:40');
INSERT INTO `games` VALUES (1326, 23, NULL, 'evoplay_5751', 'Wild Bullets', 'evoplay-wild-bullets', NULL, NULL, 'fivers/evoplay-wild-bullets.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:41', '2024-04-12 14:06:41');
INSERT INTO `games` VALUES (1327, 23, NULL, 'evoplay_5939', 'Redrose Sanctuary Bonus Buy', 'evoplay-redrose-sanctuary-bonus-buy', NULL, NULL, 'fivers/evoplay-redrose-sanctuary-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:42', '2024-04-12 14:06:42');
INSERT INTO `games` VALUES (1328, 15, NULL, 'HelicopterX', 'HelicopterX', 'smartsoft-helicopterx', NULL, NULL, 'fivers/smartsoft-helicopterx.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:42', '2024-04-12 14:06:42');
INSERT INTO `games` VALUES (1329, 23, NULL, 'evoplay_5871', 'The Greatest Catch', 'evoplay-the-greatest-catch', NULL, NULL, 'fivers/evoplay-the-greatest-catch.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:43', '2024-04-12 14:06:43');
INSERT INTO `games` VALUES (1330, 23, NULL, 'evoplay_5941', 'Treasure-snipes: Christmas', 'evoplay-treasure-snipes-christmas', NULL, NULL, 'fivers/evoplay-treasure-snipes-christmas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:43', '2024-04-12 14:06:43');
INSERT INTO `games` VALUES (1331, 23, NULL, 'evoplay_2292', 'Robinson', 'evoplay-robinson', NULL, NULL, 'fivers/evoplay-robinson.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:44', '2024-04-12 14:06:44');
INSERT INTO `games` VALUES (1332, 23, NULL, 'evoplay_5995', 'Unlimited Treasures Bonus Buy', 'evoplay-unlimited-treasures-bonus-buy', NULL, NULL, 'fivers/evoplay-unlimited-treasures-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:45', '2024-04-12 14:06:45');
INSERT INTO `games` VALUES (1333, 23, NULL, 'evoplay_5677', 'Surf Zone', 'evoplay-surf-zone', NULL, NULL, 'fivers/evoplay-surf-zone.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:45', '2024-04-12 14:06:45');
INSERT INTO `games` VALUES (1334, 23, NULL, 'evoplay_5902', 'Hot Volcano', 'evoplay-hot-volcano', NULL, NULL, 'fivers/evoplay-hot-volcano.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:46', '2024-04-12 14:06:46');
INSERT INTO `games` VALUES (1335, 23, NULL, 'evoplay_5695', 'Jelly Boom', 'evoplay-jelly-boom', NULL, NULL, 'fivers/evoplay-jelly-boom.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:46', '2024-04-12 14:06:46');
INSERT INTO `games` VALUES (1336, 23, NULL, 'evoplay_5907', 'Candy Dreams Sweet Planet Bonus Buy', 'evoplay-candy-dreams-sweet-planet-bonus-buy', NULL, NULL, 'fivers/evoplay-candy-dreams-sweet-planet-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:47', '2024-04-12 14:06:47');
INSERT INTO `games` VALUES (1337, 23, NULL, 'evoplay_6015', 'Northern Temple', 'evoplay-northern-temple', NULL, NULL, 'fivers/evoplay-northern-temple.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:47', '2024-04-12 14:06:47');
INSERT INTO `games` VALUES (1338, 23, NULL, 'evoplay_5547', 'Animal Quest', 'evoplay-animal-quest', NULL, NULL, 'fivers/evoplay-animal-quest.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:48', '2024-04-12 14:06:48');
INSERT INTO `games` VALUES (1339, 23, NULL, 'evoplay_5829', 'Dragon\'s Tavern', 'evoplay-dragons-tavern', NULL, NULL, 'fivers/evoplay-dragons-tavern.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:49', '2024-04-12 14:06:49');
INSERT INTO `games` VALUES (1340, 23, NULL, 'evoplay_5801', 'Triple Chili', 'evoplay-triple-chili', NULL, NULL, 'fivers/evoplay-triple-chili.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:49', '2024-04-12 14:06:49');
INSERT INTO `games` VALUES (1341, 23, NULL, 'evoplay_5919', 'Rueda De Chile', 'evoplay-rueda-de-chile', NULL, NULL, 'fivers/evoplay-rueda-de-chile.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:50', '2024-04-12 14:06:50');
INSERT INTO `games` VALUES (1342, 23, NULL, 'evoplay_5791', 'Fruit Disco', 'evoplay-fruit-disco', NULL, NULL, 'fivers/evoplay-fruit-disco.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:50', '2024-04-12 14:06:50');
INSERT INTO `games` VALUES (1343, 23, NULL, 'evoplay_2374', 'Battle Tanks', 'evoplay-battle-tanks', NULL, NULL, 'fivers/evoplay-battle-tanks.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:51', '2024-04-12 14:06:51');
INSERT INTO `games` VALUES (1344, 23, NULL, 'evoplay_5479', 'Brutal Santa', 'evoplay-brutal-santa', NULL, NULL, 'fivers/evoplay-brutal-santa.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:52', '2024-04-12 14:06:52');
INSERT INTO `games` VALUES (1345, 23, NULL, 'evoplay_589', 'The Great Wall Treasure', 'evoplay-the-great-wall-treasure', NULL, NULL, 'fivers/evoplay-the-great-wall-treasure.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:52', '2024-04-12 14:06:52');
INSERT INTO `games` VALUES (1346, 23, NULL, 'evoplay_5777', 'Temple Of Dead Bonus Buy', 'evoplay-temple-of-dead-bonus-buy', NULL, NULL, 'fivers/evoplay-temple-of-dead-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:53', '2024-04-12 14:06:53');
INSERT INTO `games` VALUES (1347, 23, NULL, 'evoplay_957', 'Indiana\'s Quest', 'evoplay-indianas-quest', NULL, NULL, 'fivers/evoplay-indianas-quest.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:53', '2024-04-12 14:06:53');
INSERT INTO `games` VALUES (1348, 23, NULL, 'evoplay_5775', 'Fruit Super Nova 40', 'evoplay-fruit-super-nova-40', NULL, NULL, 'fivers/evoplay-fruit-super-nova-40.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:54', '2024-04-12 14:06:54');
INSERT INTO `games` VALUES (1349, 21, NULL, 'vs20maskgame', 'Cash Chips', 'pragmaticplay-cash-chips', NULL, NULL, 'fivers/pragmaticplay-cash-chips.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:55', '2024-04-12 14:06:55');
INSERT INTO `games` VALUES (1350, 23, NULL, 'evoplay_5991', 'X-Demon', 'evoplay-x-demon', NULL, NULL, 'fivers/evoplay-x-demon.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:55', '2024-04-12 14:06:55');
INSERT INTO `games` VALUES (1351, 23, NULL, 'evoplay_610', 'Clash of Pirates', 'evoplay-clash-of-pirates', NULL, NULL, 'fivers/evoplay-clash-of-pirates.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:56', '2024-04-12 14:06:56');
INSERT INTO `games` VALUES (1352, 23, NULL, 'evoplay_5981', 'Irish Weekend', 'evoplay-irish-weekend', NULL, NULL, 'fivers/evoplay-irish-weekend.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:56', '2024-04-12 14:06:56');
INSERT INTO `games` VALUES (1353, 23, NULL, 'evoplay_4399', 'Robots: Energy Conflict', 'evoplay-robots-energy-conflict', NULL, NULL, 'fivers/evoplay-robots-energy-conflict.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:57', '2024-04-12 14:06:57');
INSERT INTO `games` VALUES (1354, 23, NULL, 'evoplay_5913', 'Redrose Sanctuary', 'evoplay-redrose-sanctuary', NULL, NULL, 'fivers/evoplay-redrose-sanctuary.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:57', '2024-04-12 14:06:57');
INSERT INTO `games` VALUES (1355, 23, NULL, 'evoplay_5921', 'Inner Fire', 'evoplay-inner-fire', NULL, NULL, 'fivers/evoplay-inner-fire.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:58', '2024-04-12 14:06:58');
INSERT INTO `games` VALUES (1356, 23, NULL, 'evoplay_5979', 'Wonder Farm', 'evoplay-wonder-farm', NULL, NULL, 'fivers/evoplay-wonder-farm.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:59', '2024-04-12 14:06:59');
INSERT INTO `games` VALUES (1357, 21, NULL, 'vs50jucier', 'Sky Bounty', 'pragmaticplay-sky-bounty', NULL, NULL, 'fivers/pragmaticplay-sky-bounty.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:06:59', '2024-04-12 14:06:59');
INSERT INTO `games` VALUES (1358, 23, NULL, 'evoplay_5452', 'Dungeon: Immortal Evil', 'evoplay-dungeon-immortal-evil', NULL, NULL, 'fivers/evoplay-dungeon-immortal-evil.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:00', '2024-04-12 14:07:00');
INSERT INTO `games` VALUES (1359, 23, NULL, 'evoplay_5901', 'Wolf Hiding', 'evoplay-wolf-hiding', NULL, NULL, 'fivers/evoplay-wolf-hiding.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:00', '2024-04-12 14:07:00');
INSERT INTO `games` VALUES (1360, 23, NULL, 'evoplay_5973', 'Treasure-snipes Bonus Buy', 'evoplay-treasure-snipes-bonus-buy', NULL, NULL, 'fivers/evoplay-treasure-snipes-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:01', '2024-04-12 14:07:01');
INSERT INTO `games` VALUES (1361, 23, NULL, 'evoplay_5749', 'Treasure Mania', 'evoplay-treasure-mania', NULL, NULL, 'fivers/evoplay-treasure-mania.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:02', '2024-04-12 14:07:02');
INSERT INTO `games` VALUES (1362, 23, NULL, 'evoplay_5569', 'Rise Of Horus', 'evoplay-rise-of-horus', NULL, NULL, 'fivers/evoplay-rise-of-horus.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:02', '2024-04-12 14:07:02');
INSERT INTO `games` VALUES (1363, 23, NULL, 'evoplay_1614', 'Fruit Burst', 'evoplay-fruit-burst', NULL, NULL, 'fivers/evoplay-fruit-burst.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:03', '2024-04-12 14:07:03');
INSERT INTO `games` VALUES (1364, 23, NULL, 'evoplay_655', 'Jewellery Store', 'evoplay-jewellery-store', NULL, NULL, 'fivers/evoplay-jewellery-store.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:03', '2024-04-12 14:07:03');
INSERT INTO `games` VALUES (1365, 23, NULL, 'evoplay_5773', 'Gold Of Sirens', 'evoplay-gold-of-sirens', NULL, NULL, 'fivers/evoplay-gold-of-sirens.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:04', '2024-04-12 14:07:04');
INSERT INTO `games` VALUES (1366, 23, NULL, 'evoplay_5845', 'Dragon\'s Tavern Bonus Buy', 'evoplay-dragons-tavern-bonus-buy', NULL, NULL, 'fivers/evoplay-dragons-tavern-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:04', '2024-04-12 14:07:04');
INSERT INTO `games` VALUES (1367, 25, NULL, 'mj-live-teen-patti', 'Teen Patti', 'games-inc-teen-patti', NULL, NULL, 'fivers/games-inc-teen-patti.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:05', '2024-04-12 14:07:05');
INSERT INTO `games` VALUES (1368, 23, NULL, 'evoplay_5760', 'Food Feast', 'evoplay-food-feast', NULL, NULL, 'fivers/evoplay-food-feast.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:06', '2024-04-12 14:07:06');
INSERT INTO `games` VALUES (1369, 23, NULL, 'evoplay_5943', 'Collapsed Castle Bonus Buy', 'evoplay-collapsed-castle-bonus-buy', NULL, NULL, 'fivers/evoplay-collapsed-castle-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:06', '2024-04-12 14:07:06');
INSERT INTO `games` VALUES (1370, 23, NULL, 'evoplay_5951', 'Hot Rio Nights', 'evoplay-hot-rio-nights', NULL, NULL, 'fivers/evoplay-hot-rio-nights.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:07', '2024-04-12 14:07:07');
INSERT INTO `games` VALUES (1371, 23, NULL, 'evoplay_2919', 'Mystery Planet', 'evoplay-mystery-planet', NULL, NULL, 'fivers/evoplay-mystery-planet.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:07', '2024-04-12 14:07:07');
INSERT INTO `games` VALUES (1372, 23, NULL, 'evoplay_2371', 'The Great Conflict', 'evoplay-the-great-conflict', NULL, NULL, 'fivers/evoplay-the-great-conflict.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:08', '2024-04-12 14:07:08');
INSERT INTO `games` VALUES (1373, 23, NULL, 'evoplay_5997', 'Neon Capital Bonus Buy', 'evoplay-neon-capital-bonus-buy', NULL, NULL, 'fivers/evoplay-neon-capital-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:09', '2024-04-12 14:07:09');
INSERT INTO `games` VALUES (1374, 23, NULL, 'evoplay_5762', 'Epic Legends', 'evoplay-epic-legends', NULL, NULL, 'fivers/evoplay-epic-legends.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:09', '2024-04-12 14:07:09');
INSERT INTO `games` VALUES (1375, 23, NULL, 'evoplay_5653', 'Midnight Show', 'evoplay-midnight-show', NULL, NULL, 'fivers/evoplay-midnight-show.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:10', '2024-04-12 14:07:10');
INSERT INTO `games` VALUES (1376, 23, NULL, 'evoplay_5759', 'Unlimited Wishes', 'evoplay-unlimited-wishes', NULL, NULL, 'fivers/evoplay-unlimited-wishes.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:10', '2024-04-12 14:07:10');
INSERT INTO `games` VALUES (1377, 23, NULL, 'evoplay_5493', 'Book of Rest', 'evoplay-book-of-rest', NULL, NULL, 'fivers/evoplay-book-of-rest.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:11', '2024-04-12 14:07:11');
INSERT INTO `games` VALUES (1378, 23, NULL, 'evoplay_2379', 'Dolphins Treasure', 'evoplay-dolphins-treasure', NULL, NULL, 'fivers/evoplay-dolphins-treasure.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:11', '2024-04-12 14:07:11');
INSERT INTO `games` VALUES (1379, 23, NULL, 'evoplay_5987', 'Unlimited Treasures', 'evoplay-unlimited-treasures', NULL, NULL, 'fivers/evoplay-unlimited-treasures.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:12', '2024-04-12 14:07:12');
INSERT INTO `games` VALUES (1380, 23, NULL, 'evoplay_5487', 'Hungry Night', 'evoplay-hungry-night', NULL, NULL, 'fivers/evoplay-hungry-night.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:13', '2024-04-12 14:07:13');
INSERT INTO `games` VALUES (1381, 23, NULL, 'evoplay_5717', 'Raccoon Tales', 'evoplay-raccoon-tales', NULL, NULL, 'fivers/evoplay-raccoon-tales.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:13', '2024-04-12 14:07:13');
INSERT INTO `games` VALUES (1382, 23, NULL, 'evoplay_5735', 'Jolly Treasures', 'evoplay-jolly-treasures', NULL, NULL, 'fivers/evoplay-jolly-treasures.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:14', '2024-04-12 14:07:14');
INSERT INTO `games` VALUES (1383, 23, NULL, 'evoplay_5985', 'Wonder Farm Bonus Buy', 'evoplay-wonder-farm-bonus-buy', NULL, NULL, 'fivers/evoplay-wonder-farm-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:14', '2024-04-12 14:07:14');
INSERT INTO `games` VALUES (1384, 23, NULL, 'evoplay_5989', 'Irish Weekend Bonus Buy', 'evoplay-irish-weekend-bonus-buy', NULL, NULL, 'fivers/evoplay-irish-weekend-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:15', '2024-04-12 14:07:15');
INSERT INTO `games` VALUES (1385, 23, NULL, 'evoplay_5957', 'Treasure-snipes: Christmas Bonus Buy', 'evoplay-treasure-snipes-christmas-bonus-buy', NULL, NULL, 'fivers/evoplay-treasure-snipes-christmas-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:16', '2024-04-12 14:07:16');
INSERT INTO `games` VALUES (1386, 23, NULL, 'evoplay_5593', 'Rocket Stars', 'evoplay-rocket-stars', NULL, NULL, 'fivers/evoplay-rocket-stars.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:16', '2024-04-12 14:07:16');
INSERT INTO `games` VALUES (1387, 23, NULL, 'evoplay_5959', 'Sold it Bonus Buy', 'evoplay-sold-it-bonus-buy', NULL, NULL, 'fivers/evoplay-sold-it-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:17', '2024-04-12 14:07:17');
INSERT INTO `games` VALUES (1388, 23, NULL, 'evoplay_5755', 'Runes Of Destiny', 'evoplay-runes-of-destiny', NULL, NULL, 'fivers/evoplay-runes-of-destiny.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:17', '2024-04-12 14:07:17');
INSERT INTO `games` VALUES (1389, 23, NULL, 'evoplay_5746', 'Temple Of Dead', 'evoplay-temple-of-dead', NULL, NULL, 'fivers/evoplay-temple-of-dead.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:18', '2024-04-12 14:07:18');
INSERT INTO `games` VALUES (1390, 23, NULL, 'evoplay_1704', 'Legend of Ra', 'evoplay-legend-of-ra', NULL, NULL, 'fivers/evoplay-legend-of-ra.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:18', '2024-04-12 14:07:18');
INSERT INTO `games` VALUES (1391, 23, NULL, 'evoplay_5926', 'Collapsed Castle', 'evoplay-collapsed-castle', NULL, NULL, 'fivers/evoplay-collapsed-castle.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:19', '2024-04-12 14:07:19');
INSERT INTO `games` VALUES (1392, 23, NULL, 'evoplay_2247', 'Epic Gladiators', 'evoplay-epic-gladiators', NULL, NULL, 'fivers/evoplay-epic-gladiators.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:20', '2024-04-12 14:07:20');
INSERT INTO `games` VALUES (1393, 23, NULL, 'evoplay_5485', 'Legend of Kaan', 'evoplay-legend-of-kaan', NULL, NULL, 'fivers/evoplay-legend-of-kaan.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:20', '2024-04-12 14:07:20');
INSERT INTO `games` VALUES (1394, 23, NULL, 'evoplay_6009', 'Goddess of the Night', 'evoplay-goddess-of-the-night', NULL, NULL, 'fivers/evoplay-goddess-of-the-night.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:21', '2024-04-12 14:07:21');
INSERT INTO `games` VALUES (1395, 23, NULL, 'evoplay_5905', 'Massive Luck Bonus Buy', 'evoplay-massive-luck-bonus-buy', NULL, NULL, 'fivers/evoplay-massive-luck-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:21', '2024-04-12 14:07:21');
INSERT INTO `games` VALUES (1396, 23, NULL, 'evoplay_5977', 'Book Of The Priestess Bonus Buy', 'evoplay-book-of-the-priestess-bonus-buy', NULL, NULL, 'fivers/evoplay-book-of-the-priestess-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:22', '2024-04-12 14:07:22');
INSERT INTO `games` VALUES (1397, 23, NULL, 'evoplay_5766', 'Cycle of Luck', 'evoplay-cycle-of-luck', NULL, NULL, 'fivers/evoplay-cycle-of-luck.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:22', '2024-04-12 14:07:22');
INSERT INTO `games` VALUES (1398, 24, NULL, 'eg-tb-jacksorbetter_1', 'Jacks or Better', 'genii-jacks-or-better', NULL, NULL, 'fivers/genii-jacks-or-better.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:23', '2024-04-12 14:07:23');
INSERT INTO `games` VALUES (1399, 23, NULL, 'evoplay_5455', 'Sprinkle', 'evoplay-sprinkle', NULL, NULL, 'fivers/evoplay-sprinkle.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:24', '2024-04-12 14:07:24');
INSERT INTO `games` VALUES (1400, 23, NULL, 'evoplay_5727', 'Forgotten Fable', 'evoplay-forgotten-fable', NULL, NULL, 'fivers/evoplay-forgotten-fable.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:24', '2024-04-12 14:07:24');
INSERT INTO `games` VALUES (1401, 23, NULL, 'evoplay_5738', 'Valley Of Dreams', 'evoplay-valley-of-dreams', NULL, NULL, 'fivers/evoplay-valley-of-dreams.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:25', '2024-04-12 14:07:25');
INSERT INTO `games` VALUES (1402, 23, NULL, 'evoplay_5867', 'Blessed Flame', 'evoplay-blessed-flame', NULL, NULL, 'fivers/evoplay-blessed-flame.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:25', '2024-04-12 14:07:25');
INSERT INTO `games` VALUES (1403, 23, NULL, 'evoplay_5641', 'Fluffy Rangers', 'evoplay-fluffy-rangers', NULL, NULL, 'fivers/evoplay-fluffy-rangers.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:26', '2024-04-12 14:07:26');
INSERT INTO `games` VALUES (1404, 23, NULL, 'evoplay_5737', 'Night Of The Living Tales', 'evoplay-night-of-the-living-tales', NULL, NULL, 'fivers/evoplay-night-of-the-living-tales.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:27', '2024-04-12 14:07:27');
INSERT INTO `games` VALUES (1405, 21, NULL, 'vs25jeitinho', 'Jeitinho Brasileiro', 'pragmaticplay-jeitinho-brasileiro', NULL, NULL, 'fivers/pragmaticplay-jeitinho-brasileiro.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:27', '2024-04-12 14:07:27');
INSERT INTO `games` VALUES (1406, 23, NULL, 'evoplay_882', 'Red Cliff', 'evoplay-red-cliff', NULL, NULL, 'fivers/evoplay-red-cliff.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:28', '2024-04-12 14:07:28');
INSERT INTO `games` VALUES (1407, 23, NULL, 'evoplay_5833', 'Christmas Reach Bonus Buy', 'evoplay-christmas-reach-bonus-buy', NULL, NULL, 'fivers/evoplay-christmas-reach-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:28', '2024-04-12 14:07:28');
INSERT INTO `games` VALUES (1408, 23, NULL, 'evoplay_5774', 'Bloody Brilliant', 'evoplay-bloody-brilliant', NULL, NULL, 'fivers/evoplay-bloody-brilliant.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:29', '2024-04-12 14:07:29');
INSERT INTO `games` VALUES (1409, 23, NULL, 'evoplay_5551', 'Irish Reels', 'evoplay-irish-reels', NULL, NULL, 'fivers/evoplay-irish-reels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:29', '2024-04-12 14:07:29');
INSERT INTO `games` VALUES (1410, 23, NULL, 'evoplay_5805', 'Curse of the Pharaoh Bonus Buy', 'evoplay-curse-of-the-pharaoh-bonus-buy', NULL, NULL, 'fivers/evoplay-curse-of-the-pharaoh-bonus-buy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:30', '2024-04-12 14:07:30');
INSERT INTO `games` VALUES (1411, 23, NULL, 'evoplay_5993', 'Neon Capital', 'evoplay-neon-capital', NULL, NULL, 'fivers/evoplay-neon-capital.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:31', '2024-04-12 14:07:31');
INSERT INTO `games` VALUES (1412, 23, NULL, 'evoplay_5799', 'Curse of the Pharaoh', 'evoplay-curse-of-the-pharaoh', NULL, NULL, 'fivers/evoplay-curse-of-the-pharaoh.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:31', '2024-04-12 14:07:31');
INSERT INTO `games` VALUES (1413, 23, NULL, 'evoplay_5815', 'Christmas Reach', 'evoplay-christmas-reach', NULL, NULL, 'fivers/evoplay-christmas-reach.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:32', '2024-04-12 14:07:32');
INSERT INTO `games` VALUES (1414, 23, NULL, 'evoplay_2241', 'Naughty Girls Cabaret', 'evoplay-naughty-girls-cabaret', NULL, NULL, 'fivers/evoplay-naughty-girls-cabaret.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:32', '2024-04-12 14:07:32');
INSERT INTO `games` VALUES (1415, 23, NULL, 'evoplay_5089', 'E.T. Lost Socks', 'evoplay-et-lost-socks', NULL, NULL, 'fivers/evoplay-et-lost-socks.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:33', '2024-04-12 14:07:33');
INSERT INTO `games` VALUES (1416, 23, NULL, 'evoplay_2331', 'The Slavs', 'evoplay-the-slavs', NULL, NULL, 'fivers/evoplay-the-slavs.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:34', '2024-04-12 14:07:34');
INSERT INTO `games` VALUES (1417, 23, NULL, 'evoplay_1287', 'Ace Round', 'evoplay-ace-round', NULL, NULL, 'fivers/evoplay-ace-round.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:34', '2024-04-12 14:07:34');
INSERT INTO `games` VALUES (1418, 23, NULL, 'evoplay_2344', 'Aeronauts', 'evoplay-aeronauts', NULL, NULL, 'fivers/evoplay-aeronauts.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:35', '2024-04-12 14:07:35');
INSERT INTO `games` VALUES (1419, 23, NULL, 'evoplay_5949', 'Sold it', 'evoplay-sold-it', NULL, NULL, 'fivers/evoplay-sold-it.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:35', '2024-04-12 14:07:35');
INSERT INTO `games` VALUES (1420, 23, NULL, 'evoplay_1956', 'Necromancer', 'evoplay-necromancer', NULL, NULL, 'fivers/evoplay-necromancer.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:36', '2024-04-12 14:07:36');
INSERT INTO `games` VALUES (1421, 23, NULL, 'evoplay_5398', 'Nuke World', 'evoplay-nuke-world', NULL, NULL, 'fivers/evoplay-nuke-world.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:36', '2024-04-12 14:07:36');
INSERT INTO `games` VALUES (1422, 23, NULL, 'evoplay_5527', 'Season sisters', 'evoplay-season-sisters', NULL, NULL, 'fivers/evoplay-season-sisters.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:37', '2024-04-12 14:07:37');
INSERT INTO `games` VALUES (1423, 23, NULL, 'evoplay_5673', 'Sea of Spins', 'evoplay-sea-of-spins', NULL, NULL, 'fivers/evoplay-sea-of-spins.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:38', '2024-04-12 14:07:38');
INSERT INTO `games` VALUES (1424, 23, NULL, 'evoplay_5967', 'Book Of The Priestess', 'evoplay-book-of-the-priestess', NULL, NULL, 'fivers/evoplay-book-of-the-priestess.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:38', '2024-04-12 14:07:38');
INSERT INTO `games` VALUES (1425, 23, NULL, 'evoplay_5549', 'Rich Reels', 'evoplay-rich-reels', NULL, NULL, 'fivers/evoplay-rich-reels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:39', '2024-04-12 14:07:39');
INSERT INTO `games` VALUES (1426, 23, NULL, 'evoplay_5903', 'Massive Luck', 'evoplay-massive-luck', NULL, NULL, 'fivers/evoplay-massive-luck.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:39', '2024-04-12 14:07:39');
INSERT INTO `games` VALUES (1427, 23, NULL, 'evoplay_2368', 'Monster Lab', 'evoplay-monster-lab', NULL, NULL, 'fivers/evoplay-monster-lab.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:40', '2024-04-12 14:07:40');
INSERT INTO `games` VALUES (1428, 23, NULL, 'evoplay_5587', 'Western Reels', 'evoplay-western-reels', NULL, NULL, 'fivers/evoplay-western-reels.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:40', '2024-04-12 14:07:40');
INSERT INTO `games` VALUES (1429, 23, NULL, 'evoplay_5721', 'Forest Dreams', 'evoplay-forest-dreams', NULL, NULL, 'fivers/evoplay-forest-dreams.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:41', '2024-04-12 14:07:41');
INSERT INTO `games` VALUES (1430, 23, NULL, 'evoplay_4402', 'Syndicate', 'evoplay-syndicate', NULL, NULL, 'fivers/evoplay-syndicate.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:42', '2024-04-12 14:07:42');
INSERT INTO `games` VALUES (1431, 23, NULL, 'evoplay_5483', 'Maze', 'evoplay-maze', NULL, NULL, 'fivers/evoplay-maze.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:42', '2024-04-12 14:07:42');
INSERT INTO `games` VALUES (1432, 26, NULL, 'troyangems', 'Troyan Gems', 'onlyplay-troyan-gems', NULL, NULL, 'fivers/onlyplay-troyan-gems.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:43', '2024-04-12 14:07:43');
INSERT INTO `games` VALUES (1433, 26, NULL, 'bookofbambo', 'Book of Bamboo', 'onlyplay-book-of-bamboo', NULL, NULL, 'fivers/onlyplay-book-of-bamboo.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:43', '2024-04-12 14:07:43');
INSERT INTO `games` VALUES (1434, 26, NULL, 'op-slot-bookofeye', 'Book of Eye', 'onlyplay-book-of-eye', NULL, NULL, 'fivers/onlyplay-book-of-eye.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:44', '2024-04-12 14:07:44');
INSERT INTO `games` VALUES (1435, 26, NULL, 'op-slot-chervonaKalyna', 'Chervona Kalyna', 'onlyplay-chervona-kalyna', NULL, NULL, 'fivers/onlyplay-chervona-kalyna.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:45', '2024-04-12 14:07:45');
INSERT INTO `games` VALUES (1436, 26, NULL, 'chervonakal', 'Chervona Kalyna Megaways', 'onlyplay-chervona-kalyna-megaways', NULL, NULL, 'fivers/onlyplay-chervona-kalyna-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:45', '2024-04-12 14:07:45');
INSERT INTO `games` VALUES (1437, 26, NULL, 'op-slot-Christmas7', 'Christmas Seven', 'onlyplay-christmas-seven', NULL, NULL, 'fivers/onlyplay-christmas-seven.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:46', '2024-04-12 14:07:46');
INSERT INTO `games` VALUES (1438, 26, NULL, 'op-slot-Combo7', 'Combo Seven', 'onlyplay-combo-seven', NULL, NULL, 'fivers/onlyplay-combo-seven.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:46', '2024-04-12 14:07:46');
INSERT INTO `games` VALUES (1439, 26, NULL, 'op-crash-CricketCrash', 'Cricket Crash', 'onlyplay-cricket-crash', NULL, NULL, 'fivers/onlyplay-cricket-crash.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:47', '2024-04-12 14:07:47');
INSERT INTO `games` VALUES (1440, 26, NULL, 'crystalcasc', 'Crystal Cascade', 'onlyplay-crystal-cascade', NULL, NULL, 'fivers/onlyplay-crystal-cascade.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:47', '2024-04-12 14:07:47');
INSERT INTO `games` VALUES (1441, 26, NULL, 'op-slot-F777Fighter', 'F777 Fighter', 'onlyplay-f777-fighter', NULL, NULL, 'fivers/onlyplay-f777-fighter.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:48', '2024-04-12 14:07:48');
INSERT INTO `games` VALUES (1442, 26, NULL, 'op-slot-fruitybook', 'Fruity Book', 'onlyplay-fruity-book', NULL, NULL, 'fivers/onlyplay-fruity-book.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:48', '2024-04-12 14:07:48');
INSERT INTO `games` VALUES (1443, 26, NULL, 'goldenclove', 'Golden Clover', 'onlyplay-golden-clover', NULL, NULL, 'fivers/onlyplay-golden-clover.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:49', '2024-04-12 14:07:49');
INSERT INTO `games` VALUES (1444, 26, NULL, 'op-slot-HappyCookie', 'Happy Cookie', 'onlyplay-happy-cookie', NULL, NULL, 'fivers/onlyplay-happy-cookie.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:50', '2024-04-12 14:07:50');
INSERT INTO `games` VALUES (1445, 26, NULL, 'hotandspicy', 'Hot & Spicy', 'onlyplay-hot-spicy', NULL, NULL, 'fivers/onlyplay-hot-spicy.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:50', '2024-04-12 14:07:50');
INSERT INTO `games` VALUES (1446, 26, NULL, 'hotspicymeg', 'Hot & Spicy Megaways', 'onlyplay-hot-spicy-megaways', NULL, NULL, 'fivers/onlyplay-hot-spicy-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:51', '2024-04-12 14:07:51');
INSERT INTO `games` VALUES (1447, 26, NULL, 'op-slot-IggyRacing', 'Iggy Racing', 'onlyplay-iggy-racing', NULL, NULL, 'fivers/onlyplay-iggy-racing.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:51', '2024-04-12 14:07:51');
INSERT INTO `games` VALUES (1448, 26, NULL, 'incason', 'Inca Son', 'onlyplay-inca-son', NULL, NULL, 'fivers/onlyplay-inca-son.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:52', '2024-04-12 14:07:52');
INSERT INTO `games` VALUES (1449, 26, NULL, 'op-slot-JackPotter', 'Jack Potter', 'onlyplay-jack-potter', NULL, NULL, 'fivers/onlyplay-jack-potter.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:53', '2024-04-12 14:07:53');
INSERT INTO `games` VALUES (1450, 26, NULL, 'op-slot-JackPotterDeluxe', 'Jack Potter Deluxe', 'onlyplay-jack-potter-deluxe', NULL, NULL, 'fivers/onlyplay-jack-potter-deluxe.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:53', '2024-04-12 14:07:53');
INSERT INTO `games` VALUES (1451, 26, NULL, 'op-slot-JackPotterMegaways', 'Jack Potter Megaways', 'onlyplay-jack-potter-megaways', NULL, NULL, 'fivers/onlyplay-jack-potter-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:54', '2024-04-12 14:07:54');
INSERT INTO `games` VALUES (1452, 26, NULL, 'op-slot-jackpotterxmas', 'Jack Potter X-MAS', 'onlyplay-jack-potter-x-mas', NULL, NULL, 'fivers/onlyplay-jack-potter-x-mas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:54', '2024-04-12 14:07:54');
INSERT INTO `games` VALUES (1453, 26, NULL, 'op-slot-JokerCoinsMegaways', 'Joker Coins Megaways', 'onlyplay-joker-coins-megaways', NULL, NULL, 'fivers/onlyplay-joker-coins-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:55', '2024-04-12 14:07:55');
INSERT INTO `games` VALUES (1454, 26, NULL, 'op-slot-jokerscoinsxmas', 'Joker Coins X-MAS', 'onlyplay-joker-coins-x-mas', NULL, NULL, 'fivers/onlyplay-joker-coins-x-mas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:56', '2024-04-12 14:07:56');
INSERT INTO `games` VALUES (1455, 26, NULL, 'juicycrush', 'Juicy Crush', 'onlyplay-juicy-crush', NULL, NULL, 'fivers/onlyplay-juicy-crush.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:56', '2024-04-12 14:07:56');
INSERT INTO `games` VALUES (1456, 26, NULL, 'op-slot-JungleGold', 'Jungle Gold', 'onlyplay-jungle-gold', NULL, NULL, 'fivers/onlyplay-jungle-gold.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:57', '2024-04-12 14:07:57');
INSERT INTO `games` VALUES (1457, 26, NULL, 'ligafortuna', 'Liga Fortuna Megaways', 'onlyplay-liga-fortuna-megaways', NULL, NULL, 'fivers/onlyplay-liga-fortuna-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:57', '2024-04-12 14:07:57');
INSERT INTO `games` VALUES (1458, 26, NULL, 'limbocat', 'Limbo Cat', 'onlyplay-limbo-cat', NULL, NULL, 'fivers/onlyplay-limbo-cat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:58', '2024-04-12 14:07:58');
INSERT INTO `games` VALUES (1459, 26, NULL, 'op-vg-LuckyClover', 'Lucky Clover', 'onlyplay-lucky-clover', NULL, NULL, 'fivers/onlyplay-lucky-clover.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:58', '2024-04-12 14:07:58');
INSERT INTO `games` VALUES (1460, 26, NULL, 'op-slot-LuckyCoin', 'Lucky Coin', 'onlyplay-lucky-coin', NULL, NULL, 'fivers/onlyplay-lucky-coin.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:59', '2024-04-12 14:07:59');
INSERT INTO `games` VALUES (1461, 26, NULL, 'op-slot-LuckyOcean', 'Lucky Ocean', 'onlyplay-lucky-ocean', NULL, NULL, 'fivers/onlyplay-lucky-ocean.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:07:59', '2024-04-12 14:07:59');
INSERT INTO `games` VALUES (1462, 26, NULL, 'op-LuckyPunch', 'Lucky Punch', 'onlyplay-lucky-punch', NULL, NULL, 'fivers/onlyplay-lucky-punch.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:00', '2024-04-12 14:08:00');
INSERT INTO `games` VALUES (1463, 26, NULL, 'luckypunchb', 'King of Bitstarz', 'onlyplay-king-of-bitstarz', NULL, NULL, 'fivers/onlyplay-king-of-bitstarz.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:01', '2024-04-12 14:08:01');
INSERT INTO `games` VALUES (1464, 26, NULL, 'op-slot-LuckyTanks', 'Lucky Tanks', 'onlyplay-lucky-tanks', NULL, NULL, 'fivers/onlyplay-lucky-tanks.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:01', '2024-04-12 14:08:01');
INSERT INTO `games` VALUES (1465, 26, NULL, 'op-slot-MythsofBastet', 'Myths of Bastet', 'onlyplay-myths-of-bastet', NULL, NULL, 'fivers/onlyplay-myths-of-bastet.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:02', '2024-04-12 14:08:02');
INSERT INTO `games` VALUES (1466, 26, NULL, 'op-slot-NeedforX', 'Need for X', 'onlyplay-need-for-x', NULL, NULL, 'fivers/onlyplay-need-for-x.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:02', '2024-04-12 14:08:02');
INSERT INTO `games` VALUES (1467, 26, NULL, 'op-vg-quantumx', 'Quantum X', 'onlyplay-quantum-x', NULL, NULL, 'fivers/onlyplay-quantum-x.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:03', '2024-04-12 14:08:03');
INSERT INTO `games` VALUES (1468, 26, NULL, 'op-slot-RoyalKitties', 'Royal Kitties', 'onlyplay-royal-kitties', NULL, NULL, 'fivers/onlyplay-royal-kitties.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:03', '2024-04-12 14:08:03');
INSERT INTO `games` VALUES (1469, 26, NULL, 'op-slot-TheThimbles', 'The Thimbles', 'onlyplay-the-thimbles', NULL, NULL, 'fivers/onlyplay-the-thimbles.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:04', '2024-04-12 14:08:04');
INSERT INTO `games` VALUES (1470, 26, NULL, 'op-slot-TrollDice', 'Troll Dice', 'onlyplay-troll-dice', NULL, NULL, 'fivers/onlyplay-troll-dice.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:05', '2024-04-12 14:08:05');
INSERT INTO `games` VALUES (1471, 26, NULL, 'op-crash-WhenLambo', 'When Lambo', 'onlyplay-when-lambo', NULL, NULL, 'fivers/onlyplay-when-lambo.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:05', '2024-04-12 14:08:05');
INSERT INTO `games` VALUES (1472, 26, NULL, 'wildwestgir', 'Wild West Girls', 'onlyplay-wild-west-girls', NULL, NULL, 'fivers/onlyplay-wild-west-girls.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:06', '2024-04-12 14:08:06');
INSERT INTO `games` VALUES (1473, 26, NULL, 'luckypunchm', 'Lucky Punch Megaways', 'onlyplay-lucky-punch-megaways', NULL, NULL, 'fivers/onlyplay-lucky-punch-megaways.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:06', '2024-04-12 14:08:06');
INSERT INTO `games` VALUES (1474, 26, NULL, 'donpapuswee', 'Don Papu Sweet Christmas', 'onlyplay-don-papu-sweet-christmas', NULL, NULL, 'fivers/onlyplay-don-papu-sweet-christmas.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:07', '2024-04-12 14:08:07');
INSERT INTO `games` VALUES (1475, 26, NULL, 'op-slot-BrazilFarm', 'Brazil Farm', 'onlyplay-brazil-farm', NULL, NULL, 'fivers/onlyplay-brazil-farm.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:07', '2024-04-12 14:08:07');
INSERT INTO `games` VALUES (1476, 26, NULL, 'anubisobeli', 'Anubis’ Obelisk', 'onlyplay-anubis-obelisk', NULL, NULL, 'fivers/onlyplay-anubis-obelisk.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:08', '2024-04-12 14:08:08');
INSERT INTO `games` VALUES (1477, 26, NULL, 'combo7', 'Combo 7', 'onlyplay-combo-7', NULL, NULL, 'fivers/onlyplay-combo-7.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:08', '2024-04-12 14:08:08');
INSERT INTO `games` VALUES (1478, 26, NULL, 'snowgiants', 'Snow Giants', 'onlyplay-snow-giants', NULL, NULL, 'fivers/onlyplay-snow-giants.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:09', '2024-04-12 14:08:09');
INSERT INTO `games` VALUES (1479, 3, NULL, 'evo-oss-xs-baccarat-a', 'Baccarat A', 'evolution-baccarat-a', NULL, NULL, 'fivers/evolution-baccarat-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:10', '2024-04-12 14:08:10');
INSERT INTO `games` VALUES (1480, 3, NULL, 'evo-oss-xs-speed-baccarat-a', 'Speed Baccarat A', 'evolution-speed-baccarat-a', NULL, NULL, 'fivers/evolution-speed-baccarat-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:10', '2024-04-12 14:08:10');
INSERT INTO `games` VALUES (1481, 3, NULL, 'evo-oss-xs-baccarat-b', 'Baccarat B', 'evolution-baccarat-b', NULL, NULL, 'fivers/evolution-baccarat-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:11', '2024-04-12 14:08:11');
INSERT INTO `games` VALUES (1482, 3, NULL, 'evo-oss-xs-lightning-baccarat', 'Lightning Baccarat', 'evolution-lightning-baccarat', NULL, NULL, 'fivers/evolution-lightning-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:11', '2024-04-12 14:08:11');
INSERT INTO `games` VALUES (1483, 3, NULL, 'evo-oss-xs-golden-wealth-baccarat', 'Golden Wealth Baccarat', 'evolution-golden-wealth-baccarat', NULL, NULL, 'fivers/evolution-golden-wealth-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:12', '2024-04-12 14:08:12');
INSERT INTO `games` VALUES (1484, 21, NULL, 'prag-tb-baccarat-10', 'Live - Speed Baccarat 10', 'pragmaticplay-live-speed-baccarat-10', NULL, NULL, 'fivers/pragmaticplay-live-speed-baccarat-10.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:13', '2024-04-12 14:08:13');
INSERT INTO `games` VALUES (1485, 21, NULL, 'prag-tb-baccarat-15', 'Live - Speed Baccarat 15', 'pragmaticplay-live-speed-baccarat-15', NULL, NULL, 'fivers/pragmaticplay-live-speed-baccarat-15.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:13', '2024-04-12 14:08:13');
INSERT INTO `games` VALUES (1486, 21, NULL, 'prag-tb-baccarat-7', 'Live - Baccarat 7', 'pragmaticplay-live-baccarat-7', NULL, NULL, 'fivers/pragmaticplay-live-baccarat-7.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:14', '2024-04-12 14:08:14');
INSERT INTO `games` VALUES (1487, 3, NULL, 'evo-oss-xs-no-commission-speed-baccarat-b', 'No Commission Speed Baccarat B', 'evolution-no-commission-speed-baccarat-b', NULL, NULL, 'fivers/evolution-no-commission-speed-baccarat-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:14', '2024-04-12 14:08:14');
INSERT INTO `games` VALUES (1488, 3, NULL, 'evo-oss-xs-baccarat-c', 'Baccarat C', 'evolution-baccarat-c', NULL, NULL, 'fivers/evolution-baccarat-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:15', '2024-04-12 14:08:15');
INSERT INTO `games` VALUES (1489, 3, NULL, 'evo-oss-xs-baccarat-control-squeeze', 'Baccarat Control Squeeze', 'evolution-baccarat-control-squeeze', NULL, NULL, 'fivers/evolution-baccarat-control-squeeze.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:15', '2024-04-12 14:08:15');
INSERT INTO `games` VALUES (1490, 3, NULL, 'evo-oss-xs-speed-baccarat-h', 'Speed Baccarat H', 'evolution-speed-baccarat-h', NULL, NULL, 'fivers/evolution-speed-baccarat-h.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:16', '2024-04-12 14:08:16');
INSERT INTO `games` VALUES (1491, 3, NULL, 'evo-oss-xs-no-commission-speed-baccarat-a', 'No Commission Speed Baccarat A', 'evolution-no-commission-speed-baccarat-a', NULL, NULL, 'fivers/evolution-no-commission-speed-baccarat-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:17', '2024-04-12 14:08:17');
INSERT INTO `games` VALUES (1492, 3, NULL, 'evo-oss-xs-no-commission-speed-baccarat-c', 'No Commission Speed Baccarat C', 'evolution-no-commission-speed-baccarat-c', NULL, NULL, 'fivers/evolution-no-commission-speed-baccarat-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:17', '2024-04-12 14:08:17');
INSERT INTO `games` VALUES (1493, 3, NULL, 'evo-oss-xs-speed-baccarat-f', 'Speed Baccarat F', 'evolution-speed-baccarat-f', NULL, NULL, 'fivers/evolution-speed-baccarat-f.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:18', '2024-04-12 14:08:18');
INSERT INTO `games` VALUES (1494, 3, NULL, 'evo-oss-xs-speed-baccarat-b', 'Speed Baccarat B', 'evolution-speed-baccarat-b', NULL, NULL, 'fivers/evolution-speed-baccarat-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:18', '2024-04-12 14:08:18');
INSERT INTO `games` VALUES (1495, 3, NULL, 'evo-oss-xs-speed-baccarat-m', 'Speed Baccarat M', 'evolution-speed-baccarat-m', NULL, NULL, 'fivers/evolution-speed-baccarat-m.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:19', '2024-04-12 14:08:19');
INSERT INTO `games` VALUES (1496, 23, NULL, 'evoplay_2916', 'Baccarat 777', 'evoplay-baccarat-777', NULL, NULL, 'fivers/evoplay-baccarat-777.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:20', '2024-04-12 14:08:20');
INSERT INTO `games` VALUES (1497, 3, NULL, 'evo-oss-xs-peek-baccarat', 'Peek Baccarat', 'evolution-peek-baccarat', NULL, NULL, 'fivers/evolution-peek-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:20', '2024-04-12 14:08:20');
INSERT INTO `games` VALUES (1498, 3, NULL, 'evo-oss-xs-first-person-baccarat', 'First Person Baccarat', 'evolution-first-person-baccarat', NULL, NULL, 'fivers/evolution-first-person-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:21', '2024-04-12 14:08:21');
INSERT INTO `games` VALUES (1499, 3, NULL, 'evo-oss-xs-speed-baccarat-n', 'Speed Baccarat N', 'evolution-speed-baccarat-n', NULL, NULL, 'fivers/evolution-speed-baccarat-n.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:21', '2024-04-12 14:08:21');
INSERT INTO `games` VALUES (1500, 3, NULL, 'evo-oss-xs-speed-baccarat-l', 'Speed Baccarat L', 'evolution-speed-baccarat-l', NULL, NULL, 'fivers/evolution-speed-baccarat-l.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:22', '2024-04-12 14:08:22');
INSERT INTO `games` VALUES (1501, 3, NULL, 'evo-oss-xs-speed-baccarat-k', 'Speed Baccarat K', 'evolution-speed-baccarat-k', NULL, NULL, 'fivers/evolution-speed-baccarat-k.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:22', '2024-04-12 14:08:22');
INSERT INTO `games` VALUES (1502, 3, NULL, 'evo-oss-xs-speed-baccarat-s', 'Speed Baccarat S', 'evolution-speed-baccarat-s', NULL, NULL, 'fivers/evolution-speed-baccarat-s.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:23', '2024-04-12 14:08:23');
INSERT INTO `games` VALUES (1503, 3, NULL, 'evo-oss-xs-speed-baccarat-q', 'Speed Baccarat Q', 'evolution-speed-baccarat-q', NULL, NULL, 'fivers/evolution-speed-baccarat-q.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:24', '2024-04-12 14:08:24');
INSERT INTO `games` VALUES (1504, 3, NULL, 'evo-oss-xs-speed-baccarat-p', 'Speed Baccarat P', 'evolution-speed-baccarat-p', NULL, NULL, 'fivers/evolution-speed-baccarat-p.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:24', '2024-04-12 14:08:24');
INSERT INTO `games` VALUES (1505, 3, NULL, 'evo-oss-xs-baccarat-squeeze', 'Baccarat Squeeze', 'evolution-baccarat-squeeze', NULL, NULL, 'fivers/evolution-baccarat-squeeze.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:25', '2024-04-12 14:08:25');
INSERT INTO `games` VALUES (1506, 3, NULL, 'evo-oss-xs-speed-baccarat-r', 'Speed Baccarat R', 'evolution-speed-baccarat-r', NULL, NULL, 'fivers/evolution-speed-baccarat-r.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:25', '2024-04-12 14:08:25');
INSERT INTO `games` VALUES (1507, 3, NULL, 'prag-prive-baccarat-c', 'Salon Prive Baccarat C', 'evolution-salon-prive-baccarat-c', NULL, NULL, 'fivers/evolution-salon-prive-baccarat-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:26', '2024-04-12 14:08:26');
INSERT INTO `games` VALUES (1508, 3, NULL, 'evo-oss-xs-speed-baccarat-c', 'Speed Baccarat C', 'evolution-speed-baccarat-c', NULL, NULL, 'fivers/evolution-speed-baccarat-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:27', '2024-04-12 14:08:27');
INSERT INTO `games` VALUES (1509, 3, NULL, 'evo-oss-xs-speed-baccarat-d', 'Speed Baccarat D', 'evolution-speed-baccarat-d', NULL, NULL, 'fivers/evolution-speed-baccarat-d.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:27', '2024-04-12 14:08:27');
INSERT INTO `games` VALUES (1510, 3, NULL, 'evo-oss-xs-speed-baccarat-e', 'Speed Baccarat E', 'evolution-speed-baccarat-e', NULL, NULL, 'fivers/evolution-speed-baccarat-e.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:28', '2024-04-12 14:08:28');
INSERT INTO `games` VALUES (1511, 3, NULL, 'evo-oss-xs-speed-baccarat-o', 'Speed Baccarat O', 'evolution-speed-baccarat-o', NULL, NULL, 'fivers/evolution-speed-baccarat-o.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:28', '2024-04-12 14:08:28');
INSERT INTO `games` VALUES (1512, 3, NULL, 'evo-oss-xs-speed-baccarat-g', 'Speed Baccarat G', 'evolution-speed-baccarat-g', NULL, NULL, 'fivers/evolution-speed-baccarat-g.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:29', '2024-04-12 14:08:29');
INSERT INTO `games` VALUES (1513, 3, NULL, 'evo-oss-xs-infinite-blackjack', 'Infinite Blackjack', 'evolution-infinite-blackjack', NULL, NULL, 'fivers/evolution-infinite-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:29', '2024-04-12 14:08:29');
INSERT INTO `games` VALUES (1514, 23, NULL, 'evoplay_56343', 'Penalty Shoot Out', 'evoplay-penalty-shoot', NULL, NULL, 'fivers/evoplay-penalty-shoot.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:30', '2024-04-12 14:08:30');
INSERT INTO `games` VALUES (1515, 3, NULL, 'evo-oss-xs-blackjack-a', 'Blackjack A', 'evolution-blackjack-a', NULL, NULL, 'fivers/evolution-blackjack-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:30', '2024-04-12 14:08:30');
INSERT INTO `games` VALUES (1516, 3, NULL, 'evo-oss-xs-blackjack-vip-19', 'Blackjack VIP 19 ', 'evolution-blackjack-vip-19', NULL, NULL, 'fivers/evolution-blackjack-vip-19.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:31', '2024-04-12 14:08:31');
INSERT INTO `games` VALUES (1517, 3, NULL, 'evo-oss-xs-lightning-blackjack', 'Lightning Blackjack', 'evolution-lightning-blackjack', NULL, NULL, 'fivers/evolution-lightning-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:32', '2024-04-12 14:08:32');
INSERT INTO `games` VALUES (1518, 3, NULL, 'evo-oss-xs-power-blackjack', 'Power Blackjack', 'evolution-power-blackjack', NULL, NULL, 'fivers/evolution-power-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:32', '2024-04-12 14:08:32');
INSERT INTO `games` VALUES (1519, 3, NULL, 'evo-oss-xs-blackjack-c', 'Blackjack C', 'evolution-blackjack-c', NULL, NULL, 'fivers/evolution-blackjack-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:33', '2024-04-12 14:08:33');
INSERT INTO `games` VALUES (1520, 3, NULL, 'evo-oss-xs-first-person-lightning-blackjack', 'First Person Lightning Blackjack', 'evolution-first-person-lightning-blackjack', NULL, NULL, 'fivers/evolution-first-person-lightning-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:33', '2024-04-12 14:08:33');
INSERT INTO `games` VALUES (1521, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-g', 'Speed VIP Blackjack G', 'evolution-speed-vip-blackjack-g', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-g.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:34', '2024-04-12 14:08:34');
INSERT INTO `games` VALUES (1522, 3, NULL, 'evo-oss-xs-blackjack-party', 'Blackjack Party', 'evolution-blackjack-party', NULL, NULL, 'fivers/evolution-blackjack-party.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:34', '2024-04-12 14:08:34');
INSERT INTO `games` VALUES (1523, 3, NULL, 'evo-oss-xs-blackjack-fortune-vip', 'Blackjack Fortune VIP', 'evolution-blackjack-fortune-vip', NULL, NULL, 'fivers/evolution-blackjack-fortune-vip.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:35', '2024-04-12 14:08:35');
INSERT INTO `games` VALUES (1524, 3, NULL, 'evo-oss-xs-blackjack-vip-18', 'Blackjack VIP 18 ', 'evolution-blackjack-vip-18', NULL, NULL, 'fivers/evolution-blackjack-vip-18.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:36', '2024-04-12 14:08:36');
INSERT INTO `games` VALUES (1525, 3, NULL, 'evo-oss-xs-blackjack-diamond-vip', 'Blackjack Diamond VIP', 'evolution-blackjack-diamond-vip', NULL, NULL, 'fivers/evolution-blackjack-diamond-vip.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:36', '2024-04-12 14:08:36');
INSERT INTO `games` VALUES (1526, 23, NULL, 'evoplay_2319', 'BlackJack Lucky Sevens', 'evoplay-blackjack-lucky-sevens', NULL, NULL, 'fivers/evoplay-blackjack-lucky-sevens.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:37', '2024-04-12 14:08:37');
INSERT INTO `games` VALUES (1527, 3, NULL, 'evo-oss-xs-first-person-blackjack', 'First Person Blackjack', 'evolution-first-person-blackjack', NULL, NULL, 'fivers/evolution-first-person-blackjack.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:37', '2024-04-12 14:08:37');
INSERT INTO `games` VALUES (1528, 3, NULL, 'evo-oss-xs-blackjack-platinum-vip', 'Blackjack Platinum VIP', 'evolution-blackjack-platinum-vip', NULL, NULL, 'fivers/evolution-blackjack-platinum-vip.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:38', '2024-04-12 14:08:38');
INSERT INTO `games` VALUES (1529, 3, NULL, 'evo-oss-xs-speed-blackjack-h', 'Speed Blackjack H', 'evolution-speed-blackjack-h', NULL, NULL, 'fivers/evolution-speed-blackjack-h.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:38', '2024-04-12 14:08:38');
INSERT INTO `games` VALUES (1530, 3, NULL, 'evo-oss-xs-blackjack-vip-11', 'Blackjack VIP 11', 'evolution-blackjack-vip-11', NULL, NULL, 'fivers/evolution-blackjack-vip-11.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:39', '2024-04-12 14:08:39');
INSERT INTO `games` VALUES (1531, 3, NULL, 'evo-oss-xs-blackjack-vip-14', 'Blackjack VIP 14', 'evolution-blackjack-vip-14', NULL, NULL, 'fivers/evolution-blackjack-vip-14.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:40', '2024-04-12 14:08:40');
INSERT INTO `games` VALUES (1532, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-i', 'Speed VIP Blackjack I', 'evolution-speed-vip-blackjack-i', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-i.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:40', '2024-04-12 14:08:40');
INSERT INTO `games` VALUES (1533, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-h', 'Speed VIP Blackjack H', 'evolution-speed-vip-blackjack-h', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-h.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:41', '2024-04-12 14:08:41');
INSERT INTO `games` VALUES (1534, 3, NULL, 'evo-oss-xs-blackjack-vip-10', 'Blackjack VIP 10', 'evolution-blackjack-vip-10', NULL, NULL, 'fivers/evolution-blackjack-vip-10.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:41', '2024-04-12 14:08:41');
INSERT INTO `games` VALUES (1535, 3, NULL, 'evo-oss-xs-blackjack-vip-1', 'Blackjack VIP 1', 'evolution-blackjack-vip-1', NULL, NULL, 'fivers/evolution-blackjack-vip-1.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:42', '2024-04-12 14:08:42');
INSERT INTO `games` VALUES (1536, 3, NULL, 'evo-oss-xs-blackjack-vip-12', 'Blackjack VIP 12', 'evolution-blackjack-vip-12', NULL, NULL, 'fivers/evolution-blackjack-vip-12.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:43', '2024-04-12 14:08:43');
INSERT INTO `games` VALUES (1537, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-a', 'Speed VIP Blackjack A', 'evolution-speed-vip-blackjack-a', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:43', '2024-04-12 14:08:43');
INSERT INTO `games` VALUES (1538, 3, NULL, 'evo-oss-xs-blackjack-vip-15', 'Blackjack VIP 15', 'evolution-blackjack-vip-15', NULL, NULL, 'fivers/evolution-blackjack-vip-15.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:44', '2024-04-12 14:08:44');
INSERT INTO `games` VALUES (1539, 3, NULL, 'evo-oss-xs-blackjack-vip-16', 'Blackjack VIP 16', 'evolution-blackjack-vip-16', NULL, NULL, 'fivers/evolution-blackjack-vip-16.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:44', '2024-04-12 14:08:44');
INSERT INTO `games` VALUES (1540, 3, NULL, 'evo-oss-xs-blackjack-vip-gamma', 'Blackjack VIP Gamma', 'evolution-blackjack-vip-gamma', NULL, NULL, 'fivers/evolution-blackjack-vip-gamma.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:45', '2024-04-12 14:08:45');
INSERT INTO `games` VALUES (1541, 3, NULL, 'evo-oss-xs-blackjack-vip-b', 'Blackjack VIP B', 'evolution-blackjack-vip-b', NULL, NULL, 'fivers/evolution-blackjack-vip-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:46', '2024-04-12 14:08:46');
INSERT INTO `games` VALUES (1542, 3, NULL, 'evo-oss-xs-blackjack-b', 'Blackjack B', 'evolution-blackjack-b', NULL, NULL, 'fivers/evolution-blackjack-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:46', '2024-04-12 14:08:46');
INSERT INTO `games` VALUES (1543, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-f', 'Speed VIP Blackjack F', 'evolution-speed-vip-blackjack-f', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-f.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:47', '2024-04-12 14:08:47');
INSERT INTO `games` VALUES (1544, 3, NULL, 'evo-oss-xs-blackjack-vip-beta', 'Blackjack VIP Beta', 'evolution-blackjack-vip-beta', NULL, NULL, 'fivers/evolution-blackjack-vip-beta.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:47', '2024-04-12 14:08:47');
INSERT INTO `games` VALUES (1545, 3, NULL, 'evo-oss-xs-blackjack-silver-d', 'Blackjack Silver D', 'evolution-blackjack-silver-d', NULL, NULL, 'fivers/evolution-blackjack-silver-d.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:48', '2024-04-12 14:08:48');
INSERT INTO `games` VALUES (1546, 3, NULL, 'evo-oss-xs-speed-blackjack-d', 'Speed Blackjack D', 'evolution-speed-blackjack-d', NULL, NULL, 'fivers/evolution-speed-blackjack-d.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:48', '2024-04-12 14:08:48');
INSERT INTO `games` VALUES (1547, 3, NULL, 'evo-oss-xs-blackjack-silver-c', 'Blackjack Silver C', 'evolution-blackjack-silver-c', NULL, NULL, 'fivers/evolution-blackjack-silver-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:49', '2024-04-12 14:08:49');
INSERT INTO `games` VALUES (1548, 3, NULL, 'evo-oss-xs-speed-blackjack-i', 'Speed Blackjack I', 'evolution-speed-blackjack-i', NULL, NULL, 'fivers/evolution-speed-blackjack-i.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:50', '2024-04-12 14:08:50');
INSERT INTO `games` VALUES (1549, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-j', 'Speed VIP Blackjack J', 'evolution-speed-vip-blackjack-j', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-j.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:50', '2024-04-12 14:08:50');
INSERT INTO `games` VALUES (1550, 3, NULL, 'evo-oss-xs-blackjack-vip-d', 'Blackjack VIP D', 'evolution-blackjack-vip-d', NULL, NULL, 'fivers/evolution-blackjack-vip-d.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:51', '2024-04-12 14:08:51');
INSERT INTO `games` VALUES (1551, 3, NULL, 'evo-oss-xs-blackjack-vip-alpha', 'Blackjack VIP Alpha', 'evolution-blackjack-vip-alpha', NULL, NULL, 'fivers/evolution-blackjack-vip-alpha.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:51', '2024-04-12 14:08:51');
INSERT INTO `games` VALUES (1552, 3, NULL, 'evo-oss-xs-speed-blackjack-j', 'Speed Blackjack J', 'evolution-speed-blackjack-j', NULL, NULL, 'fivers/evolution-speed-blackjack-j.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:52', '2024-04-12 14:08:52');
INSERT INTO `games` VALUES (1553, 3, NULL, 'evo-oss-xs-blackjack-vip-2', 'Blackjack VIP 2', 'evolution-blackjack-vip-2', NULL, NULL, 'fivers/evolution-blackjack-vip-2.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:53', '2024-04-12 14:08:53');
INSERT INTO `games` VALUES (1554, 3, NULL, 'evo-oss-xs-blackjack-grand-vip', 'Blackjack Grand VIP', 'evolution-blackjack-grand-vip', NULL, NULL, 'fivers/evolution-blackjack-grand-vip.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:53', '2024-04-12 14:08:53');
INSERT INTO `games` VALUES (1555, 3, NULL, 'evo-oss-xs-blackjack-silver-f', 'Blackjack Silver F', 'evolution-blackjack-silver-f', NULL, NULL, 'fivers/evolution-blackjack-silver-f.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:54', '2024-04-12 14:08:54');
INSERT INTO `games` VALUES (1556, 3, NULL, 'evo-oss-xs-blackjack-vip-c', 'Blackjack VIP C', 'evolution-blackjack-vip-c', NULL, NULL, 'fivers/evolution-blackjack-vip-c.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:54', '2024-04-12 14:08:54');
INSERT INTO `games` VALUES (1557, 11, NULL, 'ez-oss-blackjack1', 'Blackjack 1', 'playtech-blackjack-1', NULL, NULL, 'fivers/playtech-blackjack-1.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:55', '2024-04-12 14:08:55');
INSERT INTO `games` VALUES (1558, 3, NULL, 'evo-oss-xs-speed-blackjack-k', 'Speed Blackjack K', 'evolution-speed-blackjack-k', NULL, NULL, 'fivers/evolution-speed-blackjack-k.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:55', '2024-04-12 14:08:55');
INSERT INTO `games` VALUES (1559, 3, NULL, 'evo-oss-xs-blackjack-silver-a', 'Blackjack Silver A', 'evolution-blackjack-silver-a', NULL, NULL, 'fivers/evolution-blackjack-silver-a.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:56', '2024-04-12 14:08:56');
INSERT INTO `games` VALUES (1560, 3, NULL, 'evo-oss-xs-blackjack-silver-g', 'Blackjack Silver G', 'evolution-blackjack-silver-g', NULL, NULL, 'fivers/evolution-blackjack-silver-g.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:57', '2024-04-12 14:08:57');
INSERT INTO `games` VALUES (1561, 3, NULL, 'evo-oss-xs-blackjack-vip-q', 'Blackjack VIP Q', 'evolution-blackjack-vip-q', NULL, NULL, 'fivers/evolution-blackjack-vip-q.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:57', '2024-04-12 14:08:57');
INSERT INTO `games` VALUES (1562, 3, NULL, 'evo-oss-xs-blackjack-vip-f', 'Blackjack VIP F', 'evolution-blackjack-vip-f', NULL, NULL, 'fivers/evolution-blackjack-vip-f.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:58', '2024-04-12 14:08:58');
INSERT INTO `games` VALUES (1563, 3, NULL, 'evo-oss-xs-speed-blackjack-g', 'Speed Blackjack G', 'evolution-speed-blackjack-g', NULL, NULL, 'fivers/evolution-speed-blackjack-g.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:58', '2024-04-12 14:08:58');
INSERT INTO `games` VALUES (1564, 3, NULL, 'evo-oss-xs-blackjack-vip-e', 'Blackjack VIP E', 'evolution-blackjack-vip-e', NULL, NULL, 'fivers/evolution-blackjack-vip-e.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:08:59', '2024-04-12 14:08:59');
INSERT INTO `games` VALUES (1565, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-b', 'Speed VIP Blackjack B', 'evolution-speed-vip-blackjack-b', NULL, NULL, 'fivers/evolution-speed-vip-blackjack-b.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:00', '2024-04-12 14:09:00');
INSERT INTO `games` VALUES (1566, 3, NULL, 'evo-oss-xs-blackjack-vip-g', 'Blackjack VIP G', 'evolution-blackjack-vip-g', NULL, NULL, 'fivers/evolution-blackjack-vip-g.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:00', '2024-04-12 14:09:00');
INSERT INTO `games` VALUES (1567, 3, NULL, 'evo-oss-xs-blackjack-vip-4', 'Blackjack VIP 4', 'evolution-blackjack-vip-4', NULL, NULL, 'fivers/evolution-blackjack-vip-4.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:01', '2024-04-12 14:09:01');
INSERT INTO `games` VALUES (1568, 3, NULL, 'evo-oss-xs-blackjack-vip-n', 'Blackjack VIP N', 'evolution-blackjack-vip-n', NULL, NULL, 'fivers/evolution-blackjack-vip-n.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:01', '2024-04-12 14:09:01');
INSERT INTO `games` VALUES (1569, 28, NULL, 'starlightro', 'Roleta Starlight Brasil', 'banana-roleta-starlight-brasil', NULL, NULL, 'fivers/banana-roleta-starlight-brasil.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:02', '2024-04-12 14:09:02');
INSERT INTO `games` VALUES (1570, 28, NULL, 'livebingo', 'Bingolar Live Brasil', 'banana-bingolar-live-brasil', NULL, NULL, 'fivers/banana-bingolar-live-brasil.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:03', '2024-04-12 14:09:03');
INSERT INTO `games` VALUES (1571, 3, NULL, 'evo-oss-xs-bac-bo', 'Bac Bo', 'evolution-bac-bo', NULL, NULL, 'fivers/evolution-bac-bo.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:03', '2024-04-12 14:09:03');
INSERT INTO `games` VALUES (1572, 3, NULL, 'evo-oss-xs-football-studio', 'Football studio', 'evolution-football-studio', NULL, NULL, 'fivers/evolution-football-studio.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:04', '2024-04-12 14:09:04');
INSERT INTO `games` VALUES (1573, 3, NULL, 'evo-oss-xs-crazy-time', 'Crazy Time', 'evolution-crazy-time', NULL, NULL, 'fivers/evolution-crazy-time.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:05', '2024-04-12 14:09:05');
INSERT INTO `games` VALUES (1574, 3, NULL, 'evo-oss-xs-mega-ball', 'Mega Ball', 'evolution-mega-ball', NULL, NULL, 'fivers/evolution-mega-ball.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:05', '2024-04-12 14:09:05');
INSERT INTO `games` VALUES (1575, 3, NULL, 'evo-oss-xs-deal-or-no-deal', 'Deal or no Deal', 'evolution-deal-or-no-deal', NULL, NULL, 'fivers/evolution-deal-or-no-deal.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:06', '2024-04-12 14:09:06');
INSERT INTO `games` VALUES (1576, 3, NULL, 'evo-oss-xs-dream-catcher-', 'Dream Catcher', 'evolution-dream-catcher', NULL, NULL, 'fivers/evolution-dream-catcher.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:06', '2024-04-12 14:09:06');
INSERT INTO `games` VALUES (1577, 3, NULL, 'evo-oss-xs-lightning-dice', 'Lightning Dice', 'evolution-lightning-dice', NULL, NULL, 'fivers/evolution-lightning-dice.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:07', '2024-04-12 14:09:07');
INSERT INTO `games` VALUES (1578, 3, NULL, 'evo-oss-xs-auto-roulette-vip', 'Auto-Roulette VIP', 'evolution-auto-roulette-vip', NULL, NULL, 'fivers/evolution-auto-roulette-vip.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:08', '2024-04-12 14:09:08');
INSERT INTO `games` VALUES (1579, 1, NULL, 'spb-tb-aviator', 'Aviator', 'spribe-aviator', NULL, NULL, 'fivers/spribe-aviator.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:08', '2024-04-12 14:09:08');
INSERT INTO `games` VALUES (1580, 3, NULL, 'evo-oss-xs-xxxtreme-lightning-roulette', 'XXXtreme Lightning Roulette', 'evolution-xxxtreme-lightning-roulette', NULL, NULL, 'fivers/evolution-xxxtreme-lightning-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:09', '2024-04-12 14:09:09');
INSERT INTO `games` VALUES (1581, 3, NULL, 'evo-oss-xs-immersive-roulette', 'Immersive Roulette', 'evolution-immersive-roulette', NULL, NULL, 'fivers/evolution-immersive-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:09', '2024-04-12 14:09:09');
INSERT INTO `games` VALUES (1582, 3, NULL, 'evo-oss-xs-lightning-roulette', 'Lightning Roulette', 'evolution-lightning-roulette', NULL, NULL, 'fivers/evolution-lightning-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:10', '2024-04-12 14:09:10');
INSERT INTO `games` VALUES (1583, 3, NULL, 'evo-oss-xs-football-studio-dice', 'Football Studio Dice', 'evolution-football-studio-dice', NULL, NULL, 'fivers/evolution-football-studio-dice.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:10', '2024-04-12 14:09:10');
INSERT INTO `games` VALUES (1584, 1, NULL, 'spb-tb-plinko', 'Plinko', 'spribe-plinko', NULL, NULL, 'fivers/spribe-plinko.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:11', '2024-04-12 14:09:11');
INSERT INTO `games` VALUES (1585, 1, NULL, 'spb-tb-miniroulette', 'Mini Roulette', 'spribe-mini-roulette', NULL, NULL, 'fivers/spribe-mini-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:11', '2024-04-12 14:09:11');
INSERT INTO `games` VALUES (1586, 3, NULL, 'evo-oss-xs-auto-roulette-la-partage', 'Auto-Roulette La Partage', 'evolution-auto-roulette-la-partage', NULL, NULL, 'fivers/evolution-auto-roulette-la-partage.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:12', '2024-04-12 14:09:12');
INSERT INTO `games` VALUES (1587, 1, NULL, 'spb-tb-keno', 'Keno', 'spribe-keno', NULL, NULL, 'fivers/spribe-keno.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:12', '2024-04-12 14:09:12');
INSERT INTO `games` VALUES (1588, 1, NULL, 'turbogames_dice', 'Dice', 'spribe-dice', NULL, NULL, 'fivers/spribe-dice.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:13', '2024-04-12 14:09:13');
INSERT INTO `games` VALUES (1589, 3, NULL, 'evo-oss-xs-super-sic-bo', 'Super Sic Bo', 'evolution-super-sic-bo', NULL, NULL, 'fivers/evolution-super-sic-bo.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:13', '2024-04-12 14:09:13');
INSERT INTO `games` VALUES (1590, 3, NULL, 'evo-oss-xs-fan-tan', 'Fan Tan', 'evolution-fan-tan', NULL, NULL, 'fivers/evolution-fan-tan.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:14', '2024-04-12 14:09:14');
INSERT INTO `games` VALUES (1591, 3, NULL, 'evo-oss-xs-auto-roulette', 'Auto-Roulette', 'evolution-auto-roulette', NULL, NULL, 'fivers/evolution-auto-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:15', '2024-04-12 14:09:15');
INSERT INTO `games` VALUES (1592, 23, NULL, 'evoplay_6001', 'Long Ball', 'evoplay-long-ball', NULL, NULL, 'fivers/evoplay-long-ball.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:15', '2024-04-12 14:09:15');
INSERT INTO `games` VALUES (1593, 3, NULL, 'evo-oss-xs-vip-roulette', 'VIP Roulette', 'evolution-vip-roulette', NULL, NULL, 'fivers/evolution-vip-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:16', '2024-04-12 14:09:16');
INSERT INTO `games` VALUES (1594, 29, NULL, 'tvbet-7bet', '7Bet', 'tvbet-7bet', NULL, NULL, 'fivers/tvbet-7bet.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:16', '2024-04-12 14:09:16');
INSERT INTO `games` VALUES (1595, 23, NULL, 'evoplay_230', 'Old West', 'evoplay-old-west', NULL, NULL, 'fivers/evoplay-old-west.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:17', '2024-04-12 14:09:17');
INSERT INTO `games` VALUES (1596, 3, NULL, 'evo-oss-xs-speed-roulette', 'Speed Roulette', 'evolution-speed-roulette', NULL, NULL, 'fivers/evolution-speed-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:17', '2024-04-12 14:09:17');
INSERT INTO `games` VALUES (1597, 23, NULL, 'evoplay_5831', 'Penalty Series', 'evoplay-penalty-series', NULL, NULL, 'fivers/evoplay-penalty-series.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:18', '2024-04-12 14:09:18');
INSERT INTO `games` VALUES (1598, 3, NULL, 'evo-oss-xs-first-person-mega-ball', 'First Person Mega Ball', 'evolution-first-person-mega-ball', NULL, NULL, 'fivers/evolution-first-person-mega-ball.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:19', '2024-04-12 14:09:19');
INSERT INTO `games` VALUES (1599, 3, NULL, 'evo-oss-xs-double-ball-roulette', 'Double Ball Roulette', 'evolution-double-ball-roulette', NULL, NULL, 'fivers/evolution-double-ball-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:19', '2024-04-12 14:09:19');
INSERT INTO `games` VALUES (1600, 23, NULL, 'evoplay_5491', 'Scratch Match', 'evoplay-scratch-match', NULL, NULL, 'fivers/evoplay-scratch-match.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:20', '2024-04-12 14:09:20');
INSERT INTO `games` VALUES (1601, 3, NULL, 'evo-oss-xs-first-person-top-card', 'First Person Top Card', 'evolution-first-person-top-card', NULL, NULL, 'fivers/evolution-first-person-top-card.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:20', '2024-04-12 14:09:20');
INSERT INTO `games` VALUES (1602, 1, NULL, 'spb-tb-poker', 'Poker', 'tvbet-poker', NULL, NULL, 'fivers/tvbet-poker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:21', '2024-04-12 14:09:21');
INSERT INTO `games` VALUES (1603, 23, NULL, 'evoplay_5863', 'Patrick\'s Magic Field', 'evoplay-patricks-magic-field', NULL, NULL, 'fivers/evoplay-patricks-magic-field.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:22', '2024-04-12 14:09:22');
INSERT INTO `games` VALUES (1604, 23, NULL, 'evoplay_5573', 'Mine Field', 'evoplay-mine-field', NULL, NULL, 'fivers/evoplay-mine-field.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:22', '2024-04-12 14:09:22');
INSERT INTO `games` VALUES (1605, 3, NULL, 'evo-oss-xs-football-studio-roulette', 'Football Studio Roulette', 'evolution-football-studio-roulette', NULL, NULL, 'fivers/evolution-football-studio-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:23', '2024-04-12 14:09:23');
INSERT INTO `games` VALUES (1606, 23, NULL, 'evoplay_5899', 'Magic Chests', 'evoplay-magic-chests', NULL, NULL, 'fivers/evoplay-magic-chests.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:23', '2024-04-12 14:09:23');
INSERT INTO `games` VALUES (1607, 23, NULL, 'evoplay_5489', 'Courier Sweeper', 'evoplay-courier-sweeper', NULL, NULL, 'fivers/evoplay-courier-sweeper.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:24', '2024-04-12 14:09:24');
INSERT INTO `games` VALUES (1608, 23, NULL, 'evoplay_5965', 'Candy Dreams: Bingo', 'evoplay-candy-dreams-bingo', NULL, NULL, 'fivers/evoplay-candy-dreams-bingo.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:24', '2024-04-12 14:09:24');
INSERT INTO `games` VALUES (1609, 3, NULL, 'evo-oss-xs-casino-malta-roulette', 'Casino Malta Roulette', 'evolution-casino-malta-roulette', NULL, NULL, 'fivers/evolution-casino-malta-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:25', '2024-04-12 14:09:25');
INSERT INTO `games` VALUES (1610, 23, NULL, 'evoplay_5523', 'Magic Wheel', 'evoplay-magic-wheel', NULL, NULL, 'fivers/evoplay-magic-wheel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:25', '2024-04-12 14:09:25');
INSERT INTO `games` VALUES (1611, 3, NULL, 'evo-oss-xs-first-person-american-roulette', 'First Person American Roulette', 'evolution-first-person-american-roulette', NULL, NULL, 'fivers/evolution-first-person-american-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:26', '2024-04-12 14:09:26');
INSERT INTO `games` VALUES (1612, 3, NULL, 'evo-oss-xs-first-person-craps', 'First Person Craps', 'evolution-first-person-craps', NULL, NULL, 'fivers/evolution-first-person-craps.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:27', '2024-04-12 14:09:27');
INSERT INTO `games` VALUES (1613, 3, NULL, 'evo-oss-xs-first-person-golden-wealth-baccarat', 'First Person Golden Wealth Baccarat', 'evolution-first-person-golden-wealth-baccarat', NULL, NULL, 'fivers/evolution-first-person-golden-wealth-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:27', '2024-04-12 14:09:27');
INSERT INTO `games` VALUES (1614, 11, NULL, 'ez-oss-NoCommissionBaccarat', 'No Commission Baccarat', '7-mojos-slots-no-commission-baccarat', NULL, NULL, 'fivers/7-mojos-slots-no-commission-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:28', '2024-04-12 14:09:28');
INSERT INTO `games` VALUES (1615, 3, NULL, 'evo-oss-xs-first-person-lightning-baccarat', 'First Person Lightning Baccarat', 'evolution-first-person-lightning-baccarat', NULL, NULL, 'fivers/evolution-first-person-lightning-baccarat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:28', '2024-04-12 14:09:28');
INSERT INTO `games` VALUES (1616, 3, NULL, 'dg-tb-threecardpoker', 'Three Card Poker', 'evolution-three-card-poker', NULL, NULL, 'fivers/evolution-three-card-poker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:29', '2024-04-12 14:09:29');
INSERT INTO `games` VALUES (1617, 23, NULL, 'evoplay_5553', 'Texas Holdem Poker', 'evoplay-texas-holdem-poker', NULL, NULL, 'fivers/evoplay-texas-holdem-poker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:30', '2024-04-12 14:09:30');
INSERT INTO `games` VALUES (1618, 3, NULL, 'evo-oss-xs-first-person-lightning-roulette-', 'First Person Lightning Roulette', 'evolution-first-person-lightning-roulette', NULL, NULL, 'fivers/evolution-first-person-lightning-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:30', '2024-04-12 14:09:30');
INSERT INTO `games` VALUES (1619, 23, NULL, 'evoplay_5961', 'Funny Hunting', 'evoplay-funny-hunting', NULL, NULL, 'fivers/evoplay-funny-hunting.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:31', '2024-04-12 14:09:31');
INSERT INTO `games` VALUES (1620, 23, NULL, 'evoplay_2343', 'Thimbles', 'evoplay-thimbles', NULL, NULL, 'fivers/evoplay-thimbles.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:31', '2024-04-12 14:09:31');
INSERT INTO `games` VALUES (1621, 3, NULL, 'evo-oss-xs-craps', 'Craps', 'evolution-craps', NULL, NULL, 'fivers/evolution-craps.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:32', '2024-04-12 14:09:32');
INSERT INTO `games` VALUES (1622, 23, NULL, 'evoplay_5891', 'Football Bet', 'evoplay-football-bet', NULL, NULL, 'fivers/evoplay-football-bet.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:32', '2024-04-12 14:09:32');
INSERT INTO `games` VALUES (1623, 3, NULL, 'evo-oss-xs-first-person-roulette', 'First Person Roulette', 'evolution-first-person-roulette', NULL, NULL, 'fivers/evolution-first-person-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:33', '2024-04-12 14:09:33');
INSERT INTO `games` VALUES (1624, 23, NULL, 'evoplay_6011', 'Mary\'s Mining Mania', 'evoplay-marys-mining-mania', NULL, NULL, 'fivers/evoplay-marys-mining-mania.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:34', '2024-04-12 14:09:34');
INSERT INTO `games` VALUES (1625, 3, NULL, 'evo-oss-xs-first-person-dragon-tiger', 'First Person Dragon Tiger', 'evolution-first-person-dragon-tiger', NULL, NULL, 'fivers/evolution-first-person-dragon-tiger.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:34', '2024-04-12 14:09:34');
INSERT INTO `games` VALUES (1626, 23, NULL, 'evoplay_5865', 'Lucky Card', 'evoplay-lucky-card', NULL, NULL, 'fivers/evoplay-lucky-card.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:35', '2024-04-12 14:09:35');
INSERT INTO `games` VALUES (1627, 3, NULL, 'evo-oss-xs-french-roulette-gold', 'French Roulette Gold', 'evolution-french-roulette-gold', NULL, NULL, 'fivers/evolution-french-roulette-gold.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:35', '2024-04-12 14:09:35');
INSERT INTO `games` VALUES (1628, 11, NULL, 'ez-oss-autoroulette', 'Auto Roulette', 'playtech-auto-roulette', NULL, NULL, 'fivers/playtech-auto-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:36', '2024-04-12 14:09:36');
INSERT INTO `games` VALUES (1629, 3, NULL, 'evo-oss-xs-grand-casino-roulette', 'Grand Casino Roulette', 'evolution-grand-casino-roulette', NULL, NULL, 'fivers/evolution-grand-casino-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:37', '2024-04-12 14:09:37');
INSERT INTO `games` VALUES (1630, 23, NULL, 'evoplay_5170', 'American Roulette 3D Classic', 'evoplay-american-roulette-3d-classic', NULL, NULL, 'fivers/evoplay-american-roulette-3d-classic.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:37', '2024-04-12 14:09:37');
INSERT INTO `games` VALUES (1631, 23, NULL, 'evoplay_2313', 'Heads & Tails', 'evoplay-heads-tails', NULL, NULL, 'fivers/evoplay-heads-tails.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:38', '2024-04-12 14:09:38');
INSERT INTO `games` VALUES (1632, 23, NULL, 'evoplay_5883', 'Pride Fight', 'evoplay-pride-fight', NULL, NULL, 'fivers/evoplay-pride-fight.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:38', '2024-04-12 14:09:38');
INSERT INTO `games` VALUES (1633, 11, NULL, 'ez-oss-TurkishRoulette', 'Turkish Roulette', 'playtech-turkish-roulette', NULL, NULL, 'fivers/playtech-turkish-roulette.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:39', '2024-04-12 14:09:39');
INSERT INTO `games` VALUES (1634, 23, NULL, 'evoplay_5770', 'PlingoBall', 'evoplay-plingoball', NULL, NULL, 'fivers/evoplay-plingoball.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:39', '2024-04-12 14:09:39');
INSERT INTO `games` VALUES (1635, 23, NULL, 'evoplay_5931', 'Perfect Fishing', 'evoplay-perfect-fishing', NULL, NULL, 'fivers/evoplay-perfect-fishing.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:40', '2024-04-12 14:09:40');
INSERT INTO `games` VALUES (1636, 23, NULL, 'evoplay_5525', 'Bomb Squad', 'evoplay-bomb-squad', NULL, NULL, 'fivers/evoplay-bomb-squad.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:41', '2024-04-12 14:09:41');
INSERT INTO `games` VALUES (1637, 23, NULL, 'evoplay_5776', 'Bonanza Wheel', 'evoplay-bonanza-wheel', NULL, NULL, 'fivers/evoplay-bonanza-wheel.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:41', '2024-04-12 14:09:41');
INSERT INTO `games` VALUES (1638, 23, NULL, 'evoplay_5983', 'Treasures Of The Gods', 'evoplay-treasures-of-the-gods', NULL, NULL, 'fivers/evoplay-treasures-of-the-gods.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:42', '2024-04-12 14:09:42');
INSERT INTO `games` VALUES (1639, 23, NULL, 'evoplay_2322', 'Oasis Poker Classic', 'evoplay-oasis-poker-classic', NULL, NULL, 'fivers/evoplay-oasis-poker-classic.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:42', '2024-04-12 14:09:42');
INSERT INTO `games` VALUES (1640, 23, NULL, 'ha-scr-football', 'Football Scratch', 'evoplay-football-scratch', NULL, NULL, 'fivers/evoplay-football-scratch.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:43', '2024-04-12 14:09:43');
INSERT INTO `games` VALUES (1641, 23, NULL, 'evoplay_5971', 'Super Bartender', 'evoplay-super-bartender', NULL, NULL, 'fivers/evoplay-super-bartender.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:43', '2024-04-12 14:09:43');
INSERT INTO `games` VALUES (1642, 23, NULL, 'evoplay_5356', 'Poker Teen Patti', 'evoplay-poker-teen-patti', NULL, NULL, 'fivers/evoplay-poker-teen-patti.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:44', '2024-04-12 14:09:44');
INSERT INTO `games` VALUES (1643, 23, NULL, 'evoplay_5761', 'Mysteries of the East', 'evoplay-mysteries-of-the-east', NULL, NULL, 'fivers/evoplay-mysteries-of-the-east.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:45', '2024-04-12 14:09:45');
INSERT INTO `games` VALUES (1644, 23, NULL, 'evoplay_5781', 'Save The Hamster', 'evoplay-save-the-hamster', NULL, NULL, 'fivers/evoplay-save-the-hamster.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:45', '2024-04-12 14:09:45');
INSERT INTO `games` VALUES (1645, 3, NULL, 'evo-oss-xs-side-bet-city', 'Side Bet City', 'evolution-side-bet-city', NULL, NULL, 'fivers/evolution-side-bet-city.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:46', '2024-04-12 14:09:46');
INSERT INTO `games` VALUES (1646, 23, NULL, 'evoplay_5739', 'Book Of Keno', 'evoplay-book-of-keno', NULL, NULL, 'fivers/evoplay-book-of-keno.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:46', '2024-04-12 14:09:46');
INSERT INTO `games` VALUES (1647, 23, NULL, 'evoplay_5924', 'Lottery Ticket', 'evoplay-lottery-ticket', NULL, NULL, 'fivers/evoplay-lottery-ticket.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:47', '2024-04-12 14:09:47');
INSERT INTO `games` VALUES (1648, 23, NULL, 'evoplay_6007', 'Soccer Solo Striker', 'evoplay-soccer-solo-striker', NULL, NULL, 'fivers/evoplay-soccer-solo-striker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:48', '2024-04-12 14:09:48');
INSERT INTO `games` VALUES (1649, 23, NULL, 'evoplay_5679', 'Texas Holdem Bonus', 'evoplay-texas-holdem-bonus', NULL, NULL, 'fivers/evoplay-texas-holdem-bonus.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:48', '2024-04-12 14:09:48');
INSERT INTO `games` VALUES (1650, 23, NULL, 'evoplay_5767', 'Roll To Luck', 'evoplay-roll-to-luck', NULL, NULL, 'fivers/evoplay-roll-to-luck.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:49', '2024-04-12 14:09:49');
INSERT INTO `games` VALUES (1651, 27, NULL, 'prag-tb-baccarat-brasileira', 'Baccarat Brasileira', 'playtech-baccarat-brasileira', NULL, NULL, 'fivers/playtech-baccarat-brasileira.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:49', '2024-04-12 14:09:49');
INSERT INTO `games` VALUES (1652, 23, NULL, 'evoplay_5875', 'Goblin Run', 'evoplay-goblin-run', NULL, NULL, 'fivers/evoplay-goblin-run.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:50', '2024-04-12 14:09:50');
INSERT INTO `games` VALUES (1653, 23, NULL, 'evoplay_5811', 'Lucky Crumbling', 'evoplay-lucky-crumbling', NULL, NULL, 'fivers/evoplay-lucky-crumbling.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:50', '2024-04-12 14:09:50');
INSERT INTO `games` VALUES (1654, 23, NULL, 'evoplay_5736', 'Wheel Of Time', 'evoplay-wheel-of-time', NULL, NULL, 'fivers/evoplay-wheel-of-time.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:51', '2024-04-12 14:09:51');
INSERT INTO `games` VALUES (1655, 23, NULL, 'evoplay_5748', 'Christmas Party', 'evoplay-christmas-party', NULL, NULL, 'fivers/evoplay-christmas-party.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:52', '2024-04-12 14:09:52');
INSERT INTO `games` VALUES (1656, 23, NULL, 'evoplay_5585', 'Crown and Anchor', 'evoplay-crown-and-anchor', NULL, NULL, 'fivers/evoplay-crown-and-anchor.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:52', '2024-04-12 14:09:52');
INSERT INTO `games` VALUES (1657, 23, NULL, 'evoplay_5687', 'Football Manager', 'evoplay-football-manager', NULL, NULL, 'fivers/evoplay-football-manager.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:53', '2024-04-12 14:09:53');
INSERT INTO `games` VALUES (1658, 23, NULL, 'evoplay_5173', 'E.T. Races', 'evoplay-et-races', NULL, NULL, 'fivers/evoplay-et-races.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:53', '2024-04-12 14:09:53');
INSERT INTO `games` VALUES (1659, 23, NULL, 'evoplay_5937', 'Ethan Grand: Mayan Diaries', 'evoplay-ethan-grand-mayan-diaries', NULL, NULL, 'fivers/evoplay-ethan-grand-mayan-diaries.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:54', '2024-04-12 14:09:54');
INSERT INTO `games` VALUES (1660, 23, NULL, 'evoplay_5743', 'Pachin Girl', 'evoplay-pachin-girl', NULL, NULL, 'fivers/evoplay-pachin-girl.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:55', '2024-04-12 14:09:55');
INSERT INTO `games` VALUES (1661, 23, NULL, 'evoplay_5753', 'Mehen', 'evoplay-mehen', NULL, NULL, 'fivers/evoplay-mehen.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:55', '2024-04-12 14:09:55');
INSERT INTO `games` VALUES (1662, 23, NULL, 'evoplay_2337', 'Four Aces', 'evoplay-four-aces', NULL, NULL, 'fivers/evoplay-four-aces.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:56', '2024-04-12 14:09:56');
INSERT INTO `games` VALUES (1663, 23, NULL, 'evoplay_5344', 'High Striker', 'evoplay-high-striker', NULL, NULL, 'fivers/evoplay-high-striker.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:56', '2024-04-12 14:09:56');
INSERT INTO `games` VALUES (1664, 23, NULL, 'evoplay_5750', 'Xmas Keno Cat', 'evoplay-xmas-keno-cat', NULL, NULL, 'fivers/evoplay-xmas-keno-cat.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:57', '2024-04-12 14:09:57');
INSERT INTO `games` VALUES (1665, 23, NULL, 'evoplay_2340', 'Red Queen', 'evoplay-red-queen', NULL, NULL, 'fivers/evoplay-red-queen.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:57', '2024-04-12 14:09:57');
INSERT INTO `games` VALUES (1666, 23, NULL, 'evoplay_5757', 'Neon Shapes', 'evoplay-neon-shapes', NULL, NULL, 'fivers/evoplay-neon-shapes.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:58', '2024-04-12 14:09:58');
INSERT INTO `games` VALUES (1667, 23, NULL, 'evoplay_5849', 'Andar Nights', 'evoplay-andar-nights', NULL, NULL, 'fivers/evoplay-andar-nights.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:59', '2024-04-12 14:09:59');
INSERT INTO `games` VALUES (1668, 23, NULL, 'evoplay_4393', 'Rock Paper Scissors', 'evoplay-rock-paper-scissors', NULL, NULL, 'fivers/evoplay-rock-paper-scissors.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:09:59', '2024-04-12 14:09:59');
INSERT INTO `games` VALUES (1669, 23, NULL, 'evoplay_2316', 'More or Less', 'evoplay-more-or-less', NULL, NULL, 'fivers/evoplay-more-or-less.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:00', '2024-04-12 14:10:00');
INSERT INTO `games` VALUES (1670, 3, NULL, 'evo-oss-xs-speed-baccarat-i', 'Speed Baccarat I', 'evolution-speed-baccarat-i', NULL, NULL, 'fivers/evolution-speed-baccarat-i.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:00', '2024-04-12 14:10:00');
INSERT INTO `games` VALUES (1671, 3, NULL, 'evo-oss-xs-speed-baccarat-j', 'Speed Baccarat J', 'evolution-speed-baccarat-j', NULL, NULL, 'fivers/evolution-speed-baccarat-j.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:01', '2024-04-12 14:10:01');
INSERT INTO `games` VALUES (1672, 11, NULL, 'ez-oss-andarbahar', 'Andar Bahar', 'playtech-andar-bahar', NULL, NULL, 'fivers/playtech-andar-bahar.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:01', '2024-04-12 14:10:01');
INSERT INTO `games` VALUES (1673, 21, NULL, 'scwolfgold', 'Wolf Gold 1 Million', 'pragmaticplay-wolf-gold-1-million', NULL, NULL, 'fivers/pragmaticplay-wolf-gold-1-million.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:02', '2024-04-12 14:10:02');
INSERT INTO `games` VALUES (1674, 1, NULL, 'spb-tb-mines', 'Mines', 'spribe-mines', NULL, NULL, 'fivers/spribe-mines.webp', '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:03', '2024-04-12 14:10:03');
INSERT INTO `games` VALUES (1675, 3, NULL, 'evo-oss-xs-2-hand-casino-holdem', '2 Hand Casino Holdem', 'evo-oss-xs-2-hand-casino-holdem', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:03', '2024-04-12 14:10:03');
INSERT INTO `games` VALUES (1676, 11, NULL, 'ez-oss-32cards', '32 Cards ', 'ez-oss-32cards', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:04', '2024-04-12 14:10:04');
INSERT INTO `games` VALUES (1677, 15, NULL, 'sms-slot-tripleseven', '777', 'sms-slot-tripleseven', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:04', '2024-04-12 14:10:04');
INSERT INTO `games` VALUES (1678, 13, NULL, 'pgs-tb-AmericanBlackjack', 'American Blackjack', 'pgs-tb-AmericanBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:05', '2024-04-12 14:10:05');
INSERT INTO `games` VALUES (1679, 3, NULL, 'evo-oss-xs-american-roulette', 'American Roulette', 'evo-oss-xs-american-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:06', '2024-04-12 14:10:06');
INSERT INTO `games` VALUES (1680, 23, NULL, 'evoplay_2244', 'Atlantis', 'evoplay_2244', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:06', '2024-04-12 14:10:06');
INSERT INTO `games` VALUES (1681, 3, NULL, 'evo-oss-xs-auto-lightning-roulette', 'Auto Lightning Roulette', 'evo-oss-xs-auto-lightning-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:07', '2024-04-12 14:10:07');
INSERT INTO `games` VALUES (1682, 3, NULL, 'evo-oss-xs-bacara-rapido', 'Bacará Rápido', 'evo-oss-xs-bacara-rapido', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:07', '2024-04-12 14:10:07');
INSERT INTO `games` VALUES (1683, 11, NULL, 'ez-oss-baccarat', 'Baccarat ', 'ez-oss-baccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:08', '2024-04-12 14:10:08');
INSERT INTO `games` VALUES (1684, 23, NULL, 'evoplay_6095', 'Bandit Bust', 'evoplay_6095', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:08', '2024-04-12 14:10:08');
INSERT INTO `games` VALUES (1685, 15, NULL, 'sms-slot-bank', 'BankJob', 'sms-slot-bank', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:09', '2024-04-12 14:10:09');
INSERT INTO `games` VALUES (1686, 23, NULL, 'evoplay_6074', 'Battle Roosters', 'evoplay_6074', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:10', '2024-04-12 14:10:10');
INSERT INTO `games` VALUES (1687, 23, NULL, 'evoplay_6082', 'Battle Roosters Bonus Buy', 'evoplay_6082', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:10', '2024-04-12 14:10:10');
INSERT INTO `games` VALUES (1688, 11, NULL, 'ez-oss-betonteenpatti', 'Bet on Teen Patti', 'ez-oss-betonteenpatti', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:11', '2024-04-12 14:10:11');
INSERT INTO `games` VALUES (1689, 10, NULL, 'boo-BillyBobBoom', 'Billy Bob Boom', 'boo-BillyBobBoom', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:11', '2024-04-12 14:10:11');
INSERT INTO `games` VALUES (1690, 11, NULL, 'ez-oss-blackjack-a', 'Blackjack A ', 'ez-oss-blackjack-a', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:12', '2024-04-12 14:10:12');
INSERT INTO `games` VALUES (1691, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-1', 'Blackjack Clasico en Español 1', 'evo-oss-xs-blackjack-clasico-en-espanol-1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:13', '2024-04-12 14:10:13');
INSERT INTO `games` VALUES (1692, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-2', 'Blackjack Clasico en Español 2', 'evo-oss-xs-blackjack-clasico-en-espanol-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:13', '2024-04-12 14:10:13');
INSERT INTO `games` VALUES (1693, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-3', 'Blackjack Clasico en Español 3', 'evo-oss-xs-blackjack-clasico-en-espanol-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:14', '2024-04-12 14:10:14');
INSERT INTO `games` VALUES (1694, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-4', 'Blackjack Clasico en Español 4', 'evo-oss-xs-blackjack-clasico-en-espanol-4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:14', '2024-04-12 14:10:14');
INSERT INTO `games` VALUES (1695, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-5', 'Blackjack Clasico en Español 5', 'evo-oss-xs-blackjack-clasico-en-espanol-5', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:15', '2024-04-12 14:10:15');
INSERT INTO `games` VALUES (1696, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-6', 'Blackjack Clasico en Español 6', 'evo-oss-xs-blackjack-clasico-en-espanol-6', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:16', '2024-04-12 14:10:16');
INSERT INTO `games` VALUES (1697, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-7', 'Blackjack Clasico en Español 7', 'evo-oss-xs-blackjack-clasico-en-espanol-7', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:16', '2024-04-12 14:10:16');
INSERT INTO `games` VALUES (1698, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-8', 'Blackjack Clasico en Español 8', 'evo-oss-xs-blackjack-clasico-en-espanol-8', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:17', '2024-04-12 14:10:17');
INSERT INTO `games` VALUES (1699, 3, NULL, 'evo-oss-xs-blackjack-clasico-en-espanol-9', 'Blackjack Clasico en Español 9', 'evo-oss-xs-blackjack-clasico-en-espanol-9', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:17', '2024-04-12 14:10:17');
INSERT INTO `games` VALUES (1700, 3, NULL, 'evo-oss-xs-blackjack-classic-17', 'Blackjack Classic 17', 'evo-oss-xs-blackjack-classic-17', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:18', '2024-04-12 14:10:18');
INSERT INTO `games` VALUES (1701, 3, NULL, 'evo-oss-xs-blackjack-classic-18', 'Blackjack Classic 18', 'evo-oss-xs-blackjack-classic-18', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:18', '2024-04-12 14:10:18');
INSERT INTO `games` VALUES (1702, 3, NULL, 'evo-oss-xs-blackjack-classic-20', 'Blackjack Classic 20', 'evo-oss-xs-blackjack-classic-20', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:19', '2024-04-12 14:10:19');
INSERT INTO `games` VALUES (1703, 3, NULL, 'evo-oss-xs-blackjack-classic-24', 'Blackjack Classic 24', 'evo-oss-xs-blackjack-classic-24', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:20', '2024-04-12 14:10:20');
INSERT INTO `games` VALUES (1704, 3, NULL, 'evo-oss-xs-blackjack-classic-25', 'Blackjack Classic 25', 'evo-oss-xs-blackjack-classic-25', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:20', '2024-04-12 14:10:20');
INSERT INTO `games` VALUES (1705, 3, NULL, 'evo-oss-xs-blackjack-classic-26', 'Blackjack Classic 26', 'evo-oss-xs-blackjack-classic-26', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:21', '2024-04-12 14:10:21');
INSERT INTO `games` VALUES (1706, 3, NULL, 'evo-oss-xs-blackjack-classic-29', 'Blackjack Classic 29', 'evo-oss-xs-blackjack-classic-29', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:21', '2024-04-12 14:10:21');
INSERT INTO `games` VALUES (1707, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-1', 'Blackjack Clássico em Português 1', 'evo-oss-xs-blackjack-classico-em-portugues-1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:22', '2024-04-12 14:10:22');
INSERT INTO `games` VALUES (1708, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-10', 'Blackjack Clássico em Português 10', 'evo-oss-xs-blackjack-classico-em-portugues-10', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:23', '2024-04-12 14:10:23');
INSERT INTO `games` VALUES (1709, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-11', 'Blackjack Clássico em Português 11', 'evo-oss-xs-blackjack-classico-em-portugues-11', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:23', '2024-04-12 14:10:23');
INSERT INTO `games` VALUES (1710, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-12', 'Blackjack Clássico em Português 12', 'evo-oss-xs-blackjack-classico-em-portugues-12', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:24', '2024-04-12 14:10:24');
INSERT INTO `games` VALUES (1711, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-13', 'Blackjack Clássico em Português 13', 'evo-oss-xs-blackjack-classico-em-portugues-13', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:24', '2024-04-12 14:10:24');
INSERT INTO `games` VALUES (1712, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-2', 'Blackjack Clássico em Português 2', 'evo-oss-xs-blackjack-classico-em-portugues-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:25', '2024-04-12 14:10:25');
INSERT INTO `games` VALUES (1713, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-3', 'Blackjack Clássico em Português 3', 'evo-oss-xs-blackjack-classico-em-portugues-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:25', '2024-04-12 14:10:25');
INSERT INTO `games` VALUES (1714, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-4', 'Blackjack Clássico em Português 4', 'evo-oss-xs-blackjack-classico-em-portugues-4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:26', '2024-04-12 14:10:26');
INSERT INTO `games` VALUES (1715, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-5', 'Blackjack Clássico em Português 5', 'evo-oss-xs-blackjack-classico-em-portugues-5', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:27', '2024-04-12 14:10:27');
INSERT INTO `games` VALUES (1716, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-6', 'Blackjack Clássico em Português 6', 'evo-oss-xs-blackjack-classico-em-portugues-6', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:27', '2024-04-12 14:10:27');
INSERT INTO `games` VALUES (1717, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-7', 'Blackjack Clássico em Português 7', 'evo-oss-xs-blackjack-classico-em-portugues-7', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:28', '2024-04-12 14:10:28');
INSERT INTO `games` VALUES (1718, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-8', 'Blackjack Clássico em Português 8', 'evo-oss-xs-blackjack-classico-em-portugues-8', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:28', '2024-04-12 14:10:28');
INSERT INTO `games` VALUES (1719, 3, NULL, 'evo-oss-xs-blackjack-classico-em-portugues-9', 'Blackjack Clássico em Português 9', 'evo-oss-xs-blackjack-classico-em-portugues-9', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:29', '2024-04-12 14:10:29');
INSERT INTO `games` VALUES (1720, 11, NULL, 'ez-oss-blackjack-dasorte', 'Blackjack Da Sorte', 'ez-oss-blackjack-dasorte', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:29', '2024-04-12 14:10:29');
INSERT INTO `games` VALUES (1721, 11, NULL, 'ez-oss-blackjackdasorte', 'Blackjack Da Sorte', 'ez-oss-blackjackdasorte', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:30', '2024-04-12 14:10:30');
INSERT INTO `games` VALUES (1722, 3, NULL, 'evo-oss-xs-blackjack-em-portugues-ouro', 'Blackjack em Português Ouro', 'evo-oss-xs-blackjack-em-portugues-ouro', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:31', '2024-04-12 14:10:31');
INSERT INTO `games` VALUES (1723, 3, NULL, 'evo-oss-xs-blackjack-en-espanol-1', 'Blackjack en Español 1', 'evo-oss-xs-blackjack-en-espanol-1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:31', '2024-04-12 14:10:31');
INSERT INTO `games` VALUES (1724, 3, NULL, 'evo-oss-xs-blackjack-en-espanol-2', 'Blackjack en Español 2', 'evo-oss-xs-blackjack-en-espanol-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:32', '2024-04-12 14:10:32');
INSERT INTO `games` VALUES (1725, 3, NULL, 'evo-oss-xs-blackjack-en-espanol-3', 'Blackjack en Español 3', 'evo-oss-xs-blackjack-en-espanol-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:32', '2024-04-12 14:10:32');
INSERT INTO `games` VALUES (1726, 3, NULL, 'evo-oss-xs-blackjack-ilimitado-ao-vivo', 'Blackjack Ilimitado Ao Vivo', 'evo-oss-xs-blackjack-ilimitado-ao-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:33', '2024-04-12 14:10:33');
INSERT INTO `games` VALUES (1727, 3, NULL, 'evo-oss-xs-blackjack-vip-ha', 'Blackjack VIP HÂ', 'evo-oss-xs-blackjack-vip-ha', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:34', '2024-04-12 14:10:34');
INSERT INTO `games` VALUES (1728, 3, NULL, 'evo-oss-xs-blackjack-vip-i', 'Blackjack VIP I', 'evo-oss-xs-blackjack-vip-i', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:34', '2024-04-12 14:10:34');
INSERT INTO `games` VALUES (1729, 3, NULL, 'evo-oss-xs-blackjack-vip-j', 'Blackjack VIP J', 'evo-oss-xs-blackjack-vip-j', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:35', '2024-04-12 14:10:35');
INSERT INTO `games` VALUES (1730, 3, NULL, 'evo-oss-xs-blackjack-vip-k', 'Blackjack VIP K', 'evo-oss-xs-blackjack-vip-k', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:35', '2024-04-12 14:10:35');
INSERT INTO `games` VALUES (1731, 3, NULL, 'evo-oss-xs-blackjack-vip-o', 'Blackjack VIP O', 'evo-oss-xs-blackjack-vip-o', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:36', '2024-04-12 14:10:36');
INSERT INTO `games` VALUES (1732, 3, NULL, 'evo-oss-xs-blackjack-vip-s', 'Blackjack VIP S', 'evo-oss-xs-blackjack-vip-s', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:36', '2024-04-12 14:10:36');
INSERT INTO `games` VALUES (1733, 3, NULL, 'evo-oss-xs-blackjack-vip-u', 'Blackjack VIP U', 'evo-oss-xs-blackjack-vip-u', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:37', '2024-04-12 14:10:37');
INSERT INTO `games` VALUES (1734, 3, NULL, 'evo-oss-xs-blackjack-vip-v', 'Blackjack VIP V', 'evo-oss-xs-blackjack-vip-v', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:38', '2024-04-12 14:10:38');
INSERT INTO `games` VALUES (1735, 3, NULL, 'evo-oss-xs-BrazillianBacBo', 'Brazillian Bac Bo', 'evo-oss-xs-BrazillianBacBo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:38', '2024-04-12 14:10:38');
INSERT INTO `games` VALUES (1736, 3, NULL, 'evo-oss-xs-cash-or-crash', 'Cash or Crash', 'evo-oss-xs-cash-or-crash', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:39', '2024-04-12 14:10:39');
INSERT INTO `games` VALUES (1737, 3, NULL, 'evo-oss-xs-casino-holdem', 'Casino Holdem', 'evo-oss-xs-casino-holdem', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:39', '2024-04-12 14:10:39');
INSERT INTO `games` VALUES (1738, 11, NULL, 'ez-oss-CasinoHoldem', 'Casino Holdem ', 'ez-oss-CasinoHoldem', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:40', '2024-04-12 14:10:40');
INSERT INTO `games` VALUES (1739, 11, NULL, 'ez-oss-CasinoMarinaAndarBahar', 'Casino Marina Andar Bahar', 'ez-oss-CasinoMarinaAndarBahar', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:41', '2024-04-12 14:10:41');
INSERT INTO `games` VALUES (1740, 11, NULL, 'ez-oss-CasinoMarinaBaccarat1', 'Casino Marina Baccarat 1', 'ez-oss-CasinoMarinaBaccarat1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:41', '2024-04-12 14:10:41');
INSERT INTO `games` VALUES (1741, 11, NULL, 'ez-oss-CasinoMarinaBaccarat2', 'Casino Marina Baccarat 2', 'ez-oss-CasinoMarinaBaccarat2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:42', '2024-04-12 14:10:42');
INSERT INTO `games` VALUES (1742, 11, NULL, 'ez-oss-CasinoMarinaBaccarat3', 'Casino Marina Baccarat 3', 'ez-oss-CasinoMarinaBaccarat3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:42', '2024-04-12 14:10:42');
INSERT INTO `games` VALUES (1743, 11, NULL, 'ez-oss-CasinoMarinaBaccarat4', 'Casino Marina Baccarat 4', 'ez-oss-CasinoMarinaBaccarat4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:43', '2024-04-12 14:10:43');
INSERT INTO `games` VALUES (1744, 11, NULL, 'ez-oss-CasinoMarinaRoulette1', 'Casino Marina Roulette 1', 'ez-oss-CasinoMarinaRoulette1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:44', '2024-04-12 14:10:44');
INSERT INTO `games` VALUES (1745, 11, NULL, 'ez-oss-CasinoMarinaRoulette2', 'Casino Marina Roulette 2', 'ez-oss-CasinoMarinaRoulette2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:44', '2024-04-12 14:10:44');
INSERT INTO `games` VALUES (1746, 23, NULL, 'evoplay_6042', 'Catch The Wind', 'evoplay_6042', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:45', '2024-04-12 14:10:45');
INSERT INTO `games` VALUES (1747, 23, NULL, 'evoplay_6041', 'Catch The Wind Bonus Buy', 'evoplay_6041', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:45', '2024-04-12 14:10:45');
INSERT INTO `games` VALUES (1748, 23, NULL, 'evoplay_6080', 'Christmas Crash', 'evoplay_6080', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:46', '2024-04-12 14:10:46');
INSERT INTO `games` VALUES (1749, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-12', 'Classic Speed Blackjack 12', 'evo-oss-xs-classic-speed-blackjack-12', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:46', '2024-04-12 14:10:46');
INSERT INTO `games` VALUES (1750, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-13', 'Classic Speed Blackjack 13', 'evo-oss-xs-classic-speed-blackjack-13', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:47', '2024-04-12 14:10:47');
INSERT INTO `games` VALUES (1751, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-18', 'Classic Speed Blackjack 18', 'evo-oss-xs-classic-speed-blackjack-18', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:48', '2024-04-12 14:10:48');
INSERT INTO `games` VALUES (1752, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-19', 'Classic Speed Blackjack 19', 'evo-oss-xs-classic-speed-blackjack-19', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:48', '2024-04-12 14:10:48');
INSERT INTO `games` VALUES (1753, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-2', 'Classic Speed Blackjack 2', 'evo-oss-xs-classic-speed-blackjack-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:49', '2024-04-12 14:10:49');
INSERT INTO `games` VALUES (1754, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-20', 'Classic Speed Blackjack 20', 'evo-oss-xs-classic-speed-blackjack-20', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:49', '2024-04-12 14:10:49');
INSERT INTO `games` VALUES (1755, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-21', 'Classic Speed Blackjack 21', 'evo-oss-xs-classic-speed-blackjack-21', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:50', '2024-04-12 14:10:50');
INSERT INTO `games` VALUES (1756, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-22', 'Classic Speed Blackjack 22', 'evo-oss-xs-classic-speed-blackjack-22', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:50', '2024-04-12 14:10:50');
INSERT INTO `games` VALUES (1757, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-23', 'Classic Speed Blackjack 23', 'evo-oss-xs-classic-speed-blackjack-23', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:51', '2024-04-12 14:10:51');
INSERT INTO `games` VALUES (1758, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-24', 'Classic Speed Blackjack 24', 'evo-oss-xs-classic-speed-blackjack-24', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:52', '2024-04-12 14:10:52');
INSERT INTO `games` VALUES (1759, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-25', 'Classic Speed Blackjack 25', 'evo-oss-xs-classic-speed-blackjack-25', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:52', '2024-04-12 14:10:52');
INSERT INTO `games` VALUES (1760, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-26', 'Classic Speed Blackjack 26', 'evo-oss-xs-classic-speed-blackjack-26', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:53', '2024-04-12 14:10:53');
INSERT INTO `games` VALUES (1761, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-27', 'Classic Speed Blackjack 27', 'evo-oss-xs-classic-speed-blackjack-27', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:53', '2024-04-12 14:10:53');
INSERT INTO `games` VALUES (1762, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-28', 'Classic Speed Blackjack 28', 'evo-oss-xs-classic-speed-blackjack-28', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:54', '2024-04-12 14:10:54');
INSERT INTO `games` VALUES (1763, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-29', 'Classic Speed Blackjack 29', 'evo-oss-xs-classic-speed-blackjack-29', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:55', '2024-04-12 14:10:55');
INSERT INTO `games` VALUES (1764, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-3', 'Classic Speed Blackjack 3', 'evo-oss-xs-classic-speed-blackjack-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:55', '2024-04-12 14:10:55');
INSERT INTO `games` VALUES (1765, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-30', 'Classic Speed Blackjack 30', 'evo-oss-xs-classic-speed-blackjack-30', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:56', '2024-04-12 14:10:56');
INSERT INTO `games` VALUES (1766, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-31', 'Classic Speed Blackjack 31', 'evo-oss-xs-classic-speed-blackjack-31', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:56', '2024-04-12 14:10:56');
INSERT INTO `games` VALUES (1767, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-32', 'Classic Speed Blackjack 32', 'evo-oss-xs-classic-speed-blackjack-32', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:57', '2024-04-12 14:10:57');
INSERT INTO `games` VALUES (1768, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-33', 'Classic Speed Blackjack 33', 'evo-oss-xs-classic-speed-blackjack-33', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:57', '2024-04-12 14:10:57');
INSERT INTO `games` VALUES (1769, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-34', 'Classic Speed Blackjack 34', 'evo-oss-xs-classic-speed-blackjack-34', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:58', '2024-04-12 14:10:58');
INSERT INTO `games` VALUES (1770, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-35', 'Classic Speed Blackjack 35', 'evo-oss-xs-classic-speed-blackjack-35', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:59', '2024-04-12 14:10:59');
INSERT INTO `games` VALUES (1771, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-36', 'Classic Speed Blackjack 36', 'evo-oss-xs-classic-speed-blackjack-36', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:10:59', '2024-04-12 14:10:59');
INSERT INTO `games` VALUES (1772, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-37', 'Classic Speed Blackjack 37', 'evo-oss-xs-classic-speed-blackjack-37', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:00', '2024-04-12 14:11:00');
INSERT INTO `games` VALUES (1773, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-38', 'Classic Speed Blackjack 38', 'evo-oss-xs-classic-speed-blackjack-38', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:00', '2024-04-12 14:11:00');
INSERT INTO `games` VALUES (1774, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-39', 'Classic Speed Blackjack 39', 'evo-oss-xs-classic-speed-blackjack-39', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:01', '2024-04-12 14:11:01');
INSERT INTO `games` VALUES (1775, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-4', 'Classic Speed Blackjack 4', 'evo-oss-xs-classic-speed-blackjack-4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:02', '2024-04-12 14:11:02');
INSERT INTO `games` VALUES (1776, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-40', 'Classic Speed Blackjack 40', 'evo-oss-xs-classic-speed-blackjack-40', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:02', '2024-04-12 14:11:02');
INSERT INTO `games` VALUES (1777, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-41', 'Classic Speed Blackjack 41', 'evo-oss-xs-classic-speed-blackjack-41', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:03', '2024-04-12 14:11:03');
INSERT INTO `games` VALUES (1778, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-42', 'Classic Speed Blackjack 42', 'evo-oss-xs-classic-speed-blackjack-42', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:03', '2024-04-12 14:11:03');
INSERT INTO `games` VALUES (1779, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-43', 'Classic Speed Blackjack 43', 'evo-oss-xs-classic-speed-blackjack-43', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:04', '2024-04-12 14:11:04');
INSERT INTO `games` VALUES (1780, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-44', 'Classic Speed Blackjack 44', 'evo-oss-xs-classic-speed-blackjack-44', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:04', '2024-04-12 14:11:04');
INSERT INTO `games` VALUES (1781, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-45', 'Classic Speed Blackjack 45', 'evo-oss-xs-classic-speed-blackjack-45', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:05', '2024-04-12 14:11:05');
INSERT INTO `games` VALUES (1782, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-46', 'Classic Speed Blackjack 46', 'evo-oss-xs-classic-speed-blackjack-46', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:06', '2024-04-12 14:11:06');
INSERT INTO `games` VALUES (1783, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-47', 'Classic Speed Blackjack 47', 'evo-oss-xs-classic-speed-blackjack-47', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:06', '2024-04-12 14:11:06');
INSERT INTO `games` VALUES (1784, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-48', 'Classic Speed Blackjack 48', 'evo-oss-xs-classic-speed-blackjack-48', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:07', '2024-04-12 14:11:07');
INSERT INTO `games` VALUES (1785, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-49', 'Classic Speed Blackjack 49', 'evo-oss-xs-classic-speed-blackjack-49', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:07', '2024-04-12 14:11:07');
INSERT INTO `games` VALUES (1786, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-5', 'Classic Speed Blackjack 5', 'evo-oss-xs-classic-speed-blackjack-5', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:08', '2024-04-12 14:11:08');
INSERT INTO `games` VALUES (1787, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-50', 'Classic Speed Blackjack 50', 'evo-oss-xs-classic-speed-blackjack-50', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:09', '2024-04-12 14:11:09');
INSERT INTO `games` VALUES (1788, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-51', 'Classic Speed Blackjack 51', 'evo-oss-xs-classic-speed-blackjack-51', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:09', '2024-04-12 14:11:09');
INSERT INTO `games` VALUES (1789, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-52', 'Classic Speed Blackjack 52', 'evo-oss-xs-classic-speed-blackjack-52', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:10', '2024-04-12 14:11:10');
INSERT INTO `games` VALUES (1790, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-53', 'Classic Speed Blackjack 53', 'evo-oss-xs-classic-speed-blackjack-53', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:10', '2024-04-12 14:11:10');
INSERT INTO `games` VALUES (1791, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-54', 'Classic Speed Blackjack 54', 'evo-oss-xs-classic-speed-blackjack-54', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:11', '2024-04-12 14:11:11');
INSERT INTO `games` VALUES (1792, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-55', 'Classic Speed Blackjack 55', 'evo-oss-xs-classic-speed-blackjack-55', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:11', '2024-04-12 14:11:11');
INSERT INTO `games` VALUES (1793, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-56', 'Classic Speed Blackjack 56', 'evo-oss-xs-classic-speed-blackjack-56', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:12', '2024-04-12 14:11:12');
INSERT INTO `games` VALUES (1794, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-57', 'Classic Speed Blackjack 57', 'evo-oss-xs-classic-speed-blackjack-57', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:13', '2024-04-12 14:11:13');
INSERT INTO `games` VALUES (1795, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-58', 'Classic Speed Blackjack 58', 'evo-oss-xs-classic-speed-blackjack-58', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:13', '2024-04-12 14:11:13');
INSERT INTO `games` VALUES (1796, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-59', 'Classic Speed Blackjack 59', 'evo-oss-xs-classic-speed-blackjack-59', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:14', '2024-04-12 14:11:14');
INSERT INTO `games` VALUES (1797, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-6', 'Classic Speed Blackjack 6', 'evo-oss-xs-classic-speed-blackjack-6', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:14', '2024-04-12 14:11:14');
INSERT INTO `games` VALUES (1798, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-60', 'Classic Speed Blackjack 60', 'evo-oss-xs-classic-speed-blackjack-60', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:15', '2024-04-12 14:11:15');
INSERT INTO `games` VALUES (1799, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-61', 'Classic Speed Blackjack 61', 'evo-oss-xs-classic-speed-blackjack-61', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:16', '2024-04-12 14:11:16');
INSERT INTO `games` VALUES (1800, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-62', 'Classic Speed Blackjack 62', 'evo-oss-xs-classic-speed-blackjack-62', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:16', '2024-04-12 14:11:16');
INSERT INTO `games` VALUES (1801, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-67', 'Classic Speed Blackjack 67', 'evo-oss-xs-classic-speed-blackjack-67', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:17', '2024-04-12 14:11:17');
INSERT INTO `games` VALUES (1802, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-68', 'Classic Speed Blackjack 68', 'evo-oss-xs-classic-speed-blackjack-68', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:17', '2024-04-12 14:11:17');
INSERT INTO `games` VALUES (1803, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-69', 'Classic Speed Blackjack 69', 'evo-oss-xs-classic-speed-blackjack-69', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:18', '2024-04-12 14:11:18');
INSERT INTO `games` VALUES (1804, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-7', 'Classic Speed Blackjack 7', 'evo-oss-xs-classic-speed-blackjack-7', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:18', '2024-04-12 14:11:18');
INSERT INTO `games` VALUES (1805, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-70', 'Classic Speed Blackjack 70', 'evo-oss-xs-classic-speed-blackjack-70', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:19', '2024-04-12 14:11:19');
INSERT INTO `games` VALUES (1806, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-76', 'Classic Speed Blackjack 76', 'evo-oss-xs-classic-speed-blackjack-76', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:20', '2024-04-12 14:11:20');
INSERT INTO `games` VALUES (1807, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-77', 'Classic Speed Blackjack 77', 'evo-oss-xs-classic-speed-blackjack-77', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:20', '2024-04-12 14:11:20');
INSERT INTO `games` VALUES (1808, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-78', 'Classic Speed Blackjack 78', 'evo-oss-xs-classic-speed-blackjack-78', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:21', '2024-04-12 14:11:21');
INSERT INTO `games` VALUES (1809, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-79', 'Classic Speed Blackjack 79', 'evo-oss-xs-classic-speed-blackjack-79', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:21', '2024-04-12 14:11:21');
INSERT INTO `games` VALUES (1810, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-8', 'Classic Speed Blackjack 8', 'evo-oss-xs-classic-speed-blackjack-8', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:22', '2024-04-12 14:11:22');
INSERT INTO `games` VALUES (1811, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-80', 'Classic Speed Blackjack 80', 'evo-oss-xs-classic-speed-blackjack-80', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:23', '2024-04-12 14:11:23');
INSERT INTO `games` VALUES (1812, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-81', 'Classic Speed Blackjack 81', 'evo-oss-xs-classic-speed-blackjack-81', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:23', '2024-04-12 14:11:23');
INSERT INTO `games` VALUES (1813, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-82', 'Classic Speed Blackjack 82', 'evo-oss-xs-classic-speed-blackjack-82', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:24', '2024-04-12 14:11:24');
INSERT INTO `games` VALUES (1814, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-83', 'Classic Speed Blackjack 83', 'evo-oss-xs-classic-speed-blackjack-83', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:24', '2024-04-12 14:11:24');
INSERT INTO `games` VALUES (1815, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-84', 'Classic Speed Blackjack 84', 'evo-oss-xs-classic-speed-blackjack-84', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:25', '2024-04-12 14:11:25');
INSERT INTO `games` VALUES (1816, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-85', 'Classic Speed Blackjack 85', 'evo-oss-xs-classic-speed-blackjack-85', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:25', '2024-04-12 14:11:25');
INSERT INTO `games` VALUES (1817, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-86', 'Classic Speed Blackjack 86', 'evo-oss-xs-classic-speed-blackjack-86', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:26', '2024-04-12 14:11:26');
INSERT INTO `games` VALUES (1818, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-87', 'Classic Speed Blackjack 87', 'evo-oss-xs-classic-speed-blackjack-87', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:27', '2024-04-12 14:11:27');
INSERT INTO `games` VALUES (1819, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-88', 'Classic Speed Blackjack 88', 'evo-oss-xs-classic-speed-blackjack-88', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:27', '2024-04-12 14:11:27');
INSERT INTO `games` VALUES (1820, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-89', 'Classic Speed Blackjack 89', 'evo-oss-xs-classic-speed-blackjack-89', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:28', '2024-04-12 14:11:28');
INSERT INTO `games` VALUES (1821, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-9', 'Classic Speed Blackjack 9', 'evo-oss-xs-classic-speed-blackjack-9', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:28', '2024-04-12 14:11:28');
INSERT INTO `games` VALUES (1822, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-90', 'Classic Speed Blackjack 90', 'evo-oss-xs-classic-speed-blackjack-90', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:29', '2024-04-12 14:11:29');
INSERT INTO `games` VALUES (1823, 3, NULL, 'evo-oss-xs-classic-speed-blackjack-91', 'Classic Speed Blackjack 91', 'evo-oss-xs-classic-speed-blackjack-91', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:30', '2024-04-12 14:11:30');
INSERT INTO `games` VALUES (1824, 3, NULL, 'evo-oss-xs-crazy-coin-flip', 'Crazy Coin Flip', 'evo-oss-xs-crazy-coin-flip', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:30', '2024-04-12 14:11:30');
INSERT INTO `games` VALUES (1825, 3, NULL, 'evo-oss-xs-crazy-pachinko', 'Crazy Pachinko', 'evo-oss-xs-crazy-pachinko', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:31', '2024-04-12 14:11:31');
INSERT INTO `games` VALUES (1826, 3, NULL, 'evo-oss-xs-crazy-time-a', 'Crazy Time A', 'evo-oss-xs-crazy-time-a', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:31', '2024-04-12 14:11:31');
INSERT INTO `games` VALUES (1827, 23, NULL, 'evoplay_6057', 'Cursed Can', 'evoplay_6057', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:32', '2024-04-12 14:11:32');
INSERT INTO `games` VALUES (1828, 23, NULL, 'evoplay_6061', 'Cursed Can Bonus Buy', 'evoplay_6061', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:32', '2024-04-12 14:11:32');
INSERT INTO `games` VALUES (1829, 11, NULL, 'ez-oss-DiamondRoulette', 'Diamond Roulette', 'ez-oss-DiamondRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:33', '2024-04-12 14:11:33');
INSERT INTO `games` VALUES (1830, 1, NULL, 'spb-tb-dice', 'Dice', 'spb-tb-dice', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:34', '2024-04-12 14:11:34');
INSERT INTO `games` VALUES (1831, 13, NULL, 'pgs-slot-dimSumMania', 'Dim Sum Mania', 'pgs-slot-dimSumMania', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:34', '2024-04-12 14:11:34');
INSERT INTO `games` VALUES (1832, 3, NULL, 'evo-oss-xs-dragon-tiger', 'Dragon Tiger', 'evo-oss-xs-dragon-tiger', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:35', '2024-04-12 14:11:35');
INSERT INTO `games` VALUES (1833, 11, NULL, 'ez-oss-DragonTiger', 'Dragon Tiger ', 'ez-oss-DragonTiger', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:35', '2024-04-12 14:11:35');
INSERT INTO `games` VALUES (1834, 11, NULL, 'ez-oss-DragonTigerdasorte', 'Dragon Tiger da sorte', 'ez-oss-DragonTigerdasorte', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:36', '2024-04-12 14:11:36');
INSERT INTO `games` VALUES (1835, 3, NULL, 'evo-oss-xs-dragonara-roulette', 'Dragonara Roulette', 'evo-oss-xs-dragonara-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:37', '2024-04-12 14:11:37');
INSERT INTO `games` VALUES (1836, 23, NULL, 'evoplay_6037', 'Elven Princesses: Crown Quest', 'evoplay_6037', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:37', '2024-04-12 14:11:37');
INSERT INTO `games` VALUES (1837, 3, NULL, 'evo-oss-xs-EmperorBacBo', 'Emperor Bac Bo', 'evo-oss-xs-EmperorBacBo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:38', '2024-04-12 14:11:38');
INSERT INTO `games` VALUES (1838, 3, NULL, 'evo-oss-xs-EmperorDragonTiger', 'Emperor Dragon Tiger', 'evo-oss-xs-EmperorDragonTiger', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:38', '2024-04-12 14:11:38');
INSERT INTO `games` VALUES (1839, 3, NULL, 'evo-oss-xs-EmperorSicBo', 'Emperor Sic Bo', 'evo-oss-xs-EmperorSicBo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:39', '2024-04-12 14:11:39');
INSERT INTO `games` VALUES (1840, 3, NULL, 'evo-oss-xs-EmperorSpeedBaccaratA', 'Emperor Speed Baccarat A', 'evo-oss-xs-EmperorSpeedBaccaratA', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:39', '2024-04-12 14:11:39');
INSERT INTO `games` VALUES (1841, 3, NULL, 'evo-oss-xs-EmperorSpeedBaccaratB', 'Emperor Speed Baccarat B', 'evo-oss-xs-EmperorSpeedBaccaratB', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:40', '2024-04-12 14:11:40');
INSERT INTO `games` VALUES (1842, 3, NULL, 'evo-oss-xs-EmperorSpeedBaccaratC', 'Emperor Speed Baccarat C', 'evo-oss-xs-EmperorSpeedBaccaratC', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:41', '2024-04-12 14:11:41');
INSERT INTO `games` VALUES (1843, 23, NULL, 'evoplay_6025', 'Europe Transit', 'evoplay_6025', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:41', '2024-04-12 14:11:41');
INSERT INTO `games` VALUES (1844, 23, NULL, 'evoplay_6035', 'Europe Transit Bonus Buy', 'evoplay_6035', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:42', '2024-04-12 14:11:42');
INSERT INTO `games` VALUES (1845, 13, NULL, 'pgs-tb-EuropeanBlackjack', 'European Blackjack', 'pgs-tb-EuropeanBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:42', '2024-04-12 14:11:42');
INSERT INTO `games` VALUES (1846, 23, NULL, 'evoplay_2365', 'European Roulette', 'evoplay_2365', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:43', '2024-04-12 14:11:43');
INSERT INTO `games` VALUES (1847, 3, NULL, 'evo-oss-xs-extrachilliepicspins', 'Extra Chilli Epic Spins', 'evo-oss-xs-extrachilliepicspins', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:44', '2024-04-12 14:11:44');
INSERT INTO `games` VALUES (1848, 11, NULL, 'ez-oss-DealerRouletteBrazil', 'EZ Dealer Roulette Brazil', 'ez-oss-DealerRouletteBrazil', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:44', '2024-04-12 14:11:44');
INSERT INTO `games` VALUES (1849, 11, NULL, 'ez-oss-DealerRouletteJapanese', 'EZ Dealer Roulette Japanese', 'ez-oss-DealerRouletteJapanese', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:45', '2024-04-12 14:11:45');
INSERT INTO `games` VALUES (1850, 11, NULL, 'ez-oss-DealerRouletteMandarin', 'EZ Dealer Roulette Mandarin', 'ez-oss-DealerRouletteMandarin', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:45', '2024-04-12 14:11:45');
INSERT INTO `games` VALUES (1851, 11, NULL, 'ez-oss-DealerRouletteThai', 'EZ Dealer Roulette Thai', 'ez-oss-DealerRouletteThai', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:46', '2024-04-12 14:11:46');
INSERT INTO `games` VALUES (1852, 11, NULL, 'ez-oss-FiestaBaccarat', 'Fiesta Baccarat ', 'ez-oss-FiestaBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:46', '2024-04-12 14:11:46');
INSERT INTO `games` VALUES (1853, 11, NULL, 'ez-oss-FiestaRoulette', 'Fiesta Roulette ', 'ez-oss-FiestaRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:47', '2024-04-12 14:11:47');
INSERT INTO `games` VALUES (1854, 3, NULL, 'evo-oss-xs-first-person-deal-or-no-deal', 'First Person Deal or No Deal', 'evo-oss-xs-first-person-deal-or-no-deal', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:48', '2024-04-12 14:11:48');
INSERT INTO `games` VALUES (1855, 3, NULL, 'evo-oss-xs-first-person-dream-catcher', 'First Person Dream Catcher', 'evo-oss-xs-first-person-dream-catcher', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:48', '2024-04-12 14:11:48');
INSERT INTO `games` VALUES (1856, 23, NULL, 'evoplay_5928', 'Football Scratch', 'evoplay_5928', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:49', '2024-04-12 14:11:49');
INSERT INTO `games` VALUES (1857, 13, NULL, 'pgs-ForgeofWealth', 'Forge Of Wealth', 'pgs-ForgeofWealth', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:49', '2024-04-12 14:11:49');
INSERT INTO `games` VALUES (1858, 3, NULL, 'evo-oss-xs-free-bet-blackjack-1', 'Free Bet Blackjack 1', 'evo-oss-xs-free-bet-blackjack-1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:50', '2024-04-12 14:11:50');
INSERT INTO `games` VALUES (1859, 3, NULL, 'evo-oss-xs-free-bet-blackjack-2', 'Free Bet Blackjack 2', 'evo-oss-xs-free-bet-blackjack-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:50', '2024-04-12 14:11:50');
INSERT INTO `games` VALUES (1860, 3, NULL, 'evo-oss-xs-free-bet-blackjack-3', 'Free Bet Blackjack 3', 'evo-oss-xs-free-bet-blackjack-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:51', '2024-04-12 14:11:51');
INSERT INTO `games` VALUES (1861, 3, NULL, 'evo-oss-xs-free-bet-blackjack-4', 'Free Bet Blackjack 4', 'evo-oss-xs-free-bet-blackjack-4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:52', '2024-04-12 14:11:52');
INSERT INTO `games` VALUES (1862, 3, NULL, 'evo-oss-xs-free-bet-blackjack-5', 'Free Bet Blackjack 5', 'evo-oss-xs-free-bet-blackjack-5', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:52', '2024-04-12 14:11:52');
INSERT INTO `games` VALUES (1863, 3, NULL, 'evo-oss-xs-free-bet-blackjack-6', 'Free Bet Blackjack 6', 'evo-oss-xs-free-bet-blackjack-6', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:53', '2024-04-12 14:11:53');
INSERT INTO `games` VALUES (1864, 3, NULL, 'evo-oss-xs-free-bet-blackjack-7', 'Free Bet Blackjack 7', 'evo-oss-xs-free-bet-blackjack-7', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:53', '2024-04-12 14:11:53');
INSERT INTO `games` VALUES (1865, 3, NULL, 'evo-oss-xs-FreeBet-bj-ClassicoPTBR', 'Free Bet Blackjack Clássico em Português 1- LIVE', 'evo-oss-xs-FreeBet-bj-ClassicoPTBR', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:54', '2024-04-12 14:11:54');
INSERT INTO `games` VALUES (1866, 3, NULL, 'evo-oss-xs-funky-time', 'Funky Time', 'evo-oss-xs-funky-time', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:55', '2024-04-12 14:11:55');
INSERT INTO `games` VALUES (1867, 3, NULL, 'evo-oss-xs-futbol-studio', 'Futbol Studio', 'evo-oss-xs-futbol-studio', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:55', '2024-04-12 14:11:55');
INSERT INTO `games` VALUES (1868, 13, NULL, 'pgs-gemstonesgold', 'Gemstones Gold', 'pgs-gemstonesgold', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:56', '2024-04-12 14:11:56');
INSERT INTO `games` VALUES (1869, 13, NULL, 'pgs-GladiatorsGlory', 'Gladiators Glory', 'pgs-GladiatorsGlory', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:56', '2024-04-12 14:11:56');
INSERT INTO `games` VALUES (1870, 1, NULL, 'spb-tb-goal', 'Goal', 'spb-tb-goal', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:57', '2024-04-12 14:11:57');
INSERT INTO `games` VALUES (1871, 23, NULL, 'evoplay_6021', 'Goddess Of The Night Bonus Buy', 'evoplay_6021', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:57', '2024-04-12 14:11:57');
INSERT INTO `games` VALUES (1872, 11, NULL, 'ez-oss-GoldBlackjack3', 'Gold Blackjack 3 ', 'ez-oss-GoldBlackjack3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:58', '2024-04-12 14:11:58');
INSERT INTO `games` VALUES (1873, 11, NULL, 'ez-oss-GoldBlackjack4', 'Gold Blackjack 4 ', 'ez-oss-GoldBlackjack4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:59', '2024-04-12 14:11:59');
INSERT INTO `games` VALUES (1874, 11, NULL, 'ez-oss-GoldBlackjack5', 'Gold Blackjack 5 ', 'ez-oss-GoldBlackjack5', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:11:59', '2024-04-12 14:11:59');
INSERT INTO `games` VALUES (1875, 11, NULL, 'ez-oss-GoldBlackjack6', 'Gold Blackjack 6 ', 'ez-oss-GoldBlackjack6', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:00', '2024-04-12 14:12:00');
INSERT INTO `games` VALUES (1876, 3, NULL, 'evo-oss-xs-goldvaultroulette', 'Gold Vault Roulette', 'evo-oss-xs-goldvaultroulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:00', '2024-04-12 14:12:00');
INSERT INTO `games` VALUES (1877, 10, NULL, 'boo-slot-goldenRoyals', 'Golden Royals', 'boo-slot-goldenRoyals', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:01', '2024-04-12 14:12:01');
INSERT INTO `games` VALUES (1878, 3, NULL, 'evo-oss-xs-gonzos-treasure-hunt', 'Gonzos Treasure Hunt', 'evo-oss-xs-gonzos-treasure-hunt', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:02', '2024-04-12 14:12:02');
INSERT INTO `games` VALUES (1879, 1, NULL, 'spb-tb-hilo', 'Hi-lo', 'spb-tb-hilo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:02', '2024-04-12 14:12:02');
INSERT INTO `games` VALUES (1880, 3, NULL, 'evo-oss-xs-hippodrome-grand-casino', 'Hippodrome Grand Casino', 'evo-oss-xs-hippodrome-grand-casino', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:03', '2024-04-12 14:12:03');
INSERT INTO `games` VALUES (1881, 23, NULL, 'evoplay_6084', 'Hockey Shootout', 'evoplay_6084', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:03', '2024-04-12 14:12:03');
INSERT INTO `games` VALUES (1882, 10, NULL, 'boo-HollyJollyBonanza', 'Holly Jolly Bonanza', 'boo-HollyJollyBonanza', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:04', '2024-04-12 14:12:04');
INSERT INTO `games` VALUES (1883, 10, NULL, 'boo-HoopKings', 'Hoop Kings', 'boo-HoopKings', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:04', '2024-04-12 14:12:04');
INSERT INTO `games` VALUES (1884, 26, NULL, 'op-slot-HotandSpicy', 'Hot and Spicy', 'op-slot-HotandSpicy', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:05', '2024-04-12 14:12:05');
INSERT INTO `games` VALUES (1885, 23, NULL, 'evoplay_6044', 'Hot Mania', 'evoplay_6044', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:06', '2024-04-12 14:12:06');
INSERT INTO `games` VALUES (1886, 1, NULL, 'spb-tb-hotline', 'Hotline', 'spb-tb-hotline', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:06', '2024-04-12 14:12:06');
INSERT INTO `games` VALUES (1887, 3, NULL, 'evo-oss-xs-infinite-free-bet-blackjack', 'Infinite Free Bet Blackjack', 'evo-oss-xs-infinite-free-bet-blackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:07', '2024-04-12 14:12:07');
INSERT INTO `games` VALUES (1888, 3, NULL, 'evo-oss-xs-instant-roulette', 'Instant Roulette', 'evo-oss-xs-instant-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:07', '2024-04-12 14:12:07');
INSERT INTO `games` VALUES (1889, 11, NULL, 'ez-oss-ItalianBaccarat', 'Italian Baccarat ', 'ez-oss-ItalianBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:08', '2024-04-12 14:12:08');
INSERT INTO `games` VALUES (1890, 11, NULL, 'ez-oss-ItalianBlackjack', 'Italian Blackjack ', 'ez-oss-ItalianBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:09', '2024-04-12 14:12:09');
INSERT INTO `games` VALUES (1891, 11, NULL, 'ez-oss-ItalianRoulette', 'Italian Roulette ', 'ez-oss-ItalianRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:09', '2024-04-12 14:12:09');
INSERT INTO `games` VALUES (1892, 10, NULL, 'boo-JesterRiches', 'Jester Riches', 'boo-JesterRiches', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:10', '2024-04-12 14:12:10');
INSERT INTO `games` VALUES (1893, 23, NULL, 'evoplay_6039', 'Jhana of God', 'evoplay_6039', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:10', '2024-04-12 14:12:10');
INSERT INTO `games` VALUES (1894, 23, NULL, 'evoplay_6040', 'Jhana of God Bonus Buy', 'evoplay_6040', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:11', '2024-04-12 14:12:11');
INSERT INTO `games` VALUES (1895, 23, NULL, 'evoplay_6063', 'Jhana Of God: Scratch', 'evoplay_6063', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:11', '2024-04-12 14:12:11');
INSERT INTO `games` VALUES (1896, 23, NULL, 'evoplay_631', 'Journey to the West', 'evoplay_631', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:12', '2024-04-12 14:12:12');
INSERT INTO `games` VALUES (1897, 11, NULL, 'ez-oss-KnockoutBaccarat', 'Knockout Baccarat', 'ez-oss-KnockoutBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:13', '2024-04-12 14:12:13');
INSERT INTO `games` VALUES (1898, 23, NULL, 'evoplay_6089', 'Legacy Of The Sages', 'evoplay_6089', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:13', '2024-04-12 14:12:13');
INSERT INTO `games` VALUES (1899, 23, NULL, 'evoplay_6097', 'Legacy Of The Sages Bonus Buy', 'evoplay_6097', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:14', '2024-04-12 14:12:14');
INSERT INTO `games` VALUES (1900, 3, NULL, 'evo-oss-xs-lightning-lotto', 'Lightning Lotto', 'evo-oss-xs-lightning-lotto', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:14', '2024-04-12 14:12:14');
INSERT INTO `games` VALUES (1901, 11, NULL, 'ez-oss-Lucky7', 'Lucky 7 ', 'ez-oss-Lucky7', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:15', '2024-04-12 14:12:15');
INSERT INTO `games` VALUES (1902, 23, NULL, 'evoplay_6029', 'Lucky Porker', 'evoplay_6029', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:16', '2024-04-12 14:12:16');
INSERT INTO `games` VALUES (1903, 23, NULL, 'evoplay_6033', 'Lucky Porker Bonus Buy', 'evoplay_6033', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:16', '2024-04-12 14:12:16');
INSERT INTO `games` VALUES (1904, 13, NULL, 'pgs-MafiaMayhem', 'Mafia Mayhem', 'pgs-MafiaMayhem', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:17', '2024-04-12 14:12:17');
INSERT INTO `games` VALUES (1905, 3, NULL, 'evo-oss-xs-mega-bola', 'Mega Bola', 'evo-oss-xs-mega-bola', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:17', '2024-04-12 14:12:17');
INSERT INTO `games` VALUES (1906, 3, NULL, 'evo-oss-xs-mega-bola-da-sorte', 'Mega Bola Da Sorte', 'evo-oss-xs-mega-bola-da-sorte', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:18', '2024-04-12 14:12:18');
INSERT INTO `games` VALUES (1907, 23, NULL, 'evoplay_6071', 'Mega Fruit 40', 'evoplay_6071', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:18', '2024-04-12 14:12:18');
INSERT INTO `games` VALUES (1908, 23, NULL, 'evoplay_6081', 'Mega Juicer 5', 'evoplay_6081', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:19', '2024-04-12 14:12:19');
INSERT INTO `games` VALUES (1909, 15, NULL, 'sms-MineIsland', 'Mine Island', 'sms-MineIsland', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:20', '2024-04-12 14:12:20');
INSERT INTO `games` VALUES (1910, 3, NULL, 'evo-oss-xs-monopoly-big-baller', 'Monopoly Big Baller', 'evo-oss-xs-monopoly-big-baller', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:20', '2024-04-12 14:12:20');
INSERT INTO `games` VALUES (1911, 3, NULL, 'evo-oss-xs-monopoly-live', 'Monopoly Live', 'evo-oss-xs-monopoly-live', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:21', '2024-04-12 14:12:21');
INSERT INTO `games` VALUES (1912, 11, NULL, 'ez-oss-NamasteRoulette', 'Namaste Roulette', 'ez-oss-NamasteRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:21', '2024-04-12 14:12:21');
INSERT INTO `games` VALUES (1913, 3, NULL, 'evo-oss-xs-no-commission-baccarat', 'No Commission Baccarat', 'evo-oss-xs-no-commission-baccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:22', '2024-04-12 14:12:22');
INSERT INTO `games` VALUES (1914, 23, NULL, 'evoplay_6023', 'Northern Temple Bonus Buy', 'evoplay_6023', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:22', '2024-04-12 14:12:22');
INSERT INTO `games` VALUES (1915, 23, NULL, 'evoplay_6052', 'October Pub', 'evoplay_6052', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:23', '2024-04-12 14:12:23');
INSERT INTO `games` VALUES (1916, 11, NULL, 'ez-oss-OneDayTeenPatti', 'One Day Teen Patti', 'ez-oss-OneDayTeenPatti', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:24', '2024-04-12 14:12:24');
INSERT INTO `games` VALUES (1917, 11, NULL, 'ez-oss-Oracle360Roulette', 'Oracle 360 Roulette', 'ez-oss-Oracle360Roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:24', '2024-04-12 14:12:24');
INSERT INTO `games` VALUES (1918, 11, NULL, 'ez-oss-OracleRoulette2', 'Oracle Roulette 2', 'ez-oss-OracleRoulette2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:25', '2024-04-12 14:12:25');
INSERT INTO `games` VALUES (1919, 13, NULL, 'pgs-slot-PeasFairy', 'Peas Fairy', 'pgs-slot-PeasFairy', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:25', '2024-04-12 14:12:25');
INSERT INTO `games` VALUES (1920, 23, NULL, 'evoplay_6019', 'Penalty Roulette', 'evoplay_6019', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:26', '2024-04-12 14:12:26');
INSERT INTO `games` VALUES (1921, 23, NULL, 'evoplay_5643', 'Penalty Shoot Out', 'evoplay_5643', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:27', '2024-04-12 14:12:27');
INSERT INTO `games` VALUES (1922, 23, NULL, 'evoplay_6013', 'Penalty Shoot-Out Street', 'evoplay_6013', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:27', '2024-04-12 14:12:27');
INSERT INTO `games` VALUES (1923, 11, NULL, 'ez-oss-PlatinumBlackjack1', 'Platinum Blackjack 1', 'ez-oss-PlatinumBlackjack1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:28', '2024-04-12 14:12:28');
INSERT INTO `games` VALUES (1924, 11, NULL, 'ez-oss-PortomasoRoulette2', 'Portomaso Roulette 2', 'ez-oss-PortomasoRoulette2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:28', '2024-04-12 14:12:28');
INSERT INTO `games` VALUES (1925, 11, NULL, 'ez-oss-PrestigeAutoRoulette', 'Prestige Auto Roulette', 'ez-oss-PrestigeAutoRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:29', '2024-04-12 14:12:29');
INSERT INTO `games` VALUES (1926, 23, NULL, 'evoplay_6060', 'Pumpkin Master', 'evoplay_6060', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:29', '2024-04-12 14:12:29');
INSERT INTO `games` VALUES (1927, 3, NULL, 'evo-oss-xs-red-door-roulette', 'Red Door Roulette', 'evo-oss-xs-red-door-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:30', '2024-04-12 14:12:30');
INSERT INTO `games` VALUES (1928, 13, NULL, 'pgs-slot-RestaurantCraze', 'Restaurant Craze', 'pgs-slot-RestaurantCraze', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:31', '2024-04-12 14:12:31');
INSERT INTO `games` VALUES (1929, 3, NULL, 'evo-oss-xs-roleta-ao-vivo', 'Roleta Ao Vivo', 'evo-oss-xs-roleta-ao-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:31', '2024-04-12 14:12:31');
INSERT INTO `games` VALUES (1930, 11, NULL, 'ez-oss-Roletadasorte', 'Roleta da sorte ', 'ez-oss-Roletadasorte', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:32', '2024-04-12 14:12:32');
INSERT INTO `games` VALUES (1931, 3, NULL, 'evo-oss-xs-roleta-relampago', 'Roleta Relâmpago', 'evo-oss-xs-roleta-relampago', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:32', '2024-04-12 14:12:32');
INSERT INTO `games` VALUES (1932, 23, NULL, 'evoplay_2310', 'Roll The Dice', 'evoplay_2310', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:33', '2024-04-12 14:12:33');
INSERT INTO `games` VALUES (1933, 3, NULL, 'evo-oss-xs-roulette', 'Roulette', 'evo-oss-xs-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:34', '2024-04-12 14:12:34');
INSERT INTO `games` VALUES (1934, 3, NULL, 'evo-oss-xs-ruleta-auto-francesa', 'Ruleta Auto Francesa', 'evo-oss-xs-ruleta-auto-francesa', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:34', '2024-04-12 14:12:34');
INSERT INTO `games` VALUES (1935, 3, NULL, 'evo-oss-xs-ruleta-automatica', 'Ruleta Automática', 'evo-oss-xs-ruleta-automatica', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:35', '2024-04-12 14:12:35');
INSERT INTO `games` VALUES (1936, 3, NULL, 'evo-oss-xs-ruleta-bola-rapida-en-vivo', 'Ruleta Bola Rapida en Vivo', 'evo-oss-xs-ruleta-bola-rapida-en-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:35', '2024-04-12 14:12:35');
INSERT INTO `games` VALUES (1937, 11, NULL, 'ez-oss-RuletadelSol', 'Ruleta del Sol ', 'ez-oss-RuletadelSol', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:36', '2024-04-12 14:12:36');
INSERT INTO `games` VALUES (1938, 3, NULL, 'evo-oss-xs-ruleta-dual-play', 'Ruleta Dual Play', 'evo-oss-xs-ruleta-dual-play', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:36', '2024-04-12 14:12:36');
INSERT INTO `games` VALUES (1939, 3, NULL, 'evo-oss-xs-ruleta-en-espanol', 'Ruleta en Español', 'evo-oss-xs-ruleta-en-espanol', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:37', '2024-04-12 14:12:37');
INSERT INTO `games` VALUES (1940, 3, NULL, 'evo-oss-xs-ruleta-en-vivo', 'Ruleta En Vivo', 'evo-oss-xs-ruleta-en-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:38', '2024-04-12 14:12:38');
INSERT INTO `games` VALUES (1941, 3, NULL, 'evo-oss-xs-ruleta-francesa-en-vivo', 'Ruleta Francesa en Vivo', 'evo-oss-xs-ruleta-francesa-en-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:38', '2024-04-12 14:12:38');
INSERT INTO `games` VALUES (1942, 3, NULL, 'evo-oss-xs-ruleta-relampago-en-vivo', 'Ruleta Relámpago en Vivo', 'evo-oss-xs-ruleta-relampago-en-vivo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:39', '2024-04-12 14:12:39');
INSERT INTO `games` VALUES (1943, 11, NULL, 'ez-oss-RumbaBlackjack1', 'Rumba Blackjack 1', 'ez-oss-RumbaBlackjack1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:39', '2024-04-12 14:12:39');
INSERT INTO `games` VALUES (1944, 11, NULL, 'ez-oss-RumbaBlackjack3', 'Rumba Blackjack 3', 'ez-oss-RumbaBlackjack3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:40', '2024-04-12 14:12:40');
INSERT INTO `games` VALUES (1945, 11, NULL, 'ez-oss-RumbaBlackjack4', 'Rumba Blackjack 4', 'ez-oss-RumbaBlackjack4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:41', '2024-04-12 14:12:41');
INSERT INTO `games` VALUES (1946, 23, NULL, 'evoplay_6064', 'Rumble In The Shadows', 'evoplay_6064', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:41', '2024-04-12 14:12:41');
INSERT INTO `games` VALUES (1947, 11, NULL, 'ez-oss-RussianBlackjack1', 'Russian Blackjack 1', 'ez-oss-RussianBlackjack1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:42', '2024-04-12 14:12:42');
INSERT INTO `games` VALUES (1948, 11, NULL, 'ez-oss-RussianBlackjack2', 'Russian Blackjack 2', 'ez-oss-RussianBlackjack2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:42', '2024-04-12 14:12:42');
INSERT INTO `games` VALUES (1949, 11, NULL, 'ez-oss-RussianPoker', 'Russian Poker ', 'ez-oss-RussianPoker', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:43', '2024-04-12 14:12:43');
INSERT INTO `games` VALUES (1950, 11, NULL, 'ez-oss-RussianRoulette', 'Russian Roulette ', 'ez-oss-RussianRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:43', '2024-04-12 14:12:43');
INSERT INTO `games` VALUES (1951, 13, NULL, 'pgs-slot-safariwilds', 'Safari Wilds', 'pgs-slot-safariwilds', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:44', '2024-04-12 14:12:44');
INSERT INTO `games` VALUES (1952, 11, NULL, 'ez-oss-SalonPriveBlackjack', 'Salon Prive Blackjack', 'ez-oss-SalonPriveBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:45', '2024-04-12 14:12:45');
INSERT INTO `games` VALUES (1953, 11, NULL, 'ez-oss-SicBo', 'Sic Bo', 'ez-oss-SicBo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:45', '2024-04-12 14:12:45');
INSERT INTO `games` VALUES (1954, 9, NULL, 'bs-slot-sleighinit', 'Sleighin&apos;it', 'bs-slot-sleighinit', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:46', '2024-04-12 14:12:46');
INSERT INTO `games` VALUES (1955, 10, NULL, 'boo-SpaceCowTotheMoon', 'Spacecows to the moon', 'boo-SpaceCowTotheMoon', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:46', '2024-04-12 14:12:46');
INSERT INTO `games` VALUES (1956, 11, NULL, 'ez-oss-SpanishRoulette', 'Spanish Roulette', 'ez-oss-SpanishRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:47', '2024-04-12 14:12:47');
INSERT INTO `games` VALUES (1957, 11, NULL, 'ez-oss-SpanishUnlimitedBlackjack', 'Spanish Unlimited Blackjack', 'ez-oss-SpanishUnlimitedBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:47', '2024-04-12 14:12:47');
INSERT INTO `games` VALUES (1958, 11, NULL, 'ez-oss-SpeedAutoRoulette', 'Speed Auto Roulette', 'ez-oss-SpeedAutoRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:48', '2024-04-12 14:12:48');
INSERT INTO `games` VALUES (1959, 3, NULL, 'evo-oss-xs-speed-auto-roulette', 'Speed Auto Roulette', 'evo-oss-xs-speed-auto-roulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:49', '2024-04-12 14:12:49');
INSERT INTO `games` VALUES (1960, 3, NULL, 'evo-oss-xs-speed-baccarat-1', 'Speed Baccarat 1', 'evo-oss-xs-speed-baccarat-1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:49', '2024-04-12 14:12:49');
INSERT INTO `games` VALUES (1961, 3, NULL, 'evo-oss-xs-speed-baccarat-2', 'Speed Baccarat 2', 'evo-oss-xs-speed-baccarat-2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:50', '2024-04-12 14:12:50');
INSERT INTO `games` VALUES (1962, 3, NULL, 'evo-oss-xs-speed-baccarat-3', 'Speed Baccarat 3', 'evo-oss-xs-speed-baccarat-3', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:50', '2024-04-12 14:12:50');
INSERT INTO `games` VALUES (1963, 3, NULL, 'evo-oss-xs-speed-baccarat-4', 'Speed Baccarat 4', 'evo-oss-xs-speed-baccarat-4', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:51', '2024-04-12 14:12:51');
INSERT INTO `games` VALUES (1964, 3, NULL, 'evo-oss-xs-speed-baccarat-t', 'Speed Baccarat T', 'evo-oss-xs-speed-baccarat-t', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:52', '2024-04-12 14:12:52');
INSERT INTO `games` VALUES (1965, 3, NULL, 'evo-oss-xs-speed-baccarat-u', 'Speed Baccarat U', 'evo-oss-xs-speed-baccarat-u', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:52', '2024-04-12 14:12:52');
INSERT INTO `games` VALUES (1966, 3, NULL, 'evo-oss-xs-speed-baccarat-v', 'Speed Baccarat V', 'evo-oss-xs-speed-baccarat-v', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:53', '2024-04-12 14:12:53');
INSERT INTO `games` VALUES (1967, 3, NULL, 'evo-oss-xs-speed-baccarat-w', 'Speed Baccarat W', 'evo-oss-xs-speed-baccarat-w', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:53', '2024-04-12 14:12:53');
INSERT INTO `games` VALUES (1968, 3, NULL, 'evo-oss-xs-speed-baccarat-x', 'Speed Baccarat X', 'evo-oss-xs-speed-baccarat-x', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:54', '2024-04-12 14:12:54');
INSERT INTO `games` VALUES (1969, 3, NULL, 'evo-oss-xs-speed-baccarat-z', 'Speed Baccarat Z', 'evo-oss-xs-speed-baccarat-z', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:54', '2024-04-12 14:12:54');
INSERT INTO `games` VALUES (1970, 11, NULL, 'ez-oss-SpeedCricketBaccarat', 'Speed Cricket Baccarat', 'ez-oss-SpeedCricketBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:55', '2024-04-12 14:12:55');
INSERT INTO `games` VALUES (1971, 11, NULL, 'ez-oss-SpeedFortuneBaccarat', 'Speed Fortune Baccarat', 'ez-oss-SpeedFortuneBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:56', '2024-04-12 14:12:56');
INSERT INTO `games` VALUES (1972, 11, NULL, 'ez-oss-SpeedRoulette', 'Speed Roulette ', 'ez-oss-SpeedRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:56', '2024-04-12 14:12:56');
INSERT INTO `games` VALUES (1973, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-k', 'Speed VIP Blackjack K', 'evo-oss-xs-speed-vip-blackjack-k', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:57', '2024-04-12 14:12:57');
INSERT INTO `games` VALUES (1974, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-l', 'Speed VIP Blackjack L', 'evo-oss-xs-speed-vip-blackjack-l', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:57', '2024-04-12 14:12:57');
INSERT INTO `games` VALUES (1975, 3, NULL, 'evo-oss-xs-speed-vip-blackjack-m', 'Speed VIP Blackjack M', 'evo-oss-xs-speed-vip-blackjack-m', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:58', '2024-04-12 14:12:58');
INSERT INTO `games` VALUES (1976, 13, NULL, 'pgs-slot- SteampunkWheelOfDestiny', 'Steampunk Wheel of Destiny', 'pgs-slot- SteampunkWheelOfDestiny', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:59', '2024-04-12 14:12:59');
INSERT INTO `games` VALUES (1977, 11, NULL, 'ez-oss-Super6Baccarat', 'Super 6 Baccarat', 'ez-oss-Super6Baccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:12:59', '2024-04-12 14:12:59');
INSERT INTO `games` VALUES (1978, 11, NULL, 'ez-oss-TeenPatti3Card', 'Teen Patti 3 Card', 'ez-oss-TeenPatti3Card', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:00', '2024-04-12 14:13:00');
INSERT INTO `games` VALUES (1979, 23, NULL, 'evoplay_6077', 'Temple Of Thunder II', 'evoplay_6077', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:00', '2024-04-12 14:13:00');
INSERT INTO `games` VALUES (1980, 23, NULL, 'evoplay_6078', 'Temple Of Thunder II Bonus Buy', 'evoplay_6078', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:01', '2024-04-12 14:13:01');
INSERT INTO `games` VALUES (1981, 3, NULL, 'evo-oss-xs-texas-holdem-bonus-poker', 'Texas Holdem Bonus Poker', 'evo-oss-xs-texas-holdem-bonus-poker', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:01', '2024-04-12 14:13:01');
INSERT INTO `games` VALUES (1982, 23, NULL, 'evoplay_6066', 'The Belt Of Champion', 'evoplay_6066', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:02', '2024-04-12 14:13:02');
INSERT INTO `games` VALUES (1983, 23, NULL, 'evoplay_6070', 'The Belt Of Champion Bonus Buy', 'evoplay_6070', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:03', '2024-04-12 14:13:03');
INSERT INTO `games` VALUES (1984, 10, NULL, 'boo-slot-TheMightyToro', 'The Mighty Toro', 'boo-slot-TheMightyToro', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:03', '2024-04-12 14:13:03');
INSERT INTO `games` VALUES (1985, 11, NULL, 'ez-oss-ThreeCardPoker', 'Three Card Poker', 'ez-oss-ThreeCardPoker', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:04', '2024-04-12 14:13:04');
INSERT INTO `games` VALUES (1986, 23, NULL, 'evoplay_6036', 'Thunder Mega Sevens', 'evoplay_6036', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:04', '2024-04-12 14:13:04');
INSERT INTO `games` VALUES (1987, 23, NULL, 'evoplay_6038', 'Thunder Mega Sevens Bonus Buy', 'evoplay_6038', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:05', '2024-04-12 14:13:05');
INSERT INTO `games` VALUES (1988, 13, NULL, 'pgs-slot-tikiGo', 'Tiki Go', 'pgs-slot-tikiGo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:06', '2024-04-12 14:13:06');
INSERT INTO `games` VALUES (1989, 13, NULL, 'pgs-slot-TombOfTreasure', 'Tomb of Treasure', 'pgs-slot-TombOfTreasure', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:06', '2024-04-12 14:13:06');
INSERT INTO `games` VALUES (1990, 3, NULL, 'evo-oss-xs-triple-card-poker', 'Triple Card Poker', 'evo-oss-xs-triple-card-poker', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:07', '2024-04-12 14:13:07');
INSERT INTO `games` VALUES (1991, 13, NULL, 'pgs-TsarTreasures', 'Tsar Treasures', 'pgs-TsarTreasures', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:07', '2024-04-12 14:13:07');
INSERT INTO `games` VALUES (1992, 11, NULL, 'ez-oss-TurkishBlackjack1', 'Turkish Blackjack 1', 'ez-oss-TurkishBlackjack1', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:08', '2024-04-12 14:13:08');
INSERT INTO `games` VALUES (1993, 11, NULL, 'ez-oss-TurkishBlackjack2', 'Turkish Blackjack 2', 'ez-oss-TurkishBlackjack2', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:08', '2024-04-12 14:13:08');
INSERT INTO `games` VALUES (1994, 11, NULL, 'ez-oss-TurkishUnlimitedBlackjack', 'Turkish Unlimited Blackjack', 'ez-oss-TurkishUnlimitedBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:09', '2024-04-12 14:13:09');
INSERT INTO `games` VALUES (1995, 11, NULL, 'ez-oss-UltimateAndarBahar', 'Ultimate Andar Bahar', 'ez-oss-UltimateAndarBahar', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:10', '2024-04-12 14:13:10');
INSERT INTO `games` VALUES (1996, 11, NULL, 'ez-oss-UltimateRoulette', 'Ultimate Roulette ', 'ez-oss-UltimateRoulette', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:10', '2024-04-12 14:13:10');
INSERT INTO `games` VALUES (1997, 11, NULL, 'ez-oss-UltimateSicBo', 'Ultimate Sic Bo ', 'ez-oss-UltimateSicBo', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:11', '2024-04-12 14:13:11');
INSERT INTO `games` VALUES (1998, 3, NULL, 'evo-oss-xs-ultimate-texas-holdem', 'Ultimate Texas Holdem', 'evo-oss-xs-ultimate-texas-holdem', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:11', '2024-04-12 14:13:11');
INSERT INTO `games` VALUES (1999, 11, NULL, 'ez-oss-UnlimitedBlackjack', 'Unlimited Blackjack', 'ez-oss-UnlimitedBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:12', '2024-04-12 14:13:12');
INSERT INTO `games` VALUES (2000, 23, NULL, 'evoplay_640', 'Vegas Nights', 'evoplay_640', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:13', '2024-04-12 14:13:13');
INSERT INTO `games` VALUES (2001, 11, NULL, 'ez-oss-VideoBlackjack', 'Video Blackjack ', 'ez-oss-VideoBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:13', '2024-04-12 14:13:13');
INSERT INTO `games` VALUES (2002, 23, NULL, 'evoplay_6056', 'Video Poker', 'evoplay_6056', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:14', '2024-04-12 14:13:14');
INSERT INTO `games` VALUES (2003, 3, NULL, 'evo-oss-xs-vip-blackjack-em-portugues', 'VIP Blackjack em Português', 'evo-oss-xs-vip-blackjack-em-portugues', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:14', '2024-04-12 14:13:14');
INSERT INTO `games` VALUES (2004, 3, NULL, 'evo-oss-xs-vip-blackjack-en-espanol', 'VIP Blackjack en Español', 'evo-oss-xs-vip-blackjack-en-espanol', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:15', '2024-04-12 14:13:15');
INSERT INTO `games` VALUES (2005, 11, NULL, 'ez-oss-VIPDiamondBlackjack', 'VIP Diamond Blackjack', 'ez-oss-VIPDiamondBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:16', '2024-04-12 14:13:16');
INSERT INTO `games` VALUES (2006, 11, NULL, 'ez-oss-VIPFortuneBaccarat', 'VIP Fortune Baccarat', 'ez-oss-VIPFortuneBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:16', '2024-04-12 14:13:16');
INSERT INTO `games` VALUES (2007, 11, NULL, 'ez-oss-VIPNoComSpeedCricketBaccarat', 'VIP No Commission Speed Cricket Baccarat', 'ez-oss-VIPNoComSpeedCricketBaccarat', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:17', '2024-04-12 14:13:17');
INSERT INTO `games` VALUES (2008, 11, NULL, 'ez-oss-VipSurrenderBlackjack', 'VIP Surrender Blackjack', 'ez-oss-VipSurrenderBlackjack', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:17', '2024-04-12 14:13:17');
INSERT INTO `games` VALUES (2009, 13, NULL, 'pgs-werewolfshunt', 'Werewolf\'s Hunt', 'pgs-werewolfshunt', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:18', '2024-04-12 14:13:18');
INSERT INTO `games` VALUES (2010, 23, NULL, 'evoplay_6079', 'Wild Double Up', 'evoplay_6079', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:18', '2024-04-12 14:13:18');
INSERT INTO `games` VALUES (2011, 13, NULL, 'pgs-slot-WildInferno', 'Wild Inferno', 'pgs-slot-WildInferno', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:19', '2024-04-12 14:13:19');
INSERT INTO `games` VALUES (2012, 23, NULL, 'evoplay_6072', 'Winter Star', 'evoplay_6072', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:20', '2024-04-12 14:13:20');
INSERT INTO `games` VALUES (2013, 23, NULL, 'evoplay_6073', 'Winter Star Bonus Buy', 'evoplay_6073', NULL, NULL, NULL, '1', 'html5', 0, 0, 0, 0, 0, 90, 'venix', 0, 0, 0, '2024-04-12 14:13:20', '2024-04-12 14:13:20');

-- ----------------------------
-- Table structure for games_keys
-- ----------------------------
DROP TABLE IF EXISTS `games_keys`;
CREATE TABLE `games_keys`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `merchant_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `merchant_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `merchant_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `agent_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `agent_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `agent_secret_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `api_endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `salsa_base_uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `salsa_pn` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `salsa_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `vibra_site_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `vibra_game_mode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `worldslot_agent_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `worldslot_agent_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `worldslot_agent_secret_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `worldslot_api_endpoint` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'https://api.worldslotgame.com/api/v2/',
  `games2_agent_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `games2_agent_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `games2_agent_secret_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `games2_api_endpoint` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'api.games2api.xyz',
  `evergame_agent_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `evergame_agent_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `evergame_api_endpoint` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `venix_agent_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `venix_agent_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `venix_agent_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `play_gaming_hall` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `play_gaming_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `play_gaming_login` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pig_agent_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pig_agent_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pig_agent_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `imperium_games_hall` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `imperium_games_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `imperium_games_login` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of games_keys
-- ----------------------------
INSERT INTO `games_keys` VALUES (1, 'https://gis.slotegrator.com/api/index.php/v1', NULL, NULL, NULL, NULL, NULL, 'https://api.fiverscool.com', NULL, NULL, NULL, '2023-11-30 15:03:08', '2024-04-12 12:55:19', NULL, NULL, NULL, NULL, NULL, 'https://api.worldslotgame.com/api/v2/', NULL, NULL, NULL, 'https://api.games2api.xyz', '', NULL, 'https://api.evergame.org/api/casinoapi', NULL, NULL, NULL, NULL, NULL, NULL, 'victor', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for gateways
-- ----------------------------
DROP TABLE IF EXISTS `gateways`;
CREATE TABLE `gateways`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `suitpay_uri` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `suitpay_cliente_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `suitpay_cliente_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `stripe_production` tinyint(4) NULL DEFAULT 0,
  `stripe_public_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `stripe_secret_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `stripe_webhook_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bspay_uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bspay_cliente_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bspay_cliente_secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `public_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `private_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mp_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mp_client_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mp_public_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mp_access_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `digitopay_uri` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `digitopay_cliente_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `digitopay_cliente_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of gateways
-- ----------------------------
INSERT INTO `gateways` VALUES (1, 'https://ws.suitpay.app/api/v1/', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '2023-11-30 18:05:51', '2024-03-31 12:55:10', NULL, NULL, NULL, NULL, NULL, NULL, 'https://si5n56mrnjzvt5gr2f536ildr40sqzke.lambda-url.sa-east-1.on.aws/', NULL, NULL);

-- ----------------------------
-- Table structure for ggds_spin_config
-- ----------------------------
DROP TABLE IF EXISTS `ggds_spin_config`;
CREATE TABLE `ggds_spin_config`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `prizes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of ggds_spin_config
-- ----------------------------
INSERT INTO `ggds_spin_config` VALUES (1, '[{\"currency\":\"BRL\",\"value\":5},{\"currency\":\"BRL\",\"value\":10},{\"currency\":\"BRL\",\"value\":25},{\"currency\":\"BRL\",\"value\":30},{\"currency\":\"BRL\",\"value\":40},{\"currency\":\"BRL\",\"value\":50},{\"currency\":\"BRL\",\"value\":90},{\"currency\":\"BRL\",\"value\":100},{\"currency\":\"BRL\",\"value\":140},{\"currency\":\"BRL\",\"value\":15},{\"currency\":\"BRL\",\"value\":30},{\"currency\":\"BRL\",\"value\":500},{\"currency\":\"BRL\",\"value\":1000},{\"currency\":\"BRL\",\"value\":1500},{\"currency\":\"BRL\",\"value\":2000},{\"currency\":\"BRL\",\"value\":2500}]', '2024-01-11 17:52:59', '2024-01-14 14:07:12');

-- ----------------------------
-- Table structure for ggds_spin_runs
-- ----------------------------
DROP TABLE IF EXISTS `ggds_spin_runs`;
CREATE TABLE `ggds_spin_runs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `possibilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `prize` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of ggds_spin_runs
-- ----------------------------
INSERT INTO `ggds_spin_runs` VALUES (1, 'bccec5b62ab37e996470f8bb36ff83ea127a73f17f31cba275453f5ed7b24c34', '592f4304-4837-4a81-8f27-6c3ac412c7dc', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":2000}', '2024-01-12 12:49:28', '2024-01-12 12:49:28');
INSERT INTO `ggds_spin_runs` VALUES (2, '93f0c422ecb15337d358cca690529c9db7d9b7a52acc0727092b938ade4e1c9b', 'eff5d8c3-475b-4994-a49d-778cf06aebf4', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":25}', '2024-01-12 12:51:01', '2024-01-12 12:51:01');
INSERT INTO `ggds_spin_runs` VALUES (3, 'c7f0b2cc871954aa3a03f680969f029034d111e5550ee0769389fefe3fd6f9fd', '203098ef-3347-4938-813e-91be82891cbc', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":105}', '2024-01-12 12:51:34', '2024-01-12 12:51:34');
INSERT INTO `ggds_spin_runs` VALUES (4, '5b4059c88237be6a78ff1fb35e427fd1e4e1a30184ced8d3e4ed9044a0939663', '65cf85de-3dee-48f4-a1d3-d26a8f89ba16', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":2000}', '2024-01-12 13:56:56', '2024-01-12 13:56:56');
INSERT INTO `ggds_spin_runs` VALUES (5, '0901814bf6598c5c7e1072abcc8fa16290dff49b3c2aa44a9346cee34444f98f', '79519214-2125-4ed5-a672-45973c8af5eb', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":2500}', '2024-01-12 13:57:47', '2024-01-12 13:57:47');
INSERT INTO `ggds_spin_runs` VALUES (6, '7b5642d63b3081907a3b7489794ba74f3052fe490095e7354d98570f6c4e5a6c', 'e5b728db-07e3-4531-910b-7c85f1555973', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":9.79}', '2024-01-12 15:51:25', '2024-01-12 15:51:25');
INSERT INTO `ggds_spin_runs` VALUES (7, '001f8f60f30e431a9f28d39a4db43e0b3e03d0379816fe04ff5007aca5d0a14e', '4ab2acba-57f3-46f4-9dc6-c32e993fb995', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":1500}', '2024-01-12 16:13:25', '2024-01-12 16:13:25');
INSERT INTO `ggds_spin_runs` VALUES (8, '8a801a13e786df312b4d3a2a023b5472cfca776b2b9524af3c12fac4e00bb935', 'e050a5ad-ab8a-4922-95cc-6fae7f62be99', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":2500}', '2024-01-12 16:40:12', '2024-01-12 16:40:12');
INSERT INTO `ggds_spin_runs` VALUES (9, '3432d11c1efd935afcf84fba6c3466c3c98aee06c63163368a18b7d07749ea66', 'de330a3f-b3d0-41ef-94ae-2cee7686f341', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":15}', '2024-01-12 17:01:33', '2024-01-12 17:01:33');
INSERT INTO `ggds_spin_runs` VALUES (10, 'cf741c182225f003f16fb815517a3d94d9cde7e16d767766864c7536ae51e101', 'ec3a409c-159f-4723-848c-7a45fe838c65', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":105}', '2024-01-12 17:26:04', '2024-01-12 17:26:04');
INSERT INTO `ggds_spin_runs` VALUES (11, 'f7a528bd425441c09093c146b4456acc0391b2aaf6af26ed7282dd8b153411df', 'b9e39a17-328e-4730-979f-bd37714552f1', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":5.02}', '2024-01-12 22:02:21', '2024-01-12 22:02:21');
INSERT INTO `ggds_spin_runs` VALUES (12, '7ec6e7dea1750162832a02bbcb986e3a77e4ea3ece5110b0c8c746e9ab586d27', '876d2835-b5c5-4c2f-997d-007fa566d356', '[{\"currency\":\"brl\",\"value\":5.02},{\"currency\":\"brl\",\"value\":9.79},{\"currency\":\"brl\",\"value\":25},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":40},{\"currency\":\"brl\",\"value\":50},{\"currency\":\"brl\",\"value\":90},{\"currency\":\"brl\",\"value\":105},{\"currency\":\"brl\",\"value\":140},{\"currency\":\"brl\",\"value\":15},{\"currency\":\"brl\",\"value\":30},{\"currency\":\"brl\",\"value\":500},{\"currency\":\"brl\",\"value\":980},{\"currency\":\"brl\",\"value\":1500},{\"currency\":\"brl\",\"value\":2000},{\"currency\":\"brl\",\"value\":2500}]', '{\"currency\":\"brl\",\"value\":980}', '2024-01-13 10:40:26', '2024-01-13 10:40:26');
INSERT INTO `ggds_spin_runs` VALUES (13, '7980558afa73f95c09d898c3f40a488de06097822831729b21659e6e330d6f92', '19962ee0-52f1-45dd-b858-4003deb2eb43', '[{\"currency\":\"BRL\",\"value\":5},{\"currency\":\"BRL\",\"value\":10},{\"currency\":\"BRL\",\"value\":25},{\"currency\":\"BRL\",\"value\":30},{\"currency\":\"BRL\",\"value\":40},{\"currency\":\"BRL\",\"value\":50},{\"currency\":\"BRL\",\"value\":90},{\"currency\":\"BRL\",\"value\":100},{\"currency\":\"BRL\",\"value\":140},{\"currency\":\"BRL\",\"value\":15},{\"currency\":\"BRL\",\"value\":30},{\"currency\":\"BRL\",\"value\":500},{\"currency\":\"BRL\",\"value\":1000},{\"currency\":\"BRL\",\"value\":1500},{\"currency\":\"BRL\",\"value\":2000},{\"currency\":\"BRL\",\"value\":2500}]', '{\"currency\":\"BRL\",\"value\":30}', '2024-01-15 16:28:00', '2024-01-15 16:28:00');

-- ----------------------------
-- Table structure for ggr_games
-- ----------------------------
DROP TABLE IF EXISTS `ggr_games`;
CREATE TABLE `ggr_games`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `provider` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `game` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance_bet` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `balance_win` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `currency` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `aggregator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ggr_games_fivers_user_id_index`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of ggr_games
-- ----------------------------

-- ----------------------------
-- Table structure for likes
-- ----------------------------
DROP TABLE IF EXISTS `likes`;
CREATE TABLE `likes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `liked_user_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `likes_user_id_foreign`(`user_id`) USING BTREE,
  INDEX `likes_liked_user_id_foreign`(`liked_user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of likes
-- ----------------------------

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 102 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of migrations
-- ----------------------------
INSERT INTO `migrations` VALUES (1, '0000_00_00_000000_create_websockets_statistics_entries_table', 1);
INSERT INTO `migrations` VALUES (2, '2014_10_12_000000_create_users_table', 1);
INSERT INTO `migrations` VALUES (3, '2014_10_12_100000_create_password_reset_tokens_table', 1);
INSERT INTO `migrations` VALUES (4, '2019_08_19_000000_create_failed_jobs_table', 1);
INSERT INTO `migrations` VALUES (5, '2019_12_14_000001_create_personal_access_tokens_table', 1);
INSERT INTO `migrations` VALUES (15, '2023_10_30_034921_create_settings_table', 6);
INSERT INTO `migrations` VALUES (7, '2023_11_03_205251_create_sport_categories_table', 1);
INSERT INTO `migrations` VALUES (8, '2023_11_03_205252_create_sports_table', 1);
INSERT INTO `migrations` VALUES (10, '2023_11_04_001342_create_sport_events_table', 2);
INSERT INTO `migrations` VALUES (11, '2023_11_04_213841_add_fields_to_users_table', 3);
INSERT INTO `migrations` VALUES (12, '2023_11_07_202919_create_currencies_table', 4);
INSERT INTO `migrations` VALUES (13, '2023_11_07_210310_create_wallets_table', 5);
INSERT INTO `migrations` VALUES (16, '2023_11_07_214236_create_withdrawals_table', 7);
INSERT INTO `migrations` VALUES (17, '2023_11_07_214240_create_deposits_table', 7);
INSERT INTO `migrations` VALUES (18, '2023_11_07_214244_create_orders_table', 7);
INSERT INTO `migrations` VALUES (19, '2023_11_07_214708_create_suit_pay_payments_table', 7);
INSERT INTO `migrations` VALUES (20, '2023_11_07_215204_create_notifications_table', 8);
INSERT INTO `migrations` VALUES (21, '2023_11_07_202919_create_currency_alloweds_table', 9);
INSERT INTO `migrations` VALUES (22, '2023_11_11_205824_create_casino_categories_table', 9);
INSERT INTO `migrations` VALUES (23, '2023_11_11_205834_create_casino_providers_table', 9);
INSERT INTO `migrations` VALUES (24, '2023_11_11_205938_create_casino_games_slotgrators_table', 9);
INSERT INTO `migrations` VALUES (25, '2023_11_11_210018_create_casino_games_kscinuses_table', 9);
INSERT INTO `migrations` VALUES (26, '2023_11_12_225424_create_transactions_table', 10);
INSERT INTO `migrations` VALUES (27, '2023_11_12_225431_create_affiliate_histories_table', 10);
INSERT INTO `migrations` VALUES (28, '2023_11_12_234643_add_field_to_wallet_table', 11);
INSERT INTO `migrations` VALUES (29, '2023_11_14_203632_create_likes_table', 12);
INSERT INTO `migrations` VALUES (30, '2023_09_27_214903_create_wallet_changes_table', 13);
INSERT INTO `migrations` VALUES (31, '2023_11_16_155140_create_permission_tables', 14);
INSERT INTO `migrations` VALUES (32, '2023_11_17_012533_add_language_to_users_table', 15);
INSERT INTO `migrations` VALUES (33, '2023_11_22_171616_create_football_leagues_table', 16);
INSERT INTO `migrations` VALUES (34, '2023_11_22_175530_create_football_venues_table', 17);
INSERT INTO `migrations` VALUES (35, '2023_11_22_175547_create_football_teams_table', 17);
INSERT INTO `migrations` VALUES (36, '2023_11_23_143637_create_football_events_table', 18);
INSERT INTO `migrations` VALUES (38, '2023_11_29_134520_create_sport_bets_table', 19);
INSERT INTO `migrations` VALUES (39, '2023_11_29_135451_create_sport_bets_odds_table', 19);
INSERT INTO `migrations` VALUES (40, '2023_11_30_195548_create_gateways_table', 20);
INSERT INTO `migrations` VALUES (41, '2023_11_30_195557_create_games_keys_table', 20);
INSERT INTO `migrations` VALUES (42, '2023_11_30_195609_create_setting_mails_table', 20);
INSERT INTO `migrations` VALUES (43, '2023_10_08_111755_add_fields_to_game_exclusives_table', 20);
INSERT INTO `migrations` VALUES (44, '2023_10_07_183921_create_game_exclusives_table', 21);
INSERT INTO `migrations` VALUES (45, '2023_10_11_144956_create_system_wallets_table', 22);
INSERT INTO `migrations` VALUES (46, '2023_12_18_172721_create_banners_table', 23);
INSERT INTO `migrations` VALUES (47, '2023_12_20_135908_create_casino_games_salsas_table', 24);
INSERT INTO `migrations` VALUES (48, '2023_12_23_224032_create_fivers_providers_table', 25);
INSERT INTO `migrations` VALUES (49, '2023_12_23_224105_create_fivers_games_table', 25);
INSERT INTO `migrations` VALUES (50, '2023_12_31_121453_create_custom_layouts_table', 26);
INSERT INTO `migrations` VALUES (51, '2024_01_01_193712_create_g_g_r_games_fivers_table', 27);
INSERT INTO `migrations` VALUES (52, '2024_01_14_155144_create_missions_table', 28);
INSERT INTO `migrations` VALUES (53, '2024_01_14_155150_create_mission_users_table', 28);
INSERT INTO `migrations` VALUES (54, '2024_01_19_120728_create_ka_gamings_table', 29);
INSERT INTO `migrations` VALUES (55, '2024_01_19_170650_create_categories_table', 30);
INSERT INTO `migrations` VALUES (56, '2024_01_19_170657_create_providers_table', 30);
INSERT INTO `migrations` VALUES (57, '2024_01_19_170658_create_games_table', 31);
INSERT INTO `migrations` VALUES (58, '2023_10_07_183920_create_categories_table', 32);
INSERT INTO `migrations` VALUES (59, '2023_10_07_183921_create_providers_table', 33);
INSERT INTO `migrations` VALUES (60, '2023_10_07_183922_create_games_table', 34);
INSERT INTO `migrations` VALUES (61, '2024_01_20_144529_create_category_games_table', 35);
INSERT INTO `migrations` VALUES (62, '2024_01_20_182155_add_vibra_to_games_keys_table', 36);
INSERT INTO `migrations` VALUES (63, '2024_01_21_173742_create_game_favorites_table', 37);
INSERT INTO `migrations` VALUES (64, '2024_01_21_173752_create_game_likes_table', 37);
INSERT INTO `migrations` VALUES (65, '2024_01_21_173803_create_game_reviews_table', 37);
INSERT INTO `migrations` VALUES (66, '2024_01_11_231932_create_vibra_casino_games_table', 38);
INSERT INTO `migrations` VALUES (69, '2024_01_28_194456_add_vip_to_wallet_table', 40);
INSERT INTO `migrations` VALUES (68, '2024_01_28_194645_create_vips_table', 39);
INSERT INTO `migrations` VALUES (70, '2024_01_28_231843_create_vip_users_table', 41);
INSERT INTO `migrations` VALUES (71, '2024_01_29_102939_add_paid_to_limits_table', 41);
INSERT INTO `migrations` VALUES (72, '2024_01_10_001705_create_sub_affiliates_table', 42);
INSERT INTO `migrations` VALUES (73, '2024_01_30_120547_create_affiliate_withdraws_table', 43);
INSERT INTO `migrations` VALUES (74, '2024_02_09_233936_add_worldslot_to_games_keys_table', 44);
INSERT INTO `migrations` VALUES (75, '2024_02_10_191215_add_disable_spin_to_settings_table', 45);
INSERT INTO `migrations` VALUES (76, '2024_02_17_210822_add_games2_to_games_keys_table', 46);
INSERT INTO `migrations` VALUES (78, '2024_02_20_004853_add_sub_to_settings_table', 47);
INSERT INTO `migrations` VALUES (79, '2024_02_24_121146_add_header_to_custom_layouts_table', 48);
INSERT INTO `migrations` VALUES (80, '2024_02_26_144235_create_ggr_games_world_slots_table', 49);
INSERT INTO `migrations` VALUES (81, '2024_03_01_172613_add_evergame_to_games_keys_table', 50);
INSERT INTO `migrations` VALUES (82, '2024_03_03_201700_add_venixkey_to_games_keys_table', 51);
INSERT INTO `migrations` VALUES (83, '2024_03_08_201557_add_play_gaming_to_games_keys_table', 52);
INSERT INTO `migrations` VALUES (84, '2024_03_21_154342_add_headerbody_to_custom_layouts_table', 53);
INSERT INTO `migrations` VALUES (85, '2024_03_21_154342_add_headerbody_to_custom_layouts_table', 54);
INSERT INTO `migrations` VALUES (86, '2024_03_21_223739_add_sharkpay_to_gateways_table', 55);
INSERT INTO `migrations` VALUES (87, '2024_03_21_230017_add_reference_to_transactions_table', 56);
INSERT INTO `migrations` VALUES (88, '2024_03_24_125025_add_rollver_protection_to_settings_table', 57);
INSERT INTO `migrations` VALUES (89, '2024_03_24_134101_add_accept_bonus_to_transactions_table', 58);
INSERT INTO `migrations` VALUES (90, '2024_03_24_172243_add_receita_to_affiliate_histories_table', 59);
INSERT INTO `migrations` VALUES (91, '2024_03_26_161932_add_baseline_column_to_settings_table', 60);
INSERT INTO `migrations` VALUES (92, '2024_03_26_234226_add_playigaming_column_to_games_key_table', 61);
INSERT INTO `migrations` VALUES (93, '2024_03_25_231103_add_mercado_pago_column_to_gateways_table', 62);
INSERT INTO `migrations` VALUES (94, '2024_03_30_215051_add_social_to_custom_layouts_table', 63);
INSERT INTO `migrations` VALUES (98, '2024_03_30_225900_create_digito_pay_payments_table', 66);
INSERT INTO `migrations` VALUES (96, '2024_03_30_225929_add_digitopay_to_gateways_table', 64);
INSERT INTO `migrations` VALUES (97, '2024_03_31_124211_add_digitopay_to_settings_table', 65);
INSERT INTO `migrations` VALUES (99, '2024_04_02_140932_add_default_gateway_to_settings_table', 67);
INSERT INTO `migrations` VALUES (100, '2024_03_08_201557_add_imperium_games_to_games_keys_table', 68);
INSERT INTO `migrations` VALUES (101, '2024_04_12_201402_add_hash_to_transactions_table', 69);

-- ----------------------------
-- Table structure for mission_users
-- ----------------------------
DROP TABLE IF EXISTS `mission_users`;
CREATE TABLE `mission_users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `mission_id` int(10) UNSIGNED NOT NULL,
  `rounds` bigint(20) NULL DEFAULT 0,
  `rewards` decimal(10, 2) NULL DEFAULT 0.00,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `mission_users_user_id_index`(`user_id`) USING BTREE,
  INDEX `mission_users_mission_id_index`(`mission_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of mission_users
-- ----------------------------

-- ----------------------------
-- Table structure for missions
-- ----------------------------
DROP TABLE IF EXISTS `missions`;
CREATE TABLE `missions`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `challenge_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `challenge_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `challenge_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `challenge_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'game',
  `challenge_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `challenge_start_date` datetime NOT NULL,
  `challenge_end_date` datetime NOT NULL,
  `challenge_bonus` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `challenge_total` bigint(20) NOT NULL DEFAULT 1,
  `challenge_currency` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `challenge_provider` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `challenge_gameid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of missions
-- ----------------------------

-- ----------------------------
-- Table structure for model_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions`  (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`permission_id`, `model_id`, `model_type`) USING BTREE,
  INDEX `model_has_permissions_model_id_model_type_index`(`model_id`, `model_type`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of model_has_permissions
-- ----------------------------

-- ----------------------------
-- Table structure for model_has_roles
-- ----------------------------
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles`  (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`role_id`, `model_id`, `model_type`) USING BTREE,
  INDEX `model_has_roles_model_id_model_type_index`(`model_id`, `model_type`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of model_has_roles
-- ----------------------------
INSERT INTO `model_has_roles` VALUES (1, 'App\\Models\\User', 1);
INSERT INTO `model_has_roles` VALUES (2, 'App\\Models\\User', 39);

-- ----------------------------
-- Table structure for notifications
-- ----------------------------
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications`  (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) UNSIGNED NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `notifications_notifiable_type_notifiable_id_index`(`notifiable_type`, `notifiable_id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of notifications
-- ----------------------------

-- ----------------------------
-- Table structure for orders
-- ----------------------------
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `session_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `transaction_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `game` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `game_uuid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_money` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `providers` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `refunded` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `round_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `orders_user_id_foreign`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of orders
-- ----------------------------

-- ----------------------------
-- Table structure for password_reset_tokens
-- ----------------------------
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens`  (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of password_reset_tokens
-- ----------------------------

-- ----------------------------
-- Table structure for permissions
-- ----------------------------
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `permissions_name_guard_name_unique`(`name`, `guard_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 41 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of permissions
-- ----------------------------
INSERT INTO `permissions` VALUES (1, 'games-exclusive-edit', 'web', '2023-10-12 13:23:45', '2023-10-12 15:12:28');
INSERT INTO `permissions` VALUES (2, 'games-exclusive-view', 'web', '2023-10-12 13:23:56', '2023-10-12 15:11:25');
INSERT INTO `permissions` VALUES (3, 'games-exclusive-create', 'web', '2023-10-12 13:25:06', '2023-10-12 15:11:10');
INSERT INTO `permissions` VALUES (4, 'admin-view', 'web', '2023-10-12 14:56:35', '2023-10-12 14:56:35');
INSERT INTO `permissions` VALUES (5, 'admin-create', 'web', '2023-10-12 15:56:02', '2023-10-12 15:56:02');
INSERT INTO `permissions` VALUES (6, 'admin-edit', 'web', '2023-10-12 15:56:27', '2023-10-12 15:56:27');
INSERT INTO `permissions` VALUES (7, 'admin-delete', 'web', '2023-10-12 15:56:55', '2023-10-12 15:56:55');
INSERT INTO `permissions` VALUES (8, 'category-view', 'web', '2023-10-12 16:01:31', '2023-10-12 16:01:31');
INSERT INTO `permissions` VALUES (9, 'category-create', 'web', '2023-10-12 16:01:46', '2023-10-12 16:01:46');
INSERT INTO `permissions` VALUES (10, 'category-edit', 'web', '2023-10-12 16:01:59', '2023-10-12 16:01:59');
INSERT INTO `permissions` VALUES (11, 'category-delete', 'web', '2023-10-12 16:02:09', '2023-10-12 16:02:09');
INSERT INTO `permissions` VALUES (12, 'game-view', 'web', '2023-10-12 16:02:27', '2023-10-12 16:02:27');
INSERT INTO `permissions` VALUES (13, 'game-create', 'web', '2023-10-12 16:02:36', '2023-10-12 16:02:36');
INSERT INTO `permissions` VALUES (14, 'game-edit', 'web', '2023-10-12 16:02:44', '2023-10-12 16:02:44');
INSERT INTO `permissions` VALUES (15, 'game-delete', 'web', '2023-10-12 16:02:54', '2023-10-12 16:02:54');
INSERT INTO `permissions` VALUES (16, 'wallet-view', 'web', '2023-10-12 16:05:49', '2023-10-12 16:05:49');
INSERT INTO `permissions` VALUES (17, 'wallet-create', 'web', '2023-10-12 16:06:01', '2023-10-12 16:06:01');
INSERT INTO `permissions` VALUES (18, 'wallet-edit', 'web', '2023-10-12 16:06:11', '2023-10-12 16:06:11');
INSERT INTO `permissions` VALUES (19, 'wallet-delete', 'web', '2023-10-12 16:06:18', '2023-10-12 16:06:18');
INSERT INTO `permissions` VALUES (20, 'deposit-view', 'web', '2023-10-12 16:06:44', '2023-10-12 16:06:44');
INSERT INTO `permissions` VALUES (21, 'deposit-create', 'web', '2023-10-12 16:06:56', '2023-10-12 16:06:56');
INSERT INTO `permissions` VALUES (22, 'deposit-edit', 'web', '2023-10-12 16:07:05', '2023-10-12 16:07:05');
INSERT INTO `permissions` VALUES (23, 'deposit-update', 'web', '2023-10-12 16:08:00', '2023-10-12 16:08:00');
INSERT INTO `permissions` VALUES (24, 'deposit-delete', 'web', '2023-10-12 16:08:11', '2023-10-12 16:08:11');
INSERT INTO `permissions` VALUES (25, 'withdrawal-view', 'web', '2023-10-12 16:09:31', '2023-10-12 16:09:31');
INSERT INTO `permissions` VALUES (26, 'withdrawal-create', 'web', '2023-10-12 16:09:40', '2023-10-12 16:09:40');
INSERT INTO `permissions` VALUES (27, 'withdrawal-edit', 'web', '2023-10-12 16:09:51', '2023-10-12 16:09:51');
INSERT INTO `permissions` VALUES (28, 'withdrawal-update', 'web', '2023-10-12 16:10:00', '2023-10-12 16:10:00');
INSERT INTO `permissions` VALUES (29, 'withdrawal-delete', 'web', '2023-10-12 16:10:09', '2023-10-12 16:10:09');
INSERT INTO `permissions` VALUES (30, 'order-view', 'web', '2023-10-12 16:12:36', '2023-10-12 16:12:36');
INSERT INTO `permissions` VALUES (31, 'order-create', 'web', '2023-10-12 16:12:47', '2023-10-12 16:12:47');
INSERT INTO `permissions` VALUES (32, 'order-edit', 'web', '2023-10-12 16:12:56', '2023-10-12 16:12:56');
INSERT INTO `permissions` VALUES (33, 'order-update', 'web', '2023-10-12 16:13:06', '2023-10-12 16:13:06');
INSERT INTO `permissions` VALUES (34, 'order-delete', 'web', '2023-10-12 16:13:19', '2023-10-12 16:13:19');
INSERT INTO `permissions` VALUES (35, 'admin-menu-view', 'web', '2023-10-12 17:26:06', '2023-10-12 17:26:06');
INSERT INTO `permissions` VALUES (36, 'setting-view', 'web', '2023-10-12 18:25:46', '2023-10-12 18:25:46');
INSERT INTO `permissions` VALUES (37, 'setting-create', 'web', '2023-10-12 18:25:57', '2023-10-12 18:25:57');
INSERT INTO `permissions` VALUES (38, 'setting-edit', 'web', '2023-10-12 18:26:06', '2023-10-12 18:26:06');
INSERT INTO `permissions` VALUES (39, 'setting-update', 'web', '2023-10-12 18:26:19', '2023-10-12 18:26:19');
INSERT INTO `permissions` VALUES (40, 'setting-delete', 'web', '2023-10-12 18:26:33', '2023-10-12 18:26:33');

-- ----------------------------
-- Table structure for personal_access_tokens
-- ----------------------------
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `personal_access_tokens_token_unique`(`token`) USING BTREE,
  INDEX `personal_access_tokens_tokenable_type_tokenable_id_index`(`tokenable_type`, `tokenable_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of personal_access_tokens
-- ----------------------------

-- ----------------------------
-- Table structure for providers
-- ----------------------------
DROP TABLE IF EXISTS `providers`;
CREATE TABLE `providers`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `rtp` bigint(20) NULL DEFAULT 90,
  `views` bigint(20) NULL DEFAULT 1,
  `distribution` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of providers
-- ----------------------------
INSERT INTO `providers` VALUES (1, '', 'SPRIBE', 'SPRIBE', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (2, '', 'PRAGMATIC LIVE', 'PRAGMATIC LIVE', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (3, '', 'EVOLUTION', 'EVOLUTION', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (4, '', 'SALSA DEFAULT', 'SALSA DEFAULT', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (5, '', 'BETGAMES', 'BETGAMES', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (6, '', '3OAKS', '3OAKS', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (7, '', '7777GAMINGS', '7777GAMINGS', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (8, '', '1GAMEHUB', '1GAMEHUB', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (9, '', 'BETSOFT', 'BETSOFT', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (10, '', 'BOOMING', 'BOOMING', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (11, '', 'EZUGI', 'EZUGI', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (12, '', 'NETENT BRANDED', 'NETENT BRANDED', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (13, '', 'PGSOFT', 'PGSOFT', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (14, '', 'RED TIGER BRANDED', 'RED TIGER BRANDED', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (15, '', 'SMARTSOFT', 'SMARTSOFT', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (16, '', 'SALSA STUDIO', 'SALSA STUDIO', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (17, '', 'CASINO LIVE', 'CASINO LIVE', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (18, '', 'Salsa Original', 'Salsa Original', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (19, '', 'SLOTS', 'SLOTS', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (20, '', 'VIRTUAL SPORTS', 'VIRTUAL SPORTS', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (21, '', 'pragmaticplay', 'Pragmatic Play', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (22, '', '7-mojos-slots', '7 Mojos Slots', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (23, '', 'evoplay', 'Evoplay', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (24, '', 'genii', 'Genii', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (25, '', 'games-inc', 'Games Inc', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (26, '', 'onlyplay', 'onlyplay', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (27, '', 'playtech', 'playtech', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (28, '', 'banana', 'Banana Games', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');
INSERT INTO `providers` VALUES (29, '', 'tvbet', 'TVBet', 1, 80, 1, 'venix', '2024-04-12 13:49:55', '2024-04-12 13:49:55');

-- ----------------------------
-- Table structure for role_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions`  (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`permission_id`, `role_id`) USING BTREE,
  INDEX `role_has_permissions_role_id_foreign`(`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of role_has_permissions
-- ----------------------------

-- ----------------------------
-- Table structure for roles
-- ----------------------------
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `roles_name_guard_name_unique`(`name`, `guard_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of roles
-- ----------------------------
INSERT INTO `roles` VALUES (1, 'admin', 'web', '2023-10-12 13:20:41', '2023-10-12 13:20:41');
INSERT INTO `roles` VALUES (2, 'afiliado', 'web', '2023-10-12 13:21:08', '2023-10-12 13:21:08');

-- ----------------------------
-- Table structure for setting_mails
-- ----------------------------
DROP TABLE IF EXISTS `setting_mails`;
CREATE TABLE `setting_mails`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `software_smtp_type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_host` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_port` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_encryption` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_from_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_smtp_mail_from_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of setting_mails
-- ----------------------------

-- ----------------------------
-- Table structure for settings
-- ----------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `software_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_favicon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_logo_white` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_logo_black` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `software_background` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `currency_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'BRL',
  `decimal_format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dot',
  `currency_position` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `revshare_percentage` bigint(20) NULL DEFAULT 20,
  `ngr_percent` bigint(20) NULL DEFAULT 20,
  `soccer_percentage` bigint(20) NULL DEFAULT 30,
  `prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'R$',
  `storage` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `initial_bonus` bigint(20) NULL DEFAULT 0,
  `min_deposit` decimal(10, 2) NULL DEFAULT 20.00,
  `max_deposit` decimal(10, 2) NULL DEFAULT 0.00,
  `min_withdrawal` decimal(10, 2) NULL DEFAULT 20.00,
  `max_withdrawal` decimal(10, 2) NULL DEFAULT 0.00,
  `rollover` bigint(20) NULL DEFAULT 10,
  `rollover_deposit` bigint(20) NULL DEFAULT 1,
  `suitpay_is_enable` tinyint(4) NULL DEFAULT 1,
  `stripe_is_enable` tinyint(4) NULL DEFAULT 1,
  `bspay_is_enable` tinyint(4) NULL DEFAULT 0,
  `sharkpay_is_enable` tinyint(4) NULL DEFAULT 1,
  `turn_on_football` tinyint(4) NULL DEFAULT 1,
  `revshare_reverse` tinyint(1) NULL DEFAULT 1,
  `bonus_vip` bigint(20) NULL DEFAULT 100,
  `activate_vip_bonus` tinyint(1) NULL DEFAULT 1,
  `updated_at` timestamp NULL DEFAULT NULL,
  `maintenance_mode` tinyint(4) NULL DEFAULT 0,
  `withdrawal_limit` bigint(20) NULL DEFAULT NULL,
  `withdrawal_period` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `disable_spin` tinyint(1) NOT NULL DEFAULT 0,
  `perc_sub_lv1` bigint(20) NOT NULL DEFAULT 4,
  `perc_sub_lv2` bigint(20) NOT NULL DEFAULT 2,
  `perc_sub_lv3` bigint(20) NOT NULL DEFAULT 3,
  `disable_rollover` tinyint(4) NULL DEFAULT 0,
  `rollover_protection` bigint(20) NOT NULL DEFAULT 1,
  `cpa_baseline` decimal(10, 2) NULL DEFAULT NULL,
  `cpa_value` decimal(10, 2) NULL DEFAULT NULL,
  `mercadopago_is_enable` tinyint(4) NULL DEFAULT 0,
  `digitopay_is_enable` tinyint(4) NOT NULL DEFAULT 0,
  `default_gateway` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'digitopay',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of settings
-- ----------------------------
INSERT INTO `settings` VALUES (1, 'Viper Pro ', 'A mais abrangente plataforma de cassino atualmente, oferecendo uma variedade de recursos profissionais para garantir a melhor experiência para você.', 'uploads/ntDQH8vdaInnOmxXJHs2QjdkFOm21OUOblyFrvDI.png', 'uploads/3MGfODaXxvOJ6Pe7Wm1pep7f7N6eNqehD9wN2x53.png', 'uploads/WgYRN9pcOTO8ImINGVW6TvEGdx21UGydq04opdUT.png', '[]', 'BRL', 'dot', 'left', 20, 0, 30, 'R$', 'local', 100, 20.00, 50000.00, 20.00, 50000.00, 10, 2, 1, 1, 1, 1, 0, 1, 100, 1, '2024-04-12 21:00:38', 0, 500, 'weekly', 1, 4, 2, 3, 0, 5, 50.00, 50.00, 0, 1, 'digitopay');

-- ----------------------------
-- Table structure for sub_affiliates
-- ----------------------------
DROP TABLE IF EXISTS `sub_affiliates`;
CREATE TABLE `sub_affiliates`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `status` tinyint(1) NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sub_affiliates_affiliate_id_index`(`affiliate_id`) USING BTREE,
  INDEX `sub_affiliates_user_id_index`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of sub_affiliates
-- ----------------------------

-- ----------------------------
-- Table structure for system_wallets
-- ----------------------------
DROP TABLE IF EXISTS `system_wallets`;
CREATE TABLE `system_wallets`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `label` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` decimal(27, 12) NOT NULL DEFAULT 0.000000000000,
  `balance_min` decimal(27, 12) NOT NULL DEFAULT 10000.100000000000,
  `pay_upto_percentage` decimal(4, 2) NOT NULL DEFAULT 45.00,
  `mode` enum('balance_min','percentage') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percentage',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of system_wallets
-- ----------------------------
INSERT INTO `system_wallets` VALUES (1, 'system', 261.800000000000, 10000.100000000000, 45.00, 'percentage', '2023-10-11 13:11:15', '2023-10-16 15:42:00');

-- ----------------------------
-- Table structure for transactions
-- ----------------------------
DROP TABLE IF EXISTS `transactions`;
CREATE TABLE `transactions`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `price` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `currency` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'usd',
  `status` tinyint(4) NULL DEFAULT 0,
  `reference` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `accept_bonus` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `transactions_user_id_index`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of transactions
-- ----------------------------

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `oauth_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `oauth_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `avatar` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `phone` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logged_in` tinyint(4) NOT NULL DEFAULT 0,
  `banned` tinyint(4) NOT NULL DEFAULT 0,
  `inviter` int(11) NULL DEFAULT NULL,
  `inviter_code` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `affiliate_revenue_share` bigint(20) NOT NULL DEFAULT 2,
  `affiliate_revenue_share_fake` bigint(20) NULL DEFAULT NULL,
  `affiliate_cpa` decimal(20, 2) NOT NULL DEFAULT 10.00,
  `affiliate_baseline` decimal(20, 2) NOT NULL DEFAULT 40.00,
  `is_demo_agent` tinyint(4) NOT NULL DEFAULT 0,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `language` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pt_BR',
  `role_id` int(11) NULL DEFAULT 3,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `users_email_unique`(`email`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 40 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES (1, 'Admin', 'admin@demo.com', NULL, '$2y$10$sq4gZjSHoI4Jk4yEthM5Cua/yVoFac6nTpRsTy7v9ayXAvKLHHrsq', 'Tb5Z4Br9ksYmvy4r0do0m0szYI2m5I2bXZo0uddrZquyzvzNRimd0yveUxaH', NULL, NULL, 'uploads/8lx3OeL0c6GX18GMIhbgf2Kj4JVew0NRmnTUYYSb.png', NULL, NULL, NULL, 0, 0, NULL, 'IL9O93HOCY', 20, NULL, 10.00, 40.00, 0, 'active', 'pt_BR', 1, '2023-11-07 19:15:13', '2024-03-31 12:51:21');
INSERT INTO `users` VALUES (39, 'Afiliado', 'afiliado@demo.com', NULL, '$2y$10$zRmRWdhiFu0lJvdVlU5mZO5Zbg3YCHmYCpl0NyiJ.o3hQMxk8lqQS', NULL, NULL, NULL, NULL, NULL, '976.980.020-12', '33333333333', 0, 0, NULL, '8E5O2DUZGY', 20, NULL, 50.00, 50.00, 0, 'active', 'pt_BR', 3, '2024-04-11 13:41:36', '2024-04-11 13:41:48');

-- ----------------------------
-- Table structure for vip_users
-- ----------------------------
DROP TABLE IF EXISTS `vip_users`;
CREATE TABLE `vip_users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `vip_id` int(10) UNSIGNED NOT NULL,
  `level` bigint(20) NOT NULL,
  `points` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `vip_users_user_id_index`(`user_id`) USING BTREE,
  INDEX `vip_users_vip_id_index`(`vip_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of vip_users
-- ----------------------------

-- ----------------------------
-- Table structure for vips
-- ----------------------------
DROP TABLE IF EXISTS `vips`;
CREATE TABLE `vips`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bet_symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bet_level` bigint(20) NOT NULL DEFAULT 1,
  `bet_required` bigint(20) NULL DEFAULT NULL,
  `bet_period` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bet_bonus` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of vips
-- ----------------------------

-- ----------------------------
-- Table structure for wallet_changes
-- ----------------------------
DROP TABLE IF EXISTS `wallet_changes`;
CREATE TABLE `wallet_changes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reason` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `change` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `value_bonus` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `value_total` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `value_roi` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `value_entry` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `refer_rewards` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `game` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `wallet_changes_user_id_foreign`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wallet_changes
-- ----------------------------

-- ----------------------------
-- Table structure for wallets
-- ----------------------------
DROP TABLE IF EXISTS `wallets`;
CREATE TABLE `wallets`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `currency` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `balance_bonus_rollover` decimal(10, 2) NULL DEFAULT 0.00,
  `balance_deposit_rollover` decimal(10, 2) NULL DEFAULT 0.00,
  `balance_withdrawal` decimal(10, 2) NULL DEFAULT 0.00,
  `balance_bonus` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `balance_cryptocurrency` decimal(20, 8) NOT NULL DEFAULT 0.00000000,
  `balance_demo` decimal(20, 8) NULL DEFAULT 1000.00000000,
  `refer_rewards` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `hide_balance` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_bet` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `total_won` bigint(20) NOT NULL DEFAULT 0,
  `total_lose` bigint(20) NOT NULL DEFAULT 0,
  `last_won` bigint(20) NOT NULL DEFAULT 0,
  `last_lose` bigint(20) NOT NULL DEFAULT 0,
  `vip_level` bigint(20) NULL DEFAULT 0,
  `vip_points` bigint(20) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `wallets_user_id_index`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 41 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of wallets
-- ----------------------------
INSERT INTO `wallets` VALUES (1, 1, 'BRL', 'R$', 100.00, 0.00, 0.00, 0.00, 0.00, 0.00000000, 1000.00000000, 5900.00, 0, 1, '2023-11-07 19:15:13', '2024-03-05 12:03:54', 0.00, 0, 0, 0, 0, 1, 10000);
INSERT INTO `wallets` VALUES (40, 39, 'BRL', 'R$', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00000000, 1000.00000000, 0.00, 0, 1, '2024-04-11 13:41:36', '2024-04-11 13:41:36', 0.00, 0, 0, 0, 0, 0, 0);

-- ----------------------------
-- Table structure for websockets_statistics_entries
-- ----------------------------
DROP TABLE IF EXISTS `websockets_statistics_entries`;
CREATE TABLE `websockets_statistics_entries`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `app_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `peak_connection_count` int(11) NOT NULL,
  `websocket_message_count` int(11) NOT NULL,
  `api_message_count` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of websockets_statistics_entries
-- ----------------------------

-- ----------------------------
-- Table structure for withdrawals
-- ----------------------------
DROP TABLE IF EXISTS `withdrawals`;
CREATE TABLE `withdrawals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `pix_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pix_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bank_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `currency` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `symbol` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `withdrawals_user_id_foreign`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of withdrawals
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
